/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzmj;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzfe;
import com.google.android.gms.measurement.internal.zzff;
import com.google.android.gms.measurement.internal.zzfg;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzgr;

final class zzfd
extends zzgr {
    @VisibleForTesting
    static final Pair<String, Long> zza = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzz;
    public zzfg zzb;
    public final zzfh zzc = new zzfh(this, "last_upload", 0L);
    public final zzfh zzd = new zzfh(this, "last_upload_attempt", 0L);
    public final zzfh zze = new zzfh(this, "backoff", 0L);
    public final zzfh zzf = new zzfh(this, "last_delete_stale", 0L);
    public final zzfh zzg;
    public final zzfh zzh;
    public final zzfh zzi;
    public final zzfj zzj;
    private String zzaa;
    private boolean zzab;
    private long zzac;
    public final zzfh zzk = new zzfh(this, "time_before_start", 10000L);
    public final zzfh zzl = new zzfh(this, "session_timeout", 1800000L);
    public final zzff zzm = new zzff(this, "start_new_session", true);
    public final zzfj zzn;
    public final zzff zzo;
    public final zzfh zzp = new zzfh(this, "last_pause_time", 0L);
    public boolean zzq;
    public zzff zzr;
    public zzff zzs;
    public zzfh zzt;
    public final zzfj zzu;
    public final zzfj zzv;
    public final zzfh zzw;
    public final zzfe zzx;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zza(String string) {
        this.zzc();
        long l = this.zzl().elapsedRealtime();
        if (this.zzaa != null && l < this.zzac) {
            return new Pair((Object)this.zzaa, (Object)this.zzab);
        }
        this.zzac = l + this.zzs().zze(string);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.zzm());
            if (info != null) {
                this.zzaa = info.getId();
                this.zzab = info.isLimitAdTrackingEnabled();
            }
            if (this.zzaa == null) {
                this.zzaa = "";
            }
        }
        catch (Exception exception) {
            this.zzq().zzv().zza("Unable to get advertising id", exception);
            this.zzaa = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzaa, (Object)this.zzab);
    }

    zzfd(zzfv zzfv2) {
        super(zzfv2);
        this.zzn = new zzfj(this, "non_personalized_ads", null);
        this.zzo = new zzff(this, "allow_remote_dynamite", false);
        this.zzg = new zzfh(this, "midnight_offset", 0L);
        this.zzh = new zzfh(this, "first_open_time", 0L);
        this.zzi = new zzfh(this, "app_install_time", 0L);
        this.zzj = new zzfj(this, "app_instance_id", null);
        this.zzr = new zzff(this, "app_backgrounded", false);
        this.zzs = new zzff(this, "deep_link_retrieval_complete", false);
        this.zzt = new zzfh(this, "deep_link_retrieval_attempts", 0L);
        this.zzu = new zzfj(this, "firebase_feature_rollouts", null);
        this.zzv = new zzfj(this, "deferred_attribution_cache", null);
        this.zzw = new zzfh(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzx = new zzfe(this, "default_event_parameters", null);
    }

    @Override
    protected final boolean zzd() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void g_() {
        this.zzz = this.zzm().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzq = this.zzz.getBoolean("has_been_opened", false);
        if (!this.zzq) {
            SharedPreferences.Editor editor = this.zzz.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzb = new zzfg(this, "health_monitor", Math.max(0L, (Long)zzat.zzb.zza(null)), null);
    }

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zzf() {
        this.zzc();
        this.zzaa();
        return this.zzz;
    }

    @WorkerThread
    final void zzb(String string) {
        this.zzc();
        SharedPreferences.Editor editor = this.zzf().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzg() {
        this.zzc();
        return this.zzf().getString("gmp_app_id", null);
    }

    @WorkerThread
    final void zzc(String string) {
        this.zzc();
        SharedPreferences.Editor editor = this.zzf().edit();
        editor.putString("admob_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzh() {
        this.zzc();
        return this.zzf().getString("admob_app_id", null);
    }

    @WorkerThread
    final Boolean zzi() {
        this.zzc();
        if (!this.zzf().contains("use_service")) {
            return null;
        }
        return this.zzf().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzc();
        SharedPreferences.Editor editor = this.zzf().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzj() {
        this.zzc();
        Boolean bl = this.zzu();
        SharedPreferences.Editor editor = this.zzf().edit();
        editor.clear();
        editor.apply();
        if (bl != null) {
            this.zza(bl);
        }
    }

    @WorkerThread
    final void zza(Boolean bl) {
        this.zzc();
        SharedPreferences.Editor editor = this.zzf().edit();
        if (bl != null) {
            editor.putBoolean("measurement_enabled", bl.booleanValue());
        } else {
            editor.remove("measurement_enabled");
        }
        editor.apply();
    }

    @WorkerThread
    final Boolean zzu() {
        this.zzc();
        if (this.zzf().contains("measurement_enabled")) {
            return this.zzf().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    final void zzb(Boolean bl) {
        if (zzmj.zzb() && this.zzs().zza(zzat.zzcg)) {
            this.zzc();
            SharedPreferences.Editor editor = this.zzf().edit();
            if (bl != null) {
                editor.putBoolean("measurement_enabled_from_api", bl.booleanValue());
            } else {
                editor.remove("measurement_enabled_from_api");
            }
            editor.apply();
        }
    }

    @WorkerThread
    final Boolean zzv() {
        if (zzmj.zzb() && this.zzs().zza(zzat.zzcg)) {
            this.zzc();
            if (this.zzf().contains("measurement_enabled_from_api")) {
                return this.zzf().getBoolean("measurement_enabled_from_api", true);
            }
        }
        return null;
    }

    @WorkerThread
    final boolean zza(zzad zzad2, int n) {
        if (zzmj.zzb() && this.zzs().zza(zzat.zzcg)) {
            this.zzc();
            if (this.zza(n)) {
                SharedPreferences.Editor editor = this.zzf().edit();
                editor.putString("consent_settings", zzad2.zza());
                editor.putInt("consent_source", n);
                editor.apply();
                return true;
            }
        }
        return false;
    }

    @WorkerThread
    final boolean zza(int n) {
        return zzad.zza(n, this.zzf().getInt("consent_source", 100));
    }

    @WorkerThread
    final zzad zzw() {
        this.zzc();
        return zzad.zza(this.zzf().getString("consent_settings", "G1"));
    }

    @WorkerThread
    protected final String zzx() {
        this.zzc();
        String string = this.zzf().getString("previous_os_version", null);
        this.zzk().zzaa();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzf().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzb(boolean bl) {
        this.zzc();
        this.zzq().zzw().zza("App measurement setting deferred collection", bl);
        SharedPreferences.Editor editor = this.zzf().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzy() {
        return this.zzz.contains("deferred_analytics_collection");
    }

    final boolean zza(long l) {
        return l - this.zzl.zza() > this.zzp.zza();
    }
}

