/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import androidx.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfv;

public final class zzfn {
    private final zzfm zza;

    public zzfn(zzfm zzfm2) {
        Preconditions.checkNotNull((Object)zzfm2);
        this.zza = zzfm2;
    }

    public static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void zza(Context context, Intent intent) {
        zzfv zzfv2 = zzfv.zza(context, null, null);
        zzer zzer2 = zzfv2.zzq();
        if (intent == null) {
            zzer2.zzh().zza("Receiver called with null intent");
            return;
        }
        String string = intent.getAction();
        zzer2.zzw().zza("Local receiver got", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzer2.zzw().zza("Starting wakeful intent.");
            this.zza.doStartService(context, intent2);
            return;
        }
        if ("com.android.vending.INSTALL_REFERRER".equals(string)) {
            zzer2.zzh().zza("Install Referrer Broadcasts are deprecated");
        }
    }
}

