/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgr;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzfo
extends zzgr {
    private zzfs zza;
    private zzfs zzb;
    private final PriorityBlockingQueue<zzft<?>> zzc;
    private final BlockingQueue<zzft<?>> zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg = new Object();
    private final Semaphore zzh = new Semaphore(2);
    private volatile boolean zzi;
    private static final AtomicLong zzj = new AtomicLong(Long.MIN_VALUE);

    zzfo(zzfv zzfv2) {
        super(zzfv2);
        this.zzc = new PriorityBlockingQueue();
        this.zzd = new LinkedBlockingQueue();
        this.zze = new zzfq(this, "Thread death: Uncaught exception on worker thread");
        this.zzf = new zzfq(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzd() {
        return false;
    }

    @Override
    public final void zzc() {
        if (Thread.currentThread() != this.zza) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzb() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzf() {
        return Thread.currentThread() == this.zza;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzft zzft2 = new zzft(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                ((zzgo)this).zzq().zzh().zza("Callable skipped the worker queue.");
            }
            zzft2.run();
        } else {
            this.zza(zzft2);
        }
        return zzft2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzft zzft2 = new zzft(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            zzft2.run();
        } else {
            this.zza(zzft2);
        }
        return zzft2;
    }

    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzft(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzgo)this).zzp().zza(runnable);
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzgo)this).zzq().zzh().zza(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzgo)this).zzq().zzh().zza(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzft(this, runnable, true, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzft<?> zzft2) {
        Object object = this.zzg;
        synchronized (object) {
            this.zzc.add(zzft2);
            if (this.zza == null) {
                this.zza = new zzfs(this, "Measurement Worker", this.zzc);
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                this.zza.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzc(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        zzft zzft2 = new zzft(this, runnable, false, "Task exception on network thread");
        zzfo zzfo2 = this;
        Object object = zzfo2.zzg;
        synchronized (object) {
            zzfo2.zzd.add(zzft2);
            if (zzfo2.zzb == null) {
                zzfo2.zzb = new zzfs(zzfo2, "Measurement Network", zzfo2.zzd);
                zzfo2.zzb.setUncaughtExceptionHandler(zzfo2.zzf);
                zzfo2.zzb.start();
            } else {
                zzfo2.zzb.zza();
            }
            return;
        }
    }

    static /* synthetic */ Semaphore zza(zzfo zzfo2) {
        return zzfo2.zzh;
    }

    static /* synthetic */ boolean zzb(zzfo zzfo2) {
        return zzfo2.zzi;
    }

    static /* synthetic */ Object zzc(zzfo zzfo2) {
        return zzfo2.zzg;
    }

    static /* synthetic */ zzfs zzd(zzfo zzfo2) {
        return zzfo2.zza;
    }

    static /* synthetic */ zzfs zza(zzfo zzfo2, zzfs zzfs2) {
        zzfo2.zza = null;
        return null;
    }

    static /* synthetic */ zzfs zze(zzfo zzfo2) {
        return zzfo2.zzb;
    }

    static /* synthetic */ zzfs zzb(zzfo zzfo2, zzfs zzfs2) {
        zzfo2.zzb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzg() {
        return zzj;
    }
}

