/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.internal.measurement.zzdh;
import com.google.android.gms.internal.measurement.zzmj;
import com.google.android.gms.internal.measurement.zzmu;
import com.google.android.gms.internal.measurement.zzny;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class zzfv
implements zzgq {
    private static volatile zzfv zzb;
    private final Context zzc;
    private final String zzd;
    private final String zze;
    private final String zzf;
    private final boolean zzg;
    private final zzx zzh;
    private final zzy zzi;
    private final zzfd zzj;
    private final zzer zzk;
    private final zzfo zzl;
    private final zzju zzm;
    private final zzkw zzn;
    private final zzep zzo;
    private final Clock zzp;
    private final zzij zzq;
    private final zzgy zzr;
    private final zza zzs;
    private final zzia zzt;
    private zzen zzu;
    private zzio zzv;
    private zzal zzw;
    private zzek zzx;
    private zzfi zzy;
    private boolean zzz = false;
    private Boolean zzaa;
    private long zzab;
    private volatile Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    @VisibleForTesting
    private Boolean zzae;
    private volatile boolean zzaf;
    private int zzag;
    private AtomicInteger zzah = new AtomicInteger(0);
    @VisibleForTesting
    final long zza;

    private zzfv(zzgz zzgz2) {
        Object object;
        Preconditions.checkNotNull((Object)zzgz2);
        Object object2 = zzgz2.zza;
        zzeh.zza = this.zzh = new zzx((Context)object2);
        this.zzc = zzgz2.zza;
        this.zzd = zzgz2.zzb;
        this.zze = zzgz2.zzc;
        this.zzf = zzgz2.zzd;
        this.zzg = zzgz2.zzh;
        this.zzac = zzgz2.zze;
        this.zzaf = true;
        zzae zzae2 = zzgz2.zzg;
        if (zzae2 != null && zzae2.zzg != null) {
            object = zzae2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
            if ((object = zzae2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzae = (Boolean)object;
            }
        }
        zzdh.zza(this.zzc);
        this.zzp = DefaultClock.getInstance();
        this.zza = zzgz2.zzi != null ? zzgz2.zzi.longValue() : this.zzp.currentTimeMillis();
        object2 = this;
        this.zzi = new zzy((zzfv)object2);
        object2 = this;
        object = new zzfd((zzfv)object2);
        ((zzgr)object).zzab();
        this.zzj = object;
        object2 = this;
        zzer zzer2 = new zzer((zzfv)object2);
        zzer2.zzab();
        this.zzk = zzer2;
        object2 = this;
        zzkw zzkw2 = new zzkw((zzfv)object2);
        zzkw2.zzab();
        this.zzn = zzkw2;
        object2 = this;
        zzep zzep2 = new zzep((zzfv)object2);
        zzep2.zzab();
        this.zzo = zzep2;
        object2 = this;
        this.zzs = new zza((zzfv)object2);
        object2 = this;
        zzij zzij2 = new zzij((zzfv)object2);
        zzij2.zzw();
        this.zzq = zzij2;
        object2 = this;
        zzgy zzgy2 = new zzgy((zzfv)object2);
        zzgy2.zzw();
        this.zzr = zzgy2;
        object2 = this;
        zzju zzju2 = new zzju((zzfv)object2);
        zzju2.zzw();
        this.zzm = zzju2;
        object2 = this;
        zzia zzia2 = new zzia((zzfv)object2);
        zzia2.zzab();
        this.zzt = zzia2;
        object2 = this;
        zzfo zzfo2 = new zzfo((zzfv)object2);
        zzfo2.zzab();
        this.zzl = zzfo2;
        boolean bl = zzgz2.zzg != null && zzgz2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        if (((zzfv)object2).zzc.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            zzgy zzgy3 = ((zzfv)object2).zzg();
            if (((zzgo)zzgy3).zzm().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzgo)zzgy3).zzm().getApplicationContext();
                if (zzgy3.zza == null) {
                    zzgy3.zza = new zzhz(zzgy3, null);
                }
                if (bl3) {
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzgy3.zza);
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzgy3.zza);
                    ((zzgo)zzgy3).zzq().zzw().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzfv)object2).zzq().zzh().zza("Application context is not an Application");
        }
        this.zzl.zza(new zzfx(this, zzgz2));
    }

    @WorkerThread
    private final void zza(zzgz zzgz2) {
        ((zzgo)this.zzp()).zzc();
        Object object = this;
        zzal zzal2 = new zzal((zzfv)object);
        zzal2.zzab();
        this.zzw = zzal2;
        zzfv zzfv2 = this;
        object = zzgz2;
        zzek zzek2 = new zzek(zzfv2, ((zzgz)object).zzf);
        zzek2.zzw();
        this.zzx = zzek2;
        object = this;
        zzen zzen2 = new zzen((zzfv)object);
        zzen2.zzw();
        this.zzu = zzen2;
        object = this;
        zzio zzio2 = new zzio((zzfv)object);
        zzio2.zzw();
        this.zzv = zzio2;
        this.zzn.zzac();
        this.zzj.zzac();
        object = this;
        this.zzy = new zzfi((zzfv)object);
        this.zzx.zzx();
        this.zzq().zzu().zza("App measurement initialized, version", 32053L);
        this.zzq().zzu().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string = zzek2.zzaa();
        if (TextUtils.isEmpty((CharSequence)this.zzd)) {
            String string2;
            zzet zzet2;
            if (this.zzh().zze(string)) {
                zzet2 = this.zzq().zzu();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzet2 = this.zzq().zzu();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzet2.zza(string2);
        }
        this.zzq().zzv().zza("Debug-level message logging enabled");
        if (this.zzag != this.zzah.get()) {
            this.zzq().zze().zza("Not all components initialized", this.zzag, this.zzah.get());
        }
        this.zzz = true;
    }

    @WorkerThread
    protected final void zza(zzae zzae2) {
        ((zzgo)this.zzp()).zzc();
        if (zzmj.zzb() && this.zzi.zza(zzat.zzcg)) {
            zzad zzad2;
            zzad zzad3 = this.zzb().zzw();
            if (zzae2 != null && zzae2.zzg != null && this.zzb().zza(40) && !(zzad2 = com.google.android.gms.measurement.internal.zzad.zzb(zzae2.zzg)).equals(com.google.android.gms.measurement.internal.zzad.zza)) {
                zzad3 = zzad2;
                this.zzg().zza(zzad3, 40, this.zza);
            }
            this.zzg().zza(zzad3);
        }
        if (this.zzb().zzc.zza() == 0L) {
            this.zzb().zzc.zza(this.zzp.currentTimeMillis());
        }
        if (Long.valueOf(this.zzb().zzh.zza()) == 0L) {
            this.zzq().zzw().zza("Persisting first open", this.zza);
            this.zzb().zzh.zza(this.zza);
        }
        if (this.zzi.zza(zzat.zzcc)) {
            this.zzg().zzb.zzb();
        }
        if (!this.zzaf()) {
            if (this.zzaa()) {
                if (!this.zzh().zzc("android.permission.INTERNET")) {
                    this.zzq().zze().zza("App is missing INTERNET permission");
                }
                if (!this.zzh().zzc("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzq().zze().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() && !this.zzi.zzw()) {
                    if (!zzfn.zza(this.zzc)) {
                        this.zzq().zze().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzkw.zza(this.zzc, false)) {
                        this.zzq().zze().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzq().zze().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzx().zzab()) || !TextUtils.isEmpty((CharSequence)this.zzx().zzac())) {
                this.zzh();
                if (zzkw.zza(this.zzx().zzab(), this.zzb().zzg(), this.zzx().zzac(), this.zzb().zzh())) {
                    this.zzq().zzu().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzb().zzj();
                    this.zzj().zzaa();
                    this.zzv.zzag();
                    this.zzv.zzae();
                    this.zzb().zzh.zza(this.zza);
                    this.zzb().zzj.zza(null);
                }
                this.zzb().zzb(this.zzx().zzab());
                this.zzb().zzc(this.zzx().zzac());
            }
            if (zzmj.zzb() && this.zzi.zza(zzat.zzcg) && !this.zzb().zzw().zze()) {
                this.zzb().zzj.zza(null);
            }
            this.zzg().zza(this.zzb().zzj.zza());
            if (zzmu.zzb() && this.zzi.zza(zzat.zzbo) && !this.zzh().zzj() && !TextUtils.isEmpty((CharSequence)this.zzb().zzu.zza())) {
                this.zzq().zzh().zza("Remote config removed with active feature rollouts");
                this.zzb().zzu.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzx().zzab()) || !TextUtils.isEmpty((CharSequence)this.zzx().zzac())) {
                boolean bl = this.zzaa();
                if (!this.zzb().zzy() && !this.zzi.zzf()) {
                    this.zzb().zzb(!bl);
                }
                if (bl) {
                    this.zzg().zzah();
                }
                this.zzd().zza.zza();
                this.zzv().zza(new AtomicReference<String>());
                if (zzny.zzb() && this.zzi.zza(zzat.zzby)) {
                    this.zzv().zza(this.zzb().zzx.zza());
                }
            }
        }
        this.zzb().zzo.zza(this.zzi.zza(zzat.zzax));
    }

    @Override
    public final zzx zzt() {
        return this.zzh;
    }

    public final zzy zza() {
        return this.zzi;
    }

    public final zzfd zzb() {
        zzfv.zza(this.zzj);
        return this.zzj;
    }

    @Override
    public final zzer zzq() {
        zzfv.zzb(this.zzk);
        return this.zzk;
    }

    public final zzer zzc() {
        if (this.zzk != null && this.zzk.zzz()) {
            return this.zzk;
        }
        return null;
    }

    @Override
    public final zzfo zzp() {
        zzfv.zzb(this.zzl);
        return this.zzl;
    }

    public final zzju zzd() {
        zzfv.zzb(this.zzm);
        return this.zzm;
    }

    public final zzfi zze() {
        return this.zzy;
    }

    final zzfo zzf() {
        return this.zzl;
    }

    public final zzgy zzg() {
        zzfv.zzb(this.zzr);
        return this.zzr;
    }

    public final zzkw zzh() {
        zzfv.zza(this.zzn);
        return this.zzn;
    }

    public final zzep zzi() {
        zzfv.zza(this.zzo);
        return this.zzo;
    }

    public final zzen zzj() {
        zzfv.zzb(this.zzu);
        return this.zzu;
    }

    private final zzia zzah() {
        zzfv.zzb(this.zzt);
        return this.zzt;
    }

    @Override
    public final Context zzm() {
        return this.zzc;
    }

    public final boolean zzk() {
        return TextUtils.isEmpty((CharSequence)this.zzd);
    }

    public final String zzn() {
        return this.zzd;
    }

    public final String zzo() {
        return this.zze;
    }

    public final String zzr() {
        return this.zzf;
    }

    public final boolean zzs() {
        return this.zzg;
    }

    @Override
    public final Clock zzl() {
        return this.zzp;
    }

    public final zzij zzu() {
        zzfv.zzb(this.zzq);
        return this.zzq;
    }

    public final zzio zzv() {
        zzfv.zzb(this.zzv);
        return this.zzv;
    }

    public final zzal zzw() {
        zzfv.zzb(this.zzw);
        return this.zzw;
    }

    public final zzek zzx() {
        zzfv.zzb(this.zzx);
        return this.zzx;
    }

    public final zza zzy() {
        if (this.zzs == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzfv zza(Context context, zzae zzae2, Long l) {
        if (zzae2 != null && (zzae2.zze == null || zzae2.zzf == null)) {
            zzae2 = new zzae(zzae2.zza, zzae2.zzb, zzae2.zzc, zzae2.zzd, null, null, zzae2.zzg);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb == null) {
            Class<zzfv> clazz = zzfv.class;
            synchronized (zzfv.class) {
                if (zzb == null) {
                    zzgz zzgz2 = new zzgz(context, zzae2, l);
                    zzb = new zzfv(zzgz2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (zzae2 != null && zzae2.zzg != null && zzae2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            zzb.zza(zzae2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zzb;
    }

    private static void zzb(zzgr zzgr2) {
        if (zzgr2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzgr2.zzz()) {
            String string = String.valueOf(zzgr2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zzb(zzg zzg2) {
        if (zzg2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzg2.zzu()) {
            String string = String.valueOf(zzg2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzgo zzgo2) {
        if (zzgo2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzac = bl;
    }

    @WorkerThread
    public final boolean zzz() {
        return this.zzac != null && this.zzac != false;
    }

    @WorkerThread
    public final boolean zzaa() {
        return this.zzab() == 0;
    }

    @WorkerThread
    public final int zzab() {
        ((zzgo)this.zzp()).zzc();
        if (this.zzi.zzf()) {
            return 1;
        }
        if (this.zzae != null && this.zzae.booleanValue()) {
            return 2;
        }
        if (zzmj.zzb() && this.zzi.zza(zzat.zzcg) && !this.zzac()) {
            return 8;
        }
        Boolean bl = this.zzb().zzu();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        zzy zzy2 = this.zzi;
        Boolean bl2 = zzy2.zzf("firebase_analytics_collection_enabled");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzad != null) {
            if (this.zzad.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (GoogleServices.isMeasurementExplicitlyDisabled()) {
            return 6;
        }
        if (this.zzi.zza(zzat.zzar) && this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    @WorkerThread
    public final void zzb(boolean bl) {
        ((zzgo)this.zzp()).zzc();
        this.zzaf = bl;
    }

    @WorkerThread
    public final boolean zzac() {
        ((zzgo)this.zzp()).zzc();
        return this.zzaf;
    }

    final void zzad() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zza(zzgr zzgr2) {
        ++this.zzag;
    }

    final void zza(zzg zzg2) {
        ++this.zzag;
    }

    final void zzae() {
        this.zzah.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzaf() {
        if (!this.zzz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
        ((zzgo)this.zzp()).zzc();
        if (this.zzaa == null || this.zzab == 0L || this.zzaa != null && !this.zzaa.booleanValue() && Math.abs(this.zzp.elapsedRealtime() - this.zzab) > 1000L) {
            this.zzab = this.zzp.elapsedRealtime();
            this.zzaa = this.zzh().zzc("android.permission.INTERNET") && this.zzh().zzc("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() || this.zzi.zzw() || zzfn.zza(this.zzc) && zzkw.zza(this.zzc, false));
            if (this.zzaa.booleanValue()) {
                this.zzaa = this.zzh().zza(this.zzx().zzab(), this.zzx().zzac(), this.zzx().zzad()) || !TextUtils.isEmpty((CharSequence)this.zzx().zzac());
            }
        }
        return this.zzaa;
    }

    @WorkerThread
    public final void zzag() {
        ((zzgo)this.zzp()).zzc();
        zzfv.zzb(this.zzah());
        String string = this.zzx().zzaa();
        Pair<String, Boolean> pair = this.zzb().zza(string);
        if (!this.zzi.zzg().booleanValue() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzq().zzv().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return;
        }
        if (!this.zzah().zzf()) {
            this.zzq().zzh().zza("Network is not available for Deferred Deep Link request. Skipping");
            return;
        }
        zzkw zzkw2 = this.zzh();
        this.zzx();
        URL uRL = zzkw2.zza(32053L, string, (String)pair.first, this.zzb().zzt.zza() - 1L);
        zzfu zzfu2 = new zzfu(this);
        URL uRL2 = uRL;
        String string2 = string;
        zzia zzia2 = this.zzah();
        ((zzgo)zzia2).zzc();
        zzia2.zzaa();
        Preconditions.checkNotNull((Object)uRL2);
        Preconditions.checkNotNull((Object)zzfu2);
        ((zzgo)zzia2).zzp().zzc(new zzic(zzia2, string2, uRL2, null, null, zzfu2));
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzfv zzfv2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzfv2.zzq().zzh().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzfv2.zzb().zzs.zza(true);
        if (byArray2.length == 0) {
            zzfv2.zzq().zzv().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzfv2.zzq().zzv().zza("Deferred Deep Link is empty.");
                return;
            }
            String string5 = string3;
            zzkw zzkw2 = zzfv2.zzh();
            if (!(!TextUtils.isEmpty((CharSequence)string5) && (list = ((zzgo)zzkw2).zzm().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string5)), 0)) != null && !list.isEmpty())) {
                zzfv2.zzq().zzh().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzfv2.zzr.zza("auto", "_cmp", bundle);
            string5 = string3;
            zzkw2 = zzfv2.zzh();
            if (!TextUtils.isEmpty((CharSequence)string5) && zzkw2.zza(string5, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzgo)zzkw2).zzm().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzfv2.zzq().zze().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    static /* synthetic */ void zza(zzfv zzfv2, zzgz zzgz2) {
        zzfv2.zza(zzgz2);
    }
}

