/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zznm;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzil;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zzkw;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class zzij
extends zzg {
    private volatile zzig zzb;
    private zzig zzc;
    @VisibleForTesting
    protected zzig zza;
    private final Map<Activity, zzig> zzd;
    private Activity zze;
    private volatile boolean zzf;
    private volatile zzig zzg;
    private zzig zzh;
    private boolean zzi;
    private final Object zzj = new Object();
    private zzig zzk;
    private String zzl;

    public zzij(zzfv zzfv2) {
        super(zzfv2);
        this.zzd = new ConcurrentHashMap<Activity, zzig>();
    }

    @Override
    protected final boolean zzy() {
        return false;
    }

    @WorkerThread
    public final zzig zza(boolean bl) {
        this.zzv();
        ((zzgo)this).zzc();
        if (!((zzgo)this).zzs().zza(zzat.zzbu) || !bl) {
            return this.zza;
        }
        if (this.zza != null) {
            return this.zza;
        }
        return this.zzh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Bundle bundle, long l) {
        zzig zzig2;
        if (!((zzgo)this).zzs().zza(zzat.zzbu)) {
            ((zzgo)this).zzq().zzj().zza("Manual screen reporting is disabled.");
            return;
        }
        String string = null;
        String string2 = null;
        Object object = this.zzj;
        synchronized (object) {
            if (!this.zzi) {
                ((zzgo)this).zzq().zzj().zza("Cannot log screen view event when the app is in the background.");
                return;
            }
            if (bundle != null) {
                string = bundle.getString("screen_name");
                if (string != null && (string.length() <= 0 || string.length() > 100)) {
                    ((zzgo)this).zzq().zzj().zza("Invalid screen name length for screen view. Length", string.length());
                    return;
                }
                string2 = bundle.getString("screen_class");
                if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
                    ((zzgo)this).zzq().zzj().zza("Invalid screen class length for screen view. Length", string2.length());
                    return;
                }
            }
            if (string2 == null) {
                String string3 = string2 = this.zze != null ? zzij.zza(this.zze.getClass().getCanonicalName()) : "Activity";
            }
            if (this.zzf && this.zzb != null) {
                this.zzf = false;
                boolean bl = zzkw.zzc(this.zzb.zzb, string2);
                boolean bl2 = zzkw.zzc(this.zzb.zza, string);
                if (bl && bl2) {
                    ((zzgo)this).zzq().zzj().zza("Ignoring call to log screen view event with duplicate parameters.");
                    return;
                }
            }
        }
        ((zzgo)this).zzq().zzw().zza("Logging screen view with name, class", string == null ? "null" : string, string2 == null ? "null" : string2);
        object = this.zzb == null ? this.zzc : this.zzb;
        this.zzb = zzig2 = new zzig(string, string2, ((zzgo)this).zzo().zzf(), true, l);
        this.zzc = object;
        this.zzg = zzig2;
        long l2 = ((zzgo)this).zzl().elapsedRealtime();
        ((zzgo)this).zzp().zza(new zzii(this, bundle, zzig2, (zzig)object, l2));
    }

    @WorkerThread
    private final void zza(Bundle bundle, @NonNull zzig zzig2, zzig zzig3, long l) {
        if (bundle != null) {
            bundle.remove("screen_name");
            bundle.remove("screen_class");
        }
        Bundle bundle2 = ((zzgo)this).zzo().zza(null, "screen_view", bundle, null, true, true);
        this.zza(zzig2, zzig3, l, true, bundle2);
    }

    @Deprecated
    @MainThread
    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zzgo)this).zzs().zzh().booleanValue()) {
            ((zzgo)this).zzq().zzj().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        if (this.zzb == null) {
            ((zzgo)this).zzq().zzj().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzgo)this).zzq().zzj().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzij.zza(activity.getClass().getCanonicalName());
        }
        boolean bl = zzkw.zzc(this.zzb.zzb, string2);
        boolean bl2 = zzkw.zzc(this.zzb.zza, string);
        if (bl && bl2) {
            ((zzgo)this).zzq().zzj().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzgo)this).zzq().zzj().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzgo)this).zzq().zzj().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzgo)this).zzq().zzw().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzig zzig2 = new zzig(string, string2, ((zzgo)this).zzo().zzf());
        this.zzd.put(activity, zzig2);
        this.zza(activity, zzig2, true);
    }

    public final zzig zzaa() {
        return this.zzb;
    }

    @MainThread
    private final void zza(Activity activity, zzig zzig2, boolean bl) {
        zzig zzig3;
        zzig zzig4;
        zzig zzig5 = zzig4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzig2.zzb == null) {
            zzig3 = activity != null ? zzij.zza(activity.getClass().getCanonicalName()) : null;
            zzig2 = new zzig(zzig2.zza, (String)((Object)zzig3), zzig2.zzc, zzig2.zze, zzig2.zzf);
        }
        zzig3 = zzig2;
        this.zzc = this.zzb;
        this.zzb = zzig3;
        long l = ((zzgo)this).zzl().elapsedRealtime();
        ((zzgo)this).zzp().zza(new zzil(this, zzig3, zzig4, l, bl));
    }

    @WorkerThread
    private final void zza(zzig zzig2, zzig zzig3, long l, boolean bl, Bundle bundle) {
        ((zzgo)this).zzc();
        boolean bl2 = false;
        if (((zzgo)this).zzs().zza(zzat.zzas)) {
            bl2 = bl && this.zza != null;
            if (bl2) {
                this.zza(this.zza, true, l);
            }
        } else if (bl && this.zza != null) {
            this.zza(this.zza, true, l);
        }
        if (zzig3 == null || zzig3.zzc != zzig2.zzc || !zzkw.zzc(zzig3.zzb, zzig2.zzb) || !zzkw.zzc(zzig3.zza, zzig2.zza)) {
            long l2;
            Bundle bundle2 = new Bundle();
            if (((zzgo)this).zzs().zza(zzat.zzbu)) {
                bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            }
            zzij.zza(zzig2, bundle2, true);
            if (zzig3 != null) {
                if (zzig3.zza != null) {
                    bundle2.putString("_pn", zzig3.zza);
                }
                if (zzig3.zzb != null) {
                    bundle2.putString("_pc", zzig3.zzb);
                }
                bundle2.putLong("_pi", zzig3.zzc);
            }
            if (((zzgo)this).zzs().zza(zzat.zzas) && bl2 && (l2 = zznm.zzb() && ((zzgo)this).zzs().zza(zzat.zzau) ? ((zzd)this).zzj().zza(l) : ((zzd)this).zzj().zzb.zzb()) > 0L) {
                ((zzgo)this).zzo().zza(bundle2, l2);
            }
            String string = "auto";
            if (((zzgo)this).zzs().zza(zzat.zzbu)) {
                if (!((zzgo)this).zzs().zzh().booleanValue()) {
                    bundle2.putLong("_mst", 1L);
                }
                String string2 = string = zzig2.zze ? "app" : "auto";
            }
            if (((zzgo)this).zzs().zza(zzat.zzbu)) {
                long l3 = ((zzgo)this).zzl().currentTimeMillis();
                if (zzig2.zze && zzig2.zzf != 0L) {
                    l3 = zzig2.zzf;
                }
                ((zzd)this).zze().zza(string, "_vs", l3, bundle2);
            } else {
                ((zzd)this).zze().zzb(string, "_vs", bundle2);
            }
        }
        this.zza = zzig2;
        if (((zzgo)this).zzs().zza(zzat.zzbu) && zzig2.zze) {
            this.zzh = zzig2;
        }
        ((zzd)this).zzg().zza(zzig2);
    }

    @WorkerThread
    private final void zza(zzig zzig2, boolean bl, long l) {
        boolean bl2;
        ((zzd)this).zzd().zza(((zzgo)this).zzl().elapsedRealtime());
        boolean bl3 = bl2 = zzig2 != null && zzig2.zzd;
        if (((zzd)this).zzj().zza(bl2, bl, l) && zzig2 != null) {
            zzig2.zzd = false;
        }
    }

    public static void zza(zzig zzig2, Bundle bundle, boolean bl) {
        if (bundle != null && zzig2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzig2.zza != null) {
                bundle.putString("_sn", zzig2.zza);
            } else {
                bundle.remove("_sn");
            }
            if (zzig2.zzb != null) {
                bundle.putString("_sc", zzig2.zzb);
            } else {
                bundle.remove("_sc");
            }
            bundle.putLong("_si", zzig2.zzc);
            return;
        }
        if (bundle != null && zzig2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzig zzig2) {
        ((zzgo)this).zzc();
        zzij zzij2 = this;
        synchronized (zzij2) {
            if (this.zzl == null || this.zzl.equals(string) || zzig2 != null) {
                this.zzl = string;
                this.zzk = zzig2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zza(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzig zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzig zzig2 = this.zzd.get(activity);
        if (zzig2 == null) {
            String string = zzij.zza(activity.getClass().getCanonicalName());
            zzig2 = new zzig(null, string, ((zzgo)this).zzo().zzf());
            this.zzd.put(activity, zzig2);
        }
        if (!((zzgo)this).zzs().zza(zzat.zzbu)) {
            return zzig2;
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return zzig2;
    }

    @MainThread
    public final void zza(Activity activity, Bundle bundle) {
        if (!((zzgo)this).zzs().zzh().booleanValue()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzig zzig2 = new zzig(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzig2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(Activity activity) {
        zzd zzd2;
        Object object;
        if (((zzgo)this).zzs().zza(zzat.zzbu)) {
            object = this.zzj;
            synchronized (object) {
                this.zzi = true;
                if (activity != this.zze) {
                    Activity activity2 = activity;
                    zzd2 = this;
                    Object object2 = ((zzij)zzd2).zzj;
                    synchronized (object2) {
                        ((zzij)zzd2).zze = activity2;
                        ((zzij)zzd2).zzf = false;
                    }
                    if (zzd2.zzs().zza(zzat.zzbt) && zzd2.zzs().zzh().booleanValue()) {
                        ((zzij)zzd2).zzg = null;
                        zzd2.zzp().zza(new zzip((zzij)zzd2));
                    }
                }
            }
        }
        if (((zzgo)this).zzs().zza(zzat.zzbt) && !((zzgo)this).zzs().zzh().booleanValue()) {
            this.zzb = this.zzg;
            ((zzgo)this).zzp().zza(new zzik(this));
            return;
        }
        object = this.zzd(activity);
        this.zza(activity, (zzig)object, false);
        zzd2 = ((zzd)this).zzd();
        long l = zzd2.zzl().elapsedRealtime();
        zzd2.zzp().zza(new zze((zza)zzd2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzb(Activity activity) {
        if (((zzgo)this).zzs().zza(zzat.zzbu)) {
            Object object = this.zzj;
            synchronized (object) {
                this.zzi = false;
                this.zzf = true;
            }
        }
        long l = ((zzgo)this).zzl().elapsedRealtime();
        if (((zzgo)this).zzs().zza(zzat.zzbt) && !((zzgo)this).zzs().zzh().booleanValue()) {
            this.zzb = null;
            ((zzgo)this).zzp().zza(new zzin(this, l));
            return;
        }
        zzig zzig2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzgo)this).zzp().zza(new zzim(this, zzig2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (!((zzgo)this).zzs().zzh().booleanValue()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzig zzig2 = this.zzd.get(activity);
        if (zzig2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzig2.zzc);
        bundle2.putString("name", zzig2.zza);
        bundle2.putString("referrer_name", zzig2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzc(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            if (activity == this.zze) {
                this.zze = null;
            }
        }
        if (!((zzgo)this).zzs().zzh().booleanValue()) {
            return;
        }
        this.zzd.remove(activity);
    }

    static /* synthetic */ void zza(zzij zzij2, Bundle bundle, zzig zzig2, zzig zzig3, long l) {
        zzij2.zza(bundle, zzig2, zzig3, l);
    }

    static /* synthetic */ void zza(zzij zzij2, zzig zzig2, zzig zzig3, long l, boolean bl, Bundle bundle) {
        zzij2.zza(zzig2, zzig3, l, bl, null);
    }

    static /* synthetic */ zzig zza(zzij zzij2) {
        return zzij2.zzh;
    }

    static /* synthetic */ void zza(zzij zzij2, zzig zzig2, boolean bl, long l) {
        zzij2.zza(zzig2, false, l);
    }

    static /* synthetic */ zzig zza(zzij zzij2, zzig zzig2) {
        zzij2.zzh = null;
        return null;
    }
}

