/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzmj;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzkf;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzw;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzio
extends zzg {
    private final zzji zza;
    private zzej zzb;
    private volatile Boolean zzc;
    private final zzaj zzd;
    private final zzkf zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzaj zzg;

    protected zzio(zzfv zzfv2) {
        super(zzfv2);
        this.zze = new zzkf(zzfv2.zzl());
        this.zza = new zzji(this);
        this.zzd = new zzir(this, zzfv2);
        this.zzg = new zzjb(this, zzfv2);
    }

    @Override
    protected final boolean zzy() {
        return false;
    }

    @WorkerThread
    public final boolean zzaa() {
        ((zzgo)this).zzc();
        this.zzv();
        return this.zzb != null;
    }

    @WorkerThread
    protected final void zzab() {
        ((zzgo)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(true);
        this.zza(new zzjd(this, zzn2));
    }

    @WorkerThread
    protected final void zza(boolean bl) {
        if (zzmj.zzb() && ((zzgo)this).zzs().zza(zzat.zzcg)) {
            ((zzgo)this).zzc();
            this.zzv();
            if (bl) {
                ((zzd)this).zzi().zzaa();
            }
            if (this.zzai()) {
                zzn zzn2 = this.zzb(false);
                this.zza(new zzjc(this, zzn2));
            }
        }
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzej zzej2, AbstractSafeParcelable abstractSafeParcelable, zzn zzn2) {
        ((zzgo)this).zzc();
        this.zzv();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            List<AbstractSafeParcelable> list = ((zzd)this).zzi().zza(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzar) {
                    try {
                        zzej2.zza((zzar)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgo)this).zzq().zze().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzkr) {
                    try {
                        zzej2.zza((zzkr)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgo)this).zzq().zze().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzw) {
                    try {
                        zzej2.zza((zzw)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgo)this).zzq().zze().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzgo)this).zzq().zze().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzar zzar2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzar2));
        ((zzgo)this).zzc();
        this.zzv();
        boolean bl = ((zzd)this).zzi().zza(zzar2);
        zzn zzn2 = this.zzb(true);
        this.zza(new zzjf(this, true, bl, zzar2, zzn2, string));
    }

    @WorkerThread
    protected final void zza(zzw zzw2) {
        Preconditions.checkNotNull((Object)((Object)zzw2));
        ((zzgo)this).zzc();
        this.zzv();
        boolean bl = ((zzd)this).zzi().zza(zzw2);
        zzw zzw3 = new zzw(zzw2);
        zzn zzn2 = this.zzb(true);
        this.zza(new zzje(this, true, bl, zzw3, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzw>> atomicReference, String string, String string2, String string3) {
        ((zzgo)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzjh(this, atomicReference, string, string2, string3, zzn2));
    }

    @WorkerThread
    protected final void zza(com.google.android.gms.internal.measurement.zzw zzw2, String string, String string2) {
        ((zzgo)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzjg(this, string, string2, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzkr>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzgo)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzjj(this, atomicReference, string, string2, string3, bl, zzn2));
    }

    @WorkerThread
    protected final void zza(com.google.android.gms.internal.measurement.zzw zzw2, String string, String string2, boolean bl) {
        ((zzgo)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zziq(this, string, string2, bl, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zza(zzkr zzkr2) {
        ((zzgo)this).zzc();
        this.zzv();
        boolean bl = ((zzd)this).zzi().zza(zzkr2);
        zzn zzn2 = this.zzb(true);
        this.zza(new zzit(this, bl, zzkr2, zzn2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzkr>> atomicReference, boolean bl) {
        ((zzgo)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzis(this, atomicReference, zzn2, bl));
    }

    @WorkerThread
    protected final void zzac() {
        ((zzgo)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        ((zzd)this).zzi().zzaa();
        this.zza(new zziv(this, zzn2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzgo)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zziu(this, atomicReference, zzn2));
    }

    @WorkerThread
    public final void zza(com.google.android.gms.internal.measurement.zzw zzw2) {
        ((zzgo)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzix(this, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zzad() {
        ((zzgo)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(true);
        ((zzd)this).zzi().zzab();
        this.zza(new zziw(this, zzn2));
    }

    @WorkerThread
    protected final void zza(zzig zzig2) {
        ((zzgo)this).zzc();
        this.zzv();
        this.zza(new zziz(this, zzig2));
    }

    @WorkerThread
    public final void zza(Bundle bundle) {
        ((zzgo)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zziy(this, bundle, zzn2));
    }

    @WorkerThread
    private final void zzaj() {
        ((zzgo)this).zzc();
        this.zze.zza();
        this.zzd.zza((Long)zzat.zzai.zza(null));
    }

    @WorkerThread
    final void zzae() {
        ((zzgo)this).zzc();
        this.zzv();
        if (this.zzaa()) {
            return;
        }
        if (this.zzak()) {
            this.zza.zzb();
            return;
        }
        if (!((zzgo)this).zzs().zzw()) {
            Intent intent;
            zzio zzio2 = this;
            PackageManager packageManager = ((zzgo)zzio2).zzm().getPackageManager();
            List list = packageManager.queryIntentServices(intent = new Intent().setClassName(((zzgo)zzio2).zzm(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && list.size() > 0) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                intent2.setComponent(new ComponentName(((zzgo)this).zzm(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzgo)this).zzq().zze().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    final Boolean zzaf() {
        return this.zzc;
    }

    @WorkerThread
    private final boolean zzak() {
        ((zzgo)this).zzc();
        this.zzv();
        if (this.zzc == null) {
            boolean bl;
            zzio zzio2 = this;
            ((zzgo)zzio2).zzc();
            zzio2.zzv();
            Boolean bl2 = ((zzgo)zzio2).zzr().zzi();
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else {
                boolean bl3;
                boolean bl4;
                if (((zzd)zzio2).zzf().zzaf() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzgo)zzio2).zzq().zzw().zza("Checking service availability");
                    int n = ((zzgo)zzio2).zzo().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzgo)zzio2).zzq().zzw().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzgo)zzio2).zzq().zzw().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzgo)zzio2).zzq().zzh().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzgo)zzio2).zzq().zzv().zza("Service container out of date");
                            if (((zzgo)zzio2).zzo().zzi() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            bl4 = bl2 == null;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzgo)zzio2).zzq().zzh().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzgo)zzio2).zzq().zzh().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzgo)zzio2).zzq().zzh().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzgo)zzio2).zzs().zzw()) {
                    ((zzgo)zzio2).zzq().zze().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzgo)zzio2).zzr().zza(bl4);
                }
                bl = bl4;
            }
            this.zzc = bl;
        }
        return this.zzc;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzej zzej2) {
        ((zzgo)this).zzc();
        Preconditions.checkNotNull((Object)zzej2);
        this.zzb = zzej2;
        this.zzaj();
        this.zzam();
    }

    @WorkerThread
    public final void zzag() {
        ((zzgo)this).zzc();
        this.zzv();
        this.zza.zza();
        try {
            ConnectionTracker.getInstance().unbindService(((zzgo)this).zzm(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zza(ComponentName componentName) {
        ((zzgo)this).zzc();
        if (this.zzb != null) {
            this.zzb = null;
            ((zzgo)this).zzq().zzw().zza("Disconnected from device MeasurementService", componentName);
            zzio zzio2 = this;
            ((zzgo)zzio2).zzc();
            zzio2.zzae();
        }
    }

    @WorkerThread
    private final void zzal() {
        ((zzgo)this).zzc();
        if (!this.zzaa()) {
            return;
        }
        ((zzgo)this).zzq().zzw().zza("Inactivity, disconnecting from the service");
        this.zzag();
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzgo)this).zzc();
        if (this.zzaa()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzgo)this).zzq().zze().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzae();
    }

    @WorkerThread
    private final void zzam() {
        ((zzgo)this).zzc();
        ((zzgo)this).zzq().zzw().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzgo)this).zzq().zze().zza("Task exception while flushing queue", exception);
            }
        }
        this.zzf.clear();
        this.zzg.zzc();
    }

    @WorkerThread
    @Nullable
    private final zzn zzb(boolean bl) {
        return ((zzd)this).zzf().zza(bl ? ((zzgo)this).zzq().zzx() : null);
    }

    @WorkerThread
    public final void zza(com.google.android.gms.internal.measurement.zzw zzw2, zzar zzar2, String string) {
        ((zzgo)this).zzc();
        this.zzv();
        if (((zzgo)this).zzo().zza(12451000) != 0) {
            ((zzgo)this).zzq().zzh().zza("Not bundling data. Service unavailable or out of date");
            ((zzgo)this).zzo().zza(zzw2, new byte[0]);
            return;
        }
        this.zza(new zzja(this, zzar2, string, zzw2));
    }

    @WorkerThread
    final boolean zzah() {
        ((zzgo)this).zzc();
        this.zzv();
        if (!this.zzak()) {
            return true;
        }
        return ((zzgo)this).zzo().zzi() >= 200900;
    }

    @WorkerThread
    final boolean zzai() {
        ((zzgo)this).zzc();
        this.zzv();
        if (!((zzgo)this).zzs().zza(zzat.zzci)) {
            return false;
        }
        if (!this.zzak()) {
            return true;
        }
        return ((zzgo)this).zzo().zzi() >= (Integer)zzat.zzcj.zza(null);
    }

    static /* synthetic */ zzji zza(zzio zzio2) {
        return zzio2.zza;
    }

    static /* synthetic */ void zza(zzio zzio2, ComponentName componentName) {
        zzio2.zza(componentName);
    }

    static /* synthetic */ zzej zza(zzio zzio2, zzej zzej2) {
        zzio2.zzb = null;
        return null;
    }

    static /* synthetic */ void zzb(zzio zzio2) {
        zzio2.zzam();
    }

    static /* synthetic */ void zzc(zzio zzio2) {
        zzio2.zzal();
    }

    static /* synthetic */ zzej zzd(zzio zzio2) {
        return zzio2.zzb;
    }

    static /* synthetic */ void zze(zzio zzio2) {
        zzio2.zzaj();
    }
}

