/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzmi;
import com.google.android.gms.internal.measurement.zznt;
import com.google.android.gms.internal.measurement.zzof;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzkw;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

public final class zzy
extends zzgo {
    private Boolean zza;
    @NonNull
    private zzaa zzb = zzab.zza;
    private Boolean zzc;

    zzy(zzfv zzfv2) {
        super(zzfv2);
    }

    final void zza(@NonNull zzaa zzaa2) {
        this.zzb = zzaa2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int zzd() {
        if (!zzmi.zzb()) return 25;
        zzeg<Boolean> zzeg2 = zzat.zzbw;
        if (!((zzgo)this).zzs().zzd(null, zzeg2)) return 25;
        zzkw zzkw2 = ((zzgo)this).zzo();
        Boolean bl = zzkw2.zzy.zzv().zzaf();
        if (zzkw2.zzi() >= 201500) return 100;
        if (bl == null) return 25;
        if (bl != false) return 25;
        return 100;
    }

    public final int zza(@Size(min=1L) String string) {
        return this.zza(string, zzat.zzah, 25, 100);
    }

    final int zzb(@Size(min=1L) String string) {
        zzeg<Boolean> zzeg2;
        if (zzmi.zzb() && this.zzd(null, zzeg2 = zzat.zzbv)) {
            return this.zza(string, zzat.zzag, 500, 2000);
        }
        return 500;
    }

    @WorkerThread
    public final int zzc(@Size(min=1L) String string) {
        return this.zzb(string, zzat.zzn);
    }

    final int zzd(@Size(min=1L) String string) {
        zzeg<Boolean> zzeg2;
        if (zzmi.zzb() && this.zzd(null, zzeg2 = zzat.zzbv)) {
            return this.zza(string, zzat.zzaf, 25, 100);
        }
        return 25;
    }

    @WorkerThread
    final long zze(String string) {
        return this.zza(string, zzat.zza);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zze() {
        if (this.zzc == null) {
            zzy zzy2 = this;
            synchronized (zzy2) {
                if (this.zzc == null) {
                    ApplicationInfo applicationInfo = ((zzgo)this).zzm().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzc = string2 != null && string2.equals(string);
                    }
                    if (this.zzc == null) {
                        this.zzc = Boolean.TRUE;
                        ((zzgo)this).zzq().zze().zza("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzc;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzeg<Long> zzeg2) {
        if (string == null) {
            return zzeg2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzeg2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzeg2.zza(null);
        }
        try {
            long l = Long.parseLong(string2);
            return zzeg2.zza(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzeg2.zza(null);
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzeg<Integer> zzeg2) {
        if (string == null) {
            return zzeg2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzeg2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzeg2.zza(null);
        }
        try {
            int n = Integer.parseInt(string2);
            return zzeg2.zza(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzeg2.zza(null);
        }
    }

    @WorkerThread
    private final int zza(String string, @NonNull zzeg<Integer> zzeg2, int n, int n2) {
        return Math.max(Math.min(this.zzb(string, zzeg2), n2), n);
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzeg<Double> zzeg2) {
        if (string == null) {
            return zzeg2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzeg2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzeg2.zza(null);
        }
        try {
            double d = Double.parseDouble(string2);
            return zzeg2.zza(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzeg2.zza(null);
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzeg<Boolean> zzeg2) {
        if (string == null) {
            return zzeg2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzeg2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzeg2.zza(null);
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zzeg2.zza(bl);
    }

    public final boolean zze(String string, zzeg<Boolean> zzeg2) {
        return this.zzd(string, zzeg2);
    }

    public final boolean zza(zzeg<Boolean> zzeg2) {
        zzeg<Boolean> zzeg3 = zzeg2;
        return this.zzd(null, zzeg3);
    }

    @Nullable
    @VisibleForTesting
    private final Bundle zzx() {
        try {
            if (((zzgo)this).zzm().getPackageManager() == null) {
                ((zzgo)this).zzq().zze().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzgo)this).zzm()).getApplicationInfo(((zzgo)this).zzm().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzgo)this).zzq().zze().zza("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            return applicationInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzgo)this).zzq().zze().zza("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzf(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzx();
        if (bundle == null) {
            ((zzgo)this).zzq().zze().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    @Nullable
    @VisibleForTesting
    final List<String> zzg(@Size(min=1L) String string) {
        Integer n;
        Integer n2;
        String string2 = string;
        zzy zzy2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzy2.zzx();
        if (bundle == null) {
            ((zzgo)zzy2).zzq().zze().zza("Failed to load metadata: Metadata bundle is null");
            n2 = null;
        } else {
            n2 = n = !bundle.containsKey(string2) ? null : Integer.valueOf(bundle.getInt(string2));
        }
        if (n2 == null) {
            return null;
        }
        try {
            String[] stringArray = ((zzgo)this).zzm().getResources().getStringArray(n.intValue());
            if (stringArray == null) {
                return null;
            }
            return Arrays.asList(stringArray);
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzgo)this).zzq().zze().zza("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    public final boolean zzf() {
        Boolean bl = this.zzf("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final Boolean zzg() {
        Boolean bl = this.zzf("google_analytics_adid_collection_enabled");
        return bl == null || bl != false;
    }

    public final Boolean zzh() {
        if (!zzof.zzb() || !this.zza(zzat.zzbt)) {
            return true;
        }
        Boolean bl = this.zzf("google_analytics_automatic_screen_reporting_enabled");
        return bl == null || bl != false;
    }

    public static long zzi() {
        return zzat.zzac.zza(null);
    }

    public final String zza(zzf zzf2) {
        String string;
        Uri.Builder builder;
        block2: {
            block3: {
                builder = new Uri.Builder();
                string = zzf2.zze();
                if (!TextUtils.isEmpty((CharSequence)string)) break block2;
                if (!zznt.zzb()) break block3;
                zzeg<Boolean> zzeg2 = zzat.zzbi;
                if (((zzgo)this).zzs().zzd(zzf2.zzc(), zzeg2) && !TextUtils.isEmpty((CharSequence)(string = zzf2.zzg()))) break block2;
            }
            string = zzf2.zzf();
        }
        String string2 = String.valueOf(string);
        builder.scheme((String)zzat.zzd.zza(null)).encodedAuthority((String)zzat.zze.zza(null)).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", zzf2.zzd()).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "32053");
        return builder.build().toString();
    }

    public static long zzj() {
        return zzat.zzc.zza(null);
    }

    public final String zzu() {
        return this.zza("debug.firebase.analytics.app", "");
    }

    public final String zzv() {
        return this.zza("debug.deferred.deeplink", "");
    }

    private final String zza(String string, String string2) {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzgo)this).zzq().zze().zza("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzgo)this).zzq().zze().zza("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzgo)this).zzq().zze().zza("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzgo)this).zzq().zze().zza("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return string2;
    }

    public final boolean zzh(String string) {
        return "1".equals(this.zzb.zza(string, "gaia_collection_enabled"));
    }

    public final boolean zzi(String string) {
        return "1".equals(this.zzb.zza(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzj(String string) {
        return this.zzd(string, zzat.zzaj);
    }

    @WorkerThread
    final String zzk(String string) {
        zzeg<String> zzeg2 = zzat.zzak;
        String string2 = string;
        zzy zzy2 = this;
        if (string2 == null) {
            return zzeg2.zza(null);
        }
        return zzeg2.zza(zzy2.zzb.zza(string2, zzeg2.zza()));
    }

    @WorkerThread
    final boolean zzw() {
        if (this.zza == null) {
            this.zza = this.zzf("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzy.zzs();
    }
}

