/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.StringResourceValueReader;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzlm;
import com.google.android.gms.internal.measurement.zzmw;
import com.google.android.gms.internal.measurement.zznx;
import com.google.android.gms.internal.measurement.zzog;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzp;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzel
extends zzf {
    private String zza;
    private String zzb;
    private int zzc;
    private String zzd;
    private String zze;
    private long zzf;
    private final long zzg;
    private List<String> zzh;
    private int zzi;
    private String zzj;
    private String zzk;
    private String zzl;

    zzel(zzfw zzfw2, long l) {
        super(zzfw2);
        this.zzg = l;
    }

    @Override
    protected final boolean zze() {
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @EnsuresNonNull(value={"appId", "appStore", "appName", "gmpAppId", "gaAppId"})
    protected final void zzf() {
        block44: {
            block45: {
                var6_1 = this.zzx.zzaw().getPackageName();
                var7_2 = this.zzx.zzaw().getPackageManager();
                var1_3 = "unknown";
                var3_19 = "Unknown";
                var5_24 = "Unknown";
                if (var7_2 == null) {
                    this.zzx.zzat().zzb().zzb("PackageManager is null, app identity information might be inaccurate. appId", zzet.zzl(var6_1));
                    var2_26 = var3_19;
                    var3_20 = -2147483648;
                    var4_38 /* !! */  = var5_24;
                } else {
                    block42: {
                        block41: {
                            try {
                                var2_26 = var7_2.getInstallerPackageName(var6_1);
                                var1_3 = var2_26;
                            }
                            catch (IllegalArgumentException v0) {
                                this.zzx.zzat().zzb().zzb("Error retrieving app installer package name. appId", zzet.zzl(var6_1));
                            }
                            if (var1_3 == null) {
                                var1_3 = "manual_install";
                            } else if ("com.android.vending".equals(var1_3)) {
                                var1_3 = "";
                            }
                            var2_26 = this.zzx.zzaw();
                            var4_38 /* !! */  = var7_2.getPackageInfo(var2_26.getPackageName(), 0);
                            if (var4_38 /* !! */  == null) break block41;
                            var2_26 = var7_2.getApplicationLabel(var4_38 /* !! */ .applicationInfo);
                            var8_42 = TextUtils.isEmpty((CharSequence)var2_26);
                            var2_26 = var8_42 == false ? var2_26.toString() : var5_24;
                            var5_24 = var4_38 /* !! */ .versionName;
                            var4_41 = var4_38 /* !! */ .versionCode;
                            var3_19 = var5_24;
                            var5_24 = var2_26;
                            break block42;
                        }
                        var4_41 = -2147483648;
                    }
                    var2_26 = var3_19;
                    var3_20 = var4_41;
                    var4_38 /* !! */  = var5_24;
                }
                break block45;
                catch (PackageManager.NameNotFoundException v1) {
                    block43: {
                        var4_38 /* !! */  = var5_24;
                        break block43;
                        catch (PackageManager.NameNotFoundException v2) {
                            var4_38 /* !! */  = var2_26;
                            break block43;
                        }
                        catch (PackageManager.NameNotFoundException v3) {
                            var3_19 = var5_24;
                            var4_38 /* !! */  = var2_26;
                        }
                    }
                    this.zzx.zzat().zzb().zzc("Error retrieving package info. appId, appName", zzet.zzl(var6_1), var4_38 /* !! */ );
                    var2_26 = var3_19;
                    var3_20 = -2147483648;
                }
            }
            this.zza = var6_1;
            this.zzd = var1_3;
            this.zzb = var2_26;
            this.zzc = var3_20;
            this.zze = var4_38 /* !! */ ;
            this.zzf = 0L;
            var1_4 = !TextUtils.isEmpty((CharSequence)this.zzx.zzr()) ? "am".equals(this.zzx.zzs()) : false;
            var4_39 = this.zzx.zzG();
            switch (var4_39) {
                default: {
                    this.zzx.zzat().zzi().zza("App measurement disabled due to denied storage consent");
                    break;
                }
                case 0: {
                    this.zzx.zzat().zzk().zza("App measurement collection enabled");
                    break;
                }
                case 1: {
                    this.zzx.zzat().zzi().zza("App measurement deactivated via the manifest");
                    break;
                }
                case 2: {
                    this.zzx.zzat().zzk().zza("App measurement deactivated via the init parameters");
                    break;
                }
                case 3: {
                    this.zzx.zzat().zzi().zza("App measurement disabled by setAnalyticsCollectionEnabled(false)");
                    break;
                }
                case 4: {
                    this.zzx.zzat().zzi().zza("App measurement disabled via the manifest");
                    break;
                }
                case 5: {
                    this.zzx.zzat().zzk().zza("App measurement disabled via the init parameters");
                    break;
                }
                case 6: {
                    this.zzx.zzat().zzh().zza("App measurement deactivated via resources. This method is being deprecated. Please refer to https://firebase.google.com/support/guides/disable-analytics");
                    break;
                }
                case 7: {
                    this.zzx.zzat().zzi().zza("App measurement disabled via the global data collection setting");
                }
            }
            this.zzj = "";
            this.zzk = "";
            this.zzl = "";
            this.zzx.zzas();
            if (var1_4) {
                this.zzk = this.zzx.zzr();
            }
            try {
                block47: {
                    block46: {
                        zznx.zzb();
                        var1_5 = this.zzx.zzc();
                        var2_26 = zzeh.zzaM;
                        var1_6 = var1_5.zzn(null, (zzeg<Boolean>)var2_26);
                        if (var1_6) {
                            var1_7 /* !! */  = this.zzx.zzaw();
                            var2_26 = this.zzx.zzv();
                            var1_7 /* !! */  = zzie.zzb((Context)var1_7 /* !! */ , (String)"google_app_id", (String)var2_26);
                        } else {
                            var1_7 /* !! */  = this.zzx.zzaw();
                            var1_7 /* !! */  = zzie.zza((Context)var1_7 /* !! */ , (String)"google_app_id");
                        }
                        var2_28 = true != (var2_27 = TextUtils.isEmpty((CharSequence)var1_7 /* !! */ )) ? var1_7 /* !! */  : "";
                        this.zzj = var2_28;
                        zzmw.zzb();
                        var2_28 = this.zzx.zzc();
                        var3_21 = zzeh.zzah;
                        var2_29 = var2_28.zzn(null, (zzeg<Boolean>)var3_21);
                        if (!var2_29) break block46;
                        zznx.zzb();
                        var2_30 = this.zzx.zzc();
                        var3_21 = zzeh.zzaM;
                        var2_31 = var2_30.zzn(null, (zzeg<Boolean>)var3_21);
                        if (var2_31) {
                            var2_32 /* !! */  = this.zzx.zzaw();
                            var3_21 = this.zzx.zzv();
                            Preconditions.checkNotNull((Object)var2_32 /* !! */ );
                            var5_24 = var2_32 /* !! */ .getResources();
                            var8_42 = TextUtils.isEmpty((CharSequence)var3_21);
                            var2_32 /* !! */  = var8_42 == false ? var3_21 : zzfo.zza((Context)var2_32 /* !! */ );
                            var8_43 = zzfo.zzb((String)"ga_app_id", (Resources)var5_24, (String)var2_32 /* !! */ );
                            var3_22 = TextUtils.isEmpty((CharSequence)var8_43);
                            var3_21 = true != var3_22 ? var8_43 : "";
                            this.zzl = var3_21;
                            var1_8 = TextUtils.isEmpty((CharSequence)var1_7 /* !! */ );
                            if (!var1_8 || !(var1_8 = TextUtils.isEmpty((CharSequence)var8_43))) {
                                this.zzk = zzfo.zzb((String)"admob_app_id", (Resources)var5_24, (String)var2_32 /* !! */ );
                            }
                            break block47;
                        } else {
                            var2_34 = this.zzx.zzaw();
                            var3_21 = new StringResourceValueReader(var2_34);
                            var5_24 = var3_21.getString("ga_app_id");
                            var2_35 = TextUtils.isEmpty((CharSequence)var5_24);
                            var2_36 = true != var2_35 ? var5_24 : "";
                            this.zzl = var2_36;
                            var1_12 = TextUtils.isEmpty((CharSequence)var1_7 /* !! */ );
                            if (!var1_12 || !(var1_12 = TextUtils.isEmpty((CharSequence)var5_24))) {
                                this.zzk = var3_21.getString("admob_app_id");
                            }
                        }
                        break block47;
                    }
                    var1_13 = TextUtils.isEmpty((CharSequence)var1_7 /* !! */ );
                    if (!var1_13) {
                        zznx.zzb();
                        var1_14 = this.zzx.zzc();
                        var2_37 /* !! */  = zzeh.zzaM;
                        var1_15 = var1_14.zzn(null, (zzeg<Boolean>)var2_37 /* !! */ );
                        if (var1_15) {
                            var1_16 /* !! */  = this.zzx.zzaw();
                            var2_37 /* !! */  = this.zzx.zzv();
                            Preconditions.checkNotNull((Object)var1_16 /* !! */ );
                            var3_21 = var1_16 /* !! */ .getResources();
                            var5_25 = TextUtils.isEmpty((CharSequence)var2_37 /* !! */ );
                            var1_16 /* !! */  = var5_25 == false ? var2_37 /* !! */  : zzfo.zza((Context)var1_16 /* !! */ );
                            this.zzk = zzfo.zzb((String)"admob_app_id", (Resources)var3_21, (String)var1_16 /* !! */ );
                        } else {
                            var2_37 /* !! */  = this.zzx.zzaw();
                            var1_17 = new StringResourceValueReader(var2_37 /* !! */ );
                            this.zzk = var1_17.getString("admob_app_id");
                        }
                    }
                }
                if (var4_39 == 0) {
                    var1_9 = this.zzx.zzat();
                    var2_26 = var1_9.zzk();
                    var3_21 = "App measurement enabled for app package, google app id";
                    var4_40 = this.zza;
                    var1_4 = TextUtils.isEmpty((CharSequence)this.zzj);
                    var1_10 = var1_4 != false ? this.zzk : this.zzj;
                    var2_26.zzc((String)var3_21, var4_40, var1_10);
                }
            }
            catch (IllegalStateException var1_18) {
                this.zzx.zzat().zzb().zzc("Fetching Google App Id failed with exception. appId", zzet.zzl(var6_1), var1_18);
            }
            this.zzh = null;
            this.zzx.zzas();
            var1_11 = this.zzx.zzc().zzq("analytics.safelisted_events");
            if (var1_11 == null) ** GOTO lbl196
            if (var1_11.size() == 0) {
                this.zzx.zzat().zzh().zza("Safelisted event list is empty. Ignoring");
            } else {
                for (String var3_23 : var1_11) {
                    if (this.zzx.zzl().zzk("safelisted event", var3_23)) continue;
                    break block44;
                }
lbl196:
                // 2 sources

                this.zzh = var1_11;
            }
        }
        if (var7_2 != null) {
            this.zzi = (int)InstantApps.isInstantApp((Context)this.zzx.zzaw());
            return;
        }
        this.zzi = 0;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final zzp zzh(String string) {
        long l;
        long l2;
        Object object;
        boolean bl;
        boolean bl2;
        Object object2;
        Object object3;
        long l3;
        String string2;
        long l4;
        String string3;
        String string4;
        String string5;
        block24: {
            PackageManager packageManager;
            block22: {
                long l5;
                block23: {
                    ((zzgp)((Object)string8)).zzg();
                    string5 = ((zzel)((Object)string8)).zzi();
                    string4 = ((zzel)((Object)string8)).zzj();
                    ((zzf)((Object)string8)).zzb();
                    string3 = ((zzel)((Object)string8)).zzb;
                    ((zzf)((Object)string8)).zzb();
                    l4 = ((zzel)((Object)string8)).zzc;
                    ((zzf)((Object)string8)).zzb();
                    Preconditions.checkNotNull((Object)((zzel)((Object)string8)).zzd);
                    string2 = ((zzel)((Object)string8)).zzd;
                    ((zzgp)((Object)string8)).zzx.zzc().zzf();
                    ((zzf)((Object)string8)).zzb();
                    ((zzgp)((Object)string8)).zzg();
                    l3 = ((zzel)((Object)string8)).zzf;
                    if (l3 != 0L) break block22;
                    zzkv zzkv2 = ((zzel)((Object)string8)).zzx.zzl();
                    object3 = ((zzgp)((Object)string8)).zzx.zzaw();
                    String string6 = ((zzgp)((Object)string8)).zzx.zzaw().getPackageName();
                    zzkv2.zzg();
                    Preconditions.checkNotNull((Object)object3);
                    Preconditions.checkNotEmpty((String)string6);
                    packageManager = object3.getPackageManager();
                    object2 = zzkv.zzN();
                    if (object2 == null) {
                        zzkv2.zzx.zzat().zzb().zza("Could not get MD5 instance");
                        l5 = -1L;
                    } else {
                        if (packageManager != null) {
                            long l6;
                            boolean bl3 = zzkv2.zzW((Context)object3, string6);
                            if (!bl3) {
                                int n;
                                object3 = Wrappers.packageManager((Context)object3);
                                Context context = zzkv2.zzx.zzaw();
                                object3 = object3.getPackageInfo(context.getPackageName(), 64);
                                Signature[] signatureArray = ((PackageInfo)object3).signatures;
                                if (signatureArray != null && (n = ((PackageInfo)object3).signatures.length) > 0) {
                                    long l7;
                                    l6 = l7 = zzkv.zzO(((MessageDigest)object2).digest(((PackageInfo)object3).signatures[0].toByteArray()));
                                } else {
                                    object3 = zzkv2.zzx.zzat();
                                    ((zzet)object3).zze().zza("Could not get signatures");
                                    l6 = -1L;
                                }
                            } else {
                                l6 = 0L;
                            }
                            l5 = l6;
                        }
                        l5 = 0L;
                    }
                    break block23;
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        zzkv2.zzx.zzat().zzb().zzb("Package name not found", (Object)nameNotFoundException);
                        l5 = 0L;
                    }
                }
                ((zzel)((Object)string8)).zzf = l5;
                l3 = l5;
            }
            bl2 = ((zzel)((Object)string8)).zzx.zzF();
            bl = ((zzgp)((Object)string8)).zzx.zzd().zzp ^ true;
            ((zzgp)((Object)string8)).zzg();
            if (!((zzel)((Object)string8)).zzx.zzF()) {
                object = null;
            } else {
                zzog.zzb();
                if (((zzgp)((Object)string8)).zzx.zzc().zzn(null, zzeh.zzaj)) {
                    ((zzgp)((Object)string8)).zzx.zzat().zzk().zza("Disabled IID for tests.");
                    object = null;
                } else {
                    block21: {
                        block20: {
                            object = ((zzgp)((Object)string8)).zzx.zzaw();
                            object = object.getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics");
                            if (object != null) break block20;
                            object = null;
                        }
                        object3 = new Class[]{Context.class};
                        object3 = ((Class)object).getDeclaredMethod("getInstance", (Class<?>)object3);
                        Object[] objectArray = new Object[1];
                        packageManager = ((zzgp)((Object)string8)).zzx.zzaw();
                        objectArray[0] = packageManager;
                        object3 = ((Method)object3).invoke(null, objectArray);
                        if (object3 != null) break block21;
                        object = null;
                    }
                    object = (String)((Class)object).getDeclaredMethod("getFirebaseInstanceId", new Class[0]).invoke(object3, new Object[0]);
                    catch (ClassNotFoundException classNotFoundException) {
                        object = null;
                    }
                }
            }
            break block24;
            catch (Exception exception) {
                ((zzgp)((Object)string8)).zzx.zzat().zzf().zza("Failed to obtain Firebase Analytics instance");
                object = null;
            }
            break block24;
            catch (Exception exception) {
                ((zzgp)((Object)string8)).zzx.zzat().zzh().zza("Failed to retrieve Firebase Instance Id");
                object = null;
            }
        }
        object3 = ((zzel)((Object)string8)).zzx;
        Long l8 = ((zzfw)object3).zzd().zzh.zza();
        long l9 = l8 == 0L ? (l2 = ((zzfw)object3).zzc) : (l = Math.min(((zzfw)object3).zzc, l8));
        ((zzf)((Object)string8)).zzb();
        int n = ((zzel)((Object)string8)).zzi;
        boolean bl4 = ((zzgp)((Object)string8)).zzx.zzc().zzs();
        object3 = ((zzgp)((Object)string8)).zzx.zzd();
        ((zzgp)object3).zzg();
        boolean bl5 = ((zzfi)object3).zzd().getBoolean("deferred_analytics_collection", false);
        ((zzf)((Object)string8)).zzb();
        String string7 = ((zzel)((Object)string8)).zzk;
        object3 = ((zzgp)((Object)string8)).zzx.zzc().zzp("google_analytics_default_allow_ad_personalization_signals");
        object3 = object3 == null ? null : Boolean.valueOf((Boolean)object3 ^ true);
        long l10 = ((zzel)((Object)string8)).zzg;
        List<String> list = ((zzel)((Object)string8)).zzh;
        zzmw.zzb();
        object2 = ((zzgp)((Object)string8)).zzx.zzc().zzn(null, zzeh.zzah) ? ((zzel)((Object)string8)).zzl() : null;
        zzlm.zzb();
        String string8 = ((zzgp)((Object)string8)).zzx.zzc().zzn(null, zzeh.zzaE) ? ((zzgp)((Object)string8)).zzx.zzd().zzi().zzd() : "";
        return new zzp(string5, string4, string3, l4, string2, 37000L, l3, string, bl2, bl, (String)object, 0L, l9, n, bl4, bl5, string7, (Boolean)object3, l10, list, (String)object2, string8);
    }

    final String zzi() {
        this.zzb();
        Preconditions.checkNotNull((Object)this.zza);
        return this.zza;
    }

    final String zzj() {
        this.zzb();
        Preconditions.checkNotNull((Object)this.zzj);
        return this.zzj;
    }

    final String zzk() {
        this.zzb();
        return this.zzk;
    }

    final String zzl() {
        this.zzb();
        Preconditions.checkNotNull((Object)this.zzl);
        return this.zzl;
    }

    final int zzm() {
        this.zzb();
        return this.zzc;
    }

    final int zzn() {
        this.zzb();
        return this.zzi;
    }

    final List<String> zzo() {
        return this.zzh;
    }
}

