/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzft
extends zzgq {
    @Nullable
    private zzfs zza;
    @Nullable
    private zzfs zzb;
    private final PriorityBlockingQueue<zzfr<?>> zzc;
    private final BlockingQueue<zzfr<?>> zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg;
    private final Semaphore zzh;
    private volatile boolean zzi;
    private static final AtomicLong zzj;

    zzft(zzfw object) {
        super((zzfw)object);
        this.zzg = object = new Object();
        this.zzh = object = new Semaphore(2);
        object = new PriorityBlockingQueue();
        this.zzc = object;
        super();
        this.zzd = object;
        this.zze = object = new zzfq(this, "Thread death: Uncaught exception on worker thread");
        this.zzf = object = new zzfq(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zza() {
        return false;
    }

    @Override
    public final void zzg() {
        if (Thread.currentThread() != ((zzft)object).zza) {
            Object object = new IllegalStateException("Call expected from worker thread");
            throw object;
        }
    }

    @Override
    public final void zzav() {
        if (Thread.currentThread() != ((zzft)object).zzb) {
            Object object = new IllegalStateException("Call expected from network thread");
            throw object;
        }
    }

    public final boolean zzd() {
        return Thread.currentThread() == this.zza;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull(callable);
        zzfr zzfr2 = new zzfr(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                this.zzx.zzat().zze().zza("Callable skipped the worker queue.");
            }
            zzfr2.run();
            return zzfr2;
        }
        this.zzt(zzfr2);
        return zzfr2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <V> Future<V> zzf(Callable<V> callable) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull(callable);
        zzfr zzfr2 = new zzfr(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            zzfr2.run();
            return zzfr2;
        }
        this.zzt(zzfr2);
        return zzfr2;
    }

    public final void zzh(Runnable runnable) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull((Object)runnable);
        zzfr zzfr2 = new zzfr(this, runnable, false, "Task exception on worker thread");
        this.zzt(zzfr2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Nullable
    final <T> T zzi(AtomicReference<T> atomicReference, long l, String string, Runnable object) {
        Object object2;
        block9: {
            // MONITORENTER : atomicReference
            zzft zzft2 = ((zzgp)object2).zzx.zzau();
            zzft2.zzh((Runnable)object);
            try {
                atomicReference.wait(l);
                // MONITOREXIT : atomicReference
                atomicReference = atomicReference.get();
                if (atomicReference != null) return (T)atomicReference;
                object = ((zzgp)object2).zzx.zzat().zze();
                object2 = "Timed out waiting for ";
                if (string.length() != 0) {
                    object2 = ((String)object2).concat(string);
                    break block9;
                }
                string = new String((String)object2);
                object2 = string;
            }
            catch (InterruptedException interruptedException) {
                object2 = ((zzgp)object2).zzx.zzat();
                object = ((zzet)object2).zze();
                object2 = "Interrupted waiting for ";
                int n = string.length();
                if (n != 0) {
                    object2 = ((String)object2).concat(string);
                } else {
                    string = new String((String)object2);
                    object2 = string;
                }
                ((zzer)object).zza((String)object2);
                // MONITOREXIT : atomicReference
                return null;
            }
        }
        ((zzer)object).zza((String)object2);
        return (T)atomicReference;
    }

    public final void zzj(Runnable runnable) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull((Object)runnable);
        zzfr zzfr2 = new zzfr(this, runnable, true, "Task exception on worker thread");
        this.zzt(zzfr2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzt(zzfr<?> runnable) {
        Object object = this.zzg;
        synchronized (object) {
            this.zzc.add((zzfr<?>)runnable);
            runnable = this.zza;
            if (runnable == null) {
                runnable = new Runnable(this, "Measurement Worker", this.zzc);
                this.zza = runnable;
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                ((zzfs)runnable).zza();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzk(Runnable object) throws IllegalStateException {
        this.zzv();
        Preconditions.checkNotNull((Object)object);
        Runnable runnable = new Runnable(this, (Runnable)object, false, "Task exception on network thread");
        object = this.zzg;
        synchronized (object) {
            this.zzd.add((zzfr<?>)runnable);
            runnable = this.zzb;
            if (runnable == null) {
                runnable = new Runnable(this, "Measurement Network", this.zzd);
                this.zzb = runnable;
                this.zzb.setUncaughtExceptionHandler(this.zzf);
                this.zzb.start();
            } else {
                ((zzfs)runnable).zza();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    static /* synthetic */ Semaphore zzl(zzft zzft2) {
        return zzft2.zzh;
    }

    static /* synthetic */ boolean zzm(zzft zzft2) {
        boolean cfr_ignored_0 = zzft2.zzi;
        return false;
    }

    static /* synthetic */ Object zzn(zzft zzft2) {
        return zzft2.zzg;
    }

    static /* synthetic */ zzfs zzo(zzft zzft2) {
        return zzft2.zza;
    }

    static /* synthetic */ zzfs zzp(zzft zzft2, zzfs zzfs2) {
        zzft2.zza = null;
        return null;
    }

    static /* synthetic */ zzfs zzq(zzft zzft2) {
        return zzft2.zzb;
    }

    static /* synthetic */ zzfs zzr(zzft zzft2, zzfs zzfs2) {
        zzft2.zzb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzs() {
        return zzj;
    }

    static {
        AtomicLong atomicLong;
        zzj = atomicLong = new AtomicLong(Long.MIN_VALUE);
    }
}

