/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzgj;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzfb
extends zzgj {
    @VisibleForTesting
    static final Pair<String, Long> zza;
    private SharedPreferences zzt;
    public zzez zzb;
    public final zzey zzc;
    public final zzey zzd;
    public final zzfa zze;
    private String zzu;
    private boolean zzv;
    private long zzw;
    public final zzey zzf;
    public final zzew zzg;
    public final zzfa zzh;
    public final zzew zzi;
    public final zzey zzj;
    public boolean zzk;
    public final zzew zzl;
    public final zzew zzm;
    public final zzey zzn;
    public final zzfa zzo;
    public final zzfa zzp;
    public final zzey zzq;
    public final zzex zzr;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final Pair<String, Boolean> zzb(String string) {
        this.zzg();
        long l = this.zzs.zzay().elapsedRealtime();
        String string2 = this.zzu;
        if (string2 != null && l < this.zzw) {
            return new Pair((Object)string2, (Object)this.zzv);
        }
        this.zzw = l + this.zzs.zzc().zzj(string, zzea.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            string = this.zzs.zzax();
            string = AdvertisingIdClient.getAdvertisingIdInfo((Context)string);
            this.zzu = "";
            string2 = string.getId();
            if (string2 != null) {
                this.zzu = string2;
            }
            this.zzv = string.isLimitAdTrackingEnabled();
        }
        catch (Exception exception) {
            this.zzs.zzau().zzj().zzb("Unable to get advertising id", exception);
            this.zzu = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzu, (Object)this.zzv);
    }

    zzfb(zzfp object) {
        super((zzfp)object);
        this.zzf = object = new zzey(this, "session_timeout", 1800000L);
        this.zzg = object = new zzew(this, "start_new_session", true);
        this.zzj = object = new zzey(this, "last_pause_time", 0L);
        this.zzh = object = new zzfa(this, "non_personalized_ads", null);
        this.zzi = object = new zzew(this, "allow_remote_dynamite", false);
        this.zzc = object = new zzey(this, "first_open_time", 0L);
        this.zzd = object = new zzey(this, "app_install_time", 0L);
        this.zze = object = new zzfa(this, "app_instance_id", null);
        this.zzl = object = new zzew(this, "app_backgrounded", false);
        this.zzm = object = new zzew(this, "deep_link_retrieval_complete", false);
        this.zzn = object = new zzey(this, "deep_link_retrieval_attempts", 0L);
        this.zzo = object = new zzfa(this, "firebase_feature_rollouts", null);
        this.zzp = object = new zzfa(this, "deferred_attribution_cache", null);
        this.zzq = object = new zzey(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzr = object = new zzex(this, "default_event_parameters", null);
    }

    @Override
    protected final boolean zza() {
        return true;
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    @WorkerThread
    protected final void zzaz() {
        zzez zzez2;
        boolean bl;
        this.zzt = this.zzs.zzax().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzk = bl = this.zzt.getBoolean("has_been_opened", false);
        if (!bl) {
            SharedPreferences.Editor editor = this.zzt.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzs.zzc();
        this.zzb = zzez2 = new zzez(this, "health_monitor", Math.max(0L, (Long)zzea.zzb.zzb(null)), null);
    }

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zzd() {
        this.zzg();
        this.zzv();
        Preconditions.checkNotNull((Object)this.zzt);
        return this.zzt;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zze(Boolean bl) {
        zzfb2.zzg();
        zzfb zzfb2 = zzfb2.zzd().edit();
        if (bl != null) {
            zzfb2.putBoolean("measurement_enabled", bl);
        } else {
            zzfb2.remove("measurement_enabled");
        }
        zzfb2.apply();
    }

    @WorkerThread
    final Boolean zzf() {
        this.zzg();
        if (this.zzd().contains("measurement_enabled")) {
            return this.zzd().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    final boolean zzh(int n) {
        return zzaf.zzm(n, this.zzd().getInt("consent_source", 100));
    }

    @WorkerThread
    final zzaf zzi() {
        this.zzg();
        return zzaf.zzc(this.zzd().getString("consent_settings", "G1"));
    }

    @WorkerThread
    final void zzj(boolean bl) {
        zzfb2.zzg();
        zzfb2.zzs.zzau().zzk().zzb("App measurement setting deferred collection", bl);
        zzfb zzfb2 = zzfb2.zzd().edit();
        zzfb2.putBoolean("deferred_analytics_collection", bl);
        zzfb2.apply();
    }

    @WorkerThread
    final boolean zzk() {
        zzfb zzfb2 = zzfb2.zzt;
        if (zzfb2 == null) {
            return false;
        }
        return zzfb2.contains("deferred_analytics_collection");
    }

    final boolean zzl(long l) {
        return l - this.zzf.zza() > this.zzj.zza();
    }

    static {
        Pair pair;
        zza = pair = new Pair((Object)"", (Object)0L);
    }
}

