/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzlf;
import com.google.android.gms.internal.measurement.zzll;
import com.google.android.gms.internal.measurement.zzlx;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzea;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzjt;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzkl;
import com.google.android.gms.measurement.internal.zzko;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzz;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzhr
extends zzf {
    @VisibleForTesting
    protected zzhq zza;
    private zzgp zzd;
    private final Set<zzgq> zze;
    private boolean zzf;
    private final AtomicReference<String> zzg;
    private final Object zzh;
    @GuardedBy(value="consentLock")
    private zzaf zzi;
    @GuardedBy(value="consentLock")
    private int zzj;
    private final AtomicLong zzk;
    private long zzl;
    private int zzm;
    final zzr zzb;
    @VisibleForTesting
    protected boolean zzc;
    private final zzko zzn;

    protected zzhr(zzfp zzfp2) {
        super(zzfp2);
        Object object = new CopyOnWriteArraySet();
        this.zze = object;
        this.zzh = object = new Object();
        this.zzc = true;
        this.zzn = object = new zzhg(this);
        object = new AtomicReference();
        this.zzg = object;
        this.zzi = object = new zzaf(null, null);
        this.zzj = 100;
        this.zzl = -1L;
        this.zzm = 100;
        this.zzk = object = new AtomicLong(0L);
        this.zzb = object = new zzr(zzfp2);
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    public final void zzh() {
        if (this.zzs.zzax().getApplicationContext() instanceof Application && this.zza != null) {
            ((Application)this.zzs.zzax().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zza);
            return;
        }
    }

    public final Boolean zzi() {
        AtomicReference atomicReference = new AtomicReference();
        zzgk zzgk2 = this.zzs;
        zzgk2 = ((zzfp)zzgk2).zzav();
        zzhd zzhd2 = new zzhd(this, atomicReference);
        return (Boolean)((zzfm)zzgk2).zzi(atomicReference, 15000L, "boolean test flag value", zzhd2);
    }

    public final String zzj() {
        AtomicReference atomicReference = new AtomicReference();
        zzgk zzgk2 = this.zzs;
        zzgk2 = ((zzfp)zzgk2).zzav();
        zzhh zzhh2 = new zzhh(this, atomicReference);
        return (String)((zzfm)zzgk2).zzi(atomicReference, 15000L, "String test flag value", zzhh2);
    }

    public final Long zzk() {
        AtomicReference atomicReference = new AtomicReference();
        zzgk zzgk2 = this.zzs;
        zzgk2 = ((zzfp)zzgk2).zzav();
        zzhi zzhi2 = new zzhi(this, atomicReference);
        return (Long)((zzfm)zzgk2).zzi(atomicReference, 15000L, "long test flag value", zzhi2);
    }

    public final Integer zzl() {
        AtomicReference atomicReference = new AtomicReference();
        zzgk zzgk2 = this.zzs;
        zzgk2 = ((zzfp)zzgk2).zzav();
        zzhj zzhj2 = new zzhj(this, atomicReference);
        return (Integer)((zzfm)zzgk2).zzi(atomicReference, 15000L, "int test flag value", zzhj2);
    }

    public final Double zzm() {
        AtomicReference atomicReference = new AtomicReference();
        zzgk zzgk2 = this.zzs;
        zzgk2 = ((zzfp)zzgk2).zzav();
        zzhk zzhk2 = new zzhk(this, atomicReference);
        return (Double)((zzfm)zzgk2).zzi(atomicReference, 15000L, "double test flag value", zzhk2);
    }

    public final void zzn(Boolean bl) {
        this.zzb();
        zzgk zzgk2 = this.zzs;
        zzgk2 = ((zzfp)zzgk2).zzav();
        zzhl zzhl2 = new zzhl(this, bl);
        ((zzfm)zzgk2).zzh(zzhl2);
    }

    public final void zzo(Bundle bundle, int n, long l) {
        zzlf.zzb();
        if (this.zzs.zzc().zzn(null, zzea.zzau)) {
            this.zzb();
            String string = zzaf.zza(bundle);
            if (string != null) {
                this.zzs.zzau().zzh().zzb("Ignoring invalid consent setting", string);
                this.zzs.zzau().zzh().zza("Valid consent values are 'granted', 'denied'");
            }
            this.zzq(zzaf.zzb(bundle), n, l);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzq(zzaf zzaf2, int n, long l) {
        long l2;
        boolean bl;
        block16: {
            block17: {
                boolean bl2;
                boolean bl3;
                block15: {
                    zzlf.zzb();
                    if (!this.zzs.zzc().zzn(null, zzea.zzau)) return;
                    this.zzb();
                    if (!this.zzs.zzc().zzn(null, zzea.zzav) || n != -10) {
                        if (zzaf2.zze() == null && zzaf2.zzg() == null) {
                            this.zzs.zzau().zzh().zza("Discarding empty consent settings");
                            return;
                        }
                    } else {
                        n = -10;
                    }
                    Object object = this.zzh;
                    // MONITORENTER : object
                    boolean bl4 = this.zzj;
                    bl4 = zzaf.zzm(n, bl4 ? 1 : 0);
                    if (bl4) {
                        bl3 = zzaf2.zzi(this.zzi);
                        bl4 = zzaf2.zzh();
                        bl4 = bl4 ? !(bl4 = (boolean)this.zzi.zzh()) : false;
                        this.zzi = zzaf2 = zzaf2.zzl(this.zzi);
                        this.zzj = n;
                        bl = bl4;
                        bl2 = true;
                        // MONITOREXIT : object
                        break block15;
                    }
                    bl3 = false;
                    bl = false;
                    bl2 = false;
                    {
                        catch (Throwable throwable) {}
                        {
                            // MONITOREXIT : object
                            throw throwable;
                        }
                    }
                }
                if (!bl2) {
                    this.zzs.zzau().zzi().zzb("Ignoring lower-priority consent settings, proposed settings", zzaf2);
                    return;
                }
                l2 = this.zzk.getAndIncrement();
                if (bl3) {
                    this.zzg.set(null);
                    zzgk zzgk2 = this.zzs;
                    zzgk2 = ((zzfp)zzgk2).zzav();
                    zzhm zzhm2 = new zzhm(this, zzaf2, l, n, l2, bl);
                    ((zzfm)zzgk2).zzj(zzhm2);
                    return;
                }
                if (!this.zzs.zzc().zzn(null, zzea.zzav)) break block16;
                if (n == 30) break block17;
                if (n != -10) break block16;
                n = -10;
            }
            zzgk zzgk3 = this.zzs;
            zzgk3 = ((zzfp)zzgk3).zzav();
            zzhn zzhn2 = new zzhn(this, zzaf2, n, l2, bl);
            ((zzfm)zzgk3).zzj(zzhn2);
            return;
        }
        zzgk zzgk4 = this.zzs;
        zzgk4 = ((zzfp)zzgk4).zzav();
        zzho zzho2 = new zzho(this, zzaf2, n, l2, bl);
        ((zzfm)zzgk4).zzh(zzho2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzr(zzaf zzaf2) {
        ((zzgi)this).zzg();
        boolean bl = !zzaf2.zzh() || !zzaf2.zzf() ? this.zzs.zzy().zzH() : true;
        if (bl != this.zzs.zzI()) {
            this.zzs.zzH(bl);
            Object object = this.zzs.zzd();
            zzlf.zzb();
            if (((zzgi)object).zzs.zzc().zzn(null, zzea.zzau)) {
                zzfp cfr_ignored_0 = ((zzgi)object).zzs;
                ((zzgi)object).zzg();
                object = ((zzfb)object).zzd().contains("measurement_enabled_from_api") ? Boolean.valueOf(((zzfb)object).zzd().getBoolean("measurement_enabled_from_api", true)) : null;
            } else {
                object = null;
            }
            if (!bl || object == null || ((Boolean)object).booleanValue()) {
                this.zzY(bl, false);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzY(Boolean bl, boolean bl2) {
        ((zzgi)this).zzg();
        this.zzb();
        this.zzs.zzau().zzj().zzb("Setting app measurement enabled (FE)", bl);
        this.zzs.zzd().zze(bl);
        zzlf.zzb();
        if (this.zzs.zzc().zzn(null, zzea.zzau) && bl2) {
            zzfb zzfb2 = this.zzs.zzd();
            zzlf.zzb();
            if (zzfb2.zzs.zzc().zzn(null, zzea.zzau)) {
                zzfp cfr_ignored_0 = zzfb2.zzs;
                zzfb2.zzg();
                zzfb2 = zzfb2.zzd().edit();
                if (bl != null) {
                    zzfb2.putBoolean("measurement_enabled_from_api", bl);
                } else {
                    zzfb2.remove("measurement_enabled_from_api");
                }
                zzfb2.apply();
            }
        }
        zzlf.zzb();
        if (!this.zzs.zzc().zzn(null, zzea.zzau) || this.zzs.zzI() || bl != null && !bl.booleanValue()) {
            this.zzZ();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzZ() {
        ((zzgi)this).zzg();
        Object object = this.zzs.zzd().zzh.zza();
        if (object != null) {
            if ("unset".equals(object)) {
                this.zzB("app", "_npa", null, this.zzs.zzay().currentTimeMillis());
            } else {
                long l = true != "true".equals(object) ? 0L : 1L;
                this.zzB("app", "_npa", l, this.zzs.zzay().currentTimeMillis());
            }
        }
        if (this.zzs.zzF() && this.zzc) {
            this.zzs.zzau().zzj().zza("Recording app launch after enabling measurement for the first time (FE)");
            this.zzH();
            zzlx.zzb();
            if (this.zzs.zzc().zzn(null, zzea.zzan)) {
                this.zzs.zzh().zza.zza();
            }
            object = this.zzs;
            object = ((zzfp)object).zzav();
            zzgv zzgv2 = new zzgv(this);
            ((zzfm)object).zzh(zzgv2);
            return;
        }
        this.zzs.zzau().zzj().zza("Updating Scion state (FE)");
        this.zzs.zzy().zzi();
    }

    public final void zzs(String string, String string2, Bundle bundle) {
        this.zzv(string, string2, bundle, true, true, this.zzs.zzay().currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzt(String string, String string2, long l, Bundle bundle) {
        ((zzgi)this).zzg();
        boolean bl = this.zzd != null ? zzkp.zzR(string2) : true;
        this.zzu(string, string2, l, bundle, true, bl, false, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    protected final void zzu(String object, String string, long l, Bundle object2, boolean n, boolean bl, boolean bl2, String string2) {
        int n2;
        long l2;
        int n3;
        Object object32;
        block51: {
            block52: {
                Object[] objectArray;
                Preconditions.checkNotEmpty((String)object);
                Preconditions.checkNotNull((Object)object2);
                ((zzgi)zzgk2).zzg();
                ((zzf)zzgk2).zzb();
                if (!((zzhr)zzgk2).zzs.zzF()) {
                    ((zzgi)zzgk2).zzs.zzau().zzj().zza("Event not sent since app measurement is disabled");
                    return;
                }
                Object object4 = ((zze)zzgk2).zzs.zzA().zzo();
                if (object4 != null && !object4.contains(string)) {
                    ((zzgi)zzgk2).zzs.zzau().zzj().zzc("Dropping non-safelisted event. event name, origin", string, object);
                    return;
                }
                if (!((zzhr)zzgk2).zzf) {
                    GenericDeclaration genericDeclaration;
                    ((zzhr)zzgk2).zzf = true;
                    boolean bl3 = ((zzhr)zzgk2).zzs.zzu();
                    if (bl3) {
                        genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                        genericDeclaration = Class.forName((String)((Object)genericDeclaration));
                    }
                    genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                    objectArray = ((zzgi)zzgk2).zzs.zzax();
                    genericDeclaration = Class.forName((String)((Object)genericDeclaration), true, objectArray.getClassLoader());
                    try {
                        objectArray = new Class[]{Context.class};
                        genericDeclaration = ((Class)genericDeclaration).getDeclaredMethod("initialize", (Class<?>[])objectArray);
                        objectArray = new Object[1];
                        object32 = ((zzgi)zzgk2).zzs.zzax();
                        objectArray[0] = object32;
                        ((Method)genericDeclaration).invoke(null, objectArray);
                    }
                    catch (Exception exception) {
                        try {
                            ((zzgi)zzgk2).zzs.zzau().zze().zzb("Failed to invoke Tag Manager's initialize() method", exception);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ((zzgi)zzgk2).zzs.zzau().zzi().zza("Tag Manager is not found and thus will not be used");
                        }
                    }
                }
                if (((zzgi)zzgk2).zzs.zzc().zzn(null, zzea.zzab) && "_cmp".equals(string) && object2.containsKey("gclid")) {
                    ((zzgi)zzgk2).zzs.zzat();
                    ((zzhr)zzgk2).zzB("auto", "_lgclid", object2.getString("gclid"), ((zzgi)zzgk2).zzs.zzay().currentTimeMillis());
                }
                ((zzgi)zzgk2).zzs.zzat();
                if (n != 0 && zzkp.zzY(string)) {
                    ((zzgi)zzgk2).zzs.zzl().zzH((Bundle)object2, ((zzgi)zzgk2).zzs.zzd().zzr.zza());
                }
                if (bl2) {
                    ((zzgi)zzgk2).zzs.zzat();
                    if (!"_iap".equals(string)) {
                        int n4;
                        object4 = ((zzhr)zzgk2).zzs.zzl();
                        if (!((zzkp)object4).zzj("event", string)) {
                            n4 = 2;
                        } else if (!((zzkp)object4).zzl("event", zzgm.zza, zzgm.zzb, string)) {
                            n4 = 13;
                        } else {
                            ((zzgi)object4).zzs.zzc();
                            n4 = !((zzkp)object4).zzm("event", 40, string) ? 2 : 0;
                        }
                        if (n4 != 0) {
                            ((zzgi)zzgk2).zzs.zzau().zzd().zzb("Invalid public event name. Event will not be logged (FE)", ((zzgi)zzgk2).zzs.zzm().zzc(string));
                            object = ((zzhr)zzgk2).zzs;
                            object = ((zzfp)object).zzl();
                            ((zzhr)zzgk2).zzs.zzc();
                            object2 = ((zzkp)object).zzC(string, 40, true);
                            int n5 = string != null ? string.length() : 0;
                            ((zzhr)zzgk2).zzs.zzl().zzM(((zzhr)zzgk2).zzn, null, n4, "_ev", (String)object2, n5, ((zzgi)zzgk2).zzs.zzc().zzn(null, zzea.zzaz));
                            return;
                        }
                    }
                }
                ((zzgi)zzgk2).zzs.zzat();
                objectArray = ((zze)zzgk2).zzs.zzx().zzh(false);
                if (objectArray != null && !object2.containsKey("_sc")) {
                    objectArray.zzd = true;
                }
                n3 = n != 0 ? (bl2 ? 1 : 0) : 0;
                zzif.zzm((zzhy)objectArray, (Bundle)object2, n3 != 0);
                n3 = "am".equals(object);
                boolean bl4 = zzkp.zzR(string);
                if (n == 0) break block52;
                if (((zzhr)zzgk2).zzd != null) {
                    if (!bl4) {
                        if (n3 == 0) {
                            ((zzgi)zzgk2).zzs.zzau().zzj().zzc("Passing event to registered event handler (FE)", ((zzgi)zzgk2).zzs.zzm().zzc(string), ((zzgi)zzgk2).zzs.zzm().zzf((Bundle)object2));
                            Preconditions.checkNotNull((Object)((zzhr)zzgk2).zzd);
                            ((zzhr)zzgk2).zzd.interceptEvent((String)object, string, (Bundle)object2, l);
                            return;
                        }
                        n = 1;
                        break block51;
                    } else {
                        n = n3;
                    }
                    break block51;
                } else {
                    n = n3;
                }
                break block51;
            }
            n = n3;
        }
        if (!((zzhr)zzgk2).zzs.zzL()) {
            return;
        }
        n3 = ((zzgi)zzgk2).zzs.zzl().zzn(string);
        if (n3 != 0) {
            ((zzgi)zzgk2).zzs.zzau().zzd().zzb("Invalid event name. Event will not be logged (FE)", ((zzgi)zzgk2).zzs.zzm().zzc(string));
            object = ((zzgi)zzgk2).zzs;
            object = ((zzfp)object).zzl();
            ((zzgi)zzgk2).zzs.zzc();
            object2 = ((zzkp)object).zzC(string, 40, true);
            int n6 = string != null ? string.length() : 0;
            ((zzhr)zzgk2).zzs.zzl().zzM(((zzhr)zzgk2).zzn, string2, n3, "_ev", (String)object2, n6, ((zzgi)zzgk2).zzs.zzc().zzn(null, zzea.zzaz));
            return;
        }
        String[] stringArray = new String[]{"_o", "_sn", "_sc", "_si"};
        stringArray = CollectionUtils.listOf((Object[])stringArray);
        stringArray = ((zzgi)zzgk2).zzs.zzl().zzF(string2, string, (Bundle)object2, (List<String>)stringArray, bl2);
        Preconditions.checkNotNull((Object)stringArray);
        if (stringArray.containsKey("_sc") && stringArray.containsKey("_si")) {
            object2 = stringArray.getString("_sn");
            String string3 = stringArray.getString("_sc");
            l2 = stringArray.getLong("_si");
            new zzhy((String)object2, string3, l2);
        }
        ((zzgi)zzgk2).zzs.zzat();
        if (((zze)zzgk2).zzs.zzx().zzh(false) != null && "_ae".equals(string)) {
            object2 = ((zze)zzgk2).zzs.zzh().zzb;
            l2 = ((zzjs)object2).zzc.zzs.zzay().elapsedRealtime();
            long l3 = l2 - ((zzjs)object2).zzb;
            ((zzjs)object2).zzb = l2;
            if (l3 > 0L) {
                ((zzgi)zzgk2).zzs.zzl().zzac((Bundle)stringArray, l3);
            }
        }
        zzll.zzb();
        if (((zzgi)zzgk2).zzs.zzc().zzn(null, zzea.zzam)) {
            if (!"auto".equals(object) && "_ssr".equals(string)) {
                zzkp zzkp2 = ((zzgi)zzgk2).zzs.zzl();
                object2 = stringArray.getString("_ffr");
                if (Strings.isEmptyOrWhitespace((String)object2)) {
                    object2 = null;
                } else if (object2 != null) {
                    object2 = ((String)object2).trim();
                }
                if (zzkp.zzS((String)object2, zzkp2.zzs.zzd().zzo.zza())) {
                    zzkp2.zzs.zzau().zzj().zza("Not logging duplicate session_start_with_rollout event");
                    return;
                }
                zzkp2.zzs.zzd().zzo.zzb((String)object2);
            } else if ("_ae".equals(string) && !TextUtils.isEmpty((CharSequence)(object2 = ((zzgi)zzgk2).zzs.zzl().zzs.zzd().zzo.zza()))) {
                stringArray.putString("_ffr", (String)object2);
            }
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add((Bundle)stringArray);
        if (((zzgi)zzgk2).zzs.zzd().zzj.zza() > 0L && ((zzgi)zzgk2).zzs.zzd().zzl(l) && ((zzgi)zzgk2).zzs.zzd().zzl.zza()) {
            ((zzgi)zzgk2).zzs.zzau().zzk().zza("Current session is expired, remove the session number, ID, and engagement time");
            ((zzhr)zzgk2).zzB("auto", "_sid", null, ((zzgi)zzgk2).zzs.zzay().currentTimeMillis());
            ((zzhr)zzgk2).zzB("auto", "_sno", null, ((zzgi)zzgk2).zzs.zzay().currentTimeMillis());
            ((zzhr)zzgk2).zzB("auto", "_se", null, ((zzgi)zzgk2).zzs.zzay().currentTimeMillis());
        }
        if (stringArray.getLong("extend_session", 0L) == 1L) {
            ((zzgi)zzgk2).zzs.zzau().zzk().zza("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
            ((zzhr)zzgk2).zzs.zzh().zza.zzb(l, true);
        }
        object32 = new ArrayList(stringArray.keySet());
        Collections.sort(object32);
        int n7 = object32.size();
        for (n2 = 0; n2 < n7; ++n2) {
            String string4 = (String)object32.get(n2);
            if (string4 == null) continue;
            ((zzgi)zzgk2).zzs.zzl();
            Object object5 = stringArray.get(string4);
            if (object5 instanceof Bundle) {
                Bundle[] bundleArray = new Bundle[]{(Bundle)object5};
                object5 = bundleArray;
            } else if (object5 instanceof Parcelable[]) {
                object5 = (Parcelable[])object5;
                object5 = (Bundle[])Arrays.copyOf(object5, ((Parcelable[])object5).length, Bundle[].class);
            } else if (object5 instanceof ArrayList) {
                object5 = (ArrayList)object5;
                object5 = ((ArrayList)object5).toArray(new Bundle[((ArrayList)object5).size()]);
            } else {
                object5 = null;
            }
            if (object5 == null) continue;
            stringArray.putParcelableArray(string4, (Parcelable[])object5);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            stringArray = (Bundle)arrayList.get(n2);
            String string5 = n2 != 0 ? "_ep" : string;
            stringArray.putString("_o", (String)object);
            if (bl) {
                stringArray = ((zzgi)zzgk2).zzs.zzl().zzU((Bundle)stringArray);
            }
            zzaq zzaq2 = new zzaq((Bundle)stringArray);
            object32 = new zzas(string5, zzaq2, (String)object, l);
            ((zze)zzgk2).zzs.zzy().zzl((zzas)((Object)object32), string2);
            if (n != 0) continue;
            for (Object object32 : ((zzhr)zzgk2).zze) {
                object32 = (zzgq)object32;
                zzaq2 = new Bundle((Bundle)stringArray);
                object32.onEvent((String)object, string, (Bundle)zzaq2, l);
            }
        }
        ((zzgi)zzgk2).zzs.zzat();
        if (((zze)zzgk2).zzs.zzx().zzh(false) != null && "_ae".equals(string)) {
            object = ((zze)zzgk2).zzs;
            object = ((zzfp)object).zzh();
            zzgk zzgk2 = ((zzgi)zzgk2).zzs;
            zzgk2 = ((zzfp)zzgk2).zzay();
            l = zzgk2.elapsedRealtime();
            ((zzju)object).zzb.zzd(true, true, l);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzv(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        if (string == null) {
            string = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (this.zzs.zzc().zzn(null, zzea.zzar) && zzkp.zzS(string2, "screen_view")) {
            this.zzs.zzx().zzj(bundle, l);
            return;
        }
        boolean bl3 = bl2 ? (this.zzd != null ? zzkp.zzR(string2) : true) : true;
        this.zzx(string, string2, l, bundle, bl2, bl3, bl ^ true, null);
    }

    protected final void zzx(String string, String string2, long l, Bundle object2, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle = new Bundle((Bundle)object2);
        for (Object object2 : bundle.keySet()) {
            Bundle bundle2;
            Object object3;
            Object object4 = bundle.get((String)object2);
            if (object4 instanceof Bundle) {
                object3 = new Bundle((Bundle)object4);
                bundle.putBundle((String)object2, object3);
                continue;
            }
            if (object4 instanceof Parcelable[]) {
                object4 = (Parcelable[])object4;
                for (int i = 0; i < ((Parcelable[])object4).length; ++i) {
                    object3 = object4[i];
                    if (!(object3 instanceof Bundle)) continue;
                    bundle2 = new Bundle(object3);
                    object4[i] = bundle2;
                }
                continue;
            }
            if (!(object4 instanceof List)) continue;
            object4 = (List)object4;
            for (int i = 0; i < object4.size(); ++i) {
                object3 = object4.get(i);
                if (!(object3 instanceof Bundle)) continue;
                bundle2 = new Bundle(object3);
                object4.set(i, bundle2);
            }
        }
        object2 = this.zzs;
        object2 = ((zzfp)object2).zzav();
        Object object5 = new zzgx(this, string, string2, l, bundle, bl, bl2, bl3, string3);
        ((zzfm)object2).zzh((Runnable)object5);
    }

    public final void zzy(String string, String string2, Object object, boolean bl) {
        this.zzz("auto", string2, object, true, this.zzs.zzay().currentTimeMillis());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void zzz(String object, String string, Object object2, boolean bl, long l) {
        void var5_15;
        void var4_8;
        if (object == null) {
            object = "app";
        }
        if (bl) {
            int n = this.zzs.zzl().zzo(string);
        } else {
            zzkp zzkp2 = this.zzs.zzl();
            if (!zzkp2.zzj("user property", string)) {
                int n = 6;
            } else if (!zzkp2.zzl("user property", zzgo.zza, null, string)) {
                int n = 15;
            } else {
                zzkp2.zzs.zzc();
                if (!zzkp2.zzm("user property", 24, string)) {
                    int n = 6;
                } else {
                    boolean bl2 = false;
                }
            }
        }
        if (var4_8 != false) {
            object = this.zzs;
            object = ((zzfp)object).zzl();
            this.zzs.zzc();
            object2 = ((zzkp)object).zzC(string, 24, true);
            int n = string != null ? string.length() : 0;
            this.zzs.zzl().zzM(this.zzn, null, (int)var4_8, "_ev", (String)object2, n, this.zzs.zzc().zzn(null, zzea.zzaz));
            return;
        }
        if (object2 == null) {
            this.zzA((String)object, string, (long)var5_15, null);
            return;
        }
        int n = this.zzs.zzl().zzJ(string, object2);
        if (n != 0) {
            object = this.zzs;
            object = ((zzfp)object).zzl();
            this.zzs.zzc();
            string = ((zzkp)object).zzC(string, 24, true);
            int n2 = object2 instanceof String || object2 instanceof CharSequence ? String.valueOf(object2).length() : 0;
            this.zzs.zzl().zzM(this.zzn, null, n, "_ev", string, n2, this.zzs.zzc().zzn(null, zzea.zzaz));
            return;
        }
        object2 = this.zzs.zzl().zzK(string, object2);
        if (object2 != null) {
            this.zzA((String)object, string, (long)var5_15, object2);
            return;
        }
    }

    final void zzA(String string, String string2, long l, Object object) {
        zzgk zzgk2 = this.zzs;
        zzgk2 = ((zzfp)zzgk2).zzav();
        zzgy zzgy2 = new zzgy(this, string, string2, object, l);
        ((zzfm)zzgk2).zzh(zzgy2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzB(String string, String string2, Object object, long l) {
        Object object2;
        block6: {
            block7: {
                Preconditions.checkNotEmpty((String)string);
                Preconditions.checkNotEmpty((String)string2);
                ((zzgi)this).zzg();
                this.zzb();
                if (!"allow_personalized_ads".equals(string2)) break block7;
                if (object instanceof String && !TextUtils.isEmpty((CharSequence)(object2 = (String)object))) {
                    long l2 = true != "false".equals(((String)object2).toLowerCase(Locale.ENGLISH)) ? 0L : 1L;
                    object2 = l2;
                    object = this.zzs.zzd().zzh;
                    string2 = (Long)object2 == 1L ? "true" : "false";
                    ((zzfa)object).zzb(string2);
                    string2 = "_npa";
                    break block6;
                } else if (object == null) {
                    this.zzs.zzd().zzh.zzb("unset");
                    string2 = "_npa";
                    object2 = object;
                    break block6;
                } else {
                    object2 = object;
                }
                break block6;
            }
            object2 = object;
        }
        if (!this.zzs.zzF()) {
            this.zzs.zzau().zzk().zza("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzs.zzL()) {
            return;
        }
        object = new zzkl(string2, l, object2, string);
        this.zzs.zzy().zzs((zzkl)((Object)object));
    }

    public final List<zzkl> zzC(boolean bl) {
        this.zzb();
        this.zzs.zzau().zzk().zza("Getting user properties (FE)");
        if (!this.zzs.zzav().zzd()) {
            this.zzs.zzat();
            if (zzz.zza()) {
                this.zzs.zzau().zzb().zza("Cannot get all user properties from main thread");
                return Collections.emptyList();
            }
            Object object = new AtomicReference();
            zzgk zzgk2 = this.zzs;
            zzgk2 = ((zzfp)zzgk2).zzav();
            zzgz zzgz2 = new zzgz(this, (AtomicReference)object, bl);
            ((zzfm)zzgk2).zzi(object, 5000L, "get user properties", zzgz2);
            object = (List)((AtomicReference)object).get();
            if (object == null) {
                this.zzs.zzau().zzb().zzb("Timed out waiting for get user properties, includeInternal", bl);
                return Collections.emptyList();
            }
            return object;
        }
        this.zzs.zzau().zzb().zza("Cannot get all user properties from analytics worker thread");
        return Collections.emptyList();
    }

    public final String zzD() {
        return this.zzg.get();
    }

    final void zzE(String string) {
        this.zzg.set(string);
    }

    public final void zzF(long l) {
        this.zzg.set(null);
        zzgk zzgk2 = this.zzs;
        zzgk2 = ((zzfp)zzgk2).zzav();
        zzha zzha2 = new zzha(this, l);
        ((zzfm)zzgk2).zzh(zzha2);
    }

    final void zzG(long l, boolean bl) {
        ((zzgi)this).zzg();
        this.zzb();
        this.zzs.zzau().zzj().zza("Resetting analytics data (FE)");
        zzju zzju2 = this.zzs.zzh();
        ((zzgi)zzju2).zzg();
        zzjt cfr_ignored_0 = zzju2.zza;
        zzju2.zzb.zzc();
        boolean bl2 = this.zzs.zzF();
        zzfb zzfb2 = this.zzs.zzd();
        zzfb2.zzc.zzb(l);
        if (!TextUtils.isEmpty((CharSequence)zzfb2.zzs.zzd().zzo.zza())) {
            zzfb2.zzo.zzb(null);
        }
        zzlx.zzb();
        if (zzfb2.zzs.zzc().zzn(null, zzea.zzan)) {
            zzfb2.zzj.zzb(0L);
        }
        if (!zzfb2.zzs.zzc().zzr()) {
            zzfb2.zzj(bl2 ^ true);
        }
        zzfb2.zzp.zzb(null);
        zzfb2.zzq.zzb(0L);
        zzfb2.zzr.zzb(null);
        if (bl) {
            this.zzs.zzy().zzu();
        }
        zzlx.zzb();
        if (this.zzs.zzc().zzn(null, zzea.zzan)) {
            this.zzs.zzh().zza.zza();
        }
        this.zzc = bl2 ^ true;
    }

    @WorkerThread
    public final void zzH() {
        ((zzgi)this).zzg();
        this.zzb();
        if (this.zzs.zzL()) {
            Object object;
            Object object2;
            if (this.zzs.zzc().zzn(null, zzea.zzaa)) {
                object2 = this.zzs.zzc();
                ((zzgi)object2).zzs.zzat();
                object2 = ((zzae)object2).zzp("google_analytics_deferred_deep_link_enabled");
                if (object2 != null && ((Boolean)object2).booleanValue()) {
                    this.zzs.zzau().zzj().zza("Deferred Deep Link feature enabled.");
                    object2 = this.zzs;
                    object2 = ((zzfp)object2).zzav();
                    object = new zzgt(this);
                    ((zzfm)object2).zzh((Runnable)object);
                }
            }
            this.zzs.zzy().zzy();
            this.zzc = false;
            object2 = this.zzs.zzd();
            ((zzgi)object2).zzg();
            object = ((zzfb)object2).zzd().getString("previous_os_version", null);
            ((zzgi)object2).zzs.zzz().zzv();
            String string = Build.VERSION.RELEASE;
            if (!TextUtils.isEmpty((CharSequence)string) && !string.equals(object)) {
                object2 = ((zzfb)object2).zzd().edit();
                object2.putString("previous_os_version", string);
                object2.apply();
            }
            if (!TextUtils.isEmpty((CharSequence)object)) {
                this.zzs.zzz().zzv();
                if (!((String)object).equals(Build.VERSION.RELEASE)) {
                    object2 = new Bundle();
                    object2.putString("_po", (String)object);
                    this.zzs("auto", "_ou", (Bundle)object2);
                    return;
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zzI(zzgp zzgp2) {
        zzgp zzgp3;
        ((zzgi)this).zzg();
        this.zzb();
        if (zzgp2 != null && zzgp2 != (zzgp3 = this.zzd)) {
            boolean bl = zzgp3 == null;
            Preconditions.checkState((boolean)bl, (Object)"EventInterceptor already set.");
        }
        this.zzd = zzgp2;
    }

    public final void zzJ(zzgq zzgq2) {
        this.zzb();
        Preconditions.checkNotNull((Object)zzgq2);
        if (!this.zze.add(zzgq2)) {
            this.zzs.zzau().zze().zza("OnEventListener already registered");
            return;
        }
    }

    public final void zzK(zzgq zzgq2) {
        this.zzb();
        Preconditions.checkNotNull((Object)zzgq2);
        if (!this.zze.remove(zzgq2)) {
            this.zzs.zzau().zze().zza("OnEventListener had not been registered");
            return;
        }
    }

    public final int zzL(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzs.zzc();
        return 25;
    }

    public final void zzM(Bundle bundle) {
        this.zzN(bundle, this.zzs.zzay().currentTimeMillis());
    }

    public final void zzN(Bundle object, long l) {
        block6: {
            Object object2;
            block7: {
                long l2;
                block9: {
                    Bundle bundle;
                    block8: {
                        Preconditions.checkNotNull((Object)object);
                        bundle = new Bundle((Bundle)object);
                        if (!TextUtils.isEmpty((CharSequence)bundle.getString("app_id"))) {
                            this.zzs.zzau().zze().zza("Package name should be null when calling setConditionalUserProperty");
                        }
                        bundle.remove("app_id");
                        Preconditions.checkNotNull((Object)bundle);
                        zzgl.zzb((Bundle)bundle, (String)"app_id", String.class, null);
                        zzgl.zzb((Bundle)bundle, (String)"origin", String.class, null);
                        zzgl.zzb((Bundle)bundle, (String)"name", String.class, null);
                        zzgl.zzb((Bundle)bundle, (String)"value", Object.class, null);
                        zzgl.zzb((Bundle)bundle, (String)"trigger_event_name", String.class, null);
                        object = 0L;
                        zzgl.zzb((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)object);
                        zzgl.zzb((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
                        zzgl.zzb((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
                        zzgl.zzb((Bundle)bundle, (String)"triggered_event_name", String.class, null);
                        zzgl.zzb((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
                        zzgl.zzb((Bundle)bundle, (String)"time_to_live", Long.class, (Object)object);
                        zzgl.zzb((Bundle)bundle, (String)"expired_event_name", String.class, null);
                        zzgl.zzb((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
                        Preconditions.checkNotEmpty((String)bundle.getString("name"));
                        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
                        Preconditions.checkNotNull((Object)bundle.get("value"));
                        bundle.putLong("creation_timestamp", l);
                        object = bundle.getString("name");
                        object2 = bundle.get("value");
                        if (this.zzs.zzl().zzo((String)object) != 0) break block6;
                        if (this.zzs.zzl().zzJ((String)object, object2) != 0) break block7;
                        Object object3 = this.zzs.zzl().zzK((String)object, object2);
                        if (object3 == null) {
                            this.zzs.zzau().zzb().zzc("Unable to normalize conditional user property value", this.zzs.zzm().zze((String)object), object2);
                            return;
                        }
                        zzgl.zza((Bundle)bundle, (Object)object3);
                        l2 = bundle.getLong("trigger_timeout");
                        if (TextUtils.isEmpty((CharSequence)bundle.getString("trigger_event_name"))) break block8;
                        this.zzs.zzc();
                        if (l2 > 15552000000L || l2 < 1L) break block9;
                    }
                    long l3 = bundle.getLong("time_to_live");
                    this.zzs.zzc();
                    if (l3 > 15552000000L || l3 < 1L) {
                        this.zzs.zzau().zzb().zzc("Invalid conditional user property time to live", this.zzs.zzm().zze((String)object), l3);
                        return;
                    }
                    object = this.zzs;
                    object = ((zzfp)object).zzav();
                    object2 = new zzhb(this, bundle);
                    ((zzfm)object).zzh((Runnable)object2);
                    return;
                }
                this.zzs.zzau().zzb().zzc("Invalid conditional user property timeout", this.zzs.zzm().zze((String)object), l2);
                return;
            }
            this.zzs.zzau().zzb().zzc("Invalid conditional user property value", this.zzs.zzm().zze((String)object), object2);
            return;
        }
        this.zzs.zzau().zzb().zzb("Invalid conditional user property name", this.zzs.zzm().zze((String)object));
    }

    public final void zzO(String object, String object2, Bundle bundle) {
        zzfp zzfp2 = this.zzs;
        zzfp2 = zzfp2.zzay();
        long l = zzfp2.currentTimeMillis();
        Preconditions.checkNotEmpty((String)object);
        zzfp2 = new Bundle();
        zzfp2.putString("name", (String)object);
        zzfp2.putLong("creation_timestamp", l);
        if (object2 != null) {
            zzfp2.putString("expired_event_name", (String)object2);
            zzfp2.putBundle("expired_event_params", bundle);
        }
        object = this.zzs;
        object = ((zzfp)object).zzav();
        object2 = new zzhc(this, (Bundle)zzfp2);
        ((zzfm)object).zzh((Runnable)object2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList<Bundle> zzP(String object, String string) {
        if (((zzgi)((Object)this)).zzs.zzav().zzd()) {
            ((zzgi)((Object)this)).zzs.zzau().zzb().zza("Cannot get conditional user properties from analytics worker thread");
            return new ArrayList(0);
        }
        ((zzgi)((Object)this)).zzs.zzat();
        if (zzz.zza()) {
            ((zzgi)((Object)this)).zzs.zzau().zzb().zza("Cannot get conditional user properties from main thread");
            return new ArrayList(0);
        }
        AtomicReference atomicReference = new AtomicReference();
        zzgk zzgk2 = ((zzhr)((Object)this)).zzs;
        zzgk2 = ((zzfp)zzgk2).zzav();
        zzhe zzhe2 = new zzhe((zzhr)((Object)this), atomicReference, null, (String)object, string);
        ((zzfm)zzgk2).zzi(atomicReference, 5000L, "get conditional user properties", zzhe2);
        object = (List)atomicReference.get();
        if (object != null) return zzkp.zzak((List<zzaa>)object);
        ((zzgi)((Object)this)).zzs.zzau().zzb().zzb("Timed out waiting for get conditional user properties", null);
        return new ArrayList();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Map<String, Object> zzQ(String iterator, String object, boolean bl) {
        void var3_5;
        if (((zzgi)object2).zzs.zzav().zzd()) {
            ((zzgi)object2).zzs.zzau().zzb().zza("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzgi)object2).zzs.zzat();
        if (zzz.zza()) {
            ((zzgi)object2).zzs.zzau().zzb().zza("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        zzgk zzgk2 = ((zzhr)object2).zzs;
        zzgk2 = ((zzfp)zzgk2).zzav();
        zzhf zzhf2 = new zzhf((zzhr)object2, atomicReference, null, (String)((Object)iterator), (String)object, (boolean)var3_5);
        ((zzfm)zzgk2).zzi(atomicReference, 5000L, "get user properties", zzhf2);
        iterator = (List)atomicReference.get();
        if (iterator == null) {
            ((zzgi)object2).zzs.zzau().zzb().zzb("Timed out waiting for handle get user properties, includeInternal", (boolean)var3_5);
            return Collections.emptyMap();
        }
        Object object2 = new ArrayMap(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            zzkl zzkl2 = (zzkl)((Object)iterator.next());
            Object object3 = zzkl2.zza();
            if (object3 == null) continue;
            object2.put(zzkl2.zzb, object3);
        }
        return object2;
    }

    public final String zzR() {
        zzhy zzhy2 = ((zzhr)((Object)zzhy2)).zzs.zzx().zzl();
        if (zzhy2 != null) {
            return zzhy2.zza;
        }
        return null;
    }

    public final String zzS() {
        zzhy zzhy2 = ((zzhr)((Object)zzhy2)).zzs.zzx().zzl();
        if (zzhy2 != null) {
            return zzhy2.zzb;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String zzT() {
        if (this.zzs.zzr() != null) return this.zzs.zzr();
        try {
            Object object = this.zzs.zzax();
            String string = this.zzs.zzv();
            return zzhx.zza((Context)object, (String)"google_app_id", (String)string);
        }
        catch (IllegalStateException illegalStateException) {
            this.zzs.zzau().zzb().zzb("getGoogleAppId failed with exception", illegalStateException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zzU(Bundle object) {
        Object object2;
        if (object == null) {
            Object object3 = ((zzgi)object3).zzs;
            object3 = ((zzfp)object3).zzd();
            object3 = ((zzfb)object3).zzr;
            object = new Bundle();
            ((zzex)object3).zzb((Bundle)object);
            return;
        }
        Bundle bundle = ((zzgi)object3).zzs.zzd().zzr.zza();
        for (Object object4 : object.keySet()) {
            object2 = object.get((String)object4);
            if (!(object2 == null || object2 instanceof String || object2 instanceof Long || object2 instanceof Double)) {
                if (((zzgi)object3).zzs.zzl().zzs(object2)) {
                    ((zzgi)object3).zzs.zzl().zzM(((zzhr)object3).zzn, null, 27, null, null, 0, ((zzgi)object3).zzs.zzc().zzn(null, zzea.zzaz));
                }
                ((zzgi)object3).zzs.zzau().zzh().zzc("Invalid default event parameter type. Name, value", object4, object2);
                continue;
            }
            if (zzkp.zzR((String)object4)) {
                ((zzgi)object3).zzs.zzau().zzh().zzb("Invalid default event parameter name. Name", object4);
                continue;
            }
            if (object2 == null) {
                bundle.remove((String)object4);
                continue;
            }
            zzgk zzgk2 = ((zzgi)object3).zzs;
            zzgk2 = ((zzfp)zzgk2).zzl();
            ((zzgi)object3).zzs.zzc();
            if (!((zzkp)zzgk2).zzt("param", (String)object4, 100, object2)) continue;
            ((zzgi)object3).zzs.zzl().zzL(bundle, (String)object4, object2);
        }
        ((zzgi)object3).zzs.zzl();
        int n = ((zzgi)object3).zzs.zzc().zzc();
        if (bundle.size() > n) {
            Object object4;
            object = new TreeSet(bundle.keySet());
            object4 = object.iterator();
            int n2 = 0;
            while (object4.hasNext()) {
                object2 = (String)object4.next();
                if (++n2 <= n) continue;
                bundle.remove((String)object2);
            }
            ((zzgi)object3).zzs.zzl().zzM(((zzhr)object3).zzn, null, 26, null, null, 0, ((zzgi)object3).zzs.zzc().zzn(null, zzea.zzaz));
            ((zzgi)object3).zzs.zzau().zzh().zza("Too many default event parameters set. Discarding beyond event parameter limit");
        }
        ((zzgi)object3).zzs.zzd().zzr.zzb(bundle);
        ((zze)object3).zzs.zzy().zzA(bundle);
    }

    static /* synthetic */ void zzV(zzhr zzhr2, Boolean bl, boolean bl2) {
        zzhr2.zzY(bl, true);
    }

    static /* synthetic */ void zzW(zzhr zzgk2, zzaf atomicReference, int n, long l, boolean bl, boolean bl2) {
        ((zzgi)zzgk2).zzg();
        ((zzf)zzgk2).zzb();
        if (l > ((zzhr)zzgk2).zzl || !zzaf.zzm(((zzhr)zzgk2).zzm, n)) {
            zzfb zzfb2 = ((zzgi)zzgk2).zzs.zzd();
            zzlf.zzb();
            if (zzfb2.zzs.zzc().zzn(null, zzea.zzau)) {
                zzfp cfr_ignored_0 = zzfb2.zzs;
                zzfb2.zzg();
                if (zzfb2.zzh(n)) {
                    zzfb2 = zzfb2.zzd().edit();
                    zzfb2.putString("consent_settings", ((zzaf)((Object)atomicReference)).zzd());
                    zzfb2.putInt("consent_source", n);
                    zzfb2.apply();
                    ((zzhr)zzgk2).zzl = l;
                    ((zzhr)zzgk2).zzm = n;
                    ((zze)zzgk2).zzs.zzy().zzj(bl);
                    if (bl2) {
                        zzgk2 = ((zze)zzgk2).zzs;
                        zzgk2 = ((zzfp)zzgk2).zzy();
                        atomicReference = new AtomicReference<String>();
                        ((zzjf)zzgk2).zzv(atomicReference);
                        return;
                    }
                    return;
                }
            }
            ((zzgi)zzgk2).zzs.zzau().zzi().zzb("Lower precedence consent source ignored, proposed source", n);
            return;
        }
        ((zzgi)zzgk2).zzs.zzau().zzi().zzb("Dropped out-of-date consent setting, proposed settings", atomicReference);
    }

    static /* synthetic */ void zzX(zzhr zzhr2) {
        zzhr2.zzZ();
    }
}

