/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzeb;
import com.google.android.gms.measurement.internal.zzed;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzjf;

@VisibleForTesting
public final class zzje
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzei zzc;
    final /* synthetic */ zzjf zza;

    protected zzje(zzjf zzjf2) {
        this.zza = zzjf2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zza(Intent object) {
        ((zzgi)this.zza).zzg();
        Context context = this.zza.zzs.zzax();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        synchronized (this) {
            boolean bl = this.zzb;
            if (bl) {
                object = this.zza;
                object = ((zzgi)object).zzs.zzau();
                ((zzem)object).zzk().zza("Connection attempt already in progress");
                return;
            }
            zzgi zzgi2 = this.zza;
            zzgi2 = zzgi2.zzs.zzau();
            ((zzem)zzgi2).zzk().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, (Intent)object, (ServiceConnection)zzjf.zzI(this.zza), 129);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final void zzb() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onServiceConnected(ComponentName object, IBinder object2) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        // MONITORENTER : this
        if (object2 == null) {
            this.zzb = false;
            object = this.zza;
            object = ((zzgi)object).zzs.zzau();
            ((zzem)object).zzb().zza("Service connected with null binder");
            // MONITOREXIT : this
            return;
        }
        try {
            object = object2.getInterfaceDescriptor();
            boolean bl = "com.google.android.gms.measurement.internal.IMeasurementService".equals(object);
            if (bl) {
                object = object2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService");
                bl = object instanceof zzed;
                object = bl ? (zzed)object : new zzeb((IBinder)object2);
                object2 = this.zza;
                object2 = ((zzgi)object2).zzs.zzau();
                ((zzem)object2).zzk().zza("Bound to IMeasurementService interface");
                object2 = object;
            } else {
                object2 = this.zza;
                object2 = ((zzgi)object2).zzs.zzau();
                ((zzem)object2).zzb().zzb("Got binder with a wrong descriptor", object);
                object2 = null;
            }
            object = object2;
        }
        catch (RemoteException remoteException) {
            block14: {
                object = null;
                break block14;
                catch (RemoteException remoteException2) {}
            }
            object2 = this.zza;
            object2 = ((zzgi)object2).zzs.zzau();
            ((zzem)object2).zzb().zza("Service connect failed to get IMeasurementService");
        }
        if (object != null) {
            object2 = this.zza;
            object2 = ((zzgi)object2).zzs.zzav();
            zziz zziz2 = new zziz(this, (zzed)object);
            ((zzfm)object2).zzh(zziz2);
            return;
        }
        this.zzb = false;
        try {
            object = ConnectionTracker.getInstance();
            object2 = this.zza;
            object2 = ((zzgi)object2).zzs.zzax();
            object.unbindService((Context)object2, (ServiceConnection)zzjf.zzI(this.zza));
            // MONITOREXIT : this
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        this.zza.zzs.zzau().zzj().zza("Service disconnected");
        zzgk zzgk2 = this.zza;
        zzgk2 = ((zzgi)zzgk2).zzs;
        zzgk2 = ((zzfp)zzgk2).zzav();
        zzja zzja2 = new zzja(this, componentName);
        ((zzfm)zzgk2).zzh(zzja2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzc() {
        ((zzgi)this.zza).zzg();
        Object object = this.zza.zzs.zzax();
        synchronized (this) {
            zzei zzei2;
            boolean bl;
            boolean bl2 = this.zzb;
            if (bl2) {
                object = this.zza;
                object = object.zzs.zzau();
                object.zzk().zza("Connection attempt already in progress");
                return;
            }
            zzei zzei3 = this.zzc;
            if (zzei3 != null && ((bl = this.zzc.isConnecting()) || (bl = this.zzc.isConnected()))) {
                object = this.zza;
                object = object.zzs.zzau();
                object.zzk().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = zzei2 = new zzei((Context)object, Looper.getMainLooper(), this, this);
            object = this.zza;
            object = object.zzs.zzau();
            object.zzk().zza("Connecting to remote service");
            this.zzb = true;
            object = this.zzc;
            Preconditions.checkNotNull((Object)object);
            this.zzc.checkAvailabilityAndConnect();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onConnected(Bundle object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        // MONITORENTER : this
        try {
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            object = (zzed)this.zzc.getService();
            zzgi zzgi2 = this.zza;
            zzgi2 = zzgi2.zzs.zzav();
            zzjb zzjb2 = new zzjb(this, (zzed)object);
            ((zzfm)zzgi2).zzh(zzjb2);
            // MONITOREXIT : this
            return;
        }
        catch (DeadObjectException | IllegalStateException throwable) {
            this.zzc = null;
            this.zzb = false;
            return;
            {
                catch (Throwable throwable2) {}
                {
                    // MONITOREXIT : this
                    throw throwable2;
                }
            }
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        this.zza.zzs.zzau().zzj().zza("Service connection suspended");
        zzgk zzgk2 = this.zza;
        zzgk2 = ((zzgi)zzgk2).zzs;
        zzgk2 = ((zzfp)zzgk2).zzav();
        zzjc zzjc2 = new zzjc(this);
        ((zzfm)zzgk2).zzh(zzjc2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        Object object2 = this.zza.zzs.zzf();
        if (object2 != null) {
            ((zzem)object2).zze().zzb("Service connection failed", object);
        }
        synchronized (this) {
            this.zzb = false;
            this.zzc = null;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : this
            object = this.zza;
            object = ((zzgi)object).zzs;
            object = ((zzfp)object).zzav();
            object2 = new zzjd(this);
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        ((zzfm)object).zzh((Runnable)object2);
    }

    static /* synthetic */ boolean zzd(zzje zzje2, boolean bl) {
        zzje2.zzb = false;
        return false;
    }
}

