/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzcl;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzkq;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Deprecated
@ShowFirstParty
@KeepForSdk
public class AppMeasurement {
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public static final String CRASH_ORIGIN = "crash";
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public static final String FCM_ORIGIN = "fcm";
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public static final String FIAM_ORIGIN = "fiam";
    private static volatile AppMeasurement zza;
    private final zzfu zzb;
    private final zzhx zzc;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @ShowFirstParty
    @Keep
    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @NonNull
    public static AppMeasurement getInstance(@NonNull Context context) {
        if (zza == null) {
            Class<AppMeasurement> clazz = AppMeasurement.class;
            synchronized (clazz) {
                Object object = zza;
                if (object == null) {
                    Object object2;
                    block10: {
                        try {
                            object = Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            object = null;
                            break block10;
                        }
                        try {
                            Object[] objectArray = new Class[]{Context.class, Bundle.class};
                            object = ((Class)object).getDeclaredMethod("getScionFrontendApiImplementation", (Class<?>[])objectArray);
                            objectArray = new Object[]{object2, null};
                            object = (zzhx)((Method)object).invoke(null, objectArray);
                        }
                        catch (Exception exception) {
                            object = null;
                        }
                    }
                    if (object != null) {
                        object2 = new AppMeasurement((zzhx)object);
                        zza = object2;
                    } else {
                        object = new zzcl(0L, 0L, true, null, null, null, null, null);
                        object2 = zzfu.zzC(object2, (zzcl)object, null);
                        zza = object = new AppMeasurement((zzfu)object2);
                    }
                }
            }
        }
        return zza;
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @Keep
    public void logEventInternal(@NonNull String origin, @NonNull String name, @NonNull Bundle params) {
        void var3_3;
        void var2_2;
        void var1_1;
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            zzhx2.zza((String)var1_1, (String)var2_2, (Bundle)var3_3);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzs((String)var1_1, (String)var2_2, (Bundle)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public void logEventInternalNoInterceptor(@NonNull String origin, @NonNull String name, @NonNull Bundle params, long timestampInMillis) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            zzhx2.zzb((String)var1_1, (String)var2_2, (Bundle)var3_3, (long)var4_4);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzv((String)var1_1, (String)var2_2, (Bundle)var3_3, true, false, (long)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public Map<String, Object> getUserProperties(boolean includeInternal) {
        void var1_1;
        Object object = ((AppMeasurement)((Object)this_)).zzc;
        if (object != null) {
            return object.zzc(null, null, (boolean)var1_1);
        }
        Preconditions.checkNotNull((Object)((AppMeasurement)((Object)this_)).zzb);
        Iterator this_ = ((AppMeasurement)((Object)this_)).zzb.zzk().zzC((boolean)var1_1);
        ArrayMap arrayMap = new ArrayMap(this_.size());
        this_ = this_.iterator();
        while (this_.hasNext()) {
            object = (zzkq)((Object)this_.next());
            Object object2 = object.zza();
            if (object2 == null) continue;
            arrayMap.put(object.zzb, object2);
        }
        return arrayMap;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public void setEventInterceptor(@NonNull EventInterceptor interceptor) {
        void var1_1;
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            zzhx2.zzd((zzgu)var1_1);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzI((zzgu)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public void registerOnMeasurementEventListener(@NonNull OnEventListener listener) {
        void var1_1;
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            zzhx2.zze((zzgv)var1_1);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzJ((zzgv)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public void unregisterOnMeasurementEventListener(@NonNull OnEventListener listener) {
        void var1_1;
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            zzhx2.zzf((zzgv)var1_1);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzK((zzgv)var1_1);
    }

    @Keep
    @NonNull
    public String getCurrentScreenName() {
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            return zzhx2.zzg();
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzR();
    }

    @Keep
    @NonNull
    public String getCurrentScreenClass() {
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            return zzhx2.zzh();
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzS();
    }

    @Keep
    @NonNull
    public String getAppInstanceId() {
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            return zzhx2.zzi();
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzD();
    }

    @Keep
    @NonNull
    public String getGmpAppId() {
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            return zzhx2.zzj();
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzT();
    }

    @Keep
    public long generateEventId() {
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            return zzhx2.zzk();
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzl().zzd();
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void beginAdUnitExposure(@NonNull @Size(min=1L) String adUnitId) {
        void var1_1;
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            zzhx2.zzl((String)var1_1);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzB().zza((String)var1_1, this.zzb.zzay().elapsedRealtime());
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void endAdUnitExposure(@NonNull @Size(min=1L) String adUnitId) {
        void var1_1;
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            zzhx2.zzm((String)var1_1);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzB().zzb((String)var1_1, this.zzb.zzay().elapsedRealtime());
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void setConditionalUserProperty(@NonNull ConditionalUserProperty conditionalUserProperty) {
        void var1_1;
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            zzhx2.zzn(var1_1.zza());
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzM(var1_1.zza());
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String userPropertyName, @NonNull String clearEventName, @NonNull Bundle clearEventParams) {
        void var3_3;
        void var2_2;
        void var1_1;
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            zzhx2.zzo((String)var1_1, (String)var2_2, (Bundle)var3_3);
            return;
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzO((String)var1_1, (String)var2_2, (Bundle)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @Keep
    @VisibleForTesting
    @NonNull
    protected Map<String, Object> getUserProperties(@NonNull String origin, @Size(min=1L, max=24L) @NonNull String propertyNamePrefix, boolean includeInternal) {
        void var3_3;
        void var2_2;
        void var1_1;
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            return zzhx2.zzc((String)var1_1, (String)var2_2, (boolean)var3_3);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzQ((String)var1_1, (String)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public List<ConditionalUserProperty> getConditionalUserProperties(@NonNull String origin, @Size(min=1L, max=23L) @NonNull String propertyNamePrefix) {
        void var1_3;
        Object this_;
        ArrayList<ConditionalUserProperty> arrayList;
        void var1_1;
        zzhx zzhx2 = ((AppMeasurement)this_).zzc;
        if (zzhx2 != null) {
            this_ = zzhx2.zzp((String)var1_1, (String)((Object)arrayList));
        } else {
            Preconditions.checkNotNull((Object)((AppMeasurement)this_).zzb);
            this_ = ((AppMeasurement)this_).zzb.zzk().zzP((String)var1_1, (String)((Object)arrayList));
        }
        if (this_ == null) {
            boolean bl = false;
        } else {
            int n = this_.size();
        }
        arrayList = new ArrayList<ConditionalUserProperty>((int)var1_3);
        this_ = this_.iterator();
        while (this_.hasNext()) {
            Object e = this_.next();
            Bundle bundle = (Bundle)e;
            ConditionalUserProperty conditionalUserProperty = new ConditionalUserProperty(bundle);
            arrayList.add(conditionalUserProperty);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String origin) {
        void var1_1;
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            return zzhx2.zzq((String)var1_1);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        this.zzb.zzk().zzL((String)var1_1);
        return 25;
    }

    @KeepForSdk
    @NonNull
    public Boolean getBoolean() {
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            return (Boolean)zzhx2.zzr(4);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzi();
    }

    @KeepForSdk
    @NonNull
    public String getString() {
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            return (String)zzhx2.zzr(0);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzj();
    }

    @KeepForSdk
    @NonNull
    public Long getLong() {
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            return (Long)zzhx2.zzr(1);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzk();
    }

    @KeepForSdk
    @NonNull
    public Integer getInteger() {
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            return (Integer)zzhx2.zzr(3);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzl();
    }

    @KeepForSdk
    @NonNull
    public Double getDouble() {
        zzhx zzhx2 = this.zzc;
        if (zzhx2 != null) {
            return (Double)zzhx2.zzr(2);
        }
        Preconditions.checkNotNull((Object)this.zzb);
        return this.zzb.zzk().zzm();
    }

    public AppMeasurement(zzfu zzfu2) {
        Preconditions.checkNotNull((Object)zzfu2);
        this.zzb = zzfu2;
        this.zzc = null;
    }

    public AppMeasurement(zzhx zzhx2) {
        Preconditions.checkNotNull((Object)zzhx2);
        this.zzc = zzhx2;
        this.zzb = null;
    }

    @ShowFirstParty
    @KeepForSdk
    public static class ConditionalUserProperty {
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @NonNull
        public String mAppId;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @NonNull
        public String mOrigin;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @NonNull
        public String mName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @NonNull
        public Object mValue;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @NonNull
        public String mTriggerEventName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggerTimeout;
        @Keep
        @NonNull
        public String mTimedOutEventName;
        @Keep
        @NonNull
        public Bundle mTimedOutEventParams;
        @Keep
        @NonNull
        public String mTriggeredEventName;
        @Keep
        @NonNull
        public Bundle mTriggeredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTimeToLive;
        @Keep
        @NonNull
        public String mExpiredEventName;
        @Keep
        @NonNull
        public Bundle mExpiredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mCreationTimestamp;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public boolean mActive;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggeredTimestamp;

        @KeepForSdk
        public ConditionalUserProperty() {
        }

        @KeepForSdk
        public ConditionalUserProperty(@NonNull ConditionalUserProperty other) {
            Bundle bundle;
            Bundle bundle2;
            Preconditions.checkNotNull((Object)bundle2);
            this.mAppId = bundle2.mAppId;
            this.mOrigin = bundle2.mOrigin;
            this.mCreationTimestamp = bundle2.mCreationTimestamp;
            this.mName = bundle2.mName;
            Object object = bundle2.mValue;
            if (object != null) {
                this.mValue = zzic.zzb((Object)object);
                if (this.mValue == null) {
                    this.mValue = bundle2.mValue;
                }
            }
            this.mActive = bundle2.mActive;
            this.mTriggerEventName = bundle2.mTriggerEventName;
            this.mTriggerTimeout = bundle2.mTriggerTimeout;
            this.mTimedOutEventName = bundle2.mTimedOutEventName;
            object = bundle2.mTimedOutEventParams;
            if (object != null) {
                this.mTimedOutEventParams = bundle = new Bundle((Bundle)object);
            }
            this.mTriggeredEventName = bundle2.mTriggeredEventName;
            object = bundle2.mTriggeredEventParams;
            if (object != null) {
                this.mTriggeredEventParams = bundle = new Bundle((Bundle)object);
            }
            this.mTriggeredTimestamp = bundle2.mTriggeredTimestamp;
            this.mTimeToLive = bundle2.mTimeToLive;
            this.mExpiredEventName = bundle2.mExpiredEventName;
            bundle2 = bundle2.mExpiredEventParams;
            if (bundle2 != null) {
                object = new Bundle(bundle2);
                this.mExpiredEventParams = object;
                return;
            }
        }

        @VisibleForTesting
        ConditionalUserProperty(@NonNull Bundle bundle) {
            Preconditions.checkNotNull((Object)bundle);
            this.mAppId = (String)zzgq.zzb((Bundle)bundle, (String)"app_id", String.class, null);
            this.mOrigin = (String)zzgq.zzb((Bundle)bundle, (String)"origin", String.class, null);
            this.mName = (String)zzgq.zzb((Bundle)bundle, (String)"name", String.class, null);
            this.mValue = zzgq.zzb((Bundle)bundle, (String)"value", Object.class, null);
            this.mTriggerEventName = (String)zzgq.zzb((Bundle)bundle, (String)"trigger_event_name", String.class, null);
            Long l = 0L;
            this.mTriggerTimeout = (Long)zzgq.zzb((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)l);
            this.mTimedOutEventName = (String)zzgq.zzb((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
            this.mTimedOutEventParams = (Bundle)zzgq.zzb((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
            this.mTriggeredEventName = (String)zzgq.zzb((Bundle)bundle, (String)"triggered_event_name", String.class, null);
            this.mTriggeredEventParams = (Bundle)zzgq.zzb((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
            this.mTimeToLive = (Long)zzgq.zzb((Bundle)bundle, (String)"time_to_live", Long.class, (Object)l);
            this.mExpiredEventName = (String)zzgq.zzb((Bundle)bundle, (String)"expired_event_name", String.class, null);
            this.mExpiredEventParams = (Bundle)zzgq.zzb((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
            this.mActive = (Boolean)zzgq.zzb((Bundle)bundle, (String)"active", Boolean.class, (Object)false);
            this.mCreationTimestamp = (Long)zzgq.zzb((Bundle)bundle, (String)"creation_timestamp", Long.class, (Object)l);
            this.mTriggeredTimestamp = (Long)zzgq.zzb((Bundle)bundle, (String)"triggered_timestamp", Long.class, (Object)l);
        }

        @VisibleForTesting
        final Bundle zza() {
            Bundle bundle = new Bundle();
            Object object = this.mAppId;
            if (object != null) {
                bundle.putString("app_id", (String)object);
            }
            if ((object = this.mOrigin) != null) {
                bundle.putString("origin", (String)object);
            }
            if ((object = this.mName) != null) {
                bundle.putString("name", (String)object);
            }
            if ((object = this.mValue) != null) {
                zzgq.zza((Bundle)bundle, (Object)object);
            }
            if ((object = this.mTriggerEventName) != null) {
                bundle.putString("trigger_event_name", (String)object);
            }
            bundle.putLong("trigger_timeout", this.mTriggerTimeout);
            object = this.mTimedOutEventName;
            if (object != null) {
                bundle.putString("timed_out_event_name", (String)object);
            }
            if ((object = this.mTimedOutEventParams) != null) {
                bundle.putBundle("timed_out_event_params", (Bundle)object);
            }
            if ((object = this.mTriggeredEventName) != null) {
                bundle.putString("triggered_event_name", (String)object);
            }
            if ((object = this.mTriggeredEventParams) != null) {
                bundle.putBundle("triggered_event_params", (Bundle)object);
            }
            bundle.putLong("time_to_live", this.mTimeToLive);
            object = this.mExpiredEventName;
            if (object != null) {
                bundle.putString("expired_event_name", (String)object);
            }
            if ((object = this.mExpiredEventParams) != null) {
                bundle.putBundle("expired_event_params", (Bundle)object);
            }
            bundle.putLong("creation_timestamp", this.mCreationTimestamp);
            bundle.putBoolean("active", this.mActive);
            bundle.putLong("triggered_timestamp", this.mTriggeredTimestamp);
            return bundle;
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface OnEventListener
    extends zzgv {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void onEvent(@NonNull String var1, @NonNull String var2, @NonNull Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface EventInterceptor
    extends zzgu {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void interceptEvent(@NonNull String var1, @NonNull String var2, @NonNull Bundle var3, long var4);
    }
}

