/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzel;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzgo;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzem
extends zzgo {
    private char zza = '\u0000';
    private long zzb = -1L;
    @GuardedBy(value="this")
    private String zzc;
    private final zzek zzd;
    private final zzek zze;
    private final zzek zzf;
    private final zzek zzg;
    private final zzek zzh;
    private final zzek zzi;
    private final zzek zzj;
    private final zzek zzk;
    private final zzek zzl;

    zzem(zzfu object) {
        super((zzfu)object);
        this.zzd = object = new zzek(this, 6, false, false);
        this.zze = object = new zzek(this, 6, true, false);
        this.zzf = object = new zzek(this, 6, false, true);
        this.zzg = object = new zzek(this, 5, false, false);
        this.zzh = object = new zzek(this, 5, true, false);
        this.zzi = object = new zzek(this, 5, false, true);
        this.zzj = object = new zzek(this, 4, false, false);
        this.zzk = object = new zzek(this, 3, false, false);
        this.zzl = object = new zzek(this, 2, false, false);
    }

    public final zzek zzb() {
        return this.zzd;
    }

    public final zzek zzc() {
        return this.zze;
    }

    public final zzek zzd() {
        return this.zzf;
    }

    public final zzek zze() {
        return this.zzg;
    }

    public final zzek zzf() {
        return this.zzh;
    }

    public final zzek zzh() {
        return this.zzi;
    }

    public final zzek zzi() {
        return this.zzj;
    }

    public final zzek zzj() {
        return this.zzk;
    }

    public final zzek zzk() {
        return this.zzl;
    }

    @Override
    protected final boolean zza() {
        return false;
    }

    protected static Object zzl(String string) {
        if (string == null) {
            return null;
        }
        zzel zzel2 = new zzel(string);
        return zzel2;
    }

    protected final void zzm(int n, boolean bl, boolean bl2, String string, Object object, Object object2, Object object3) {
        if (!bl && Log.isLoggable((String)this.zzn(), (int)n)) {
            String string2 = zzem.zzo(false, string, object, object2, object3);
            Log.println((int)n, (String)this.zzn(), (String)string2);
        }
        if (!bl2 && n >= 5) {
            Preconditions.checkNotNull((Object)string);
            zzfr zzfr2 = this.zzs.zzj();
            if (zzfr2 == null) {
                Log.println((int)6, (String)this.zzn(), (String)"Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzfr2.zzu()) {
                Log.println((int)6, (String)this.zzn(), (String)"Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n >= 9) {
                n = 8;
            }
            zzej zzej2 = new zzej(this, n, string, object, object2, object3);
            zzfr2.zzh(zzej2);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EnsuresNonNull(value={"logTagDoNotUseDirectly"})
    @VisibleForTesting
    protected final String zzn() {
        synchronized (this) {
            Object object = this.zzc;
            if (object == null) {
                object = this.zzs.zzt();
                if (object != null) {
                    this.zzc = this.zzs.zzt();
                } else {
                    object = this.zzs.zzc();
                    this.zzc = ((zzae)object).zzb();
                }
            }
            Preconditions.checkNotNull((Object)this.zzc);
            return this.zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static String zzo(boolean bl, String string, Object object, Object object2, Object object3) {
        String string2;
        if (string == null) {
            string = "";
        }
        object = zzem.zzp(bl, object);
        object2 = zzem.zzp(bl, object2);
        object3 = zzem.zzp(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string2 = ": ";
        } else {
            string2 = "";
        }
        if (!TextUtils.isEmpty((CharSequence)object)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object);
            string2 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)object2)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object2);
            string2 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)object3)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object3);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static String zzp(boolean bl, Object object) {
        int n;
        String string;
        StringBuilder stringBuilder;
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return String.valueOf(object);
            }
            Long l = (Long)object;
            if (Math.abs(l) < 100L) {
                return String.valueOf(object);
            }
            String string2 = String.valueOf(object).charAt(0) == '-' ? "-" : "";
            object = String.valueOf(Math.abs(l));
            int n2 = ((String)object).length();
            double d = Math.pow(10.0, n2 + -1);
            long l2 = Math.round(d);
            int n3 = ((String)object).length();
            double d2 = Math.pow(10.0, n3);
            long l3 = Math.round(d2 + -1.0);
            n3 = string2.length();
            n2 = string2.length();
            StringBuilder stringBuilder2 = new StringBuilder(n3 + 43 + n2);
            stringBuilder2.append(string2);
            stringBuilder2.append(l2);
            stringBuilder2.append("...");
            stringBuilder2.append(string2);
            stringBuilder2.append(l3);
            return stringBuilder2.toString();
        }
        if (object instanceof Boolean) {
            return String.valueOf(object);
        }
        if (object instanceof Throwable) {
            object = (Throwable)object;
            String string3 = bl ? object.getClass().getName() : ((Throwable)object).toString();
            stringBuilder = new StringBuilder(string3);
            string = zzem.zzz(zzfu.class.getCanonicalName());
            object = ((Throwable)object).getStackTrace();
            n = ((Object)object).length;
        } else {
            if (object instanceof zzel) {
                return zzel.zza((zzel)object);
            }
            if (!bl) return String.valueOf(object);
            return "-";
        }
        for (int i = 0; i < n; ++i) {
            String string4;
            Object object2 = object[i];
            if (((StackTraceElement)object2).isNativeMethod() || (string4 = ((StackTraceElement)object2).getClassName()) == null || !zzem.zzz(string4).equals(string)) continue;
            stringBuilder.append(": ");
            stringBuilder.append(object2);
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    private static String zzz(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    static /* synthetic */ char zzq(zzem zzem2) {
        return zzem2.zza;
    }

    static /* synthetic */ char zzr(zzem zzem2, char c) {
        zzem2.zza = c;
        return c;
    }

    static /* synthetic */ long zzs(zzem zzem2) {
        return zzem2.zzb;
    }

    static /* synthetic */ long zzt(zzem zzem2, long l) {
        zzem2.zzb = 42004L;
        return 42004L;
    }
}

