/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzny;
import com.google.android.gms.internal.measurement.zzoh;
import com.google.android.gms.internal.measurement.zzpx;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjw;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzkq;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzr;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzhv
extends zzf {
    @VisibleForTesting
    protected zzhu zza;
    private zzgs zzd;
    private final Set<zzgt> zze;
    private boolean zzf;
    private final AtomicReference<String> zzg;
    private final Object zzh;
    @GuardedBy(value="consentLock")
    private zzag zzi;
    @GuardedBy(value="consentLock")
    private int zzj;
    private final AtomicLong zzk;
    private long zzl;
    private int zzm;
    final zzr zzb;
    @VisibleForTesting
    protected boolean zzc;
    private final zzkt zzn;

    public final int zzh(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzs.zzf();
        return 25;
    }

    public final Boolean zzi() {
        AtomicReference atomicReference = new AtomicReference();
        zzgn zzgn2 = this.zzs;
        zzgn2 = ((zzfs)zzgn2).zzaz();
        zzhg zzhg2 = new zzhg(this, atomicReference);
        return (Boolean)((zzfp)zzgn2).zzd(atomicReference, 15000L, "boolean test flag value", zzhg2);
    }

    public final Double zzj() {
        AtomicReference atomicReference = new AtomicReference();
        zzgn zzgn2 = this.zzs;
        zzgn2 = ((zzfs)zzgn2).zzaz();
        zzhn zzhn2 = new zzhn(this, atomicReference);
        return (Double)((zzfp)zzgn2).zzd(atomicReference, 15000L, "double test flag value", zzhn2);
    }

    public final Integer zzl() {
        AtomicReference atomicReference = new AtomicReference();
        zzgn zzgn2 = this.zzs;
        zzgn2 = ((zzfs)zzgn2).zzaz();
        zzhm zzhm2 = new zzhm(this, atomicReference);
        return (Integer)((zzfp)zzgn2).zzd(atomicReference, 15000L, "int test flag value", zzhm2);
    }

    public final Long zzm() {
        AtomicReference atomicReference = new AtomicReference();
        zzgn zzgn2 = this.zzs;
        zzgn2 = ((zzfs)zzgn2).zzaz();
        zzhl zzhl2 = new zzhl(this, atomicReference);
        return (Long)((zzfp)zzgn2).zzd(atomicReference, 15000L, "long test flag value", zzhl2);
    }

    public final String zzo() {
        return this.zzg.get();
    }

    public final String zzp() {
        zzic zzic2 = ((zzhv)((Object)zzic2)).zzs.zzs().zzi();
        if (zzic2 != null) {
            return zzic2.zzb;
        }
        return null;
    }

    public final String zzq() {
        zzic zzic2 = ((zzhv)((Object)zzic2)).zzs.zzs().zzi();
        if (zzic2 != null) {
            return zzic2.zza;
        }
        return null;
    }

    public final String zzr() {
        AtomicReference atomicReference = new AtomicReference();
        zzgn zzgn2 = this.zzs;
        zzgn2 = ((zzfs)zzgn2).zzaz();
        zzhk zzhk2 = new zzhk(this, atomicReference);
        return (String)((zzfp)zzgn2).zzd(atomicReference, 15000L, "String test flag value", zzhk2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList<Bundle> zzs(String object, String string) {
        if (((zzgl)((Object)this)).zzs.zzaz().zzs()) {
            ((zzgl)((Object)this)).zzs.zzay().zzd().zza("Cannot get conditional user properties from analytics worker thread");
            return new ArrayList(0);
        }
        ((zzgl)((Object)this)).zzs.zzaw();
        if (zzaa.zza()) {
            ((zzgl)((Object)this)).zzs.zzay().zzd().zza("Cannot get conditional user properties from main thread");
            return new ArrayList(0);
        }
        AtomicReference atomicReference = new AtomicReference();
        zzgn zzgn2 = ((zzhv)((Object)this)).zzs;
        zzgn2 = ((zzfs)zzgn2).zzaz();
        zzhh zzhh2 = new zzhh((zzhv)((Object)this), atomicReference, null, (String)object, string);
        ((zzfp)zzgn2).zzd(atomicReference, 5000L, "get conditional user properties", zzhh2);
        object = (List)atomicReference.get();
        if (object != null) return zzku.zzG((List<zzab>)object);
        ((zzgl)((Object)this)).zzs.zzay().zzd().zzb("Timed out waiting for get conditional user properties", null);
        return new ArrayList();
    }

    public final List<zzkq> zzt(boolean bl) {
        this.zza();
        this.zzs.zzay().zzj().zza("Getting user properties (FE)");
        if (!this.zzs.zzaz().zzs()) {
            this.zzs.zzaw();
            if (zzaa.zza()) {
                this.zzs.zzay().zzd().zza("Cannot get all user properties from main thread");
                return Collections.emptyList();
            }
            Object object = new AtomicReference();
            zzgn zzgn2 = this.zzs;
            zzgn2 = ((zzfs)zzgn2).zzaz();
            zzhc zzhc2 = new zzhc(this, (AtomicReference)object, bl);
            ((zzfp)zzgn2).zzd(object, 5000L, "get user properties", zzhc2);
            object = (List)((AtomicReference)object).get();
            if (object == null) {
                this.zzs.zzay().zzd().zzb("Timed out waiting for get user properties, includeInternal", bl);
                return Collections.emptyList();
            }
            return object;
        }
        this.zzs.zzay().zzd().zza("Cannot get all user properties from analytics worker thread");
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Map<String, Object> zzu(String iterator, String object, boolean bl) {
        void var3_5;
        if (((zzgl)object2).zzs.zzaz().zzs()) {
            ((zzgl)object2).zzs.zzay().zzd().zza("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzgl)object2).zzs.zzaw();
        if (zzaa.zza()) {
            ((zzgl)object2).zzs.zzay().zzd().zza("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        zzgn zzgn2 = ((zzhv)object2).zzs;
        zzgn2 = ((zzfs)zzgn2).zzaz();
        zzhi zzhi2 = new zzhi((zzhv)object2, atomicReference, null, (String)((Object)iterator), (String)object, (boolean)var3_5);
        ((zzfp)zzgn2).zzd(atomicReference, 5000L, "get user properties", zzhi2);
        iterator = (List)atomicReference.get();
        if (iterator == null) {
            ((zzgl)object2).zzs.zzay().zzd().zzb("Timed out waiting for handle get user properties, includeInternal", (boolean)var3_5);
            return Collections.emptyMap();
        }
        Object object2 = new ArrayMap(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            zzkq zzkq2 = (zzkq)((Object)iterator.next());
            Object object3 = zzkq2.zza();
            if (object3 == null) continue;
            object2.put(zzkq2.zzb, object3);
        }
        return object2;
    }

    static /* bridge */ /* synthetic */ void zzv(zzhv zzgn2, zzag atomicReference, int n, long l, boolean bl, boolean bl2) {
        ((zzgl)zzgn2).zzg();
        ((zzf)zzgn2).zza();
        if (l > ((zzhv)zzgn2).zzl || !zzag.zzl(((zzhv)zzgn2).zzm, n)) {
            zzex zzex2 = ((zzgl)zzgn2).zzs.zzm();
            zzfs cfr_ignored_0 = zzex2.zzs;
            zzex2.zzg();
            if (zzex2.zzl(n)) {
                zzex2 = zzex2.zza().edit();
                zzex2.putString("consent_settings", ((zzag)((Object)atomicReference)).zzi());
                zzex2.putInt("consent_source", n);
                zzex2.apply();
                ((zzhv)zzgn2).zzl = l;
                ((zzhv)zzgn2).zzm = n;
                ((zze)zzgn2).zzs.zzt().zzF(bl);
                if (bl2) {
                    zzgn2 = ((zze)zzgn2).zzs;
                    zzgn2 = ((zzfs)zzgn2).zzt();
                    atomicReference = new AtomicReference<String>();
                    ((zzjj)zzgn2).zzu(atomicReference);
                    return;
                }
                return;
            }
            ((zzgl)zzgn2).zzs.zzay().zzi().zzb("Lower precedence consent source ignored, proposed source", n);
            return;
        }
        ((zzgl)zzgn2).zzs.zzay().zzi().zzb("Dropped out-of-date consent setting, proposed settings", atomicReference);
    }

    static /* bridge */ /* synthetic */ void zzw(zzhv zzhv2, Boolean bl, boolean bl2) {
        zzhv2.zzZ(bl, true);
    }

    static /* bridge */ /* synthetic */ void zzx(zzhv zzhv2) {
        zzhv2.zzaa();
    }

    protected zzhv(zzfs zzfs2) {
        super(zzfs2);
        Object object = new CopyOnWriteArraySet();
        this.zze = object;
        this.zzh = object = new Object();
        this.zzc = true;
        this.zzn = object = new zzhj(this);
        object = new AtomicReference();
        this.zzg = object;
        this.zzi = object = new zzag(null, null);
        this.zzj = 100;
        this.zzl = -1L;
        this.zzm = 100;
        this.zzk = object = new AtomicLong(0L);
        this.zzb = object = new zzr(zzfs2);
    }

    @WorkerThread
    public final void zzy() {
        ((zzgl)this).zzg();
        this.zza();
        if (this.zzs.zzM()) {
            Object object;
            Object object2;
            if (this.zzs.zzf().zzs(null, zzdw.zzZ)) {
                object2 = this.zzs.zzf();
                ((zzgl)object2).zzs.zzaw();
                object2 = ((zzaf)object2).zzk("google_analytics_deferred_deep_link_enabled");
                if (object2 != null && ((Boolean)object2).booleanValue()) {
                    this.zzs.zzay().zzc().zza("Deferred Deep Link feature enabled.");
                    object2 = this.zzs;
                    object2 = ((zzfs)object2).zzaz();
                    object = new zzgv(this);
                    ((zzfp)object2).zzp((Runnable)object);
                }
            }
            this.zzs.zzt().zzq();
            this.zzc = false;
            object2 = this.zzs.zzm();
            ((zzgl)object2).zzg();
            object = ((zzex)object2).zza().getString("previous_os_version", null);
            ((zzgl)object2).zzs.zzg().zzu();
            String string = Build.VERSION.RELEASE;
            if (!TextUtils.isEmpty((CharSequence)string) && !string.equals(object)) {
                object2 = ((zzex)object2).zza().edit();
                object2.putString("previous_os_version", string);
                object2.apply();
            }
            if (!TextUtils.isEmpty((CharSequence)object)) {
                this.zzs.zzg().zzu();
                if (!((String)object).equals(Build.VERSION.RELEASE)) {
                    object2 = new Bundle();
                    object2.putString("_po", (String)object);
                    this.zzF("auto", "_ou", (Bundle)object2);
                    return;
                }
            }
            return;
        }
    }

    public final void zzz(String object, String object2, Bundle bundle) {
        zzfs zzfs2 = this.zzs;
        zzfs2 = zzfs2.zzav();
        long l = zzfs2.currentTimeMillis();
        Preconditions.checkNotEmpty((String)object);
        zzfs2 = new Bundle();
        zzfs2.putString("name", (String)object);
        zzfs2.putLong("creation_timestamp", l);
        if (object2 != null) {
            zzfs2.putString("expired_event_name", (String)object2);
            zzfs2.putBundle("expired_event_params", bundle);
        }
        object = this.zzs;
        object = ((zzfs)object).zzaz();
        object2 = new zzhf(this, (Bundle)zzfs2);
        ((zzfp)object).zzp((Runnable)object2);
    }

    public final void zzA() {
        if (this.zzs.zzau().getApplicationContext() instanceof Application && this.zza != null) {
            ((Application)this.zzs.zzau().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zza);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final /* synthetic */ void zzB(Bundle object) {
        Object object2;
        if (object == null) {
            Object object3 = ((zzgl)object3).zzs;
            object3 = ((zzfs)object3).zzm();
            object3 = ((zzex)object3).zzr;
            object = new Bundle();
            ((zzes)object3).zzb((Bundle)object);
            return;
        }
        Bundle bundle = ((zzgl)object3).zzs.zzm().zzr.zza();
        for (Object object4 : object.keySet()) {
            object2 = object.get((String)object4);
            if (!(object2 == null || object2 instanceof String || object2 instanceof Long || object2 instanceof Double)) {
                if (((zzgl)object3).zzs.zzv().zzae(object2)) {
                    ((zzgl)object3).zzs.zzv().zzM(((zzhv)object3).zzn, null, 27, null, null, 0);
                }
                ((zzgl)object3).zzs.zzay().zzl().zzc("Invalid default event parameter type. Name, value", object4, object2);
                continue;
            }
            if (zzku.zzag((String)object4)) {
                ((zzgl)object3).zzs.zzay().zzl().zzb("Invalid default event parameter name. Name", object4);
                continue;
            }
            if (object2 == null) {
                bundle.remove((String)object4);
                continue;
            }
            zzgn zzgn2 = ((zzgl)object3).zzs;
            zzgn2 = ((zzfs)zzgn2).zzv();
            ((zzgl)object3).zzs.zzf();
            if (!((zzku)zzgn2).zzZ("param", (String)object4, 100, object2)) continue;
            ((zzgl)object3).zzs.zzv().zzN(bundle, (String)object4, object2);
        }
        ((zzgl)object3).zzs.zzv();
        int n = ((zzgl)object3).zzs.zzf().zzc();
        if (bundle.size() > n) {
            Object object4;
            object = new TreeSet(bundle.keySet());
            object4 = object.iterator();
            int n2 = 0;
            while (object4.hasNext()) {
                object2 = (String)object4.next();
                if (++n2 <= n) continue;
                bundle.remove((String)object2);
            }
            ((zzgl)object3).zzs.zzv().zzM(((zzhv)object3).zzn, null, 26, null, null, 0);
            ((zzgl)object3).zzs.zzay().zzl().zza("Too many default event parameters set. Discarding beyond event parameter limit");
        }
        ((zzgl)object3).zzs.zzm().zzr.zzb(bundle);
        ((zze)object3).zzs.zzt().zzH(bundle);
    }

    public final void zzC(String string, String string2, Bundle bundle) {
        this.zzD(string, string2, bundle, true, true, this.zzs.zzav().currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzD(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        if (string == null) {
            string = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (zzku.zzak(string2, "screen_view")) {
            this.zzs.zzs().zzx(bundle, l);
            return;
        }
        boolean bl3 = bl2 ? (this.zzd != null ? zzku.zzag(string2) : true) : true;
        this.zzL(string, string2, l, bundle, bl2, bl3, bl, null);
    }

    public final void zzE(String string, String string2, Bundle bundle, String string3) {
        zzfs.zzO();
        this.zzL("auto", string2, this.zzs.zzav().currentTimeMillis(), bundle, false, true, true, string3);
    }

    @WorkerThread
    final void zzF(String string, String string2, Bundle bundle) {
        ((zzgl)this).zzg();
        this.zzG(string, string2, this.zzs.zzav().currentTimeMillis(), bundle);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzG(String string, String string2, long l, Bundle bundle) {
        ((zzgl)this).zzg();
        boolean bl = this.zzd != null ? zzku.zzag(string2) : true;
        this.zzH(string, string2, l, bundle, true, bl, true, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    protected final void zzH(String object, String string, long l, Bundle object2, boolean n, boolean bl, boolean bl2, String string2) {
        int n2;
        int n3;
        Object object32;
        block53: {
            block54: {
                Object[] objectArray;
                Preconditions.checkNotEmpty((String)object);
                Preconditions.checkNotNull((Object)object2);
                ((zzgl)zzgn2).zzg();
                ((zzf)zzgn2).zza();
                if (!((zzhv)zzgn2).zzs.zzJ()) {
                    ((zzgl)zzgn2).zzs.zzay().zzc().zza("Event not sent since app measurement is disabled");
                    return;
                }
                Object object4 = ((zze)zzgn2).zzs.zzh().zzo();
                if (object4 != null && !object4.contains(string)) {
                    ((zzgl)zzgn2).zzs.zzay().zzc().zzc("Dropping non-safelisted event. event name, origin", string, object);
                    return;
                }
                if (!((zzhv)zzgn2).zzf) {
                    GenericDeclaration genericDeclaration;
                    ((zzhv)zzgn2).zzf = true;
                    boolean bl3 = ((zzhv)zzgn2).zzs.zzN();
                    if (bl3) {
                        genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                        genericDeclaration = Class.forName((String)((Object)genericDeclaration));
                    }
                    genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                    objectArray = ((zzgl)zzgn2).zzs.zzau();
                    genericDeclaration = Class.forName((String)((Object)genericDeclaration), true, objectArray.getClassLoader());
                    try {
                        objectArray = new Class[]{Context.class};
                        genericDeclaration = ((Class)genericDeclaration).getDeclaredMethod("initialize", (Class<?>[])objectArray);
                        objectArray = new Object[1];
                        object32 = ((zzgl)zzgn2).zzs.zzau();
                        objectArray[0] = object32;
                        ((Method)genericDeclaration).invoke(null, objectArray);
                    }
                    catch (Exception exception) {
                        try {
                            ((zzgl)zzgn2).zzs.zzay().zzk().zzb("Failed to invoke Tag Manager's initialize() method", exception);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ((zzgl)zzgn2).zzs.zzay().zzi().zza("Tag Manager is not found and thus will not be used");
                        }
                    }
                }
                if ("_cmp".equals(string) && object2.containsKey("gclid")) {
                    ((zzgl)zzgn2).zzs.zzaw();
                    ((zzhv)zzgn2).zzX("auto", "_lgclid", object2.getString("gclid"), ((zzgl)zzgn2).zzs.zzav().currentTimeMillis());
                }
                ((zzgl)zzgn2).zzs.zzaw();
                if (n != 0 && zzku.zzal(string)) {
                    ((zzgl)zzgn2).zzs.zzv().zzK((Bundle)object2, ((zzgl)zzgn2).zzs.zzm().zzr.zza());
                }
                if (!bl2) {
                    ((zzgl)zzgn2).zzs.zzaw();
                    if (!"_iap".equals(string)) {
                        int n4;
                        object4 = ((zzhv)zzgn2).zzs.zzv();
                        if (!((zzku)object4).zzab("event", string)) {
                            n4 = 2;
                        } else if (!((zzku)object4).zzY("event", zzgp.zza, zzgp.zzb, string)) {
                            n4 = 13;
                        } else {
                            ((zzgl)object4).zzs.zzf();
                            n4 = !((zzku)object4).zzX("event", 40, string) ? 2 : 0;
                        }
                        if (n4 != 0) {
                            ((zzgl)zzgn2).zzs.zzay().zze().zzb("Invalid public event name. Event will not be logged (FE)", ((zzgl)zzgn2).zzs.zzj().zzc(string));
                            object = ((zzhv)zzgn2).zzs;
                            object = ((zzfs)object).zzv();
                            ((zzhv)zzgn2).zzs.zzf();
                            object2 = ((zzku)object).zzC(string, 40, true);
                            int n5 = string != null ? string.length() : 0;
                            ((zzhv)zzgn2).zzs.zzv().zzM(((zzhv)zzgn2).zzn, null, n4, "_ev", (String)object2, n5);
                            return;
                        }
                    }
                }
                zzpx.zzc();
                if (((zzgl)zzgn2).zzs.zzf().zzs(null, zzdw.zzaA)) {
                    ((zzgl)zzgn2).zzs.zzaw();
                    objectArray = ((zze)zzgn2).zzs.zzs().zzj(false);
                    if (objectArray != null && !object2.containsKey("_sc")) {
                        objectArray.zzd = true;
                    }
                    n3 = n != 0 ? (!bl2 ? 1 : 0) : 0;
                    zzku.zzJ((zzic)objectArray, (Bundle)object2, n3 != 0);
                } else {
                    ((zzgl)zzgn2).zzs.zzaw();
                    objectArray = ((zze)zzgn2).zzs.zzs().zzj(false);
                    if (objectArray != null && !object2.containsKey("_sc")) {
                        objectArray.zzd = true;
                    }
                    n3 = n != 0 ? (!bl2 ? 1 : 0) : 0;
                    zzku.zzJ((zzic)objectArray, (Bundle)object2, n3 != 0);
                }
                n3 = "am".equals(object);
                boolean bl4 = zzku.zzag(string);
                if (n == 0) break block54;
                if (((zzhv)zzgn2).zzd != null) {
                    if (!bl4) {
                        if (n3 == 0) {
                            ((zzgl)zzgn2).zzs.zzay().zzc().zzc("Passing event to registered event handler (FE)", ((zzgl)zzgn2).zzs.zzj().zzc(string), ((zzgl)zzgn2).zzs.zzj().zzb((Bundle)object2));
                            Preconditions.checkNotNull((Object)((zzhv)zzgn2).zzd);
                            ((zzhv)zzgn2).zzd.interceptEvent((String)object, string, (Bundle)object2, l);
                            return;
                        }
                        n = 1;
                        break block53;
                    } else {
                        n = n3;
                    }
                    break block53;
                } else {
                    n = n3;
                }
                break block53;
            }
            n = n3;
        }
        if (!((zzhv)zzgn2).zzs.zzM()) {
            return;
        }
        n3 = ((zzgl)zzgn2).zzs.zzv().zzh(string);
        if (n3 != 0) {
            ((zzgl)zzgn2).zzs.zzay().zze().zzb("Invalid event name. Event will not be logged (FE)", ((zzgl)zzgn2).zzs.zzj().zzc(string));
            object = ((zzgl)zzgn2).zzs;
            object = ((zzfs)object).zzv();
            ((zzgl)zzgn2).zzs.zzf();
            object2 = ((zzku)object).zzC(string, 40, true);
            int n6 = string != null ? string.length() : 0;
            ((zzhv)zzgn2).zzs.zzv().zzM(((zzhv)zzgn2).zzn, string2, n3, "_ev", (String)object2, n6);
            return;
        }
        String[] stringArray = new String[]{"_o", "_sn", "_sc", "_si"};
        stringArray = CollectionUtils.listOf((Object[])stringArray);
        stringArray = ((zzgl)zzgn2).zzs.zzv().zzy(string2, string, (Bundle)object2, (List<String>)stringArray, bl2);
        Preconditions.checkNotNull((Object)stringArray);
        ((zzgl)zzgn2).zzs.zzaw();
        if (((zze)zzgn2).zzs.zzs().zzj(false) != null && "_ae".equals(string)) {
            object2 = ((zze)zzgn2).zzs.zzu().zzb;
            long l2 = ((zzjw)object2).zzc.zzs.zzav().elapsedRealtime();
            long l3 = l2 - ((zzjw)object2).zzb;
            ((zzjw)object2).zzb = l2;
            if (l3 > 0L) {
                ((zzgl)zzgn2).zzs.zzv().zzH((Bundle)stringArray, l3);
            }
        }
        zzny.zzc();
        if (((zzgl)zzgn2).zzs.zzf().zzs(null, zzdw.zzai)) {
            if (!"auto".equals(object) && "_ssr".equals(string)) {
                zzku zzku2 = ((zzgl)zzgn2).zzs.zzv();
                object2 = stringArray.getString("_ffr");
                if (Strings.isEmptyOrWhitespace((String)object2)) {
                    object2 = null;
                } else if (object2 != null) {
                    object2 = ((String)object2).trim();
                }
                if (zzku.zzak((String)object2, zzku2.zzs.zzm().zzo.zza())) {
                    zzku2.zzs.zzay().zzc().zza("Not logging duplicate session_start_with_rollout event");
                    return;
                }
                zzku2.zzs.zzm().zzo.zzb((String)object2);
            } else if ("_ae".equals(string) && !TextUtils.isEmpty((CharSequence)(object2 = ((zzgl)zzgn2).zzs.zzv().zzs.zzm().zzo.zza()))) {
                stringArray.putString("_ffr", (String)object2);
            }
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add((Bundle)stringArray);
        if (((zzgl)zzgn2).zzs.zzm().zzj.zza() > 0L && ((zzgl)zzgn2).zzs.zzm().zzk(l) && ((zzgl)zzgn2).zzs.zzm().zzl.zzb()) {
            ((zzgl)zzgn2).zzs.zzay().zzj().zza("Current session is expired, remove the session number, ID, and engagement time");
            ((zzhv)zzgn2).zzX("auto", "_sid", null, ((zzgl)zzgn2).zzs.zzav().currentTimeMillis());
            ((zzhv)zzgn2).zzX("auto", "_sno", null, ((zzgl)zzgn2).zzs.zzav().currentTimeMillis());
            ((zzhv)zzgn2).zzX("auto", "_se", null, ((zzgl)zzgn2).zzs.zzav().currentTimeMillis());
        }
        if (stringArray.getLong("extend_session", 0L) == 1L) {
            ((zzgl)zzgn2).zzs.zzay().zzj().zza("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
            ((zzhv)zzgn2).zzs.zzu().zza.zzb(l, true);
        }
        object32 = new ArrayList(stringArray.keySet());
        Collections.sort(object32);
        int n7 = object32.size();
        for (n2 = 0; n2 < n7; ++n2) {
            String string3 = (String)object32.get(n2);
            if (string3 == null) continue;
            ((zzgl)zzgn2).zzs.zzv();
            Object object5 = stringArray.get(string3);
            if (object5 instanceof Bundle) {
                Bundle[] bundleArray = new Bundle[]{(Bundle)object5};
                object5 = bundleArray;
            } else if (object5 instanceof Parcelable[]) {
                object5 = (Parcelable[])object5;
                object5 = (Bundle[])Arrays.copyOf(object5, ((Parcelable[])object5).length, Bundle[].class);
            } else if (object5 instanceof ArrayList) {
                object5 = (ArrayList)object5;
                object5 = ((ArrayList)object5).toArray(new Bundle[((ArrayList)object5).size()]);
            } else {
                object5 = null;
            }
            if (object5 == null) continue;
            stringArray.putParcelableArray(string3, (Parcelable[])object5);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            stringArray = (Bundle)arrayList.get(n2);
            String string4 = n2 != 0 ? "_ep" : string;
            stringArray.putString("_o", (String)object);
            if (bl) {
                stringArray = ((zzgl)zzgn2).zzs.zzv().zzt((Bundle)stringArray);
            }
            zzar zzar2 = new zzar((Bundle)stringArray);
            object32 = new zzat(string4, zzar2, (String)object, l);
            ((zze)zzgn2).zzs.zzt().zzA((zzat)((Object)object32), string2);
            if (n != 0) continue;
            for (Object object32 : ((zzhv)zzgn2).zze) {
                object32 = (zzgt)object32;
                zzar2 = new Bundle((Bundle)stringArray);
                object32.onEvent((String)object, string, (Bundle)zzar2, l);
            }
        }
        ((zzgl)zzgn2).zzs.zzaw();
        if (((zze)zzgn2).zzs.zzs().zzj(false) != null && "_ae".equals(string)) {
            object = ((zze)zzgn2).zzs;
            object = ((zzfs)object).zzu();
            zzgn zzgn2 = ((zzgl)zzgn2).zzs;
            zzgn2 = ((zzfs)zzgn2).zzav();
            l = zzgn2.elapsedRealtime();
            ((zzjy)object).zzb.zzd(true, true, l);
            return;
        }
    }

    public final void zzI(zzgt zzgt2) {
        this.zza();
        Preconditions.checkNotNull((Object)zzgt2);
        if (!this.zze.add(zzgt2)) {
            this.zzs.zzay().zzk().zza("OnEventListener already registered");
            return;
        }
    }

    public final void zzJ(long l) {
        this.zzg.set(null);
        zzgn zzgn2 = this.zzs;
        zzgn2 = ((zzfs)zzgn2).zzaz();
        zzhd zzhd2 = new zzhd(this, l);
        ((zzfp)zzgn2).zzp(zzhd2);
    }

    final void zzK(long l, boolean bl) {
        ((zzgl)this).zzg();
        this.zza();
        this.zzs.zzay().zzc().zza("Resetting analytics data (FE)");
        zzjy zzjy2 = this.zzs.zzu();
        ((zzgl)zzjy2).zzg();
        zzjx cfr_ignored_0 = zzjy2.zza;
        zzjy2.zzb.zza();
        boolean bl2 = this.zzs.zzJ();
        zzex zzex2 = this.zzs.zzm();
        zzex2.zzc.zzb(l);
        if (!TextUtils.isEmpty((CharSequence)zzex2.zzs.zzm().zzo.zza())) {
            zzex2.zzo.zzb(null);
        }
        zzoh.zzc();
        if (zzex2.zzs.zzf().zzs(null, zzdw.zzaj)) {
            zzex2.zzj.zzb(0L);
        }
        if (!zzex2.zzs.zzf().zzv()) {
            zzex2.zzi(bl2 ^ true);
        }
        zzex2.zzp.zzb(null);
        zzex2.zzq.zzb(0L);
        zzex2.zzr.zzb(null);
        if (bl) {
            this.zzs.zzt().zzC();
        }
        zzoh.zzc();
        if (this.zzs.zzf().zzs(null, zzdw.zzaj)) {
            this.zzs.zzu().zza.zza();
        }
        this.zzc = bl2 ^ true;
    }

    protected final void zzL(String string, String string2, long l, Bundle object2, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle = new Bundle((Bundle)object2);
        for (Object object2 : bundle.keySet()) {
            Bundle bundle2;
            Object object3;
            Object object4 = bundle.get((String)object2);
            if (object4 instanceof Bundle) {
                object3 = new Bundle((Bundle)object4);
                bundle.putBundle((String)object2, object3);
                continue;
            }
            if (object4 instanceof Parcelable[]) {
                object4 = (Parcelable[])object4;
                for (int i = 0; i < ((Parcelable[])object4).length; ++i) {
                    object3 = object4[i];
                    if (!(object3 instanceof Bundle)) continue;
                    bundle2 = new Bundle(object3);
                    object4[i] = bundle2;
                }
                continue;
            }
            if (!(object4 instanceof List)) continue;
            object4 = (List)object4;
            for (int i = 0; i < object4.size(); ++i) {
                object3 = object4.get(i);
                if (!(object3 instanceof Bundle)) continue;
                bundle2 = new Bundle(object3);
                object4.set(i, bundle2);
            }
        }
        object2 = this.zzs;
        object2 = ((zzfs)object2).zzaz();
        Object object5 = new zzha(this, string, string2, l, bundle, bl, bl2, bl3, string3);
        ((zzfp)object2).zzp((Runnable)object5);
    }

    final void zzM(String string, String string2, long l, Object object) {
        zzgn zzgn2 = this.zzs;
        zzgn2 = ((zzfs)zzgn2).zzaz();
        zzhb zzhb2 = new zzhb(this, string, string2, object, l);
        ((zzfp)zzgn2).zzp(zzhb2);
    }

    final void zzN(String string) {
        this.zzg.set(string);
    }

    public final void zzO(Bundle bundle) {
        this.zzP(bundle, this.zzs.zzav().currentTimeMillis());
    }

    public final void zzP(Bundle object, long l) {
        block6: {
            Object object2;
            block7: {
                long l2;
                block9: {
                    Bundle bundle;
                    block8: {
                        Preconditions.checkNotNull((Object)object);
                        bundle = new Bundle((Bundle)object);
                        if (!TextUtils.isEmpty((CharSequence)bundle.getString("app_id"))) {
                            this.zzs.zzay().zzk().zza("Package name should be null when calling setConditionalUserProperty");
                        }
                        bundle.remove("app_id");
                        Preconditions.checkNotNull((Object)bundle);
                        zzgo.zza((Bundle)bundle, (String)"app_id", String.class, null);
                        zzgo.zza((Bundle)bundle, (String)"origin", String.class, null);
                        zzgo.zza((Bundle)bundle, (String)"name", String.class, null);
                        zzgo.zza((Bundle)bundle, (String)"value", Object.class, null);
                        zzgo.zza((Bundle)bundle, (String)"trigger_event_name", String.class, null);
                        object = 0L;
                        zzgo.zza((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)object);
                        zzgo.zza((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
                        zzgo.zza((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
                        zzgo.zza((Bundle)bundle, (String)"triggered_event_name", String.class, null);
                        zzgo.zza((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
                        zzgo.zza((Bundle)bundle, (String)"time_to_live", Long.class, (Object)object);
                        zzgo.zza((Bundle)bundle, (String)"expired_event_name", String.class, null);
                        zzgo.zza((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
                        Preconditions.checkNotEmpty((String)bundle.getString("name"));
                        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
                        Preconditions.checkNotNull((Object)bundle.get("value"));
                        bundle.putLong("creation_timestamp", l);
                        object = bundle.getString("name");
                        object2 = bundle.get("value");
                        if (this.zzs.zzv().zzl((String)object) != 0) break block6;
                        if (this.zzs.zzv().zzd((String)object, object2) != 0) break block7;
                        Object object3 = this.zzs.zzv().zzB((String)object, object2);
                        if (object3 == null) {
                            this.zzs.zzay().zzd().zzc("Unable to normalize conditional user property value", this.zzs.zzj().zze((String)object), object2);
                            return;
                        }
                        zzgo.zzb((Bundle)bundle, (Object)object3);
                        l2 = bundle.getLong("trigger_timeout");
                        if (TextUtils.isEmpty((CharSequence)bundle.getString("trigger_event_name"))) break block8;
                        this.zzs.zzf();
                        if (l2 > 15552000000L || l2 < 1L) break block9;
                    }
                    long l3 = bundle.getLong("time_to_live");
                    this.zzs.zzf();
                    if (l3 > 15552000000L || l3 < 1L) {
                        this.zzs.zzay().zzd().zzc("Invalid conditional user property time to live", this.zzs.zzj().zze((String)object), l3);
                        return;
                    }
                    object = this.zzs;
                    object = ((zzfs)object).zzaz();
                    object2 = new zzhe(this, bundle);
                    ((zzfp)object).zzp((Runnable)object2);
                    return;
                }
                this.zzs.zzay().zzd().zzc("Invalid conditional user property timeout", this.zzs.zzj().zze((String)object), l2);
                return;
            }
            this.zzs.zzay().zzd().zzc("Invalid conditional user property value", this.zzs.zzj().zze((String)object), object2);
            return;
        }
        this.zzs.zzay().zzd().zzb("Invalid conditional user property name", this.zzs.zzj().zze((String)object));
    }

    public final void zzQ(Bundle bundle, int n, long l) {
        this.zza();
        String string = zzag.zzh(bundle);
        if (string != null) {
            this.zzs.zzay().zzl().zzb("Ignoring invalid consent setting", string);
            this.zzs.zzay().zzl().zza("Valid consent values are 'granted', 'denied'");
        }
        this.zzR(zzag.zza(bundle), n, l);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzR(zzag zzag2, int n, long l) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        block9: {
            this.zza();
            if (n != -10 && zzag2.zze() == null && zzag2.zzf() == null) {
                this.zzs.zzay().zzl().zza("Discarding empty consent settings");
                return;
            }
            Object object = this.zzh;
            // MONITORENTER : object
            boolean bl4 = this.zzj;
            bl4 = zzag.zzl(n, bl4 ? 1 : 0);
            if (bl4) {
                bl3 = zzag2.zzm(this.zzi);
                bl4 = zzag2.zzk();
                bl4 = bl4 ? !(bl4 = (boolean)this.zzi.zzk()) : false;
                this.zzi = zzag2 = zzag2.zzd(this.zzi);
                this.zzj = n;
                bl2 = bl4;
                bl = true;
                // MONITOREXIT : object
                break block9;
            }
            bl3 = false;
            bl2 = false;
            bl = false;
            {
                catch (Throwable throwable) {}
                {
                    // MONITOREXIT : object
                    throw throwable;
                }
            }
        }
        if (!bl) {
            this.zzs.zzay().zzi().zzb("Ignoring lower-priority consent settings, proposed settings", zzag2);
            return;
        }
        long l2 = this.zzk.getAndIncrement();
        if (bl3) {
            this.zzg.set(null);
            zzgn zzgn2 = this.zzs;
            zzgn2 = ((zzfs)zzgn2).zzaz();
            zzhp zzhp2 = new zzhp(this, zzag2, l, n, l2, bl2);
            ((zzfp)zzgn2).zzq(zzhp2);
            return;
        }
        if (n != 30 && n != -10) {
            zzgn zzgn3 = this.zzs;
            zzgn3 = ((zzfs)zzgn3).zzaz();
            zzhr zzhr2 = new zzhr(this, zzag2, n, l2, bl2);
            ((zzfp)zzgn3).zzp(zzhr2);
            return;
        }
        zzgn zzgn4 = this.zzs;
        zzgn4 = ((zzfs)zzgn4).zzaz();
        zzhq zzhq2 = new zzhq(this, zzag2, n, l2, bl2);
        ((zzfp)zzgn4).zzq(zzhq2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zzS(zzgs zzgs2) {
        zzgs zzgs3;
        ((zzgl)this).zzg();
        this.zza();
        if (zzgs2 != null && zzgs2 != (zzgs3 = this.zzd)) {
            boolean bl = zzgs3 == null;
            Preconditions.checkState((boolean)bl, (Object)"EventInterceptor already set.");
        }
        this.zzd = zzgs2;
    }

    public final void zzT(Boolean bl) {
        this.zza();
        zzgn zzgn2 = this.zzs;
        zzgn2 = ((zzfs)zzgn2).zzaz();
        zzho zzho2 = new zzho(this, bl);
        ((zzfp)zzgn2).zzp(zzho2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzU(zzag zzag2) {
        ((zzgl)this).zzg();
        boolean bl = !zzag2.zzk() || !zzag2.zzj() ? this.zzs.zzt().zzM() : true;
        if (bl != this.zzs.zzK()) {
            this.zzs.zzG(bl);
            Object object = this.zzs.zzm();
            zzfs cfr_ignored_0 = ((zzgl)object).zzs;
            ((zzgl)object).zzg();
            object = ((zzex)object).zza().contains("measurement_enabled_from_api") ? Boolean.valueOf(((zzex)object).zza().getBoolean("measurement_enabled_from_api", true)) : null;
            if (!bl || object == null || ((Boolean)object).booleanValue()) {
                this.zzZ(bl, false);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzZ(Boolean bl, boolean bl2) {
        ((zzgl)this).zzg();
        this.zza();
        this.zzs.zzay().zzc().zzb("Setting app measurement enabled (FE)", bl);
        this.zzs.zzm().zzh(bl);
        if (bl2) {
            zzex zzex2 = this.zzs.zzm();
            zzfs cfr_ignored_0 = zzex2.zzs;
            zzex2.zzg();
            zzex2 = zzex2.zza().edit();
            if (bl != null) {
                zzex2.putBoolean("measurement_enabled_from_api", bl);
            } else {
                zzex2.remove("measurement_enabled_from_api");
            }
            zzex2.apply();
        }
        if (this.zzs.zzK() || bl != null && !bl.booleanValue()) {
            this.zzaa();
            return;
        }
    }

    public final void zzV(String string, String string2, Object object, boolean bl) {
        this.zzW("auto", "_ldl", object, true, this.zzs.zzav().currentTimeMillis());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void zzW(String object, String string, Object object2, boolean bl, long l) {
        void var5_15;
        void var4_8;
        if (object == null) {
            object = "app";
        }
        if (bl) {
            int n = this.zzs.zzv().zzl(string);
        } else {
            zzku zzku2 = this.zzs.zzv();
            if (!zzku2.zzab("user property", string)) {
                int n = 6;
            } else if (!zzku2.zzY("user property", zzgr.zza, null, string)) {
                int n = 15;
            } else {
                zzku2.zzs.zzf();
                if (!zzku2.zzX("user property", 24, string)) {
                    int n = 6;
                } else {
                    boolean bl2 = false;
                }
            }
        }
        if (var4_8 != false) {
            object = this.zzs;
            object = ((zzfs)object).zzv();
            this.zzs.zzf();
            object2 = ((zzku)object).zzC(string, 24, true);
            int n = string != null ? string.length() : 0;
            this.zzs.zzv().zzM(this.zzn, null, (int)var4_8, "_ev", (String)object2, n);
            return;
        }
        if (object2 == null) {
            this.zzM((String)object, string, (long)var5_15, null);
            return;
        }
        int n = this.zzs.zzv().zzd(string, object2);
        if (n != 0) {
            object = this.zzs;
            object = ((zzfs)object).zzv();
            this.zzs.zzf();
            string = ((zzku)object).zzC(string, 24, true);
            int n2 = object2 instanceof String || object2 instanceof CharSequence ? String.valueOf(object2).length() : 0;
            this.zzs.zzv().zzM(this.zzn, null, n, "_ev", string, n2);
            return;
        }
        object2 = this.zzs.zzv().zzB(string, object2);
        if (object2 != null) {
            this.zzM((String)object, string, (long)var5_15, object2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzX(String string, String string2, Object object, long l) {
        Object object2;
        block6: {
            block7: {
                Preconditions.checkNotEmpty((String)string);
                Preconditions.checkNotEmpty((String)string2);
                ((zzgl)this).zzg();
                this.zza();
                if (!"allow_personalized_ads".equals(string2)) break block7;
                if (object instanceof String && !TextUtils.isEmpty((CharSequence)(object2 = (String)object))) {
                    long l2 = true != "false".equals(((String)object2).toLowerCase(Locale.ENGLISH)) ? 0L : 1L;
                    object2 = l2;
                    object = this.zzs.zzm().zzh;
                    string2 = (Long)object2 == 1L ? "true" : "false";
                    ((zzew)object).zzb(string2);
                    string2 = "_npa";
                    break block6;
                } else if (object == null) {
                    this.zzs.zzm().zzh.zzb("unset");
                    string2 = "_npa";
                    object2 = object;
                    break block6;
                } else {
                    object2 = object;
                }
                break block6;
            }
            object2 = object;
        }
        if (!this.zzs.zzJ()) {
            this.zzs.zzay().zzj().zza("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzs.zzM()) {
            return;
        }
        object = new zzkq(string2, l, object2, string);
        this.zzs.zzt().zzK((zzkq)((Object)object));
    }

    public final void zzY(zzgt zzgt2) {
        this.zza();
        Preconditions.checkNotNull((Object)zzgt2);
        if (!this.zze.remove(zzgt2)) {
            this.zzs.zzay().zzk().zza("OnEventListener had not been registered");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzaa() {
        ((zzgl)this).zzg();
        Object object = this.zzs.zzm().zzh.zza();
        if (object != null) {
            if ("unset".equals(object)) {
                this.zzX("app", "_npa", null, this.zzs.zzav().currentTimeMillis());
            } else {
                long l = true != "true".equals(object) ? 0L : 1L;
                this.zzX("app", "_npa", l, this.zzs.zzav().currentTimeMillis());
            }
        }
        if (this.zzs.zzJ() && this.zzc) {
            this.zzs.zzay().zzc().zza("Recording app launch after enabling measurement for the first time (FE)");
            this.zzy();
            zzoh.zzc();
            if (this.zzs.zzf().zzs(null, zzdw.zzaj)) {
                this.zzs.zzu().zza.zza();
            }
            object = this.zzs;
            object = ((zzfs)object).zzaz();
            zzgy zzgy2 = new zzgy(this);
            ((zzfp)object).zzp(zzgy2);
            return;
        }
        this.zzs.zzay().zzc().zza("Updating Scion state (FE)");
        this.zzs.zzt().zzI();
    }

    @Override
    protected final boolean zzf() {
        return false;
    }
}

