/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzoq;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzkt;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzku
extends zzgm {
    private static final String[] zzb;
    private static final String[] zzc;
    private static final Pattern zzd;
    private static final Pattern zze;
    private static final Pattern zzf;
    private static final Pattern zzg;
    private static final Pattern zzh;
    private static final Pattern zzi;
    private SecureRandom zzj;
    private final AtomicLong zzk;
    private int zzl;
    private Integer zzm = null;
    public static final /* synthetic */ int zza;

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final int zza(String object, String string, String string2, Object object2, Bundle bundle, List<String> list, boolean bl, boolean bl2) {
        int n;
        int n2;
        block17: {
            block18: {
                block21: {
                    block22: {
                        block23: {
                            int n3;
                            boolean bl3;
                            block20: {
                                block19: {
                                    ((zzgl)object3).zzg();
                                    if (!((zzku)object3).zzae(object2)) break block18;
                                    if (!bl2) return 21;
                                    if (!zzku.zzas(string2, zzgq.zzc)) {
                                        return 20;
                                    }
                                    zzjj zzjj2 = ((zzku)object3).zzs.zzt();
                                    ((zzgl)zzjj2).zzg();
                                    zzjj2.zza();
                                    if (zzjj2.zzN() && zzjj2.zzs.zzv().zzm() < 200900) {
                                        return 25;
                                    }
                                    ((zzgl)object3).zzs.zzf();
                                    bl3 = object2 instanceof Parcelable[];
                                    if (!bl3) break block19;
                                    n3 = ((Parcelable[])object2).length;
                                    break block20;
                                }
                                if (!(object2 instanceof ArrayList)) break block21;
                                n3 = ((ArrayList)object2).size();
                            }
                            if (n3 <= 200) break block22;
                            ((zzgl)object3).zzs.zzay().zzl().zzd("Parameter array is too long; discarded. Value kind, name, array length", "param", string2, n3);
                            ((zzgl)object3).zzs.zzf();
                            if (!bl3) break block23;
                            Parcelable[] parcelableArray = (Parcelable[])object2;
                            if (parcelableArray.length > 200) {
                                bundle.putParcelableArray(string2, Arrays.copyOf(parcelableArray, 200));
                                n2 = 17;
                                break block17;
                            } else {
                                n2 = 17;
                            }
                            break block17;
                        }
                        if (object2 instanceof ArrayList) {
                            ArrayList arrayList = (ArrayList)object2;
                            if (arrayList.size() > 200) {
                                ArrayList arrayList2 = new ArrayList(arrayList.subList(0, 200));
                                bundle.putParcelableArrayList(string2, arrayList2);
                                n2 = 17;
                                break block17;
                            } else {
                                n2 = 17;
                            }
                            break block17;
                        } else {
                            n2 = 17;
                        }
                        break block17;
                    }
                    n2 = 0;
                    break block17;
                }
                n2 = 0;
                break block17;
            }
            n2 = 0;
        }
        if (((zzgl)object3).zzs.zzf().zzs((String)object, zzdw.zzR) && zzku.zzag(string) || zzku.zzag(string2)) {
            ((zzgl)object3).zzs.zzf();
            n = 256;
        } else {
            ((zzgl)object3).zzs.zzf();
            n = 100;
        }
        if (((zzku)object3).zzZ("param", string2, n, object2)) {
            return n2;
        }
        if (!bl2) return 4;
        if (object2 instanceof Bundle) {
            ((zzku)object3).zzV((String)object, string, string2, (Bundle)object2, list, bl);
            return n2;
        }
        if (object2 instanceof Parcelable[]) {
            Parcelable[] parcelableArray = (Parcelable[])object2;
            n = parcelableArray.length;
            int n4 = 0;
            while (n4 < n) {
                Parcelable parcelable = parcelableArray[n4];
                if (!(parcelable instanceof Bundle)) {
                    ((zzgl)object3).zzs.zzay().zzl().zzc("All Parcelable[] elements must be of type Bundle. Value type, name", parcelable.getClass(), string2);
                    return 4;
                }
                ((zzku)object3).zzV((String)object, string, string2, (Bundle)parcelable, list, bl);
                ++n4;
            }
            return n2;
        }
        if (!(object2 instanceof ArrayList)) return 4;
        ArrayList arrayList = (ArrayList)object2;
        n = arrayList.size();
        int n5 = 0;
        while (n5 < n) {
            Object e = arrayList.get(n5);
            if (!(e instanceof Bundle)) {
                object = ((zzgl)object3).zzs.zzay().zzl();
                Object object3 = e != null ? e.getClass() : "null";
                ((zzeg)object).zzc("All ArrayList elements must be of type Bundle. Value type, name", object3, string2);
                return 4;
            }
            ((zzku)object3).zzV((String)object, string, string2, (Bundle)e, list, bl);
            ++n5;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    final int zzd(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zzZ("user property referrer", string, this.zzaq(string), object) : this.zzZ("user property", string, this.zzaq(string), object);
        if (bl) {
            return 0;
        }
        return 7;
    }

    final int zzh(String string) {
        if (!this.zzaa("event", string)) {
            return 2;
        }
        if (!this.zzY("event", zzgp.zza, zzgp.zzb, string)) {
            return 13;
        }
        this.zzs.zzf();
        if (!this.zzX("event", 40, string)) {
            return 2;
        }
        return 0;
    }

    final int zzi(String string) {
        if (!this.zzaa("event param", string)) {
            return 3;
        }
        if (!this.zzY("event param", null, null, string)) {
            return 14;
        }
        this.zzs.zzf();
        if (!this.zzX("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final int zzj(String string) {
        if (!this.zzab("event param", string)) {
            return 3;
        }
        if (!this.zzY("event param", null, null, string)) {
            return 14;
        }
        this.zzs.zzf();
        if (!this.zzX("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final int zzl(String string) {
        if (!this.zzaa("user property", string)) {
            return 6;
        }
        if (!this.zzY("user property", zzgr.zza, null, string)) {
            return 15;
        }
        this.zzs.zzf();
        if (!this.zzX("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    @EnsuresNonNull(value={"this.apkVersion"})
    public final int zzm() {
        if (this.zzm == null) {
            this.zzm = GoogleApiAvailabilityLight.getInstance().getApkVersion(this.zzs.zzau()) / 1000;
        }
        return this.zzm;
    }

    private final int zzaq(String string) {
        if ("_ldl".equals(string)) {
            this.zzs.zzf();
            return 2048;
        }
        if (!"_id".equals(string)) {
            if (this.zzs.zzf().zzs(null, zzdw.zzab) && "_lgclid".equals(string)) {
                this.zzs.zzf();
                return 100;
            }
            this.zzs.zzf();
            return 36;
        }
        this.zzs.zzf();
        return 256;
    }

    public final int zzo(int n) {
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(this.zzs.zzau(), 12451000);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static long zzp(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        int n = byArray.length;
        int n2 = n > 0 ? 1 : 0;
        Preconditions.checkState(n2 != 0);
        long l = 0L;
        n2 = 0;
        for (int i = n + -1; i >= 0 && i >= byArray.length + -8; n2 += 8, --i) {
            long l2 = l + (((long)byArray[i] & 0xFFL) << n2);
            l = l2;
        }
        return l;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzq() {
        if (this.zzk.get() == 0L) {
            AtomicLong atomicLong = this.zzk;
            synchronized (atomicLong) {
                long l = System.nanoTime();
                Clock clock = this.zzs.zzav();
                Random random = new Random(l ^ clock.currentTimeMillis());
                long l2 = random.nextLong();
                int n = this.zzl;
                this.zzl = ++n;
                return l2 + (long)n;
            }
        }
        AtomicLong atomicLong = this.zzk;
        synchronized (atomicLong) {
            this.zzk.compareAndSet(-1L, 1L);
            return this.zzk.getAndIncrement();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final long zzr(long l, long l2) {
        return (l + l2 * 60000L) / 86400000L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Bundle zzs(Uri uri) {
        String string;
        String string2;
        String string3;
        if (uri == null) {
            return null;
        }
        try {
            Object object;
            boolean bl = uri.isHierarchical();
            if (bl) {
                string3 = uri.getQueryParameter("utm_campaign");
                string2 = uri.getQueryParameter("utm_source");
                string = uri.getQueryParameter("utm_medium");
                String string4 = uri.getQueryParameter("gclid");
                object = string3;
                string3 = string2;
                string2 = string;
                string = string4;
            } else {
                object = null;
                string3 = null;
                string2 = null;
                string = null;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ((zzgl)object).zzs.zzay().zzk().zzb("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)object) && TextUtils.isEmpty((CharSequence)string3) && TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        Bundle bundle = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)object)) {
            bundle.putString("campaign", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            bundle.putString("source", string3);
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putString("medium", string2);
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putString("gclid", string);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("utm_term")))) {
            bundle.putString("term", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("utm_content")))) {
            bundle.putString("content", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("aclid")))) {
            bundle.putString("aclid", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("cp1")))) {
            bundle.putString("cp1", (String)object);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("anid")))) {
            bundle.putString("anid", (String)object);
        }
        return bundle;
    }

    final Bundle zzt(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zzA(string, bundle.get(string));
                if (object == null) {
                    this.zzs.zzay().zzl().zzb("Param value can't be null", this.zzs.zzj().zzd(string));
                    continue;
                }
                this.zzN(bundle2, string, object);
            }
        }
        return bundle2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    final Bundle zzy(String var1_1, String var2_2, Bundle var3_3, List<String> var4_4, boolean var5_5) {
        block12: {
            var9_6 = zzku.zzas(var2_2, zzgp.zzd);
            if (var3_3 == null) break block12;
            var10_7 = new Bundle(var3_3);
            var11_8 = this.zzs.zzf().zzc();
            var6_9 = new TreeSet<E>(var3_3.keySet());
            var12_11 = var6_9.iterator();
            var6_10 = 0;
            block0: while (var12_11.hasNext()) {
                block13: {
                    block14: {
                        var13_17 = (String)var12_11.next();
                        if (var4_4 != null && var4_4.contains(var13_17)) break block13;
                        if (var5_5) break block14;
                        var7_12 = this.zzj(var13_17);
lbl13:
                        // 2 sources

                        while (true) {
                            if (var7_12 == 0) {
                                var7_12 = this.zzi(var13_17);
                            }
lbl16:
                            // 4 sources

                            while (true) {
                                if (var7_12 != 0) {
                                    if (var7_12 == 3) {
                                        var8_15 = var13_17;
lbl20:
                                        // 2 sources

                                        while (true) {
                                            this.zzI(var10_7, var7_12, var13_17, var13_17, var8_15);
                                            var10_7.remove(var13_17);
                                            continue block0;
                                            break;
                                        }
                                    }
                                    var8_15 = null;
                                    ** continue;
                                }
                                var8_16 = this.zza(var1_1, var2_2, var13_17, var3_3.get(var13_17), var10_7, var4_4, var5_5, var9_6);
                                if (var8_16 == 17) {
                                    this.zzI(var10_7, 17, var13_17, var13_17, false);
lbl29:
                                    // 2 sources

                                    while (zzku.zzah(var13_17) && ++var6_10 > var11_8) {
                                        var7_13 /* !! */  = new StringBuilder(48);
                                        var7_13 /* !! */ .append("Event can't contain more than ");
                                        var7_13 /* !! */ .append(var11_8);
                                        var7_13 /* !! */ .append(" params");
                                        var7_13 /* !! */  = var7_13 /* !! */ .toString();
                                        this.zzs.zzay().zze().zzc((String)var7_13 /* !! */ , this.zzs.zzj().zzc(var2_2), this.zzs.zzj().zzb(var3_3));
                                        zzku.zzao(var10_7, 5);
                                        var10_7.remove(var13_17);
                                        continue block0;
                                    }
                                    continue block0;
                                }
                                if (var8_16 == 0 || "_ev".equals(var13_17)) ** GOTO lbl29
                                if (var8_16 == 21) {
                                    var7_14 = var2_2;
lbl47:
                                    // 2 sources

                                    while (true) {
                                        this.zzI(var10_7, var8_16, var7_14, var13_17, var3_3.get(var13_17));
                                        var10_7.remove(var13_17);
                                        continue block0;
                                        break;
                                    }
                                }
                                var7_14 = var13_17;
                                ** continue;
                                break;
                            }
                            break;
                        }
                    }
                    var7_12 = 0;
                    ** continue;
                }
                var7_12 = 0;
                ** continue;
            }
            this = var10_7;
lbl60:
            // 2 sources

            return this;
        }
        this = null;
        ** while (true)
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final zzat zzz(String object, String string, Bundle object2, String string2, long l, boolean bl, boolean bl2) {
        void var5_11;
        void var7_12;
        void var4_10;
        void var3_7;
        void var3_5;
        Object object3;
        void var2_4;
        if (TextUtils.isEmpty((CharSequence)var2_4)) {
            return null;
        }
        if (((zzku)object3).zzh((String)var2_4) != 0) {
            ((zzgl)object3).zzs.zzay().zzd().zzb("Invalid conditional property event name", ((zzgl)object3).zzs.zzj().zze((String)var2_4));
            object3 = new IllegalArgumentException();
            throw object3;
        }
        if (var3_5 != null) {
            Bundle bundle;
            Bundle bundle2 = bundle = new Bundle((Bundle)var3_5);
        } else {
            Bundle bundle = new Bundle();
        }
        var3_7.putString("_o", (String)var4_10);
        Bundle bundle = ((zzku)object3).zzy((String)object, (String)var2_4, (Bundle)var3_7, CollectionUtils.listOf((Object)"_o"), true);
        object3 = var7_12 != false ? ((zzku)object3).zzt(bundle) : bundle;
        Preconditions.checkNotNull((Object)object3);
        zzar zzar2 = new zzar((Bundle)object3);
        return new zzat((String)var2_4, zzar2, (String)var4_10, (long)var5_11);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Object zzA(String string, Object object) {
        int n;
        if ("_ev".equals(string)) {
            this.zzs.zzf();
            return this.zzar(256, object, true, true);
        }
        if (zzku.zzag(string)) {
            this.zzs.zzf();
            n = 256;
            return this.zzar(n, object, false, true);
        }
        this.zzs.zzf();
        n = 100;
        return this.zzar(n, object, false, true);
    }

    final Object zzB(String string, Object object) {
        if ("_ldl".equals(string)) {
            return this.zzar(this.zzaq(string), object, true, false);
        }
        return this.zzar(this.zzaq(string), object, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object zzar(int n, Object parcelableArray, boolean bl, boolean n2) {
        if (parcelableArray == null) {
            return null;
        }
        if (parcelableArray instanceof Long || parcelableArray instanceof Double) {
            return parcelableArray;
        }
        if (parcelableArray instanceof Integer) {
            return (long)((Integer)parcelableArray).intValue();
        }
        if (parcelableArray instanceof Byte) {
            return (long)((Byte)parcelableArray).byteValue();
        }
        if (parcelableArray instanceof Short) {
            return (long)((Short)parcelableArray).shortValue();
        }
        if (parcelableArray instanceof Boolean) {
            long l;
            if (!((Boolean)parcelableArray).booleanValue()) {
                l = 0L;
                return l;
            }
            l = 1L;
            return l;
        }
        if (parcelableArray instanceof Float) {
            return ((Float)parcelableArray).doubleValue();
        }
        if (parcelableArray instanceof String || parcelableArray instanceof Character || parcelableArray instanceof CharSequence) {
            return this.zzC(String.valueOf(parcelableArray), n, bl);
        }
        if (n2 == 0 || !(parcelableArray instanceof Bundle[]) && !(parcelableArray instanceof Parcelable[])) return null;
        ArrayList<Parcelable> arrayList = new ArrayList<Parcelable>();
        for (Parcelable parcelable : parcelableArray) {
            if (!(parcelable instanceof Bundle) || (parcelable = this.zzt((Bundle)parcelable)).isEmpty()) continue;
            arrayList.add(parcelable);
        }
        return arrayList.toArray(new Bundle[arrayList.size()]);
    }

    public final String zzC(String string, int n, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.codePointCount(0, string.length()) > n) {
            if (bl) {
                return String.valueOf(string.substring(0, string.offsetByCodePoints(0, n))).concat("...");
            }
            return null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final URL zzD(long l, String string, String object, long l2) {
        Object object2;
        block4: {
            Preconditions.checkNotEmpty((String)object);
            Preconditions.checkNotEmpty((String)string);
            Object object3 = new Object[4];
            Object[] objectArray = new Object[]{42097L, this.zzm()};
            object3[0] = String.format("v%s.%s", objectArray);
            object3[1] = object;
            object3[2] = string;
            object3[3] = l2;
            object = String.format("https://www.googleadservices.com/pagead/conversion/app/deeplink?id_type=adid&sdk_version=%s&rdid=%s&bundleid=%s&retry=%s", (Object[])object3);
            object3 = this.zzs.zzf();
            boolean bl = string.equals(((zzaf)object3).zzm());
            if (!bl) break block4;
            try {
                object2 = ((String)object).concat("&ddl_test=1");
                return new URL((String)object2);
            }
            catch (IllegalArgumentException | MalformedURLException exception) {
                this.zzs.zzay().zzd().zzb("Failed to create BOW URL for Deferred Deep Link. exception", exception.getMessage());
                return null;
            }
        }
        object2 = object;
        return new URL((String)object2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MessageDigest zzE(String string) {
        String string2 = "MD5";
        int n = 0;
        while (n < 2) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string2);
                if (messageDigest != null) {
                    return messageDigest;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            ++n;
        }
        return null;
    }

    @EnsuresNonNull(value={"this.secureRandom"})
    @WorkerThread
    final SecureRandom zzF() {
        this.zzg();
        if (this.zzj == null) {
            SecureRandom secureRandom;
            this.zzj = secureRandom = new SecureRandom();
        }
        return this.zzj;
    }

    public static ArrayList<Bundle> zzG(List<zzab> object) {
        if (object == null) {
            object = new ArrayList(0);
            return object;
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            AbstractSafeParcelable abstractSafeParcelable = (zzab)((Object)object.next());
            Bundle bundle = new Bundle();
            bundle.putString("app_id", abstractSafeParcelable.zza);
            bundle.putString("origin", abstractSafeParcelable.zzb);
            bundle.putLong("creation_timestamp", abstractSafeParcelable.zzd);
            bundle.putString("name", abstractSafeParcelable.zzc.zzb);
            zzgo.zzb((Bundle)bundle, (Object)abstractSafeParcelable.zzc.zza());
            bundle.putBoolean("active", abstractSafeParcelable.zze);
            Object object2 = abstractSafeParcelable.zzf;
            if (object2 != null) {
                bundle.putString("trigger_event_name", object2);
            }
            if ((object2 = abstractSafeParcelable.zzg) != null) {
                bundle.putString("timed_out_event_name", ((zzat)((Object)object2)).zza);
                object2 = abstractSafeParcelable.zzg.zzb;
                if (object2 != null) {
                    bundle.putBundle("timed_out_event_params", ((zzar)object2).zzc());
                }
            }
            bundle.putLong("trigger_timeout", abstractSafeParcelable.zzh);
            object2 = abstractSafeParcelable.zzi;
            if (object2 != null) {
                bundle.putString("triggered_event_name", ((zzat)((Object)object2)).zza);
                object2 = abstractSafeParcelable.zzi.zzb;
                if (object2 != null) {
                    bundle.putBundle("triggered_event_params", ((zzar)object2).zzc());
                }
            }
            bundle.putLong("triggered_timestamp", abstractSafeParcelable.zzc.zzc);
            bundle.putLong("time_to_live", abstractSafeParcelable.zzj);
            object2 = abstractSafeParcelable.zzk;
            if (object2 != null) {
                bundle.putString("expired_event_name", ((zzat)((Object)object2)).zza);
                abstractSafeParcelable = abstractSafeParcelable.zzk.zzb;
                if (abstractSafeParcelable != null) {
                    bundle.putBundle("expired_event_params", abstractSafeParcelable.zzc());
                }
            }
            arrayList.add(bundle);
        }
        return arrayList;
    }

    static {
        String[] stringArray = new String[]{"firebase_", "google_", "ga_"};
        zzb = stringArray;
        stringArray = new String[]{"_err"};
        zzc = stringArray;
        zzd = Pattern.compile("^([^\\s@]+)@([^\\s@]+\\.[^\\s@]+)$");
        zze = Pattern.compile("^(gmail|googlemail)\\.");
        zzf = Pattern.compile("[\\s-()/.]+");
        zzg = Pattern.compile("^\\+\\d{11,15}$");
        zzh = Pattern.compile("[0-9`~!@#$%^&*()_\\-+=:;<>,.?|/\\\\\\[\\]]+");
        zzi = Pattern.compile("\\s+");
    }

    zzku(zzfs object) {
        super((zzfs)object);
        this.zzk = object = new AtomicLong(0L);
    }

    @WorkerThread
    final void zzH(Bundle bundle, long l) {
        long l2 = bundle.getLong("_et");
        if (l2 != 0L) {
            this.zzs.zzay().zzk().zzb("Params already contained engagement", l2);
        }
        bundle.putLong("_et", l + l2);
    }

    final void zzI(Bundle bundle, int n, String string, String string2, Object object) {
        if (zzku.zzao(bundle, n)) {
            this.zzs.zzf();
            bundle.putString("_ev", this.zzC(string, 40, true));
            if (object != null) {
                Preconditions.checkNotNull((Object)bundle);
                if (object instanceof String || object instanceof CharSequence) {
                    bundle.putLong("_el", (long)String.valueOf(object).length());
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public static void zzJ(zzic zzic2, Bundle bundle, boolean bl) {
        if (bundle != null && zzic2 != null) {
            if (!bundle.containsKey("_sc") || bl) {
                String string = zzic2.zza;
                if (string != null) {
                    bundle.putString("_sn", string);
                } else {
                    bundle.remove("_sn");
                }
                if ((string = zzic2.zzb) != null) {
                    bundle.putString("_sc", string);
                } else {
                    bundle.remove("_sc");
                }
                bundle.putLong("_si", zzic2.zzc);
                return;
            }
            bl = false;
        }
        if (bundle != null && zzic2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
            return;
        }
    }

    final void zzK(Bundle bundle, Bundle bundle2) {
        if (bundle2 == null) {
            return;
        }
        for (String string : bundle2.keySet()) {
            if (bundle.containsKey(string)) continue;
            this.zzs.zzv().zzN(bundle, string, bundle2.get(string));
        }
    }

    final void zzL(zzej zzej2, int n) {
        TreeSet treeSet = new TreeSet(zzej2.zzd.keySet());
        Iterator iterator = treeSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!zzku.zzah(string) || ++n2 <= n) continue;
            CharSequence charSequence = new StringBuilder(48);
            charSequence.append("Event can't contain more than ");
            charSequence.append(n);
            charSequence.append(" params");
            charSequence = charSequence.toString();
            this.zzs.zzay().zze().zzc((String)charSequence, this.zzs.zzj().zzc(zzej2.zza), this.zzs.zzj().zzb(zzej2.zzd));
            zzku.zzao(zzej2.zzd, 5);
            zzej2.zzd.remove(string);
        }
    }

    final void zzM(zzkt zzkt2, String string, int n, String string2, String string3, int n2) {
        zzku zzku2 = new Bundle();
        zzku.zzao((Bundle)zzku2, n);
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            zzku2.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            zzku2.putLong("_el", n2);
        }
        zzkt2.zza(string, "_err", (Bundle)zzku2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @WorkerThread
    protected final void zzaA() {
        long l;
        this.zzg();
        SecureRandom secureRandom = new SecureRandom();
        long l2 = secureRandom.nextLong();
        if (l2 == 0L) {
            long l3 = secureRandom.nextLong();
            if (l3 == 0L) {
                this.zzs.zzay().zzk().zza("Utils falling back to Random for random id");
                l = l3;
            } else {
                l = l3;
            }
        } else {
            l = l2;
        }
        this.zzk.set(l);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final void zzN(Bundle object, String string, Object object2) {
        void var1_3;
        void var2_5;
        void var3_6;
        if (object == null) {
            return;
        }
        if (var3_6 instanceof Long) {
            object.putLong((String)var2_5, ((Long)var3_6).longValue());
            return;
        }
        if (var3_6 instanceof String) {
            object.putString((String)var2_5, String.valueOf(var3_6));
            return;
        }
        if (var3_6 instanceof Double) {
            object.putDouble((String)var2_5, ((Double)var3_6).doubleValue());
            return;
        }
        if (var3_6 instanceof Bundle[]) {
            object.putParcelableArray((String)var2_5, (Parcelable[])((Bundle[])var3_6));
            return;
        }
        if (var2_5 == null) {
            return;
        }
        if (var3_6 != null) {
            String string2 = var3_6.getClass().getSimpleName();
        } else {
            Object var1_4 = null;
        }
        this.zzs.zzay().zzl().zzc("Not putting event parameter. Invalid value type. name, type", this.zzs.zzj().zzd((String)var2_5), var1_3);
    }

    public final void zzO(zzcf zzcf2, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("r", bl);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning boolean value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzP(zzcf zzcf2, ArrayList<Bundle> arrayList) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("r", arrayList);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning bundle list to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzQ(zzcf zzcf2, Bundle bundle) {
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzR(zzcf zzcf2, byte[] byArray) {
        Bundle bundle = new Bundle();
        bundle.putByteArray("r", byArray);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning byte array to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzS(zzcf zzcf2, int n) {
        Bundle bundle = new Bundle();
        bundle.putInt("r", n);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning int value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzT(zzcf zzcf2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("r", l);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning long value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzU(zzcf zzcf2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("r", string);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning string value to wrapper", (Object)remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzV(String string, String string2, String string3, Bundle bundle, List<String> list, boolean bl) {
        if (bundle == null) {
            return;
        }
        this.zzs.zzf();
        TreeSet treeSet = new TreeSet(bundle.keySet());
        Iterator iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2;
            String string4 = (String)iterator.next();
            if (list == null || !list.contains(string4)) {
                n2 = !bl ? this.zzj(string4) : 0;
                if (n2 == 0) {
                    n2 = this.zzi(string4);
                }
            } else {
                n2 = 0;
            }
            if (n2 != 0) {
                String string5 = n2 == 3 ? string4 : null;
                this.zzI(bundle, n2, string4, string4, string5);
                bundle.remove(string4);
                continue;
            }
            if (this.zzae(bundle.get(string4))) {
                this.zzs.zzay().zzl().zzd("Nested Bundle parameters are not allowed; discarded. event name, param name, child param name", string2, string3, string4);
                n2 = 22;
            } else {
                n2 = this.zza(string, string2, string4, bundle.get(string4), bundle, list, bl, false);
            }
            if (n2 != 0 && !"_ev".equals(string4)) {
                this.zzI(bundle, n2, string4, string4, bundle.get(string4));
                bundle.remove(string4);
                continue;
            }
            if (!zzku.zzah(string4) || zzku.zzas(string4, zzgq.zzd) || ++n <= 0) continue;
            this.zzs.zzay().zze().zzc("Item cannot contain custom parameters", this.zzs.zzj().zzc(string2), this.zzs.zzj().zzb(bundle));
            zzku.zzao(bundle, 23);
            bundle.remove(string4);
        }
        return;
    }

    private static boolean zzas(String string, String[] stringArray) {
        Preconditions.checkNotNull((Object)stringArray);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!zzku.zzak(string, stringArray[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    final boolean zzW(String string, String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (zzku.zzap(string)) return true;
            if (!this.zzs.zzL()) return false;
            this.zzs.zzay().zze().zzb("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", zzei.zzn(string));
            return false;
        }
        zzoq.zzc();
        if (this.zzs.zzf().zzs(null, zzdw.zzad) && !TextUtils.isEmpty((CharSequence)string3)) return true;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (zzku.zzap(string2)) {
                return true;
            }
            this.zzs.zzay().zze().zzb("Invalid admob_app_id. Analytics disabled.", zzei.zzn(string2));
            return false;
        }
        if (!this.zzs.zzL()) return false;
        this.zzs.zzay().zze().zza("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
        return false;
    }

    final boolean zzX(String string, int n, String string2) {
        if (string2 == null) {
            this.zzs.zzay().zze().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.codePointCount(0, string2.length()) > n) {
            this.zzs.zzay().zze().zzd("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    final boolean zzY(String string, String[] stringArray, String[] stringArray2, String string2) {
        if (string2 == null) {
            this.zzs.zzay().zze().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        Preconditions.checkNotNull((Object)string2);
        String[] stringArray3 = zzb;
        for (int i = 0; i < 3; ++i) {
            if (!string2.startsWith(stringArray3[i])) continue;
            this.zzs.zzay().zze().zzc("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null && zzku.zzas(string2, stringArray) && (stringArray2 == null || !zzku.zzas(string2, stringArray2))) {
            this.zzs.zzay().zze().zzc("Name is reserved. Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zzZ(String string, String string2, int n, Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            if (((String)(object = String.valueOf(object))).codePointCount(0, ((String)object).length()) > n) {
                this.zzs.zzay().zzl().zzd("Value is too long; discarded. Value kind, name, value length", string, string2, ((String)object).length());
                return false;
            }
            return true;
        }
        return false;
    }

    final boolean zzaa(String string, String string2) {
        block8: {
            int n;
            int n2;
            block7: {
                if (string2 == null) {
                    this.zzs.zzay().zze().zzb("Name is required and can't be null. Type", string);
                    return false;
                }
                if (string2.length() == 0) {
                    this.zzs.zzay().zze().zzb("Name is required and can't be empty. Type", string);
                    return false;
                }
                n2 = string2.codePointAt(0);
                if (Character.isLetter(n2)) break block7;
                if (n2 != 95) break block8;
                n2 = 95;
            }
            int n3 = string2.length();
            for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
                n = string2.codePointAt(n2);
                if (n == 95 || Character.isLetterOrDigit(n)) {
                    continue;
                }
                this.zzs.zzay().zze().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
                return false;
            }
            return true;
        }
        this.zzs.zzay().zze().zzc("Name must start with a letter or _ (underscore). Type, name", string, string2);
        return false;
    }

    final boolean zzab(String string, String string2) {
        int n;
        if (string2 == null) {
            this.zzs.zzay().zze().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            this.zzs.zzay().zze().zzb("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            this.zzs.zzay().zze().zzc("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
            n = string2.codePointAt(n2);
            if (n == 95 || Character.isLetterOrDigit(n)) {
                continue;
            }
            this.zzs.zzay().zze().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    @WorkerThread
    final boolean zzac(String string) {
        this.zzg();
        if (Wrappers.packageManager((Context)this.zzs.zzau()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        this.zzs.zzay().zzc().zzb("Permission not granted", string);
        return false;
    }

    final boolean zzad(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        Object object = this.zzs;
        object = ((zzfs)object).zzf();
        object = ((zzaf)object).zzl();
        this.zzs.zzaw();
        return ((String)object).equals(string);
    }

    final boolean zzae(Object object) {
        return object instanceof Parcelable[] || object instanceof ArrayList || object instanceof Bundle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final boolean zzaf(Context signature, String signatureArray) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        signature = Wrappers.packageManager((Context)signature).getPackageInfo((String)signatureArray, 64);
        if (signature == null) return true;
        signatureArray = signature.signatures;
        if (signatureArray == null) return true;
        int n = signature.signatures.length;
        if (n <= 0) return true;
        try {
            signature = signature.signatures;
            signature = signature[0];
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(signature.toByteArray());
            return ((X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream)).getSubjectX500Principal().equals(x500Principal);
        }
        catch (CertificateException certificateException) {
            this.zzs.zzay().zzd().zzb("Error obtaining certificate", certificateException);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzs.zzay().zzd().zzb("Package name not found", (Object)nameNotFoundException);
            return true;
        }
    }

    static boolean zzag(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    static boolean zzah(String string) {
        Preconditions.checkNotEmpty((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean zzai(Context context) {
        block6: {
            PackageManager packageManager;
            block5: {
                Preconditions.checkNotNull((Object)context);
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            ComponentName componentName = new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver");
            context = packageManager.getReceiverInfo(componentName, 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzat(Context context, String string) {
        block6: {
            PackageManager packageManager;
            block5: {
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            ComponentName componentName = new ComponentName(context, string);
            context = packageManager.getServiceInfo(componentName, 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    static boolean zzaj(Context context, boolean bl) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzku.zzat(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzku.zzat(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    static boolean zzak(String string, String string2) {
        if (string != null || string2 != null) {
            if (string == null) {
                return false;
            }
            return string.equals(string2);
        }
        return true;
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    public static boolean zzal(String string) {
        return !zzc[0].equals(string);
    }

    final boolean zzam(String string, String string2, String string3, String string4) {
        boolean bl = TextUtils.isEmpty((CharSequence)string);
        boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
        if (!bl && !bl2) {
            Preconditions.checkNotNull((Object)string);
            return !string.equals(string2);
        }
        if (bl && bl2) {
            if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string4)) {
                return !string3.equals(string4);
            }
            return !TextUtils.isEmpty((CharSequence)string4);
        }
        if (!bl) {
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
        }
        return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
    }

    final byte[] zzan(Parcelable object) {
        if (object == null) {
            return null;
        }
        zzku zzku2 = Parcel.obtain();
        try {
            object.writeToParcel((Parcel)zzku2, 0);
            object = zzku2.marshall();
        }
        finally {
            zzku2.recycle();
        }
        return object;
    }

    static final boolean zzao(Bundle bundle, int n) {
        if (bundle.getLong("_err") == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static final boolean zzap(String string) {
        Preconditions.checkNotNull((Object)string);
        return string.matches("^(1:\\d+:android:[a-f0-9]+|ca-app-pub-.*)$");
    }
}

