/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzdu;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzgl;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzew
extends zzgl {
    @VisibleForTesting
    static final Pair zza;
    private SharedPreferences zzt;
    public zzeu zzb;
    public final zzes zzc;
    public final zzes zzd;
    public final zzev zze;
    private String zzu;
    private boolean zzv;
    private long zzw;
    public final zzes zzf;
    public final zzeq zzg;
    public final zzev zzh;
    public final zzeq zzi;
    public final zzes zzj;
    public boolean zzk;
    public final zzeq zzl;
    public final zzeq zzm;
    public final zzes zzn;
    public final zzev zzo;
    public final zzev zzp;
    public final zzes zzq;
    public final zzer zzr;

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zza() {
        this.zzg();
        this.zzu();
        Preconditions.checkNotNull((Object)this.zzt);
        return this.zzt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final Pair zzb(String string) {
        this.zzg();
        long l = this.zzs.zzav().elapsedRealtime();
        String string2 = this.zzu;
        if (string2 != null && l < this.zzw) {
            return new Pair((Object)string2, (Object)this.zzv);
        }
        this.zzw = l + this.zzs.zzf().zzi(string, zzdu.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            string = this.zzs.zzau();
            string = AdvertisingIdClient.getAdvertisingIdInfo((Context)string);
            this.zzu = "";
            string2 = string.getId();
            if (string2 != null) {
                this.zzu = string2;
            }
            this.zzv = string.isLimitAdTrackingEnabled();
        }
        catch (Exception exception) {
            this.zzs.zzay().zzc().zzb("Unable to get advertising id", exception);
            this.zzu = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzu, (Object)this.zzv);
    }

    @WorkerThread
    final zzah zzc() {
        this.zzg();
        return zzah.zzb(this.zza().getString("consent_settings", "G1"));
    }

    @WorkerThread
    final Boolean zzd() {
        this.zzg();
        if (this.zza().contains("measurement_enabled")) {
            return this.zza().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    static {
        Pair pair;
        zza = pair = new Pair((Object)"", (Object)0L);
    }

    zzew(zzfr object) {
        super((zzfr)object);
        this.zzf = object = new zzes(this, "session_timeout", 1800000L);
        this.zzg = object = new zzeq(this, "start_new_session", true);
        this.zzj = object = new zzes(this, "last_pause_time", 0L);
        this.zzh = object = new zzev(this, "non_personalized_ads", null);
        this.zzi = object = new zzeq(this, "allow_remote_dynamite", false);
        this.zzc = object = new zzes(this, "first_open_time", 0L);
        this.zzd = object = new zzes(this, "app_install_time", 0L);
        this.zze = object = new zzev(this, "app_instance_id", null);
        this.zzl = object = new zzeq(this, "app_backgrounded", false);
        this.zzm = object = new zzeq(this, "deep_link_retrieval_complete", false);
        this.zzn = object = new zzes(this, "deep_link_retrieval_attempts", 0L);
        this.zzo = object = new zzev(this, "firebase_feature_rollouts", null);
        this.zzp = object = new zzev(this, "deferred_attribution_cache", null);
        this.zzq = object = new zzes(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzr = object = new zzer(this, "default_event_parameters", null);
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    @WorkerThread
    protected final void zzaA() {
        zzeu zzeu2;
        boolean bl;
        this.zzt = this.zzs.zzau().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzk = bl = this.zzt.getBoolean("has_been_opened", false);
        if (!bl) {
            SharedPreferences.Editor editor = this.zzt.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzs.zzf();
        this.zzb = zzeu2 = new zzeu(this, "health_monitor", Math.max(0L, (Long)zzdu.zzb.zza(null)), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzh(Boolean bl) {
        zzew2.zzg();
        zzew zzew2 = zzew2.zza().edit();
        if (bl != null) {
            zzew2.putBoolean("measurement_enabled", bl);
        } else {
            zzew2.remove("measurement_enabled");
        }
        zzew2.apply();
    }

    @WorkerThread
    final void zzi(boolean bl) {
        zzew2.zzg();
        zzew2.zzs.zzay().zzj().zzb("App measurement setting deferred collection", bl);
        zzew zzew2 = zzew2.zza().edit();
        zzew2.putBoolean("deferred_analytics_collection", bl);
        zzew2.apply();
    }

    @WorkerThread
    final boolean zzj() {
        zzew zzew2 = zzew2.zzt;
        if (zzew2 == null) {
            return false;
        }
        return zzew2.contains("deferred_analytics_collection");
    }

    final boolean zzk(long l) {
        return l - this.zzf.zza() > this.zzj.zza();
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    @WorkerThread
    final boolean zzl(int n) {
        return zzah.zzj(n, this.zza().getInt("consent_source", 100));
    }
}

