/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zznu;
import com.google.android.gms.internal.measurement.zznx;
import com.google.android.gms.internal.measurement.zzod;
import com.google.android.gms.internal.measurement.zzpb;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzdu;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzjz;
import com.google.android.gms.measurement.internal.zzka;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzr;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzhw
extends zzf {
    @VisibleForTesting
    protected zzhv zza;
    private zzgr zzd;
    private final Set zze;
    private boolean zzf;
    private final AtomicReference zzg;
    private final Object zzh;
    @GuardedBy(value="consentLock")
    private zzah zzi;
    @GuardedBy(value="consentLock")
    private int zzj;
    private final AtomicLong zzk;
    private long zzl;
    private int zzm;
    final zzr zzb;
    @VisibleForTesting
    protected boolean zzc;
    private final zzkv zzn;

    public final int zzh(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzs.zzf();
        return 25;
    }

    public final Boolean zzi() {
        AtomicReference atomicReference = new AtomicReference();
        zzgm zzgm2 = this.zzs;
        zzgm2 = ((zzfr)zzgm2).zzaz();
        zzhh zzhh2 = new zzhh(this, atomicReference);
        return (Boolean)((zzfo)zzgm2).zzd(atomicReference, 15000L, "boolean test flag value", zzhh2);
    }

    public final Double zzj() {
        AtomicReference atomicReference = new AtomicReference();
        zzgm zzgm2 = this.zzs;
        zzgm2 = ((zzfr)zzgm2).zzaz();
        zzho zzho2 = new zzho(this, atomicReference);
        return (Double)((zzfo)zzgm2).zzd(atomicReference, 15000L, "double test flag value", zzho2);
    }

    public final Integer zzl() {
        AtomicReference atomicReference = new AtomicReference();
        zzgm zzgm2 = this.zzs;
        zzgm2 = ((zzfr)zzgm2).zzaz();
        zzhn zzhn2 = new zzhn(this, atomicReference);
        return (Integer)((zzfo)zzgm2).zzd(atomicReference, 15000L, "int test flag value", zzhn2);
    }

    public final Long zzm() {
        AtomicReference atomicReference = new AtomicReference();
        zzgm zzgm2 = this.zzs;
        zzgm2 = ((zzfr)zzgm2).zzaz();
        zzhm zzhm2 = new zzhm(this, atomicReference);
        return (Long)((zzfo)zzgm2).zzd(atomicReference, 15000L, "long test flag value", zzhm2);
    }

    public final String zzo() {
        return (String)this.zzg.get();
    }

    public final String zzp() {
        zzid zzid2 = ((zzhw)((Object)zzid2)).zzs.zzs().zzi();
        if (zzid2 != null) {
            return zzid2.zzb;
        }
        return null;
    }

    public final String zzq() {
        zzid zzid2 = ((zzhw)((Object)zzid2)).zzs.zzs().zzi();
        if (zzid2 != null) {
            return zzid2.zza;
        }
        return null;
    }

    public final String zzr() {
        AtomicReference atomicReference = new AtomicReference();
        zzgm zzgm2 = this.zzs;
        zzgm2 = ((zzfr)zzgm2).zzaz();
        zzhl zzhl2 = new zzhl(this, atomicReference);
        return (String)((zzfo)zzgm2).zzd(atomicReference, 15000L, "String test flag value", zzhl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList zzs(String object, String string) {
        if (((zzgk)((Object)this)).zzs.zzaz().zzs()) {
            ((zzgk)((Object)this)).zzs.zzay().zzd().zza("Cannot get conditional user properties from analytics worker thread");
            return new ArrayList(0);
        }
        ((zzgk)((Object)this)).zzs.zzaw();
        if (zzaa.zza()) {
            ((zzgk)((Object)this)).zzs.zzay().zzd().zza("Cannot get conditional user properties from main thread");
            return new ArrayList(0);
        }
        AtomicReference atomicReference = new AtomicReference();
        zzgm zzgm2 = ((zzhw)((Object)this)).zzs;
        zzgm2 = ((zzfr)zzgm2).zzaz();
        zzhi zzhi2 = new zzhi((zzhw)((Object)this), atomicReference, null, (String)object, string);
        ((zzfo)zzgm2).zzd(atomicReference, 5000L, "get conditional user properties", zzhi2);
        object = (List)atomicReference.get();
        if (object != null) return zzkw.zzG((List)object);
        ((zzgk)((Object)this)).zzs.zzay().zzd().zzb("Timed out waiting for get conditional user properties", null);
        return new ArrayList();
    }

    public final List zzt(boolean bl) {
        this.zza();
        this.zzs.zzay().zzj().zza("Getting user properties (FE)");
        if (!this.zzs.zzaz().zzs()) {
            this.zzs.zzaw();
            if (zzaa.zza()) {
                this.zzs.zzay().zzd().zza("Cannot get all user properties from main thread");
                return Collections.emptyList();
            }
            Object object = new AtomicReference();
            zzgm zzgm2 = this.zzs;
            zzgm2 = ((zzfr)zzgm2).zzaz();
            zzhd zzhd2 = new zzhd(this, (AtomicReference)object, bl);
            ((zzfo)zzgm2).zzd((AtomicReference)object, 5000L, "get user properties", zzhd2);
            object = (List)((AtomicReference)object).get();
            if (object == null) {
                this.zzs.zzay().zzd().zzb("Timed out waiting for get user properties, includeInternal", bl);
                return Collections.emptyList();
            }
            return object;
        }
        this.zzs.zzay().zzd().zza("Cannot get all user properties from analytics worker thread");
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Map zzu(String iterator, String object, boolean bl) {
        void var3_5;
        if (((zzgk)object2).zzs.zzaz().zzs()) {
            ((zzgk)object2).zzs.zzay().zzd().zza("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzgk)object2).zzs.zzaw();
        if (zzaa.zza()) {
            ((zzgk)object2).zzs.zzay().zzd().zza("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        zzgm zzgm2 = ((zzhw)object2).zzs;
        zzgm2 = ((zzfr)zzgm2).zzaz();
        zzhj zzhj2 = new zzhj((zzhw)object2, atomicReference, null, (String)((Object)iterator), (String)object, (boolean)var3_5);
        ((zzfo)zzgm2).zzd(atomicReference, 5000L, "get user properties", zzhj2);
        iterator = (List)atomicReference.get();
        if (iterator == null) {
            ((zzgk)object2).zzs.zzay().zzd().zzb("Timed out waiting for handle get user properties, includeInternal", (boolean)var3_5);
            return Collections.emptyMap();
        }
        Object object2 = new ArrayMap(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            zzks zzks2 = (zzks)((Object)iterator.next());
            Object object3 = zzks2.zza();
            if (object3 == null) continue;
            object2.put(zzks2.zzb, object3);
        }
        return object2;
    }

    static /* synthetic */ void zzv(zzhw zzgm2, zzah atomicReference, int n, long l, boolean bl, boolean bl2) {
        ((zzgk)zzgm2).zzg();
        ((zzf)zzgm2).zza();
        if (l > ((zzhw)zzgm2).zzl || !zzah.zzj(((zzhw)zzgm2).zzm, n)) {
            zzew zzew2 = ((zzgk)zzgm2).zzs.zzm();
            zzfr cfr_ignored_0 = zzew2.zzs;
            zzew2.zzg();
            if (zzew2.zzl(n)) {
                zzew2 = zzew2.zza().edit();
                zzew2.putString("consent_settings", ((zzah)((Object)atomicReference)).zzh());
                zzew2.putInt("consent_source", n);
                zzew2.apply();
                ((zzhw)zzgm2).zzl = l;
                ((zzhw)zzgm2).zzm = n;
                ((zze)zzgm2).zzs.zzt().zzF(bl);
                if (bl2) {
                    zzgm2 = ((zze)zzgm2).zzs;
                    zzgm2 = ((zzfr)zzgm2).zzt();
                    atomicReference = new AtomicReference();
                    ((zzjk)zzgm2).zzu(atomicReference);
                    return;
                }
                return;
            }
            ((zzgk)zzgm2).zzs.zzay().zzi().zzb("Lower precedence consent source ignored, proposed source", n);
            return;
        }
        ((zzgk)zzgm2).zzs.zzay().zzi().zzb("Dropped out-of-date consent setting, proposed settings", atomicReference);
    }

    static /* bridge */ /* synthetic */ void zzw(zzhw zzhw2, Boolean bl, boolean bl2) {
        zzhw2.zzac(bl, true);
    }

    static /* bridge */ /* synthetic */ void zzx(zzhw zzhw2) {
        zzhw2.zzad();
    }

    protected zzhw(zzfr zzfr2) {
        super(zzfr2);
        Object object = new CopyOnWriteArraySet();
        this.zze = object;
        this.zzh = object = new Object();
        this.zzc = true;
        this.zzn = object = new zzhk(this);
        object = new AtomicReference();
        this.zzg = object;
        this.zzi = object = new zzah(null, null);
        this.zzj = 100;
        this.zzl = -1L;
        this.zzm = 100;
        this.zzk = object = new AtomicLong(0L);
        this.zzb = object = new zzr(zzfr2);
    }

    @WorkerThread
    public final void zzy() {
        ((zzgk)this).zzg();
        this.zza();
        if (this.zzs.zzM()) {
            Object object;
            Object object2;
            if (this.zzs.zzf().zzs(null, zzdu.zzX)) {
                object2 = this.zzs.zzf();
                ((zzgk)object2).zzs.zzaw();
                object2 = ((zzaf)object2).zzk("google_analytics_deferred_deep_link_enabled");
                if (object2 != null && ((Boolean)object2).booleanValue()) {
                    this.zzs.zzay().zzc().zza("Deferred Deep Link feature enabled.");
                    object2 = this.zzs;
                    object2 = ((zzfr)object2).zzaz();
                    object = new zzgv(this);
                    ((zzfo)object2).zzp((Runnable)object);
                }
            }
            this.zzs.zzt().zzq();
            this.zzc = false;
            object2 = this.zzs.zzm();
            ((zzgk)object2).zzg();
            object = ((zzew)object2).zza().getString("previous_os_version", null);
            ((zzgk)object2).zzs.zzg().zzu();
            String string = Build.VERSION.RELEASE;
            if (!TextUtils.isEmpty((CharSequence)string) && !string.equals(object)) {
                object2 = ((zzew)object2).zza().edit();
                object2.putString("previous_os_version", string);
                object2.apply();
            }
            if (!TextUtils.isEmpty((CharSequence)object)) {
                this.zzs.zzg().zzu();
                if (!((String)object).equals(Build.VERSION.RELEASE)) {
                    object2 = new Bundle();
                    object2.putString("_po", (String)object);
                    this.zzG("auto", "_ou", (Bundle)object2);
                    return;
                }
            }
            return;
        }
    }

    public final void zzz(String object, String object2, Bundle bundle) {
        zzfr zzfr2 = this.zzs;
        zzfr2 = zzfr2.zzav();
        long l = zzfr2.currentTimeMillis();
        Preconditions.checkNotEmpty((String)object);
        zzfr2 = new Bundle();
        zzfr2.putString("name", (String)object);
        zzfr2.putLong("creation_timestamp", l);
        if (object2 != null) {
            zzfr2.putString("expired_event_name", (String)object2);
            zzfr2.putBundle("expired_event_params", bundle);
        }
        object = this.zzs;
        object = ((zzfr)object).zzaz();
        object2 = new zzhg(this, (Bundle)zzfr2);
        ((zzfo)object).zzp((Runnable)object2);
    }

    public final void zzA() {
        if (this.zzs.zzau().getApplicationContext() instanceof Application && this.zza != null) {
            ((Application)this.zzs.zzau().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zza);
            return;
        }
    }

    final /* synthetic */ void zzB(Bundle bundle, long l) {
        this.zzab(bundle, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zzC(Bundle object) {
        Object object2;
        if (object == null) {
            Object object3 = ((zzgk)object3).zzs;
            object3 = ((zzfr)object3).zzm();
            object3 = ((zzew)object3).zzr;
            object = new Bundle();
            ((zzer)object3).zzb((Bundle)object);
            return;
        }
        Bundle bundle = ((zzgk)object3).zzs.zzm().zzr.zza();
        for (Object object4 : object.keySet()) {
            object2 = object.get((String)object4);
            if (!(object2 == null || object2 instanceof String || object2 instanceof Long || object2 instanceof Double)) {
                if (((zzgk)object3).zzs.zzv().zzae(object2)) {
                    ((zzgk)object3).zzs.zzv().zzM(((zzhw)object3).zzn, null, 27, null, null, 0);
                }
                ((zzgk)object3).zzs.zzay().zzl().zzc("Invalid default event parameter type. Name, value", object4, object2);
                continue;
            }
            if (zzkw.zzag((String)object4)) {
                ((zzgk)object3).zzs.zzay().zzl().zzb("Invalid default event parameter name. Name", object4);
                continue;
            }
            if (object2 == null) {
                bundle.remove((String)object4);
                continue;
            }
            zzgm zzgm2 = ((zzgk)object3).zzs;
            zzgm2 = ((zzfr)zzgm2).zzv();
            ((zzgk)object3).zzs.zzf();
            if (!((zzkw)zzgm2).zzZ("param", (String)object4, 100, object2)) continue;
            ((zzgk)object3).zzs.zzv().zzN(bundle, (String)object4, object2);
        }
        ((zzgk)object3).zzs.zzv();
        int n = ((zzgk)object3).zzs.zzf().zzc();
        if (bundle.size() > n) {
            Object object4;
            object = new TreeSet(bundle.keySet());
            object4 = object.iterator();
            int n2 = 0;
            while (object4.hasNext()) {
                object2 = (String)object4.next();
                if (++n2 <= n) continue;
                bundle.remove((String)object2);
            }
            ((zzgk)object3).zzs.zzv().zzM(((zzhw)object3).zzn, null, 26, null, null, 0);
            ((zzgk)object3).zzs.zzay().zzl().zza("Too many default event parameters set. Discarding beyond event parameter limit");
        }
        ((zzgk)object3).zzs.zzm().zzr.zzb(bundle);
        ((zze)object3).zzs.zzt().zzH(bundle);
    }

    public final void zzD(String string, String string2, Bundle bundle) {
        this.zzE(string, string2, bundle, true, true, this.zzs.zzav().currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzE(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        if (string == null) {
            string = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (zzkw.zzak(string2, "screen_view")) {
            this.zzs.zzs().zzx(bundle, l);
            return;
        }
        boolean bl3 = bl2 ? (this.zzd != null ? zzkw.zzag(string2) : true) : true;
        this.zzM(string, string2, l, bundle, bl2, bl3, bl, null);
    }

    public final void zzF(String string, String string2, Bundle bundle, String string3) {
        zzfr.zzO();
        this.zzM("auto", string2, this.zzs.zzav().currentTimeMillis(), bundle, false, true, true, string3);
    }

    @WorkerThread
    final void zzG(String string, String string2, Bundle bundle) {
        ((zzgk)this).zzg();
        this.zzH(string, string2, this.zzs.zzav().currentTimeMillis(), bundle);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzH(String string, String string2, long l, Bundle bundle) {
        ((zzgk)this).zzg();
        boolean bl = this.zzd != null ? zzkw.zzag(string2) : true;
        this.zzI(string, string2, l, bundle, true, bl, true, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    protected final void zzI(String object, String string, long l, Bundle object2, boolean n, boolean bl, boolean bl2, String string2) {
        int n2;
        int n3;
        Object object32;
        block53: {
            block54: {
                Object[] objectArray;
                Preconditions.checkNotEmpty((String)object);
                Preconditions.checkNotNull((Object)object2);
                ((zzgk)zzgm2).zzg();
                ((zzf)zzgm2).zza();
                if (!((zzhw)zzgm2).zzs.zzJ()) {
                    ((zzgk)zzgm2).zzs.zzay().zzc().zza("Event not sent since app measurement is disabled");
                    return;
                }
                Object object4 = ((zze)zzgm2).zzs.zzh().zzn();
                if (object4 != null && !object4.contains(string)) {
                    ((zzgk)zzgm2).zzs.zzay().zzc().zzc("Dropping non-safelisted event. event name, origin", string, object);
                    return;
                }
                if (!((zzhw)zzgm2).zzf) {
                    GenericDeclaration genericDeclaration;
                    ((zzhw)zzgm2).zzf = true;
                    boolean bl3 = ((zzhw)zzgm2).zzs.zzN();
                    if (bl3) {
                        genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                        genericDeclaration = Class.forName((String)((Object)genericDeclaration));
                    }
                    genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                    objectArray = ((zzgk)zzgm2).zzs.zzau();
                    genericDeclaration = Class.forName((String)((Object)genericDeclaration), true, objectArray.getClassLoader());
                    try {
                        objectArray = new Class[]{Context.class};
                        genericDeclaration = ((Class)genericDeclaration).getDeclaredMethod("initialize", (Class<?>[])objectArray);
                        objectArray = new Object[1];
                        object32 = ((zzgk)zzgm2).zzs.zzau();
                        objectArray[0] = object32;
                        ((Method)genericDeclaration).invoke(null, objectArray);
                    }
                    catch (Exception exception) {
                        try {
                            ((zzgk)zzgm2).zzs.zzay().zzk().zzb("Failed to invoke Tag Manager's initialize() method", exception);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ((zzgk)zzgm2).zzs.zzay().zzi().zza("Tag Manager is not found and thus will not be used");
                        }
                    }
                }
                if ("_cmp".equals(string) && object2.containsKey("gclid")) {
                    ((zzgk)zzgm2).zzs.zzaw();
                    ((zzhw)zzgm2).zzZ("auto", "_lgclid", object2.getString("gclid"), ((zzgk)zzgm2).zzs.zzav().currentTimeMillis());
                }
                ((zzgk)zzgm2).zzs.zzaw();
                if (n != 0 && zzkw.zzal(string)) {
                    ((zzgk)zzgm2).zzs.zzv().zzK((Bundle)object2, ((zzgk)zzgm2).zzs.zzm().zzr.zza());
                }
                if (!bl2) {
                    ((zzgk)zzgm2).zzs.zzaw();
                    if (!"_iap".equals(string)) {
                        int n4;
                        object4 = ((zzhw)zzgm2).zzs.zzv();
                        if (!((zzkw)object4).zzab("event", string)) {
                            n4 = 2;
                        } else if (!((zzkw)object4).zzY("event", zzgo.zza, zzgo.zzb, string)) {
                            n4 = 13;
                        } else {
                            ((zzgk)object4).zzs.zzf();
                            n4 = !((zzkw)object4).zzX("event", 40, string) ? 2 : 0;
                        }
                        if (n4 != 0) {
                            ((zzgk)zzgm2).zzs.zzay().zze().zzb("Invalid public event name. Event will not be logged (FE)", ((zzgk)zzgm2).zzs.zzj().zzd(string));
                            object = ((zzhw)zzgm2).zzs;
                            object = ((zzfr)object).zzv();
                            ((zzhw)zzgm2).zzs.zzf();
                            object2 = ((zzkw)object).zzC(string, 40, true);
                            int n5 = string != null ? string.length() : 0;
                            ((zzhw)zzgm2).zzs.zzv().zzM(((zzhw)zzgm2).zzn, null, n4, "_ev", (String)object2, n5);
                            return;
                        }
                    }
                }
                zzpb.zzc();
                if (((zzgk)zzgm2).zzs.zzf().zzs(null, zzdu.zzat)) {
                    ((zzgk)zzgm2).zzs.zzaw();
                    objectArray = ((zze)zzgm2).zzs.zzs().zzj(false);
                    if (objectArray != null && !object2.containsKey("_sc")) {
                        objectArray.zzd = true;
                    }
                    n3 = n != 0 ? (!bl2 ? 1 : 0) : 0;
                    zzkw.zzJ((zzid)objectArray, (Bundle)object2, n3 != 0);
                } else {
                    ((zzgk)zzgm2).zzs.zzaw();
                    objectArray = ((zze)zzgm2).zzs.zzs().zzj(false);
                    if (objectArray != null && !object2.containsKey("_sc")) {
                        objectArray.zzd = true;
                    }
                    n3 = n != 0 ? (!bl2 ? 1 : 0) : 0;
                    zzkw.zzJ((zzid)objectArray, (Bundle)object2, n3 != 0);
                }
                n3 = "am".equals(object);
                boolean bl4 = zzkw.zzag(string);
                if (n == 0) break block54;
                if (((zzhw)zzgm2).zzd != null) {
                    if (!bl4) {
                        if (n3 == 0) {
                            ((zzgk)zzgm2).zzs.zzay().zzc().zzc("Passing event to registered event handler (FE)", ((zzgk)zzgm2).zzs.zzj().zzd(string), ((zzgk)zzgm2).zzs.zzj().zzb((Bundle)object2));
                            Preconditions.checkNotNull((Object)((zzhw)zzgm2).zzd);
                            ((zzhw)zzgm2).zzd.interceptEvent((String)object, string, (Bundle)object2, l);
                            return;
                        }
                        n = 1;
                        break block53;
                    } else {
                        n = n3;
                    }
                    break block53;
                } else {
                    n = n3;
                }
                break block53;
            }
            n = n3;
        }
        if (!((zzhw)zzgm2).zzs.zzM()) {
            return;
        }
        n3 = ((zzgk)zzgm2).zzs.zzv().zzh(string);
        if (n3 != 0) {
            ((zzgk)zzgm2).zzs.zzay().zze().zzb("Invalid event name. Event will not be logged (FE)", ((zzgk)zzgm2).zzs.zzj().zzd(string));
            object = ((zzgk)zzgm2).zzs;
            object = ((zzfr)object).zzv();
            ((zzgk)zzgm2).zzs.zzf();
            object2 = ((zzkw)object).zzC(string, 40, true);
            int n6 = string != null ? string.length() : 0;
            ((zzhw)zzgm2).zzs.zzv().zzM(((zzhw)zzgm2).zzn, string2, n3, "_ev", (String)object2, n6);
            return;
        }
        String[] stringArray = new String[]{"_o", "_sn", "_sc", "_si"};
        stringArray = CollectionUtils.listOf((Object[])stringArray);
        stringArray = ((zzgk)zzgm2).zzs.zzv().zzy(string2, string, (Bundle)object2, (List)stringArray, bl2);
        Preconditions.checkNotNull((Object)stringArray);
        ((zzgk)zzgm2).zzs.zzaw();
        if (((zze)zzgm2).zzs.zzs().zzj(false) != null && "_ae".equals(string)) {
            object2 = ((zze)zzgm2).zzs.zzu().zzb;
            long l2 = ((zzjy)object2).zzc.zzs.zzav().elapsedRealtime();
            long l3 = l2 - ((zzjy)object2).zzb;
            ((zzjy)object2).zzb = l2;
            if (l3 > 0L) {
                ((zzgk)zzgm2).zzs.zzv().zzH((Bundle)stringArray, l3);
            }
        }
        zznu.zzc();
        if (((zzgk)zzgm2).zzs.zzf().zzs(null, zzdu.zzac)) {
            if (!"auto".equals(object) && "_ssr".equals(string)) {
                zzkw zzkw2 = ((zzgk)zzgm2).zzs.zzv();
                object2 = stringArray.getString("_ffr");
                if (Strings.isEmptyOrWhitespace((String)object2)) {
                    object2 = null;
                } else if (object2 != null) {
                    object2 = ((String)object2).trim();
                }
                if (zzkw.zzak((String)object2, zzkw2.zzs.zzm().zzo.zza())) {
                    zzkw2.zzs.zzay().zzc().zza("Not logging duplicate session_start_with_rollout event");
                    return;
                }
                zzkw2.zzs.zzm().zzo.zzb((String)object2);
            } else if ("_ae".equals(string) && !TextUtils.isEmpty((CharSequence)(object2 = ((zzgk)zzgm2).zzs.zzv().zzs.zzm().zzo.zza()))) {
                stringArray.putString("_ffr", (String)object2);
            }
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add((Bundle)stringArray);
        if (((zzgk)zzgm2).zzs.zzm().zzj.zza() > 0L && ((zzgk)zzgm2).zzs.zzm().zzk(l) && ((zzgk)zzgm2).zzs.zzm().zzl.zzb()) {
            ((zzgk)zzgm2).zzs.zzay().zzj().zza("Current session is expired, remove the session number, ID, and engagement time");
            ((zzhw)zzgm2).zzZ("auto", "_sid", null, ((zzgk)zzgm2).zzs.zzav().currentTimeMillis());
            ((zzhw)zzgm2).zzZ("auto", "_sno", null, ((zzgk)zzgm2).zzs.zzav().currentTimeMillis());
            ((zzhw)zzgm2).zzZ("auto", "_se", null, ((zzgk)zzgm2).zzs.zzav().currentTimeMillis());
        }
        if (stringArray.getLong("extend_session", 0L) == 1L) {
            ((zzgk)zzgm2).zzs.zzay().zzj().zza("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
            ((zzhw)zzgm2).zzs.zzu().zza.zzb(l, true);
        }
        object32 = new ArrayList(stringArray.keySet());
        Collections.sort(object32);
        int n7 = object32.size();
        for (n2 = 0; n2 < n7; ++n2) {
            String string3 = (String)object32.get(n2);
            if (string3 == null) continue;
            ((zzgk)zzgm2).zzs.zzv();
            Object object5 = stringArray.get(string3);
            if (object5 instanceof Bundle) {
                Bundle[] bundleArray = new Bundle[]{(Bundle)object5};
                object5 = bundleArray;
            } else if (object5 instanceof Parcelable[]) {
                object5 = (Parcelable[])object5;
                object5 = (Bundle[])Arrays.copyOf(object5, ((Parcelable[])object5).length, Bundle[].class);
            } else if (object5 instanceof ArrayList) {
                object5 = (ArrayList)object5;
                object5 = ((ArrayList)object5).toArray(new Bundle[((ArrayList)object5).size()]);
            } else {
                object5 = null;
            }
            if (object5 == null) continue;
            stringArray.putParcelableArray(string3, (Parcelable[])object5);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            stringArray = (Bundle)arrayList.get(n2);
            String string4 = n2 != 0 ? "_ep" : string;
            stringArray.putString("_o", (String)object);
            if (bl) {
                stringArray = ((zzgk)zzgm2).zzs.zzv().zzt((Bundle)stringArray);
            }
            zzas zzas2 = new zzas((Bundle)stringArray);
            object32 = new zzau(string4, zzas2, (String)object, l);
            ((zze)zzgm2).zzs.zzt().zzA((zzau)((Object)object32), string2);
            if (n != 0) continue;
            for (Object object32 : ((zzhw)zzgm2).zze) {
                object32 = (zzgs)object32;
                zzas2 = new Bundle((Bundle)stringArray);
                object32.onEvent((String)object, string, (Bundle)zzas2, l);
            }
        }
        ((zzgk)zzgm2).zzs.zzaw();
        if (((zze)zzgm2).zzs.zzs().zzj(false) != null && "_ae".equals(string)) {
            object = ((zze)zzgm2).zzs;
            object = ((zzfr)object).zzu();
            zzgm zzgm2 = ((zzgk)zzgm2).zzs;
            zzgm2 = ((zzfr)zzgm2).zzav();
            l = zzgm2.elapsedRealtime();
            ((zzka)object).zzb.zzd(true, true, l);
            return;
        }
    }

    public final void zzJ(zzgs zzgs2) {
        this.zza();
        Preconditions.checkNotNull((Object)zzgs2);
        if (!this.zze.add(zzgs2)) {
            this.zzs.zzay().zzk().zza("OnEventListener already registered");
            return;
        }
    }

    public final void zzK(long l) {
        this.zzg.set(null);
        zzgm zzgm2 = this.zzs;
        zzgm2 = ((zzfr)zzgm2).zzaz();
        zzhe zzhe2 = new zzhe(this, l);
        ((zzfo)zzgm2).zzp(zzhe2);
    }

    final void zzL(long l, boolean bl) {
        ((zzgk)this).zzg();
        this.zza();
        this.zzs.zzay().zzc().zza("Resetting analytics data (FE)");
        zzka zzka2 = this.zzs.zzu();
        ((zzgk)zzka2).zzg();
        zzjz cfr_ignored_0 = zzka2.zza;
        zzka2.zzb.zza();
        boolean bl2 = this.zzs.zzJ();
        zzew zzew2 = this.zzs.zzm();
        zzew2.zzc.zzb(l);
        if (!TextUtils.isEmpty((CharSequence)zzew2.zzs.zzm().zzo.zza())) {
            zzew2.zzo.zzb(null);
        }
        zzod.zzc();
        if (zzew2.zzs.zzf().zzs(null, zzdu.zzad)) {
            zzew2.zzj.zzb(0L);
        }
        if (!zzew2.zzs.zzf().zzv()) {
            zzew2.zzi(bl2 ^ true);
        }
        zzew2.zzp.zzb(null);
        zzew2.zzq.zzb(0L);
        zzew2.zzr.zzb(null);
        if (bl) {
            this.zzs.zzt().zzC();
        }
        zzod.zzc();
        if (this.zzs.zzf().zzs(null, zzdu.zzad)) {
            this.zzs.zzu().zza.zza();
        }
        this.zzc = bl2 ^ true;
    }

    protected final void zzM(String string, String string2, long l, Bundle object2, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle = new Bundle((Bundle)object2);
        for (Object object2 : bundle.keySet()) {
            Bundle bundle2;
            Object object3;
            Object object4 = bundle.get((String)object2);
            if (object4 instanceof Bundle) {
                object3 = new Bundle((Bundle)object4);
                bundle.putBundle((String)object2, object3);
                continue;
            }
            if (object4 instanceof Parcelable[]) {
                object4 = (Parcelable[])object4;
                for (int i = 0; i < ((Parcelable[])object4).length; ++i) {
                    object3 = object4[i];
                    if (!(object3 instanceof Bundle)) continue;
                    bundle2 = new Bundle(object3);
                    object4[i] = bundle2;
                }
                continue;
            }
            if (!(object4 instanceof List)) continue;
            object4 = (List)object4;
            for (int i = 0; i < object4.size(); ++i) {
                object3 = object4.get(i);
                if (!(object3 instanceof Bundle)) continue;
                bundle2 = new Bundle(object3);
                object4.set(i, bundle2);
            }
        }
        object2 = this.zzs;
        object2 = ((zzfr)object2).zzaz();
        Object object5 = new zzhb(this, string, string2, l, bundle, bl, bl2, bl3, string3);
        ((zzfo)object2).zzp((Runnable)object5);
    }

    final void zzN(String string, String string2, long l, Object object) {
        zzgm zzgm2 = this.zzs;
        zzgm2 = ((zzfr)zzgm2).zzaz();
        zzhc zzhc2 = new zzhc(this, string, string2, object, l);
        ((zzfo)zzgm2).zzp(zzhc2);
    }

    final void zzO(String string) {
        this.zzg.set(string);
    }

    public final void zzP(Bundle bundle) {
        this.zzQ(bundle, this.zzs.zzav().currentTimeMillis());
    }

    public final void zzQ(Bundle object, long l) {
        Preconditions.checkNotNull((Object)object);
        Bundle bundle = new Bundle((Bundle)object);
        if (!TextUtils.isEmpty((CharSequence)bundle.getString("app_id"))) {
            this.zzs.zzay().zzk().zza("Package name should be null when calling setConditionalUserProperty");
        }
        bundle.remove("app_id");
        Preconditions.checkNotNull((Object)bundle);
        zzgn.zza((Bundle)bundle, (String)"app_id", String.class, null);
        zzgn.zza((Bundle)bundle, (String)"origin", String.class, null);
        zzgn.zza((Bundle)bundle, (String)"name", String.class, null);
        zzgn.zza((Bundle)bundle, (String)"value", Object.class, null);
        zzgn.zza((Bundle)bundle, (String)"trigger_event_name", String.class, null);
        object = 0L;
        zzgn.zza((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)object);
        zzgn.zza((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
        zzgn.zza((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
        zzgn.zza((Bundle)bundle, (String)"triggered_event_name", String.class, null);
        zzgn.zza((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
        zzgn.zza((Bundle)bundle, (String)"time_to_live", Long.class, (Object)object);
        zzgn.zza((Bundle)bundle, (String)"expired_event_name", String.class, null);
        zzgn.zza((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        bundle.putLong("creation_timestamp", l);
        object = bundle.getString("name");
        Object object2 = bundle.get("value");
        if (this.zzs.zzv().zzl((String)object) == 0) {
            if (this.zzs.zzv().zzd((String)object, object2) == 0) {
                Object object3 = this.zzs.zzv().zzB((String)object, object2);
                if (object3 == null) {
                    this.zzs.zzay().zzd().zzc("Unable to normalize conditional user property value", this.zzs.zzj().zzf((String)object), object2);
                    return;
                }
                zzgn.zzb((Bundle)bundle, (Object)object3);
                long l2 = bundle.getLong("trigger_timeout");
                if (!TextUtils.isEmpty((CharSequence)bundle.getString("trigger_event_name"))) {
                    this.zzs.zzf();
                    if (l2 > 15552000000L || l2 < 1L) {
                        this.zzs.zzay().zzd().zzc("Invalid conditional user property timeout", this.zzs.zzj().zzf((String)object), l2);
                        return;
                    }
                }
                long l3 = bundle.getLong("time_to_live");
                this.zzs.zzf();
                if (l3 > 15552000000L || l3 < 1L) {
                    this.zzs.zzay().zzd().zzc("Invalid conditional user property time to live", this.zzs.zzj().zzf((String)object), l3);
                    return;
                }
                object = this.zzs;
                object = ((zzfr)object).zzaz();
                object2 = new zzhf(this, bundle);
                ((zzfo)object).zzp((Runnable)object2);
                return;
            }
            this.zzs.zzay().zzd().zzc("Invalid conditional user property value", this.zzs.zzj().zzf((String)object), object2);
            return;
        }
        this.zzs.zzay().zzd().zzb("Invalid conditional user property name", this.zzs.zzj().zzf((String)object));
    }

    public final void zzR(Bundle bundle, int n, long l) {
        this.zza();
        String string = zzah.zzg(bundle);
        if (string != null) {
            this.zzs.zzay().zzl().zzb("Ignoring invalid consent setting", string);
            this.zzs.zzay().zzl().zza("Valid consent values are 'granted', 'denied'");
        }
        this.zzS(zzah.zza(bundle), n, l);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzS(zzah zzah2, int n, long l) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        block9: {
            this.zza();
            if (n != -10 && zzah2.zze() == null && zzah2.zzf() == null) {
                this.zzs.zzay().zzl().zza("Discarding empty consent settings");
                return;
            }
            Object object = this.zzh;
            // MONITORENTER : object
            boolean bl4 = zzah.zzj(n, this.zzj);
            if (bl4) {
                zzah zzah3;
                bl3 = zzah2.zzk(this.zzi);
                bl4 = zzah2.zzi(zzag.zzb);
                bl4 = bl4 ? !(bl4 = (zzah3 = this.zzi).zzi(zzag.zzb)) : false;
                this.zzi = zzah2 = zzah2.zzd(this.zzi);
                this.zzj = n;
                bl2 = bl4;
                bl = true;
                // MONITOREXIT : object
                break block9;
            }
            bl3 = false;
            bl2 = false;
            bl = false;
            {
                catch (Throwable throwable) {}
                {
                    // MONITOREXIT : object
                    throw throwable;
                }
            }
        }
        if (!bl) {
            this.zzs.zzay().zzi().zzb("Ignoring lower-priority consent settings, proposed settings", zzah2);
            return;
        }
        long l2 = this.zzk.getAndIncrement();
        if (bl3) {
            this.zzg.set(null);
            zzgm zzgm2 = this.zzs;
            zzgm2 = ((zzfr)zzgm2).zzaz();
            zzhq zzhq2 = new zzhq(this, zzah2, l, n, l2, bl2);
            ((zzfo)zzgm2).zzq(zzhq2);
            return;
        }
        if (n != 30 && n != -10) {
            zzgm zzgm3 = this.zzs;
            zzgm3 = ((zzfr)zzgm3).zzaz();
            zzhs zzhs2 = new zzhs(this, zzah2, n, l2, bl2);
            ((zzfo)zzgm3).zzp(zzhs2);
            return;
        }
        zzgm zzgm4 = this.zzs;
        zzgm4 = ((zzfr)zzgm4).zzaz();
        zzhr zzhr2 = new zzhr(this, zzah2, n, l2, bl2);
        ((zzfo)zzgm4).zzq(zzhr2);
    }

    public final void zzT(Bundle bundle, long l) {
        zznx.zzc();
        if (this.zzs.zzf().zzs(null, zzdu.zzal)) {
            zzgm zzgm2 = this.zzs;
            zzgm2 = ((zzfr)zzgm2).zzaz();
            zzgx zzgx2 = new zzgx(this, bundle, l);
            ((zzfo)zzgm2).zzq(zzgx2);
            return;
        }
        this.zzab(bundle, l);
    }

    @WorkerThread
    private final void zzab(Bundle bundle, long l) {
        if (TextUtils.isEmpty((CharSequence)this.zzs.zzh().zzm())) {
            this.zzR(bundle, 0, l);
            return;
        }
        this.zzs.zzay().zzl().zza("Using developer consent only; google app id found");
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zzU(zzgr zzgr2) {
        zzgr zzgr3;
        ((zzgk)this).zzg();
        this.zza();
        if (zzgr2 != null && zzgr2 != (zzgr3 = this.zzd)) {
            boolean bl = zzgr3 == null;
            Preconditions.checkState((boolean)bl, (Object)"EventInterceptor already set.");
        }
        this.zzd = zzgr2;
    }

    public final void zzV(Boolean bl) {
        this.zza();
        zzgm zzgm2 = this.zzs;
        zzgm2 = ((zzfr)zzgm2).zzaz();
        zzhp zzhp2 = new zzhp(this, bl);
        ((zzfo)zzgm2).zzp(zzhp2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzW(zzah zzah2) {
        ((zzgk)this).zzg();
        boolean bl = !zzah2.zzi(zzag.zzb) || !zzah2.zzi(zzag.zza) ? this.zzs.zzt().zzM() : true;
        if (bl != this.zzs.zzK()) {
            this.zzs.zzG(bl);
            Object object = this.zzs.zzm();
            zzfr cfr_ignored_0 = ((zzgk)object).zzs;
            ((zzgk)object).zzg();
            object = ((zzew)object).zza().contains("measurement_enabled_from_api") ? Boolean.valueOf(((zzew)object).zza().getBoolean("measurement_enabled_from_api", true)) : null;
            if (!bl || object == null || ((Boolean)object).booleanValue()) {
                this.zzac(bl, false);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzac(Boolean bl, boolean bl2) {
        ((zzgk)this).zzg();
        this.zza();
        this.zzs.zzay().zzc().zzb("Setting app measurement enabled (FE)", bl);
        this.zzs.zzm().zzh(bl);
        if (bl2) {
            zzew zzew2 = this.zzs.zzm();
            zzfr cfr_ignored_0 = zzew2.zzs;
            zzew2.zzg();
            zzew2 = zzew2.zza().edit();
            if (bl != null) {
                zzew2.putBoolean("measurement_enabled_from_api", bl);
            } else {
                zzew2.remove("measurement_enabled_from_api");
            }
            zzew2.apply();
        }
        if (this.zzs.zzK() || bl != null && !bl.booleanValue()) {
            this.zzad();
            return;
        }
    }

    public final void zzX(String string, String string2, Object object, boolean bl) {
        this.zzY("auto", "_ldl", object, true, this.zzs.zzav().currentTimeMillis());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void zzY(String object, String string, Object object2, boolean bl, long l) {
        void var5_15;
        void var4_8;
        if (object == null) {
            object = "app";
        }
        if (bl) {
            int n = this.zzs.zzv().zzl(string);
        } else {
            zzkw zzkw2 = this.zzs.zzv();
            if (!zzkw2.zzab("user property", string)) {
                int n = 6;
            } else if (!zzkw2.zzY("user property", zzgq.zza, null, string)) {
                int n = 15;
            } else {
                zzkw2.zzs.zzf();
                if (!zzkw2.zzX("user property", 24, string)) {
                    int n = 6;
                } else {
                    boolean bl2 = false;
                }
            }
        }
        if (var4_8 != false) {
            object = this.zzs;
            object = ((zzfr)object).zzv();
            this.zzs.zzf();
            object2 = ((zzkw)object).zzC(string, 24, true);
            int n = string != null ? string.length() : 0;
            this.zzs.zzv().zzM(this.zzn, null, (int)var4_8, "_ev", (String)object2, n);
            return;
        }
        if (object2 == null) {
            this.zzN((String)object, string, (long)var5_15, null);
            return;
        }
        int n = this.zzs.zzv().zzd(string, object2);
        if (n != 0) {
            object = this.zzs;
            object = ((zzfr)object).zzv();
            this.zzs.zzf();
            string = ((zzkw)object).zzC(string, 24, true);
            int n2 = object2 instanceof String || object2 instanceof CharSequence ? object2.toString().length() : 0;
            this.zzs.zzv().zzM(this.zzn, null, n, "_ev", string, n2);
            return;
        }
        object2 = this.zzs.zzv().zzB(string, object2);
        if (object2 != null) {
            this.zzN((String)object, string, (long)var5_15, object2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzZ(String string, String string2, Object object, long l) {
        Object object2;
        block6: {
            block7: {
                Preconditions.checkNotEmpty((String)string);
                Preconditions.checkNotEmpty((String)string2);
                ((zzgk)this).zzg();
                this.zza();
                if (!"allow_personalized_ads".equals(string2)) break block7;
                if (object instanceof String && !TextUtils.isEmpty((CharSequence)(object2 = (String)object))) {
                    long l2 = true != "false".equals(((String)object2).toLowerCase(Locale.ENGLISH)) ? 0L : 1L;
                    object2 = l2;
                    object = this.zzs.zzm().zzh;
                    string2 = (Long)object2 == 1L ? "true" : "false";
                    ((zzev)object).zzb(string2);
                    string2 = "_npa";
                    break block6;
                } else if (object == null) {
                    this.zzs.zzm().zzh.zzb("unset");
                    string2 = "_npa";
                    object2 = object;
                    break block6;
                } else {
                    object2 = object;
                }
                break block6;
            }
            object2 = object;
        }
        if (!this.zzs.zzJ()) {
            this.zzs.zzay().zzj().zza("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzs.zzM()) {
            return;
        }
        object = new zzks(string2, l, object2, string);
        this.zzs.zzt().zzK((zzks)((Object)object));
    }

    public final void zzaa(zzgs zzgs2) {
        this.zza();
        Preconditions.checkNotNull((Object)zzgs2);
        if (!this.zze.remove(zzgs2)) {
            this.zzs.zzay().zzk().zza("OnEventListener had not been registered");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzad() {
        ((zzgk)this).zzg();
        Object object = this.zzs.zzm().zzh.zza();
        if (object != null) {
            if ("unset".equals(object)) {
                this.zzZ("app", "_npa", null, this.zzs.zzav().currentTimeMillis());
            } else {
                long l = true != "true".equals(object) ? 0L : 1L;
                this.zzZ("app", "_npa", l, this.zzs.zzav().currentTimeMillis());
            }
        }
        if (this.zzs.zzJ() && this.zzc) {
            this.zzs.zzay().zzc().zza("Recording app launch after enabling measurement for the first time (FE)");
            this.zzy();
            zzod.zzc();
            if (this.zzs.zzf().zzs(null, zzdu.zzad)) {
                this.zzs.zzu().zza.zza();
            }
            object = this.zzs;
            object = ((zzfr)object).zzaz();
            zzgz zzgz2 = new zzgz(this);
            ((zzfo)object).zzp(zzgz2);
            return;
        }
        this.zzs.zzay().zzc().zza("Updating Scion state (FE)");
        this.zzs.zzt().zzI();
    }

    @Override
    protected final boolean zzf() {
        return false;
    }
}

