/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzdu;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzkv;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzkw
extends zzgl {
    private static final String[] zzb;
    private static final String[] zzc;
    private SecureRandom zzd;
    private final AtomicLong zze;
    private int zzf;
    private Integer zzg = null;
    public static final /* synthetic */ int zza;

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final int zza(String object, String string, String string2, Object object2, Bundle bundle, List list, boolean bl, boolean bl2) {
        int n;
        int n2;
        block17: {
            block18: {
                block21: {
                    block22: {
                        block23: {
                            int n3;
                            boolean bl3;
                            block20: {
                                block19: {
                                    ((zzgk)object3).zzg();
                                    if (!((zzkw)object3).zzae(object2)) break block18;
                                    if (!bl2) return 21;
                                    if (!zzkw.zzas(string2, zzgp.zzc)) {
                                        return 20;
                                    }
                                    zzjk zzjk2 = ((zzkw)object3).zzs.zzt();
                                    ((zzgk)zzjk2).zzg();
                                    zzjk2.zza();
                                    if (zzjk2.zzN() && zzjk2.zzs.zzv().zzm() < 200900) {
                                        return 25;
                                    }
                                    ((zzgk)object3).zzs.zzf();
                                    bl3 = object2 instanceof Parcelable[];
                                    if (!bl3) break block19;
                                    n3 = ((Parcelable[])object2).length;
                                    break block20;
                                }
                                if (!(object2 instanceof ArrayList)) break block21;
                                n3 = ((ArrayList)object2).size();
                            }
                            if (n3 <= 200) break block22;
                            ((zzgk)object3).zzs.zzay().zzl().zzd("Parameter array is too long; discarded. Value kind, name, array length", "param", string2, n3);
                            ((zzgk)object3).zzs.zzf();
                            if (!bl3) break block23;
                            Parcelable[] parcelableArray = (Parcelable[])object2;
                            if (parcelableArray.length > 200) {
                                bundle.putParcelableArray(string2, Arrays.copyOf(parcelableArray, 200));
                                n2 = 17;
                                break block17;
                            } else {
                                n2 = 17;
                            }
                            break block17;
                        }
                        if (object2 instanceof ArrayList) {
                            ArrayList arrayList = (ArrayList)object2;
                            if (arrayList.size() > 200) {
                                ArrayList arrayList2 = new ArrayList(arrayList.subList(0, 200));
                                bundle.putParcelableArrayList(string2, arrayList2);
                                n2 = 17;
                                break block17;
                            } else {
                                n2 = 17;
                            }
                            break block17;
                        } else {
                            n2 = 17;
                        }
                        break block17;
                    }
                    n2 = 0;
                    break block17;
                }
                n2 = 0;
                break block17;
            }
            n2 = 0;
        }
        if (((zzgk)object3).zzs.zzf().zzs((String)object, zzdu.zzR) && zzkw.zzag(string) || zzkw.zzag(string2)) {
            ((zzgk)object3).zzs.zzf();
            n = 256;
        } else {
            ((zzgk)object3).zzs.zzf();
            n = 100;
        }
        if (((zzkw)object3).zzZ("param", string2, n, object2)) {
            return n2;
        }
        if (!bl2) return 4;
        if (object2 instanceof Bundle) {
            ((zzkw)object3).zzV((String)object, string, string2, (Bundle)object2, list, bl);
            return n2;
        }
        if (object2 instanceof Parcelable[]) {
            Parcelable[] parcelableArray = (Parcelable[])object2;
            n = parcelableArray.length;
            int n4 = 0;
            while (n4 < n) {
                Parcelable parcelable = parcelableArray[n4];
                if (!(parcelable instanceof Bundle)) {
                    ((zzgk)object3).zzs.zzay().zzl().zzc("All Parcelable[] elements must be of type Bundle. Value type, name", parcelable.getClass(), string2);
                    return 4;
                }
                ((zzkw)object3).zzV((String)object, string, string2, (Bundle)parcelable, list, bl);
                ++n4;
            }
            return n2;
        }
        if (!(object2 instanceof ArrayList)) return 4;
        ArrayList arrayList = (ArrayList)object2;
        n = arrayList.size();
        int n5 = 0;
        while (n5 < n) {
            Object e = arrayList.get(n5);
            if (!(e instanceof Bundle)) {
                object = ((zzgk)object3).zzs.zzay().zzl();
                Object object3 = e != null ? e.getClass() : "null";
                ((zzef)object).zzc("All ArrayList elements must be of type Bundle. Value type, name", object3, string2);
                return 4;
            }
            ((zzkw)object3).zzV((String)object, string, string2, (Bundle)e, list, bl);
            ++n5;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    final int zzd(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zzZ("user property referrer", string, this.zzaq(string), object) : this.zzZ("user property", string, this.zzaq(string), object);
        if (bl) {
            return 0;
        }
        return 7;
    }

    final int zzh(String string) {
        if (!this.zzaa("event", string)) {
            return 2;
        }
        if (!this.zzY("event", zzgo.zza, zzgo.zzb, string)) {
            return 13;
        }
        this.zzs.zzf();
        if (!this.zzX("event", 40, string)) {
            return 2;
        }
        return 0;
    }

    final int zzi(String string) {
        if (!this.zzaa("event param", string)) {
            return 3;
        }
        if (!this.zzY("event param", null, null, string)) {
            return 14;
        }
        this.zzs.zzf();
        if (!this.zzX("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final int zzj(String string) {
        if (!this.zzab("event param", string)) {
            return 3;
        }
        if (!this.zzY("event param", null, null, string)) {
            return 14;
        }
        this.zzs.zzf();
        if (!this.zzX("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final int zzl(String string) {
        if (!this.zzaa("user property", string)) {
            return 6;
        }
        if (!this.zzY("user property", zzgq.zza, null, string)) {
            return 15;
        }
        this.zzs.zzf();
        if (!this.zzX("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    @EnsuresNonNull(value={"this.apkVersion"})
    public final int zzm() {
        if (this.zzg == null) {
            this.zzg = GoogleApiAvailabilityLight.getInstance().getApkVersion(this.zzs.zzau()) / 1000;
        }
        return this.zzg;
    }

    private final int zzaq(String string) {
        if ("_ldl".equals(string)) {
            this.zzs.zzf();
            return 2048;
        }
        if ("_id".equals(string)) {
            this.zzs.zzf();
            return 256;
        }
        if ("_lgclid".equals(string)) {
            this.zzs.zzf();
            return 100;
        }
        this.zzs.zzf();
        return 36;
    }

    public final int zzo(int n) {
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(this.zzs.zzau(), 12451000);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static long zzp(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        int n = byArray.length;
        int n2 = n > 0 ? 1 : 0;
        Preconditions.checkState(n2 != 0);
        long l = 0L;
        n2 = 0;
        for (int i = n + -1; i >= 0 && i >= byArray.length + -8; n2 += 8, --i) {
            long l2 = l + (((long)byArray[i] & 0xFFL) << n2);
            l = l2;
        }
        return l;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzq() {
        if (this.zze.get() == 0L) {
            AtomicLong atomicLong = this.zze;
            synchronized (atomicLong) {
                long l = System.nanoTime();
                Clock clock = this.zzs.zzav();
                Random random = new Random(l ^ clock.currentTimeMillis());
                long l2 = random.nextLong();
                int n = this.zzf;
                this.zzf = ++n;
                return l2 + (long)n;
            }
        }
        AtomicLong atomicLong = this.zze;
        synchronized (atomicLong) {
            this.zze.compareAndSet(-1L, 1L);
            return this.zze.getAndIncrement();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final long zzr(long l, long l2) {
        return (l + l2 * 60000L) / 86400000L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Bundle zzs(Uri uri, boolean bl) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        block22: {
            if (uri == null) {
                return null;
            }
            try {
                Object object;
                boolean bl2 = uri.isHierarchical();
                if (bl2) {
                    string5 = uri.getQueryParameter("utm_campaign");
                    string4 = uri.getQueryParameter("utm_source");
                    string3 = uri.getQueryParameter("utm_medium");
                    string2 = uri.getQueryParameter("gclid");
                    if (bl) {
                        string = uri.getQueryParameter("utm_id");
                        String string6 = uri.getQueryParameter("dclid");
                        object = string5;
                        string5 = string4;
                        string4 = string3;
                        string3 = string2;
                        string2 = string;
                        string = string6;
                        break block22;
                    } else {
                        object = string5;
                        string5 = string4;
                        string4 = string3;
                        string3 = string2;
                        string2 = null;
                        string = null;
                    }
                    break block22;
                }
                object = null;
                string5 = null;
                string4 = null;
                string3 = null;
                string2 = null;
                string = null;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                ((zzgk)object).zzs.zzay().zzk().zzb("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
                return null;
            }
        }
        if (!(TextUtils.isEmpty((CharSequence)object) && TextUtils.isEmpty((CharSequence)string5) && TextUtils.isEmpty((CharSequence)string4) && TextUtils.isEmpty((CharSequence)string3) && (!bl || TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string)))) {
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)object)) {
                bundle.putString("campaign", (String)object);
            }
            if (!TextUtils.isEmpty((CharSequence)string5)) {
                bundle.putString("source", string5);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                bundle.putString("medium", string4);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                bundle.putString("gclid", string3);
            }
            if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("utm_term")))) {
                bundle.putString("term", (String)object);
            }
            if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("utm_content")))) {
                bundle.putString("content", (String)object);
            }
            if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("aclid")))) {
                bundle.putString("aclid", (String)object);
            }
            if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("cp1")))) {
                bundle.putString("cp1", (String)object);
            }
            if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("anid")))) {
                bundle.putString("anid", (String)object);
            }
            if (bl) {
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    bundle.putString("campaign_id", string2);
                }
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    bundle.putString("dclid", string);
                }
                if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("utm_source_platform")))) {
                    bundle.putString("source_platform", (String)object);
                }
                if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("utm_creative_format")))) {
                    bundle.putString("creative_format", (String)object);
                }
                if (!TextUtils.isEmpty((CharSequence)(object = uri.getQueryParameter("utm_marketing_tactic")))) {
                    bundle.putString("marketing_tactic", (String)object);
                }
            }
            return bundle;
        }
        return null;
    }

    final Bundle zzt(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zzA(string, bundle.get(string));
                if (object == null) {
                    this.zzs.zzay().zzl().zzb("Param value can't be null", this.zzs.zzj().zze(string));
                    continue;
                }
                this.zzN(bundle2, string, object);
            }
        }
        return bundle2;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Bundle zzy(String string, String string2, Bundle bundle, List list, boolean bl) {
        boolean bl2 = zzkw.zzas(string2, zzgo.zzd);
        if (bundle == null) {
            return null;
        }
        Bundle bundle2 = new Bundle(bundle);
        int n = this.zzs.zzf().zzc();
        TreeSet treeSet = new TreeSet(bundle.keySet());
        Iterator iterator = treeSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string3;
            int n3;
            String string4 = (String)iterator.next();
            if (list == null || !list.contains(string4)) {
                n3 = !bl ? this.zzj(string4) : 0;
                if (n3 == 0) {
                    n3 = this.zzi(string4);
                }
            } else {
                n3 = 0;
            }
            if (n3 != 0) {
                String string5 = n3 == 3 ? string4 : null;
                this.zzI(bundle2, n3, string4, string4, string5);
                bundle2.remove(string4);
                continue;
            }
            int n4 = this.zza(string, string2, string4, bundle.get(string4), bundle2, list, bl, bl2);
            if (n4 == 17) {
                this.zzI(bundle2, 17, string4, string4, false);
            } else if (n4 != 0 && !"_ev".equals(string4)) {
                string3 = n4 == 21 ? string2 : string4;
            }
            if (!zzkw.zzah(string4) || ++n2 <= n) continue;
            StringBuilder stringBuilder = new StringBuilder(48);
            stringBuilder.append("Event can't contain more than ");
            stringBuilder.append(n);
            stringBuilder.append(" params");
            this.zzs.zzay().zze().zzc(stringBuilder.toString(), this.zzs.zzj().zzd(string2), this.zzs.zzj().zzb(bundle));
            zzkw.zzao(bundle2, 5);
            bundle2.remove(string4);
            continue;
            this.zzI(bundle2, n4, string3, string4, bundle.get(string4));
            bundle2.remove(string4);
        }
        return bundle2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final zzau zzz(String object, String string, Bundle object2, String string2, long l, boolean bl, boolean bl2) {
        void var5_11;
        void var7_12;
        void var4_10;
        void var3_7;
        void var3_5;
        Object object3;
        void var2_4;
        if (TextUtils.isEmpty((CharSequence)var2_4)) {
            return null;
        }
        if (((zzkw)object3).zzh((String)var2_4) != 0) {
            ((zzgk)object3).zzs.zzay().zzd().zzb("Invalid conditional property event name", ((zzgk)object3).zzs.zzj().zzf((String)var2_4));
            object3 = new IllegalArgumentException();
            throw object3;
        }
        if (var3_5 != null) {
            Bundle bundle;
            Bundle bundle2 = bundle = new Bundle((Bundle)var3_5);
        } else {
            Bundle bundle = new Bundle();
        }
        var3_7.putString("_o", (String)var4_10);
        Bundle bundle = ((zzkw)object3).zzy((String)object, (String)var2_4, (Bundle)var3_7, CollectionUtils.listOf((Object)"_o"), true);
        object3 = var7_12 != false ? ((zzkw)object3).zzt(bundle) : bundle;
        Preconditions.checkNotNull((Object)object3);
        zzas zzas2 = new zzas((Bundle)object3);
        return new zzau((String)var2_4, zzas2, (String)var4_10, (long)var5_11);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Object zzA(String string, Object object) {
        int n;
        if ("_ev".equals(string)) {
            this.zzs.zzf();
            return this.zzar(256, object, true, true);
        }
        if (zzkw.zzag(string)) {
            this.zzs.zzf();
            n = 256;
            return this.zzar(n, object, false, true);
        }
        this.zzs.zzf();
        n = 100;
        return this.zzar(n, object, false, true);
    }

    final Object zzB(String string, Object object) {
        if ("_ldl".equals(string)) {
            return this.zzar(this.zzaq(string), object, true, false);
        }
        return this.zzar(this.zzaq(string), object, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object zzar(int n, Object parcelableArray, boolean bl, boolean n2) {
        if (parcelableArray == null) {
            return null;
        }
        if (parcelableArray instanceof Long || parcelableArray instanceof Double) {
            return parcelableArray;
        }
        if (parcelableArray instanceof Integer) {
            return (long)((Integer)parcelableArray).intValue();
        }
        if (parcelableArray instanceof Byte) {
            return (long)((Byte)parcelableArray).byteValue();
        }
        if (parcelableArray instanceof Short) {
            return (long)((Short)parcelableArray).shortValue();
        }
        if (parcelableArray instanceof Boolean) {
            long l;
            if (!((Boolean)parcelableArray).booleanValue()) {
                l = 0L;
                return l;
            }
            l = 1L;
            return l;
        }
        if (parcelableArray instanceof Float) {
            return ((Float)parcelableArray).doubleValue();
        }
        if (parcelableArray instanceof String || parcelableArray instanceof Character || parcelableArray instanceof CharSequence) {
            return this.zzC(parcelableArray.toString(), n, bl);
        }
        if (n2 == 0 || !(parcelableArray instanceof Bundle[]) && !(parcelableArray instanceof Parcelable[])) return null;
        ArrayList<Parcelable> arrayList = new ArrayList<Parcelable>();
        for (Parcelable parcelable : parcelableArray) {
            if (!(parcelable instanceof Bundle) || (parcelable = this.zzt((Bundle)parcelable)).isEmpty()) continue;
            arrayList.add(parcelable);
        }
        return arrayList.toArray(new Bundle[arrayList.size()]);
    }

    public final String zzC(String string, int n, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.codePointCount(0, string.length()) > n) {
            if (bl) {
                return String.valueOf(string.substring(0, string.offsetByCodePoints(0, n))).concat("...");
            }
            return null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final URL zzD(long l, String string, String object, long l2) {
        Object object2;
        block4: {
            Preconditions.checkNotEmpty((String)object);
            Preconditions.checkNotEmpty((String)string);
            Object object3 = new Object[4];
            Object[] objectArray = new Object[]{55005L, this.zzm()};
            object3[0] = String.format("v%s.%s", objectArray);
            object3[1] = object;
            object3[2] = string;
            object3[3] = l2;
            object = String.format("https://www.googleadservices.com/pagead/conversion/app/deeplink?id_type=adid&sdk_version=%s&rdid=%s&bundleid=%s&retry=%s", (Object[])object3);
            object3 = this.zzs.zzf();
            boolean bl = string.equals(((zzaf)object3).zzm());
            if (!bl) break block4;
            try {
                object2 = ((String)object).concat("&ddl_test=1");
                return new URL((String)object2);
            }
            catch (IllegalArgumentException | MalformedURLException exception) {
                this.zzs.zzay().zzd().zzb("Failed to create BOW URL for Deferred Deep Link. exception", exception.getMessage());
                return null;
            }
        }
        object2 = object;
        return new URL((String)object2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MessageDigest zzE() {
        int n = 0;
        while (n < 2) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (messageDigest != null) {
                    return messageDigest;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            ++n;
        }
        return null;
    }

    @EnsuresNonNull(value={"this.secureRandom"})
    @WorkerThread
    final SecureRandom zzF() {
        this.zzg();
        if (this.zzd == null) {
            SecureRandom secureRandom;
            this.zzd = secureRandom = new SecureRandom();
        }
        return this.zzd;
    }

    public static ArrayList zzG(List object) {
        if (object == null) {
            object = new ArrayList(0);
            return object;
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            AbstractSafeParcelable abstractSafeParcelable = (zzab)((Object)object.next());
            Bundle bundle = new Bundle();
            bundle.putString("app_id", abstractSafeParcelable.zza);
            bundle.putString("origin", abstractSafeParcelable.zzb);
            bundle.putLong("creation_timestamp", abstractSafeParcelable.zzd);
            bundle.putString("name", abstractSafeParcelable.zzc.zzb);
            zzgn.zzb((Bundle)bundle, (Object)Preconditions.checkNotNull((Object)abstractSafeParcelable.zzc.zza()));
            bundle.putBoolean("active", abstractSafeParcelable.zze);
            Object object2 = abstractSafeParcelable.zzf;
            if (object2 != null) {
                bundle.putString("trigger_event_name", (String)object2);
            }
            if ((object2 = abstractSafeParcelable.zzg) != null) {
                bundle.putString("timed_out_event_name", ((zzau)((Object)object2)).zza);
                object2 = ((zzau)((Object)object2)).zzb;
                if (object2 != null) {
                    bundle.putBundle("timed_out_event_params", ((zzas)object2).zzc());
                }
            }
            bundle.putLong("trigger_timeout", abstractSafeParcelable.zzh);
            object2 = abstractSafeParcelable.zzi;
            if (object2 != null) {
                bundle.putString("triggered_event_name", ((zzau)((Object)object2)).zza);
                object2 = ((zzau)((Object)object2)).zzb;
                if (object2 != null) {
                    bundle.putBundle("triggered_event_params", ((zzas)object2).zzc());
                }
            }
            bundle.putLong("triggered_timestamp", abstractSafeParcelable.zzc.zzc);
            bundle.putLong("time_to_live", abstractSafeParcelable.zzj);
            abstractSafeParcelable = abstractSafeParcelable.zzk;
            if (abstractSafeParcelable != null) {
                bundle.putString("expired_event_name", abstractSafeParcelable.zza);
                abstractSafeParcelable = abstractSafeParcelable.zzb;
                if (abstractSafeParcelable != null) {
                    bundle.putBundle("expired_event_params", abstractSafeParcelable.zzc());
                }
            }
            arrayList.add(bundle);
        }
        return arrayList;
    }

    static {
        String[] stringArray = new String[]{"firebase_", "google_", "ga_"};
        zzb = stringArray;
        stringArray = new String[]{"_err"};
        zzc = stringArray;
    }

    zzkw(zzfr object) {
        super((zzfr)object);
        this.zze = object = new AtomicLong(0L);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzH(Bundle bundle, long l) {
        long l2;
        long l3 = bundle.getLong("_et");
        if (l3 != 0L) {
            this.zzs.zzay().zzk().zzb("Params already contained engagement", l3);
            l2 = l3;
        } else {
            l2 = 0L;
        }
        bundle.putLong("_et", l + l2);
    }

    final void zzI(Bundle bundle, int n, String string, String string2, Object object) {
        if (zzkw.zzao(bundle, n)) {
            this.zzs.zzf();
            bundle.putString("_ev", this.zzC(string, 40, true));
            if (object != null) {
                Preconditions.checkNotNull((Object)bundle);
                if (object instanceof String || object instanceof CharSequence) {
                    bundle.putLong("_el", (long)object.toString().length());
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public static void zzJ(zzid zzid2, Bundle bundle, boolean bl) {
        if (bundle != null && zzid2 != null) {
            if (!bundle.containsKey("_sc") || bl) {
                String string = zzid2.zza;
                if (string != null) {
                    bundle.putString("_sn", string);
                } else {
                    bundle.remove("_sn");
                }
                if ((string = zzid2.zzb) != null) {
                    bundle.putString("_sc", string);
                } else {
                    bundle.remove("_sc");
                }
                bundle.putLong("_si", zzid2.zzc);
                return;
            }
            bl = false;
        }
        if (bundle != null && zzid2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
            return;
        }
    }

    final void zzK(Bundle bundle, Bundle bundle2) {
        if (bundle2 == null) {
            return;
        }
        for (String string : bundle2.keySet()) {
            if (bundle.containsKey(string)) continue;
            this.zzs.zzv().zzN(bundle, string, bundle2.get(string));
        }
    }

    final void zzL(zzei zzei2, int n) {
        TreeSet treeSet = new TreeSet(zzei2.zzd.keySet());
        Iterator iterator = treeSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!zzkw.zzah(string) || ++n2 <= n) continue;
            StringBuilder stringBuilder = new StringBuilder(48);
            stringBuilder.append("Event can't contain more than ");
            stringBuilder.append(n);
            stringBuilder.append(" params");
            this.zzs.zzay().zze().zzc(stringBuilder.toString(), this.zzs.zzj().zzd(zzei2.zza), this.zzs.zzj().zzb(zzei2.zzd));
            zzkw.zzao(zzei2.zzd, 5);
            zzei2.zzd.remove(string);
        }
    }

    final void zzM(zzkv zzkv2, String string, int n, String string2, String string3, int n2) {
        zzkw zzkw2 = new Bundle();
        zzkw.zzao((Bundle)zzkw2, n);
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            zzkw2.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            zzkw2.putLong("_el", n2);
        }
        zzkv2.zza(string, "_err", (Bundle)zzkw2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @WorkerThread
    protected final void zzaA() {
        long l;
        this.zzg();
        SecureRandom secureRandom = new SecureRandom();
        long l2 = secureRandom.nextLong();
        if (l2 == 0L) {
            long l3 = secureRandom.nextLong();
            if (l3 == 0L) {
                this.zzs.zzay().zzk().zza("Utils falling back to Random for random id");
                l = l3;
            } else {
                l = l3;
            }
        } else {
            l = l2;
        }
        this.zze.set(l);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final void zzN(Bundle object, String string, Object object2) {
        void var1_3;
        void var2_5;
        void var3_6;
        if (object == null) {
            return;
        }
        if (var3_6 instanceof Long) {
            object.putLong((String)var2_5, ((Long)var3_6).longValue());
            return;
        }
        if (var3_6 instanceof String) {
            object.putString((String)var2_5, String.valueOf(var3_6));
            return;
        }
        if (var3_6 instanceof Double) {
            object.putDouble((String)var2_5, ((Double)var3_6).doubleValue());
            return;
        }
        if (var3_6 instanceof Bundle[]) {
            object.putParcelableArray((String)var2_5, (Parcelable[])((Bundle[])var3_6));
            return;
        }
        if (var2_5 == null) {
            return;
        }
        if (var3_6 != null) {
            String string2 = var3_6.getClass().getSimpleName();
        } else {
            Object var1_4 = null;
        }
        this.zzs.zzay().zzl().zzc("Not putting event parameter. Invalid value type. name, type", this.zzs.zzj().zze((String)var2_5), var1_3);
    }

    public final void zzO(zzcf zzcf2, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("r", bl);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning boolean value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzP(zzcf zzcf2, ArrayList arrayList) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("r", arrayList);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning bundle list to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzQ(zzcf zzcf2, Bundle bundle) {
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzR(zzcf zzcf2, byte[] byArray) {
        Bundle bundle = new Bundle();
        bundle.putByteArray("r", byArray);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning byte array to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzS(zzcf zzcf2, int n) {
        Bundle bundle = new Bundle();
        bundle.putInt("r", n);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning int value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzT(zzcf zzcf2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("r", l);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning long value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzU(zzcf zzcf2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("r", string);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning string value to wrapper", (Object)remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzV(String string, String string2, String string3, Bundle bundle, List list, boolean bl) {
        if (bundle == null) {
            return;
        }
        this.zzs.zzf();
        TreeSet treeSet = new TreeSet(bundle.keySet());
        Iterator iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2;
            String string4 = (String)iterator.next();
            if (list == null || !list.contains(string4)) {
                n2 = !bl ? this.zzj(string4) : 0;
                if (n2 == 0) {
                    n2 = this.zzi(string4);
                }
            } else {
                n2 = 0;
            }
            if (n2 != 0) {
                String string5 = n2 == 3 ? string4 : null;
                this.zzI(bundle, n2, string4, string4, string5);
                bundle.remove(string4);
                continue;
            }
            if (this.zzae(bundle.get(string4))) {
                this.zzs.zzay().zzl().zzd("Nested Bundle parameters are not allowed; discarded. event name, param name, child param name", string2, string3, string4);
                n2 = 22;
            } else {
                n2 = this.zza(string, string2, string4, bundle.get(string4), bundle, list, bl, false);
            }
            if (n2 != 0 && !"_ev".equals(string4)) {
                this.zzI(bundle, n2, string4, string4, bundle.get(string4));
                bundle.remove(string4);
                continue;
            }
            if (!zzkw.zzah(string4) || zzkw.zzas(string4, zzgp.zzd) || ++n <= 0) continue;
            this.zzs.zzay().zze().zzc("Item cannot contain custom parameters", this.zzs.zzj().zzd(string2), this.zzs.zzj().zzb(bundle));
            zzkw.zzao(bundle, 23);
            bundle.remove(string4);
        }
        return;
    }

    private static boolean zzas(String string, String[] stringArray) {
        Preconditions.checkNotNull((Object)stringArray);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!zzkw.zzak(string, stringArray[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    final boolean zzW(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (zzkw.zzap(string)) return true;
            if (!this.zzs.zzL()) return false;
            this.zzs.zzay().zze().zzb("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", zzeh.zzn(string));
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (zzkw.zzap(string2)) {
                return true;
            }
            this.zzs.zzay().zze().zzb("Invalid admob_app_id. Analytics disabled.", zzeh.zzn(string2));
            return false;
        }
        if (!this.zzs.zzL()) return false;
        this.zzs.zzay().zze().zza("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
        return false;
    }

    final boolean zzX(String string, int n, String string2) {
        if (string2 == null) {
            this.zzs.zzay().zze().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.codePointCount(0, string2.length()) > n) {
            this.zzs.zzay().zze().zzd("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    final boolean zzY(String string, String[] stringArray, String[] stringArray2, String string2) {
        if (string2 == null) {
            this.zzs.zzay().zze().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        Preconditions.checkNotNull((Object)string2);
        String[] stringArray3 = zzb;
        for (int i = 0; i < 3; ++i) {
            if (!string2.startsWith(stringArray3[i])) continue;
            this.zzs.zzay().zze().zzc("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null && zzkw.zzas(string2, stringArray) && (stringArray2 == null || !zzkw.zzas(string2, stringArray2))) {
            this.zzs.zzay().zze().zzc("Name is reserved. Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zzZ(String string, String string2, int n, Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            if (((String)(object = object.toString())).codePointCount(0, ((String)object).length()) > n) {
                this.zzs.zzay().zzl().zzd("Value is too long; discarded. Value kind, name, value length", string, string2, ((String)object).length());
                return false;
            }
            return true;
        }
        return false;
    }

    final boolean zzaa(String string, String string2) {
        block8: {
            int n;
            int n2;
            block7: {
                if (string2 == null) {
                    this.zzs.zzay().zze().zzb("Name is required and can't be null. Type", string);
                    return false;
                }
                if (string2.length() == 0) {
                    this.zzs.zzay().zze().zzb("Name is required and can't be empty. Type", string);
                    return false;
                }
                n2 = string2.codePointAt(0);
                if (Character.isLetter(n2)) break block7;
                if (n2 != 95) break block8;
                n2 = 95;
            }
            int n3 = string2.length();
            for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
                n = string2.codePointAt(n2);
                if (n == 95 || Character.isLetterOrDigit(n)) {
                    continue;
                }
                this.zzs.zzay().zze().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
                return false;
            }
            return true;
        }
        this.zzs.zzay().zze().zzc("Name must start with a letter or _ (underscore). Type, name", string, string2);
        return false;
    }

    final boolean zzab(String string, String string2) {
        int n;
        if (string2 == null) {
            this.zzs.zzay().zze().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            this.zzs.zzay().zze().zzb("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            this.zzs.zzay().zze().zzc("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
            n = string2.codePointAt(n2);
            if (n == 95 || Character.isLetterOrDigit(n)) {
                continue;
            }
            this.zzs.zzay().zze().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    @WorkerThread
    final boolean zzac(String string) {
        this.zzg();
        if (Wrappers.packageManager((Context)this.zzs.zzau()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        this.zzs.zzay().zzc().zzb("Permission not granted", string);
        return false;
    }

    final boolean zzad(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        Object object = this.zzs;
        object = ((zzfr)object).zzf();
        object = ((zzaf)object).zzl();
        this.zzs.zzaw();
        return ((String)object).equals(string);
    }

    final boolean zzae(Object object) {
        return object instanceof Parcelable[] || object instanceof ArrayList || object instanceof Bundle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final boolean zzaf(Context signature, String signatureArray) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        signature = Wrappers.packageManager((Context)signature).getPackageInfo((String)signatureArray, 64);
        if (signature == null) return true;
        signatureArray = signature.signatures;
        if (signatureArray == null) return true;
        int n = signature.signatures.length;
        if (n <= 0) return true;
        try {
            signature = signature.signatures;
            signature = signature[0];
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(signature.toByteArray());
            return ((X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream)).getSubjectX500Principal().equals(x500Principal);
        }
        catch (CertificateException certificateException) {
            this.zzs.zzay().zzd().zzb("Error obtaining certificate", certificateException);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzs.zzay().zzd().zzb("Package name not found", (Object)nameNotFoundException);
            return true;
        }
    }

    static boolean zzag(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    static boolean zzah(String string) {
        Preconditions.checkNotEmpty((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean zzai(Context context) {
        block6: {
            PackageManager packageManager;
            block5: {
                Preconditions.checkNotNull((Object)context);
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            ComponentName componentName = new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver");
            context = packageManager.getReceiverInfo(componentName, 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzat(Context context, String string) {
        block6: {
            PackageManager packageManager;
            block5: {
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            ComponentName componentName = new ComponentName(context, string);
            context = packageManager.getServiceInfo(componentName, 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    static boolean zzaj(Context context, boolean bl) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzkw.zzat(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzkw.zzat(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    static boolean zzak(String string, String string2) {
        if (string != null || string2 != null) {
            if (string == null) {
                return false;
            }
            return string.equals(string2);
        }
        return true;
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    public static boolean zzal(String string) {
        return !zzc[0].equals(string);
    }

    final boolean zzam(String string, String string2, String string3, String string4) {
        boolean bl = TextUtils.isEmpty((CharSequence)string);
        boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
        if (!bl && !bl2) {
            Preconditions.checkNotNull((Object)string);
            return !string.equals(string2);
        }
        if (bl && bl2) {
            if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string4)) {
                return !string3.equals(string4);
            }
            return !TextUtils.isEmpty((CharSequence)string4);
        }
        if (!bl) {
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
        }
        return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
    }

    final byte[] zzan(Parcelable object) {
        if (object == null) {
            return null;
        }
        zzkw zzkw2 = Parcel.obtain();
        try {
            object.writeToParcel((Parcel)zzkw2, 0);
            object = zzkw2.marshall();
        }
        finally {
            zzkw2.recycle();
        }
        return object;
    }

    static final boolean zzao(Bundle bundle, int n) {
        if (bundle.getLong("_err") == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static final boolean zzap(String string) {
        Preconditions.checkNotNull((Object)string);
        return string.matches("^(1:\\d+:android:[a-f0-9]+|ca-app-pub-.*)$");
    }
}

