/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzgn;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzey
extends zzgn {
    @VisibleForTesting
    static final Pair zza;
    private SharedPreferences zzt;
    public zzew zzb;
    public final zzeu zzc;
    public final zzeu zzd;
    public final zzex zze;
    private String zzu;
    private boolean zzv;
    private long zzw;
    public final zzeu zzf;
    public final zzes zzg;
    public final zzex zzh;
    public final zzes zzi;
    public final zzeu zzj;
    public boolean zzk;
    public final zzes zzl;
    public final zzes zzm;
    public final zzeu zzn;
    public final zzex zzo;
    public final zzex zzp;
    public final zzeu zzq;
    public final zzet zzr;

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zza() {
        this.zzg();
        this.zzu();
        Preconditions.checkNotNull((Object)this.zzt);
        return this.zzt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final Pair zzb(String string) {
        this.zzg();
        long l = this.zzs.zzav().elapsedRealtime();
        String string2 = this.zzu;
        if (string2 != null && l < this.zzw) {
            return new Pair((Object)string2, (Object)this.zzv);
        }
        this.zzw = l + this.zzs.zzf().zzi(string, zzdw.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            string = this.zzs.zzau();
            string = AdvertisingIdClient.getAdvertisingIdInfo((Context)string);
            this.zzu = "";
            string2 = string.getId();
            if (string2 != null) {
                this.zzu = string2;
            }
            this.zzv = string.isLimitAdTrackingEnabled();
        }
        catch (Exception exception) {
            this.zzs.zzay().zzc().zzb("Unable to get advertising id", exception);
            this.zzu = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzu, (Object)this.zzv);
    }

    @WorkerThread
    final zzah zzc() {
        this.zzg();
        return zzah.zzb(this.zza().getString("consent_settings", "G1"));
    }

    @WorkerThread
    final Boolean zzd() {
        this.zzg();
        if (this.zza().contains("measurement_enabled")) {
            return this.zza().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    static {
        Pair pair;
        zza = pair = new Pair((Object)"", (Object)0L);
    }

    zzey(zzft object) {
        super((zzft)object);
        this.zzf = object = new zzeu(this, "session_timeout", 1800000L);
        this.zzg = object = new zzes(this, "start_new_session", true);
        this.zzj = object = new zzeu(this, "last_pause_time", 0L);
        this.zzh = object = new zzex(this, "non_personalized_ads", null);
        this.zzi = object = new zzes(this, "allow_remote_dynamite", false);
        this.zzc = object = new zzeu(this, "first_open_time", 0L);
        this.zzd = object = new zzeu(this, "app_install_time", 0L);
        this.zze = object = new zzex(this, "app_instance_id", null);
        this.zzl = object = new zzes(this, "app_backgrounded", false);
        this.zzm = object = new zzes(this, "deep_link_retrieval_complete", false);
        this.zzn = object = new zzeu(this, "deep_link_retrieval_attempts", 0L);
        this.zzo = object = new zzex(this, "firebase_feature_rollouts", null);
        this.zzp = object = new zzex(this, "deferred_attribution_cache", null);
        this.zzq = object = new zzeu(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzr = object = new zzet(this, "default_event_parameters", null);
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    @WorkerThread
    protected final void zzaA() {
        zzew zzew2;
        boolean bl;
        this.zzt = this.zzs.zzau().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzk = bl = this.zzt.getBoolean("has_been_opened", false);
        if (!bl) {
            SharedPreferences.Editor editor = this.zzt.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzs.zzf();
        this.zzb = zzew2 = new zzew(this, "health_monitor", Math.max(0L, (Long)zzdw.zzb.zza(null)), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzh(Boolean bl) {
        zzey2.zzg();
        zzey zzey2 = zzey2.zza().edit();
        if (bl != null) {
            zzey2.putBoolean("measurement_enabled", bl);
        } else {
            zzey2.remove("measurement_enabled");
        }
        zzey2.apply();
    }

    @WorkerThread
    final void zzi(boolean bl) {
        zzey2.zzg();
        zzey2.zzs.zzay().zzj().zzb("App measurement setting deferred collection", bl);
        zzey zzey2 = zzey2.zza().edit();
        zzey2.putBoolean("deferred_analytics_collection", bl);
        zzey2.apply();
    }

    @WorkerThread
    final boolean zzj() {
        zzey zzey2 = zzey2.zzt;
        if (zzey2 == null) {
            return false;
        }
        return zzey2.contains("deferred_analytics_collection");
    }

    final boolean zzk(long l) {
        return l - this.zzf.zza() > this.zzj.zza();
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    @WorkerThread
    final boolean zzl(int n) {
        return zzah.zzj(n, this.zza().getInt("consent_source", 100));
    }
}

