/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzob;
import com.google.android.gms.internal.measurement.zzoe;
import com.google.android.gms.internal.measurement.zzok;
import com.google.android.gms.internal.measurement.zzpi;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzdw;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzka;
import com.google.android.gms.measurement.internal.zzkb;
import com.google.android.gms.measurement.internal.zzkc;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzkx;
import com.google.android.gms.measurement.internal.zzky;
import com.google.android.gms.measurement.internal.zzr;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzhy
extends zzf {
    @VisibleForTesting
    protected zzhx zza;
    private zzgt zzd;
    private final Set zze;
    private boolean zzf;
    private final AtomicReference zzg;
    private final Object zzh;
    @GuardedBy(value="consentLock")
    private zzah zzi;
    @GuardedBy(value="consentLock")
    private int zzj;
    private final AtomicLong zzk;
    private long zzl;
    private int zzm;
    final zzr zzb;
    @VisibleForTesting
    protected boolean zzc;
    private final zzkx zzn;

    public final int zzh(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzs.zzf();
        return 25;
    }

    public final Boolean zzi() {
        AtomicReference atomicReference = new AtomicReference();
        zzgo zzgo2 = this.zzs;
        zzgo2 = ((zzft)zzgo2).zzaz();
        zzhj zzhj2 = new zzhj(this, atomicReference);
        return (Boolean)((zzfq)zzgo2).zzd(atomicReference, 15000L, "boolean test flag value", zzhj2);
    }

    public final Double zzj() {
        AtomicReference atomicReference = new AtomicReference();
        zzgo zzgo2 = this.zzs;
        zzgo2 = ((zzft)zzgo2).zzaz();
        zzhq zzhq2 = new zzhq(this, atomicReference);
        return (Double)((zzfq)zzgo2).zzd(atomicReference, 15000L, "double test flag value", zzhq2);
    }

    public final Integer zzl() {
        AtomicReference atomicReference = new AtomicReference();
        zzgo zzgo2 = this.zzs;
        zzgo2 = ((zzft)zzgo2).zzaz();
        zzhp zzhp2 = new zzhp(this, atomicReference);
        return (Integer)((zzfq)zzgo2).zzd(atomicReference, 15000L, "int test flag value", zzhp2);
    }

    public final Long zzm() {
        AtomicReference atomicReference = new AtomicReference();
        zzgo zzgo2 = this.zzs;
        zzgo2 = ((zzft)zzgo2).zzaz();
        zzho zzho2 = new zzho(this, atomicReference);
        return (Long)((zzfq)zzgo2).zzd(atomicReference, 15000L, "long test flag value", zzho2);
    }

    public final String zzo() {
        return (String)this.zzg.get();
    }

    public final String zzp() {
        zzif zzif2 = ((zzhy)((Object)zzif2)).zzs.zzs().zzi();
        if (zzif2 != null) {
            return zzif2.zzb;
        }
        return null;
    }

    public final String zzq() {
        zzif zzif2 = ((zzhy)((Object)zzif2)).zzs.zzs().zzi();
        if (zzif2 != null) {
            return zzif2.zza;
        }
        return null;
    }

    public final String zzr() {
        AtomicReference atomicReference = new AtomicReference();
        zzgo zzgo2 = this.zzs;
        zzgo2 = ((zzft)zzgo2).zzaz();
        zzhn zzhn2 = new zzhn(this, atomicReference);
        return (String)((zzfq)zzgo2).zzd(atomicReference, 15000L, "String test flag value", zzhn2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList zzs(String object, String string) {
        if (((zzgm)((Object)this)).zzs.zzaz().zzs()) {
            ((zzgm)((Object)this)).zzs.zzay().zzd().zza("Cannot get conditional user properties from analytics worker thread");
            return new ArrayList(0);
        }
        ((zzgm)((Object)this)).zzs.zzaw();
        if (zzaa.zza()) {
            ((zzgm)((Object)this)).zzs.zzay().zzd().zza("Cannot get conditional user properties from main thread");
            return new ArrayList(0);
        }
        AtomicReference atomicReference = new AtomicReference();
        zzgo zzgo2 = ((zzhy)((Object)this)).zzs;
        zzgo2 = ((zzft)zzgo2).zzaz();
        zzhk zzhk2 = new zzhk((zzhy)((Object)this), atomicReference, null, (String)object, string);
        ((zzfq)zzgo2).zzd(atomicReference, 5000L, "get conditional user properties", zzhk2);
        object = (List)atomicReference.get();
        if (object != null) return zzky.zzG((List)object);
        ((zzgm)((Object)this)).zzs.zzay().zzd().zzb("Timed out waiting for get conditional user properties", null);
        return new ArrayList();
    }

    public final List zzt(boolean bl) {
        this.zza();
        this.zzs.zzay().zzj().zza("Getting user properties (FE)");
        if (!this.zzs.zzaz().zzs()) {
            this.zzs.zzaw();
            if (zzaa.zza()) {
                this.zzs.zzay().zzd().zza("Cannot get all user properties from main thread");
                return Collections.emptyList();
            }
            Object object = new AtomicReference();
            zzgo zzgo2 = this.zzs;
            zzgo2 = ((zzft)zzgo2).zzaz();
            zzhf zzhf2 = new zzhf(this, (AtomicReference)object, bl);
            ((zzfq)zzgo2).zzd((AtomicReference)object, 5000L, "get user properties", zzhf2);
            object = (List)((AtomicReference)object).get();
            if (object == null) {
                this.zzs.zzay().zzd().zzb("Timed out waiting for get user properties, includeInternal", bl);
                return Collections.emptyList();
            }
            return object;
        }
        this.zzs.zzay().zzd().zza("Cannot get all user properties from analytics worker thread");
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Map zzu(String iterator, String object, boolean bl) {
        void var3_5;
        if (((zzgm)object2).zzs.zzaz().zzs()) {
            ((zzgm)object2).zzs.zzay().zzd().zza("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzgm)object2).zzs.zzaw();
        if (zzaa.zza()) {
            ((zzgm)object2).zzs.zzay().zzd().zza("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        zzgo zzgo2 = ((zzhy)object2).zzs;
        zzgo2 = ((zzft)zzgo2).zzaz();
        zzhl zzhl2 = new zzhl((zzhy)object2, atomicReference, null, (String)((Object)iterator), (String)object, (boolean)var3_5);
        ((zzfq)zzgo2).zzd(atomicReference, 5000L, "get user properties", zzhl2);
        iterator = (List)atomicReference.get();
        if (iterator == null) {
            ((zzgm)object2).zzs.zzay().zzd().zzb("Timed out waiting for handle get user properties, includeInternal", (boolean)var3_5);
            return Collections.emptyMap();
        }
        Object object2 = new ArrayMap(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            zzku zzku2 = (zzku)((Object)iterator.next());
            Object object3 = zzku2.zza();
            if (object3 == null) continue;
            object2.put(zzku2.zzb, object3);
        }
        return object2;
    }

    static /* synthetic */ void zzv(zzhy zzgo2, zzah atomicReference, int n, long l, boolean bl, boolean bl2) {
        ((zzgm)zzgo2).zzg();
        ((zzf)zzgo2).zza();
        if (l > ((zzhy)zzgo2).zzl || !zzah.zzj(((zzhy)zzgo2).zzm, n)) {
            zzey zzey2 = ((zzgm)zzgo2).zzs.zzm();
            zzft cfr_ignored_0 = zzey2.zzs;
            zzey2.zzg();
            if (zzey2.zzl(n)) {
                zzey2 = zzey2.zza().edit();
                zzey2.putString("consent_settings", ((zzah)((Object)atomicReference)).zzh());
                zzey2.putInt("consent_source", n);
                zzey2.apply();
                ((zzhy)zzgo2).zzl = l;
                ((zzhy)zzgo2).zzm = n;
                ((zze)zzgo2).zzs.zzt().zzF(bl);
                if (bl2) {
                    zzgo2 = ((zze)zzgo2).zzs;
                    zzgo2 = ((zzft)zzgo2).zzt();
                    atomicReference = new AtomicReference();
                    ((zzjm)zzgo2).zzu(atomicReference);
                    return;
                }
                return;
            }
            ((zzgm)zzgo2).zzs.zzay().zzi().zzb("Lower precedence consent source ignored, proposed source", n);
            return;
        }
        ((zzgm)zzgo2).zzs.zzay().zzi().zzb("Dropped out-of-date consent setting, proposed settings", atomicReference);
    }

    static /* bridge */ /* synthetic */ void zzw(zzhy zzhy2, Boolean bl, boolean bl2) {
        zzhy2.zzac(bl, true);
    }

    static /* bridge */ /* synthetic */ void zzx(zzhy zzhy2) {
        zzhy2.zzad();
    }

    protected zzhy(zzft zzft2) {
        super(zzft2);
        Object object = new CopyOnWriteArraySet();
        this.zze = object;
        this.zzh = object = new Object();
        this.zzc = true;
        this.zzn = object = new zzhm(this);
        object = new AtomicReference();
        this.zzg = object;
        this.zzi = object = new zzah(null, null);
        this.zzj = 100;
        this.zzl = -1L;
        this.zzm = 100;
        this.zzk = object = new AtomicLong(0L);
        this.zzb = object = new zzr(zzft2);
    }

    @WorkerThread
    public final void zzy() {
        ((zzgm)this).zzg();
        this.zza();
        if (this.zzs.zzM()) {
            Object object;
            Object object2;
            if (this.zzs.zzf().zzs(null, zzdw.zzX)) {
                object2 = this.zzs.zzf();
                ((zzgm)object2).zzs.zzaw();
                object2 = ((zzaf)object2).zzk("google_analytics_deferred_deep_link_enabled");
                if (object2 != null && ((Boolean)object2).booleanValue()) {
                    this.zzs.zzay().zzc().zza("Deferred Deep Link feature enabled.");
                    object2 = this.zzs;
                    object2 = ((zzft)object2).zzaz();
                    object = new zzgx(this);
                    ((zzfq)object2).zzp((Runnable)object);
                }
            }
            this.zzs.zzt().zzq();
            this.zzc = false;
            object2 = this.zzs.zzm();
            ((zzgm)object2).zzg();
            object = ((zzey)object2).zza().getString("previous_os_version", null);
            ((zzgm)object2).zzs.zzg().zzu();
            String string = Build.VERSION.RELEASE;
            if (!TextUtils.isEmpty((CharSequence)string) && !string.equals(object)) {
                object2 = ((zzey)object2).zza().edit();
                object2.putString("previous_os_version", string);
                object2.apply();
            }
            if (!TextUtils.isEmpty((CharSequence)object)) {
                this.zzs.zzg().zzu();
                if (!((String)object).equals(Build.VERSION.RELEASE)) {
                    object2 = new Bundle();
                    object2.putString("_po", (String)object);
                    this.zzG("auto", "_ou", (Bundle)object2);
                    return;
                }
            }
            return;
        }
    }

    public final void zzz(String object, String object2, Bundle bundle) {
        zzft zzft2 = this.zzs;
        zzft2 = zzft2.zzav();
        long l = zzft2.currentTimeMillis();
        Preconditions.checkNotEmpty((String)object);
        zzft2 = new Bundle();
        zzft2.putString("name", (String)object);
        zzft2.putLong("creation_timestamp", l);
        if (object2 != null) {
            zzft2.putString("expired_event_name", (String)object2);
            zzft2.putBundle("expired_event_params", bundle);
        }
        object = this.zzs;
        object = ((zzft)object).zzaz();
        object2 = new zzhi(this, (Bundle)zzft2);
        ((zzfq)object).zzp((Runnable)object2);
    }

    public final void zzA() {
        if (this.zzs.zzau().getApplicationContext() instanceof Application && this.zza != null) {
            ((Application)this.zzs.zzau().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zza);
            return;
        }
    }

    final /* synthetic */ void zzB(Bundle bundle, long l) {
        this.zzab(bundle, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zzC(Bundle object) {
        Object object2;
        if (object == null) {
            Object object3 = ((zzgm)object3).zzs;
            object3 = ((zzft)object3).zzm();
            object3 = ((zzey)object3).zzr;
            object = new Bundle();
            ((zzet)object3).zzb((Bundle)object);
            return;
        }
        Bundle bundle = ((zzgm)object3).zzs.zzm().zzr.zza();
        for (Object object4 : object.keySet()) {
            object2 = object.get((String)object4);
            if (!(object2 == null || object2 instanceof String || object2 instanceof Long || object2 instanceof Double)) {
                if (((zzgm)object3).zzs.zzv().zzae(object2)) {
                    ((zzgm)object3).zzs.zzv().zzM(((zzhy)object3).zzn, null, 27, null, null, 0);
                }
                ((zzgm)object3).zzs.zzay().zzl().zzc("Invalid default event parameter type. Name, value", object4, object2);
                continue;
            }
            if (zzky.zzag((String)object4)) {
                ((zzgm)object3).zzs.zzay().zzl().zzb("Invalid default event parameter name. Name", object4);
                continue;
            }
            if (object2 == null) {
                bundle.remove((String)object4);
                continue;
            }
            zzgo zzgo2 = ((zzgm)object3).zzs;
            zzgo2 = ((zzft)zzgo2).zzv();
            ((zzgm)object3).zzs.zzf();
            if (!((zzky)zzgo2).zzZ("param", (String)object4, 100, object2)) continue;
            ((zzgm)object3).zzs.zzv().zzN(bundle, (String)object4, object2);
        }
        ((zzgm)object3).zzs.zzv();
        int n = ((zzgm)object3).zzs.zzf().zzc();
        if (bundle.size() > n) {
            Object object4;
            object = new TreeSet(bundle.keySet());
            object4 = object.iterator();
            int n2 = 0;
            while (object4.hasNext()) {
                object2 = (String)object4.next();
                if (++n2 <= n) continue;
                bundle.remove((String)object2);
            }
            ((zzgm)object3).zzs.zzv().zzM(((zzhy)object3).zzn, null, 26, null, null, 0);
            ((zzgm)object3).zzs.zzay().zzl().zza("Too many default event parameters set. Discarding beyond event parameter limit");
        }
        ((zzgm)object3).zzs.zzm().zzr.zzb(bundle);
        ((zze)object3).zzs.zzt().zzH(bundle);
    }

    public final void zzD(String string, String string2, Bundle bundle) {
        this.zzE(string, string2, bundle, true, true, this.zzs.zzav().currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzE(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        if (string == null) {
            string = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (zzky.zzak(string2, "screen_view")) {
            this.zzs.zzs().zzx(bundle, l);
            return;
        }
        boolean bl3 = bl2 ? (this.zzd != null ? zzky.zzag(string2) : true) : true;
        this.zzM(string, string2, l, bundle, bl2, bl3, bl, null);
    }

    public final void zzF(String string, String string2, Bundle bundle, String string3) {
        zzft.zzO();
        this.zzM("auto", string2, this.zzs.zzav().currentTimeMillis(), bundle, false, true, true, string3);
    }

    @WorkerThread
    final void zzG(String string, String string2, Bundle bundle) {
        ((zzgm)this).zzg();
        this.zzH(string, string2, this.zzs.zzav().currentTimeMillis(), bundle);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzH(String string, String string2, long l, Bundle bundle) {
        ((zzgm)this).zzg();
        boolean bl = this.zzd != null ? zzky.zzag(string2) : true;
        this.zzI(string, string2, l, bundle, true, bl, true, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    protected final void zzI(String object, String string, long l, Bundle object2, boolean n, boolean bl, boolean bl2, String string2) {
        int n2;
        int n3;
        Object object32;
        block53: {
            block54: {
                Object[] objectArray;
                Preconditions.checkNotEmpty((String)object);
                Preconditions.checkNotNull((Object)object2);
                ((zzgm)zzgo2).zzg();
                ((zzf)zzgo2).zza();
                if (!((zzhy)zzgo2).zzs.zzJ()) {
                    ((zzgm)zzgo2).zzs.zzay().zzc().zza("Event not sent since app measurement is disabled");
                    return;
                }
                Object object4 = ((zze)zzgo2).zzs.zzh().zzn();
                if (object4 != null && !object4.contains(string)) {
                    ((zzgm)zzgo2).zzs.zzay().zzc().zzc("Dropping non-safelisted event. event name, origin", string, object);
                    return;
                }
                if (!((zzhy)zzgo2).zzf) {
                    GenericDeclaration genericDeclaration;
                    ((zzhy)zzgo2).zzf = true;
                    boolean bl3 = ((zzhy)zzgo2).zzs.zzN();
                    if (bl3) {
                        genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                        genericDeclaration = Class.forName((String)((Object)genericDeclaration));
                    }
                    genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                    objectArray = ((zzgm)zzgo2).zzs.zzau();
                    genericDeclaration = Class.forName((String)((Object)genericDeclaration), true, objectArray.getClassLoader());
                    try {
                        objectArray = new Class[]{Context.class};
                        genericDeclaration = ((Class)genericDeclaration).getDeclaredMethod("initialize", (Class<?>[])objectArray);
                        objectArray = new Object[1];
                        object32 = ((zzgm)zzgo2).zzs.zzau();
                        objectArray[0] = object32;
                        ((Method)genericDeclaration).invoke(null, objectArray);
                    }
                    catch (Exception exception) {
                        try {
                            ((zzgm)zzgo2).zzs.zzay().zzk().zzb("Failed to invoke Tag Manager's initialize() method", exception);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ((zzgm)zzgo2).zzs.zzay().zzi().zza("Tag Manager is not found and thus will not be used");
                        }
                    }
                }
                if ("_cmp".equals(string) && object2.containsKey("gclid")) {
                    ((zzgm)zzgo2).zzs.zzaw();
                    ((zzhy)zzgo2).zzZ("auto", "_lgclid", object2.getString("gclid"), ((zzgm)zzgo2).zzs.zzav().currentTimeMillis());
                }
                ((zzgm)zzgo2).zzs.zzaw();
                if (n != 0 && zzky.zzal(string)) {
                    ((zzgm)zzgo2).zzs.zzv().zzK((Bundle)object2, ((zzgm)zzgo2).zzs.zzm().zzr.zza());
                }
                if (!bl2) {
                    ((zzgm)zzgo2).zzs.zzaw();
                    if (!"_iap".equals(string)) {
                        int n4;
                        object4 = ((zzhy)zzgo2).zzs.zzv();
                        if (!((zzky)object4).zzab("event", string)) {
                            n4 = 2;
                        } else if (!((zzky)object4).zzY("event", zzgq.zza, zzgq.zzb, string)) {
                            n4 = 13;
                        } else {
                            ((zzgm)object4).zzs.zzf();
                            n4 = !((zzky)object4).zzX("event", 40, string) ? 2 : 0;
                        }
                        if (n4 != 0) {
                            ((zzgm)zzgo2).zzs.zzay().zze().zzb("Invalid public event name. Event will not be logged (FE)", ((zzgm)zzgo2).zzs.zzj().zzd(string));
                            object = ((zzhy)zzgo2).zzs;
                            object = ((zzft)object).zzv();
                            ((zzhy)zzgo2).zzs.zzf();
                            object2 = ((zzky)object).zzC(string, 40, true);
                            int n5 = string != null ? string.length() : 0;
                            ((zzhy)zzgo2).zzs.zzv().zzM(((zzhy)zzgo2).zzn, null, n4, "_ev", (String)object2, n5);
                            return;
                        }
                    }
                }
                zzpi.zzc();
                if (((zzgm)zzgo2).zzs.zzf().zzs(null, zzdw.zzat)) {
                    ((zzgm)zzgo2).zzs.zzaw();
                    objectArray = ((zze)zzgo2).zzs.zzs().zzj(false);
                    if (objectArray != null && !object2.containsKey("_sc")) {
                        objectArray.zzd = true;
                    }
                    n3 = n != 0 ? (!bl2 ? 1 : 0) : 0;
                    zzky.zzJ((zzif)objectArray, (Bundle)object2, n3 != 0);
                } else {
                    ((zzgm)zzgo2).zzs.zzaw();
                    objectArray = ((zze)zzgo2).zzs.zzs().zzj(false);
                    if (objectArray != null && !object2.containsKey("_sc")) {
                        objectArray.zzd = true;
                    }
                    n3 = n != 0 ? (!bl2 ? 1 : 0) : 0;
                    zzky.zzJ((zzif)objectArray, (Bundle)object2, n3 != 0);
                }
                n3 = "am".equals(object);
                boolean bl4 = zzky.zzag(string);
                if (n == 0) break block54;
                if (((zzhy)zzgo2).zzd != null) {
                    if (!bl4) {
                        if (n3 == 0) {
                            ((zzgm)zzgo2).zzs.zzay().zzc().zzc("Passing event to registered event handler (FE)", ((zzgm)zzgo2).zzs.zzj().zzd(string), ((zzgm)zzgo2).zzs.zzj().zzb((Bundle)object2));
                            Preconditions.checkNotNull((Object)((zzhy)zzgo2).zzd);
                            ((zzhy)zzgo2).zzd.interceptEvent((String)object, string, (Bundle)object2, l);
                            return;
                        }
                        n = 1;
                        break block53;
                    } else {
                        n = n3;
                    }
                    break block53;
                } else {
                    n = n3;
                }
                break block53;
            }
            n = n3;
        }
        if (!((zzhy)zzgo2).zzs.zzM()) {
            return;
        }
        n3 = ((zzgm)zzgo2).zzs.zzv().zzh(string);
        if (n3 != 0) {
            ((zzgm)zzgo2).zzs.zzay().zze().zzb("Invalid event name. Event will not be logged (FE)", ((zzgm)zzgo2).zzs.zzj().zzd(string));
            object = ((zzgm)zzgo2).zzs;
            object = ((zzft)object).zzv();
            ((zzgm)zzgo2).zzs.zzf();
            object2 = ((zzky)object).zzC(string, 40, true);
            int n6 = string != null ? string.length() : 0;
            ((zzhy)zzgo2).zzs.zzv().zzM(((zzhy)zzgo2).zzn, string2, n3, "_ev", (String)object2, n6);
            return;
        }
        String[] stringArray = new String[]{"_o", "_sn", "_sc", "_si"};
        stringArray = CollectionUtils.listOf((Object[])stringArray);
        stringArray = ((zzgm)zzgo2).zzs.zzv().zzy(string2, string, (Bundle)object2, (List)stringArray, bl2);
        Preconditions.checkNotNull((Object)stringArray);
        ((zzgm)zzgo2).zzs.zzaw();
        if (((zze)zzgo2).zzs.zzs().zzj(false) != null && "_ae".equals(string)) {
            object2 = ((zze)zzgo2).zzs.zzu().zzb;
            long l2 = ((zzka)object2).zzc.zzs.zzav().elapsedRealtime();
            long l3 = l2 - ((zzka)object2).zzb;
            ((zzka)object2).zzb = l2;
            if (l3 > 0L) {
                ((zzgm)zzgo2).zzs.zzv().zzH((Bundle)stringArray, l3);
            }
        }
        zzob.zzc();
        if (((zzgm)zzgo2).zzs.zzf().zzs(null, zzdw.zzac)) {
            if (!"auto".equals(object) && "_ssr".equals(string)) {
                zzky zzky2 = ((zzgm)zzgo2).zzs.zzv();
                object2 = stringArray.getString("_ffr");
                if (Strings.isEmptyOrWhitespace((String)object2)) {
                    object2 = null;
                } else if (object2 != null) {
                    object2 = ((String)object2).trim();
                }
                if (zzky.zzak((String)object2, zzky2.zzs.zzm().zzo.zza())) {
                    zzky2.zzs.zzay().zzc().zza("Not logging duplicate session_start_with_rollout event");
                    return;
                }
                zzky2.zzs.zzm().zzo.zzb((String)object2);
            } else if ("_ae".equals(string) && !TextUtils.isEmpty((CharSequence)(object2 = ((zzgm)zzgo2).zzs.zzv().zzs.zzm().zzo.zza()))) {
                stringArray.putString("_ffr", (String)object2);
            }
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add((Bundle)stringArray);
        if (((zzgm)zzgo2).zzs.zzm().zzj.zza() > 0L && ((zzgm)zzgo2).zzs.zzm().zzk(l) && ((zzgm)zzgo2).zzs.zzm().zzl.zzb()) {
            ((zzgm)zzgo2).zzs.zzay().zzj().zza("Current session is expired, remove the session number, ID, and engagement time");
            ((zzhy)zzgo2).zzZ("auto", "_sid", null, ((zzgm)zzgo2).zzs.zzav().currentTimeMillis());
            ((zzhy)zzgo2).zzZ("auto", "_sno", null, ((zzgm)zzgo2).zzs.zzav().currentTimeMillis());
            ((zzhy)zzgo2).zzZ("auto", "_se", null, ((zzgm)zzgo2).zzs.zzav().currentTimeMillis());
        }
        if (stringArray.getLong("extend_session", 0L) == 1L) {
            ((zzgm)zzgo2).zzs.zzay().zzj().zza("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
            ((zzhy)zzgo2).zzs.zzu().zza.zzb(l, true);
        }
        object32 = new ArrayList(stringArray.keySet());
        Collections.sort(object32);
        int n7 = object32.size();
        for (n2 = 0; n2 < n7; ++n2) {
            String string3 = (String)object32.get(n2);
            if (string3 == null) continue;
            ((zzgm)zzgo2).zzs.zzv();
            Object object5 = stringArray.get(string3);
            if (object5 instanceof Bundle) {
                Bundle[] bundleArray = new Bundle[]{(Bundle)object5};
                object5 = bundleArray;
            } else if (object5 instanceof Parcelable[]) {
                object5 = (Parcelable[])object5;
                object5 = (Bundle[])Arrays.copyOf(object5, ((Parcelable[])object5).length, Bundle[].class);
            } else if (object5 instanceof ArrayList) {
                object5 = (ArrayList)object5;
                object5 = ((ArrayList)object5).toArray(new Bundle[((ArrayList)object5).size()]);
            } else {
                object5 = null;
            }
            if (object5 == null) continue;
            stringArray.putParcelableArray(string3, (Parcelable[])object5);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            stringArray = (Bundle)arrayList.get(n2);
            String string4 = n2 != 0 ? "_ep" : string;
            stringArray.putString("_o", (String)object);
            if (bl) {
                stringArray = ((zzgm)zzgo2).zzs.zzv().zzt((Bundle)stringArray);
            }
            zzas zzas2 = new zzas((Bundle)stringArray);
            object32 = new zzau(string4, zzas2, (String)object, l);
            ((zze)zzgo2).zzs.zzt().zzA((zzau)((Object)object32), string2);
            if (n != 0) continue;
            for (Object object32 : ((zzhy)zzgo2).zze) {
                object32 = (zzgu)object32;
                zzas2 = new Bundle((Bundle)stringArray);
                object32.onEvent((String)object, string, (Bundle)zzas2, l);
            }
        }
        ((zzgm)zzgo2).zzs.zzaw();
        if (((zze)zzgo2).zzs.zzs().zzj(false) != null && "_ae".equals(string)) {
            object = ((zze)zzgo2).zzs;
            object = ((zzft)object).zzu();
            zzgo zzgo2 = ((zzgm)zzgo2).zzs;
            zzgo2 = ((zzft)zzgo2).zzav();
            l = zzgo2.elapsedRealtime();
            ((zzkc)object).zzb.zzd(true, true, l);
            return;
        }
    }

    public final void zzJ(zzgu zzgu2) {
        this.zza();
        Preconditions.checkNotNull((Object)zzgu2);
        if (!this.zze.add(zzgu2)) {
            this.zzs.zzay().zzk().zza("OnEventListener already registered");
            return;
        }
    }

    public final void zzK(long l) {
        this.zzg.set(null);
        zzgo zzgo2 = this.zzs;
        zzgo2 = ((zzft)zzgo2).zzaz();
        zzhg zzhg2 = new zzhg(this, l);
        ((zzfq)zzgo2).zzp(zzhg2);
    }

    final void zzL(long l, boolean bl) {
        ((zzgm)this).zzg();
        this.zza();
        this.zzs.zzay().zzc().zza("Resetting analytics data (FE)");
        zzkc zzkc2 = this.zzs.zzu();
        ((zzgm)zzkc2).zzg();
        zzkb cfr_ignored_0 = zzkc2.zza;
        zzkc2.zzb.zza();
        boolean bl2 = this.zzs.zzJ();
        zzey zzey2 = this.zzs.zzm();
        zzey2.zzc.zzb(l);
        if (!TextUtils.isEmpty((CharSequence)zzey2.zzs.zzm().zzo.zza())) {
            zzey2.zzo.zzb(null);
        }
        zzok.zzc();
        if (zzey2.zzs.zzf().zzs(null, zzdw.zzad)) {
            zzey2.zzj.zzb(0L);
        }
        if (!zzey2.zzs.zzf().zzv()) {
            zzey2.zzi(bl2 ^ true);
        }
        zzey2.zzp.zzb(null);
        zzey2.zzq.zzb(0L);
        zzey2.zzr.zzb(null);
        if (bl) {
            this.zzs.zzt().zzC();
        }
        zzok.zzc();
        if (this.zzs.zzf().zzs(null, zzdw.zzad)) {
            this.zzs.zzu().zza.zza();
        }
        this.zzc = bl2 ^ true;
    }

    protected final void zzM(String string, String string2, long l, Bundle object2, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle = new Bundle((Bundle)object2);
        for (Object object2 : bundle.keySet()) {
            Bundle bundle2;
            Object object3;
            Object object4 = bundle.get((String)object2);
            if (object4 instanceof Bundle) {
                object3 = new Bundle((Bundle)object4);
                bundle.putBundle((String)object2, object3);
                continue;
            }
            if (object4 instanceof Parcelable[]) {
                object4 = (Parcelable[])object4;
                for (int i = 0; i < ((Parcelable[])object4).length; ++i) {
                    object3 = object4[i];
                    if (!(object3 instanceof Bundle)) continue;
                    bundle2 = new Bundle(object3);
                    object4[i] = bundle2;
                }
                continue;
            }
            if (!(object4 instanceof List)) continue;
            object4 = (List)object4;
            for (int i = 0; i < object4.size(); ++i) {
                object3 = object4.get(i);
                if (!(object3 instanceof Bundle)) continue;
                bundle2 = new Bundle(object3);
                object4.set(i, bundle2);
            }
        }
        object2 = this.zzs;
        object2 = ((zzft)object2).zzaz();
        Object object5 = new zzhd(this, string, string2, l, bundle, bl, bl2, bl3, string3);
        ((zzfq)object2).zzp((Runnable)object5);
    }

    final void zzN(String string, String string2, long l, Object object) {
        zzgo zzgo2 = this.zzs;
        zzgo2 = ((zzft)zzgo2).zzaz();
        zzhe zzhe2 = new zzhe(this, string, string2, object, l);
        ((zzfq)zzgo2).zzp(zzhe2);
    }

    final void zzO(String string) {
        this.zzg.set(string);
    }

    public final void zzP(Bundle bundle) {
        this.zzQ(bundle, this.zzs.zzav().currentTimeMillis());
    }

    public final void zzQ(Bundle object, long l) {
        Preconditions.checkNotNull((Object)object);
        Bundle bundle = new Bundle((Bundle)object);
        if (!TextUtils.isEmpty((CharSequence)bundle.getString("app_id"))) {
            this.zzs.zzay().zzk().zza("Package name should be null when calling setConditionalUserProperty");
        }
        bundle.remove("app_id");
        Preconditions.checkNotNull((Object)bundle);
        zzgp.zza((Bundle)bundle, (String)"app_id", String.class, null);
        zzgp.zza((Bundle)bundle, (String)"origin", String.class, null);
        zzgp.zza((Bundle)bundle, (String)"name", String.class, null);
        zzgp.zza((Bundle)bundle, (String)"value", Object.class, null);
        zzgp.zza((Bundle)bundle, (String)"trigger_event_name", String.class, null);
        object = 0L;
        zzgp.zza((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)object);
        zzgp.zza((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
        zzgp.zza((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
        zzgp.zza((Bundle)bundle, (String)"triggered_event_name", String.class, null);
        zzgp.zza((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
        zzgp.zza((Bundle)bundle, (String)"time_to_live", Long.class, (Object)object);
        zzgp.zza((Bundle)bundle, (String)"expired_event_name", String.class, null);
        zzgp.zza((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        bundle.putLong("creation_timestamp", l);
        object = bundle.getString("name");
        Object object2 = bundle.get("value");
        if (this.zzs.zzv().zzl((String)object) == 0) {
            if (this.zzs.zzv().zzd((String)object, object2) == 0) {
                Object object3 = this.zzs.zzv().zzB((String)object, object2);
                if (object3 == null) {
                    this.zzs.zzay().zzd().zzc("Unable to normalize conditional user property value", this.zzs.zzj().zzf((String)object), object2);
                    return;
                }
                zzgp.zzb((Bundle)bundle, (Object)object3);
                long l2 = bundle.getLong("trigger_timeout");
                if (!TextUtils.isEmpty((CharSequence)bundle.getString("trigger_event_name"))) {
                    this.zzs.zzf();
                    if (l2 > 15552000000L || l2 < 1L) {
                        this.zzs.zzay().zzd().zzc("Invalid conditional user property timeout", this.zzs.zzj().zzf((String)object), l2);
                        return;
                    }
                }
                long l3 = bundle.getLong("time_to_live");
                this.zzs.zzf();
                if (l3 > 15552000000L || l3 < 1L) {
                    this.zzs.zzay().zzd().zzc("Invalid conditional user property time to live", this.zzs.zzj().zzf((String)object), l3);
                    return;
                }
                object = this.zzs;
                object = ((zzft)object).zzaz();
                object2 = new zzhh(this, bundle);
                ((zzfq)object).zzp((Runnable)object2);
                return;
            }
            this.zzs.zzay().zzd().zzc("Invalid conditional user property value", this.zzs.zzj().zzf((String)object), object2);
            return;
        }
        this.zzs.zzay().zzd().zzb("Invalid conditional user property name", this.zzs.zzj().zzf((String)object));
    }

    public final void zzR(Bundle bundle, int n, long l) {
        this.zza();
        String string = zzah.zzg(bundle);
        if (string != null) {
            this.zzs.zzay().zzl().zzb("Ignoring invalid consent setting", string);
            this.zzs.zzay().zzl().zza("Valid consent values are 'granted', 'denied'");
        }
        this.zzS(zzah.zza(bundle), n, l);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzS(zzah zzah2, int n, long l) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        block9: {
            this.zza();
            if (n != -10 && zzah2.zze() == null && zzah2.zzf() == null) {
                this.zzs.zzay().zzl().zza("Discarding empty consent settings");
                return;
            }
            Object object = this.zzh;
            // MONITORENTER : object
            boolean bl4 = zzah.zzj(n, this.zzj);
            if (bl4) {
                zzah zzah3;
                bl3 = zzah2.zzk(this.zzi);
                bl4 = zzah2.zzi(zzag.zzb);
                bl4 = bl4 ? !(bl4 = (zzah3 = this.zzi).zzi(zzag.zzb)) : false;
                this.zzi = zzah2 = zzah2.zzd(this.zzi);
                this.zzj = n;
                bl2 = bl4;
                bl = true;
                // MONITOREXIT : object
                break block9;
            }
            bl3 = false;
            bl2 = false;
            bl = false;
            {
                catch (Throwable throwable) {}
                {
                    // MONITOREXIT : object
                    throw throwable;
                }
            }
        }
        if (!bl) {
            this.zzs.zzay().zzi().zzb("Ignoring lower-priority consent settings, proposed settings", zzah2);
            return;
        }
        long l2 = this.zzk.getAndIncrement();
        if (bl3) {
            this.zzg.set(null);
            zzgo zzgo2 = this.zzs;
            zzgo2 = ((zzft)zzgo2).zzaz();
            zzhs zzhs2 = new zzhs(this, zzah2, l, n, l2, bl2);
            ((zzfq)zzgo2).zzq(zzhs2);
            return;
        }
        if (n != 30 && n != -10) {
            zzgo zzgo3 = this.zzs;
            zzgo3 = ((zzft)zzgo3).zzaz();
            zzhu zzhu2 = new zzhu(this, zzah2, n, l2, bl2);
            ((zzfq)zzgo3).zzp(zzhu2);
            return;
        }
        zzgo zzgo4 = this.zzs;
        zzgo4 = ((zzft)zzgo4).zzaz();
        zzht zzht2 = new zzht(this, zzah2, n, l2, bl2);
        ((zzfq)zzgo4).zzq(zzht2);
    }

    public final void zzT(Bundle bundle, long l) {
        zzoe.zzc();
        if (this.zzs.zzf().zzs(null, zzdw.zzal)) {
            zzgo zzgo2 = this.zzs;
            zzgo2 = ((zzft)zzgo2).zzaz();
            zzgz zzgz2 = new zzgz(this, bundle, l);
            ((zzfq)zzgo2).zzq(zzgz2);
            return;
        }
        this.zzab(bundle, l);
    }

    @WorkerThread
    private final void zzab(Bundle bundle, long l) {
        if (TextUtils.isEmpty((CharSequence)this.zzs.zzh().zzm())) {
            this.zzR(bundle, 0, l);
            return;
        }
        this.zzs.zzay().zzl().zza("Using developer consent only; google app id found");
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zzU(zzgt zzgt2) {
        zzgt zzgt3;
        ((zzgm)this).zzg();
        this.zza();
        if (zzgt2 != null && zzgt2 != (zzgt3 = this.zzd)) {
            boolean bl = zzgt3 == null;
            Preconditions.checkState((boolean)bl, (Object)"EventInterceptor already set.");
        }
        this.zzd = zzgt2;
    }

    public final void zzV(Boolean bl) {
        this.zza();
        zzgo zzgo2 = this.zzs;
        zzgo2 = ((zzft)zzgo2).zzaz();
        zzhr zzhr2 = new zzhr(this, bl);
        ((zzfq)zzgo2).zzp(zzhr2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzW(zzah zzah2) {
        ((zzgm)this).zzg();
        boolean bl = !zzah2.zzi(zzag.zzb) || !zzah2.zzi(zzag.zza) ? this.zzs.zzt().zzM() : true;
        if (bl != this.zzs.zzK()) {
            this.zzs.zzG(bl);
            Object object = this.zzs.zzm();
            zzft cfr_ignored_0 = ((zzgm)object).zzs;
            ((zzgm)object).zzg();
            object = ((zzey)object).zza().contains("measurement_enabled_from_api") ? Boolean.valueOf(((zzey)object).zza().getBoolean("measurement_enabled_from_api", true)) : null;
            if (!bl || object == null || ((Boolean)object).booleanValue()) {
                this.zzac(bl, false);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzac(Boolean bl, boolean bl2) {
        ((zzgm)this).zzg();
        this.zza();
        this.zzs.zzay().zzc().zzb("Setting app measurement enabled (FE)", bl);
        this.zzs.zzm().zzh(bl);
        if (bl2) {
            zzey zzey2 = this.zzs.zzm();
            zzft cfr_ignored_0 = zzey2.zzs;
            zzey2.zzg();
            zzey2 = zzey2.zza().edit();
            if (bl != null) {
                zzey2.putBoolean("measurement_enabled_from_api", bl);
            } else {
                zzey2.remove("measurement_enabled_from_api");
            }
            zzey2.apply();
        }
        if (this.zzs.zzK() || bl != null && !bl.booleanValue()) {
            this.zzad();
            return;
        }
    }

    public final void zzX(String string, String string2, Object object, boolean bl) {
        this.zzY("auto", "_ldl", object, true, this.zzs.zzav().currentTimeMillis());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void zzY(String object, String string, Object object2, boolean bl, long l) {
        void var5_15;
        void var4_8;
        if (object == null) {
            object = "app";
        }
        if (bl) {
            int n = this.zzs.zzv().zzl(string);
        } else {
            zzky zzky2 = this.zzs.zzv();
            if (!zzky2.zzab("user property", string)) {
                int n = 6;
            } else if (!zzky2.zzY("user property", zzgs.zza, null, string)) {
                int n = 15;
            } else {
                zzky2.zzs.zzf();
                if (!zzky2.zzX("user property", 24, string)) {
                    int n = 6;
                } else {
                    boolean bl2 = false;
                }
            }
        }
        if (var4_8 != false) {
            object = this.zzs;
            object = ((zzft)object).zzv();
            this.zzs.zzf();
            object2 = ((zzky)object).zzC(string, 24, true);
            int n = string != null ? string.length() : 0;
            this.zzs.zzv().zzM(this.zzn, null, (int)var4_8, "_ev", (String)object2, n);
            return;
        }
        if (object2 == null) {
            this.zzN((String)object, string, (long)var5_15, null);
            return;
        }
        int n = this.zzs.zzv().zzd(string, object2);
        if (n != 0) {
            object = this.zzs;
            object = ((zzft)object).zzv();
            this.zzs.zzf();
            string = ((zzky)object).zzC(string, 24, true);
            int n2 = object2 instanceof String || object2 instanceof CharSequence ? object2.toString().length() : 0;
            this.zzs.zzv().zzM(this.zzn, null, n, "_ev", string, n2);
            return;
        }
        object2 = this.zzs.zzv().zzB(string, object2);
        if (object2 != null) {
            this.zzN((String)object, string, (long)var5_15, object2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzZ(String string, String string2, Object object, long l) {
        Object object2;
        block6: {
            block7: {
                Preconditions.checkNotEmpty((String)string);
                Preconditions.checkNotEmpty((String)string2);
                ((zzgm)this).zzg();
                this.zza();
                if (!"allow_personalized_ads".equals(string2)) break block7;
                if (object instanceof String && !TextUtils.isEmpty((CharSequence)(object2 = (String)object))) {
                    long l2 = true != "false".equals(((String)object2).toLowerCase(Locale.ENGLISH)) ? 0L : 1L;
                    object2 = l2;
                    object = this.zzs.zzm().zzh;
                    string2 = (Long)object2 == 1L ? "true" : "false";
                    ((zzex)object).zzb(string2);
                    string2 = "_npa";
                    break block6;
                } else if (object == null) {
                    this.zzs.zzm().zzh.zzb("unset");
                    string2 = "_npa";
                    object2 = object;
                    break block6;
                } else {
                    object2 = object;
                }
                break block6;
            }
            object2 = object;
        }
        if (!this.zzs.zzJ()) {
            this.zzs.zzay().zzj().zza("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzs.zzM()) {
            return;
        }
        object = new zzku(string2, l, object2, string);
        this.zzs.zzt().zzK((zzku)((Object)object));
    }

    public final void zzaa(zzgu zzgu2) {
        this.zza();
        Preconditions.checkNotNull((Object)zzgu2);
        if (!this.zze.remove(zzgu2)) {
            this.zzs.zzay().zzk().zza("OnEventListener had not been registered");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzad() {
        ((zzgm)this).zzg();
        Object object = this.zzs.zzm().zzh.zza();
        if (object != null) {
            if ("unset".equals(object)) {
                this.zzZ("app", "_npa", null, this.zzs.zzav().currentTimeMillis());
            } else {
                long l = true != "true".equals(object) ? 0L : 1L;
                this.zzZ("app", "_npa", l, this.zzs.zzav().currentTimeMillis());
            }
        }
        if (this.zzs.zzJ() && this.zzc) {
            this.zzs.zzay().zzc().zza("Recording app launch after enabling measurement for the first time (FE)");
            this.zzy();
            zzok.zzc();
            if (this.zzs.zzf().zzs(null, zzdw.zzad)) {
                this.zzs.zzu().zza.zza();
            }
            object = this.zzs;
            object = ((zzft)object).zzaz();
            zzhb zzhb2 = new zzhb(this);
            ((zzfq)object).zzp(zzhb2);
            return;
        }
        this.zzs.zzay().zzc().zza("Updating Scion state (FE)");
        this.zzs.zzt().zzI();
    }

    @Override
    protected final boolean zzf() {
        return false;
    }
}

