/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzel;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjo;
import com.google.android.gms.measurement.internal.zzjp;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjr;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzjt;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzka;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzll;
import com.google.android.gms.measurement.internal.zzp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzkb
extends zzf {
    private final zzka zza;
    private zzeo zzb;
    private volatile Boolean zzc;
    private final zzao zzd;
    private final zzks zze;
    private final List zzf;
    private final zzao zzg;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    private final zzp zzO(boolean bl) {
        Object object;
        ((zzhb)object).zzs.zzax();
        zzep zzep2 = ((zze)object).zzs.zzh();
        if (bl) {
            object = ((zzhb)object).zzs.zzaz();
            if (((zzhb)object).zzs.zzm().zzb == null) {
                object = null;
                return zzep2.zzj((String)object);
            }
            object = ((zzhb)object).zzs.zzm().zzb.zza();
            if (object != null) {
                if (object == zzfn.zza) {
                    object = null;
                    return zzep2.zzj((String)object);
                }
                Object object2 = ((Pair)object).second;
                object2 = String.valueOf(object2);
                object = ((Pair)object).first;
                object = (String)object;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)object2);
                stringBuilder.append(":");
                stringBuilder.append((String)object);
                object = stringBuilder.toString();
                return zzep2.zzj((String)object);
            }
            object = null;
            return zzep2.zzj((String)object);
        }
        object = null;
        return zzep2.zzj((String)object);
    }

    static /* bridge */ /* synthetic */ zzeo zzh(zzkb zzkb2) {
        return zzkb2.zzb;
    }

    static /* bridge */ /* synthetic */ zzka zzi(zzkb zzkb2) {
        return zzkb2.zza;
    }

    final Boolean zzj() {
        return this.zzc;
    }

    static /* bridge */ /* synthetic */ void zzl(zzkb zzkb2, zzeo zzeo2) {
        zzkb2.zzb = null;
    }

    static /* bridge */ /* synthetic */ void zzm(zzkb zzkb2) {
        zzkb2.zzP();
    }

    static /* bridge */ /* synthetic */ void zzo(zzkb zzkb2, ComponentName componentName) {
        ((zzhb)zzkb2).zzg();
        if (zzkb2.zzb != null) {
            zzkb2.zzb = null;
            zzkb2.zzs.zzaz().zzj().zzb("Disconnected from device MeasurementService", componentName);
            ((zzhb)zzkb2).zzg();
            zzkb2.zzr();
            return;
        }
    }

    static /* bridge */ /* synthetic */ void zzp(zzkb zzkb2) {
        zzkb2.zzQ();
    }

    protected zzkb(zzgi zzgi2) {
        super(zzgi2);
        Object object = new ArrayList();
        this.zzf = object;
        this.zze = object = new zzks(zzgi2.zzaw());
        this.zza = object = new zzka(this);
        this.zzd = object = new zzjl(this, zzgi2);
        this.zzg = object = new zzjn(this, zzgi2);
    }

    @WorkerThread
    protected final void zzq() {
        ((zzhb)this).zzg();
        this.zza();
        zzp zzp2 = this.zzO(true);
        this.zzs.zzi().zzk();
        zzji zzji2 = new zzji(this, zzp2);
        this.zzR(zzji2);
    }

    @WorkerThread
    final void zzr() {
        ((zzhb)this).zzg();
        this.zza();
        if (this.zzL()) {
            return;
        }
        if (!this.zzN()) {
            if (!this.zzs.zzf().zzx()) {
                this.zzs.zzax();
                Object object = this.zzs;
                object = ((zzgi)object).zzav();
                object = object.getPackageManager();
                Intent intent = new Intent();
                object = object.queryIntentServices(intent.setClassName(this.zzs.zzav(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
                if (object != null && !object.isEmpty()) {
                    object = new Intent("com.google.android.gms.measurement.START");
                    zzgi zzgi2 = this.zzs;
                    zzgi2 = zzgi2.zzav();
                    this.zzs.zzax();
                    intent = new ComponentName((Context)zzgi2, "com.google.android.gms.measurement.AppMeasurementService");
                    object.setComponent((ComponentName)intent);
                    this.zza.zzb((Intent)object);
                    return;
                }
                this.zzs.zzaz().zzd().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
                return;
            }
            return;
        }
        this.zza.zzc();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzs() {
        ((zzhb)this).zzg();
        this.zza();
        this.zza.zzd();
        try {
            ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
            Context context = this.zzs.zzav();
            connectionTracker.unbindService(context, (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final void zzP() {
        ((zzhb)this).zzg();
        this.zzs.zzaz().zzj().zzb("Processing queued up service tasks", this.zzf.size());
        Iterator iterator = this.zzf.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.zzf.clear();
                this.zzg.zzb();
                return;
            }
            Runnable runnable = (Runnable)iterator.next();
            try {
                runnable.run();
                continue;
            }
            catch (RuntimeException runtimeException) {
                this.zzs.zzaz().zzd().zzb("Task exception while flushing queue", runtimeException);
                continue;
            }
            break;
        }
    }

    @WorkerThread
    public final void zzt(zzcf zzcf2) {
        ((zzhb)this).zzg();
        this.zza();
        zzp zzp2 = this.zzO(false);
        zzjh zzjh2 = new zzjh(this, zzp2, zzcf2);
        this.zzR(zzjh2);
    }

    @WorkerThread
    public final void zzu(AtomicReference atomicReference) {
        ((zzhb)this).zzg();
        this.zza();
        zzp zzp2 = this.zzO(false);
        zzjg zzjg2 = new zzjg(this, atomicReference, zzp2);
        this.zzR(zzjg2);
    }

    @WorkerThread
    protected final void zzv(zzcf zzcf2, String string, String string2) {
        ((zzhb)this).zzg();
        this.zza();
        zzp zzp2 = this.zzO(false);
        zzjt zzjt2 = new zzjt(this, string, string2, zzp2, zzcf2);
        this.zzR(zzjt2);
    }

    @WorkerThread
    protected final void zzw(AtomicReference atomicReference, String object, String string, String string2) {
        ((zzhb)this).zzg();
        this.zza();
        object = this.zzO(false);
        zzjs zzjs2 = new zzjs(this, atomicReference, null, string, string2, (zzp)((Object)object));
        this.zzR(zzjs2);
    }

    @WorkerThread
    protected final void zzx(AtomicReference atomicReference, boolean bl) {
        ((zzhb)this).zzg();
        this.zza();
        zzp zzp2 = this.zzO(false);
        zzje zzje2 = new zzje(this, atomicReference, zzp2, bl);
        this.zzR(zzje2);
    }

    @WorkerThread
    protected final void zzy(zzcf zzcf2, String string, String string2, boolean bl) {
        ((zzhb)this).zzg();
        this.zza();
        zzp zzp2 = this.zzO(false);
        zzjc zzjc2 = new zzjc(this, string, string2, zzp2, bl, zzcf2);
        this.zzR(zzjc2);
    }

    @WorkerThread
    protected final void zzz(AtomicReference atomicReference, String object, String string, String string2, boolean bl) {
        ((zzhb)this).zzg();
        this.zza();
        object = this.zzO(false);
        zzju zzju2 = new zzju(this, atomicReference, null, string, string2, (zzp)((Object)object), bl);
        this.zzR(zzju2);
    }

    @WorkerThread
    protected final void zzA(zzav zzav2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzav2));
        ((zzhb)this).zzg();
        this.zza();
        this.zzS();
        zzhd zzhd2 = this.zzs;
        zzhd2 = ((zzgi)zzhd2).zzi();
        boolean bl = ((zzer)zzhd2).zzo(zzav2);
        zzp zzp2 = this.zzO(true);
        zzjq zzjq2 = new zzjq(this, true, zzp2, bl, zzav2, string);
        this.zzR(zzjq2);
    }

    @WorkerThread
    public final void zzB(zzcf zzcf2, zzav zzav2, String string) {
        ((zzhb)this).zzg();
        this.zza();
        if (this.zzs.zzv().zzo(12451000) != 0) {
            this.zzs.zzaz().zzk().zza("Not bundling data. Service unavailable or out of date");
            this.zzs.zzv().zzS(zzcf2, new byte[0]);
            return;
        }
        zzjm zzjm2 = new zzjm(this, zzav2, string, zzcf2);
        this.zzR(zzjm2);
    }

    @WorkerThread
    private final void zzQ() {
        ((zzhb)this).zzg();
        this.zze.zzb();
        zzao zzao2 = this.zzd;
        this.zzs.zzf();
        zzao2.zzd((Long)zzel.zzI.zza(null));
    }

    @WorkerThread
    protected final void zzC() {
        ((zzhb)this).zzg();
        this.zza();
        zzp zzp2 = this.zzO(false);
        this.zzS();
        this.zzs.zzi().zzj();
        zzjf zzjf2 = new zzjf(this, zzp2);
        this.zzR(zzjf2);
    }

    @WorkerThread
    private final void zzR(Runnable runnable) throws IllegalStateException {
        ((zzhb)this).zzg();
        if (this.zzL()) {
            runnable.run();
            return;
        }
        List list = this.zzf;
        int n = list.size();
        this.zzs.zzf();
        if ((long)n >= 1000L) {
            this.zzs.zzaz().zzd().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zzd(60000L);
        this.zzr();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    @VisibleForTesting
    final void zzD(zzeo zzeo2, AbstractSafeParcelable abstractSafeParcelable, zzp zzp2) {
        ((zzhb)this).zzg();
        this.zza();
        this.zzS();
        this.zzs.zzf();
        int n = 100;
        int n2 = 0;
        block6: while (true) {
            ArrayList<AbstractSafeParcelable> arrayList;
            if (n2 < 1001 && n == 100) {
                arrayList = new ArrayList<AbstractSafeParcelable>();
                List list = this.zzs.zzi().zzi(100);
                if (list != null) {
                    arrayList.addAll(list);
                    n = list.size();
                } else {
                    n = 0;
                }
                if (abstractSafeParcelable != null && n < 100) {
                    arrayList.add(abstractSafeParcelable);
                }
            } else {
                return;
            }
            int n3 = arrayList.size();
            int n4 = 0;
            while (true) {
                block19: {
                    if (n4 < n3) {
                        AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)arrayList.get(n4);
                        if (abstractSafeParcelable2 instanceof zzav) {
                            zzeo2.zzk((zzav)abstractSafeParcelable2, zzp2);
                        }
                        if (abstractSafeParcelable2 instanceof zzll) {
                            zzeo2.zzt((zzll)abstractSafeParcelable2, zzp2);
                        }
                        if (abstractSafeParcelable2 instanceof zzab) {
                            zzeo2.zzn((zzab)abstractSafeParcelable2, zzp2);
                        } else {
                            this.zzs.zzaz().zzd().zza("Discarding data. Unrecognized parcel type.");
                        }
                    } else {
                        ++n2;
                        continue block6;
                        catch (RemoteException remoteException) {
                            this.zzs.zzaz().zzd().zzb("Failed to send event to the service", (Object)remoteException);
                        }
                    }
                    break block19;
                    catch (RemoteException remoteException) {
                        this.zzs.zzaz().zzd().zzb("Failed to send user property to the service", (Object)remoteException);
                    }
                    break block19;
                    catch (RemoteException remoteException) {
                        this.zzs.zzaz().zzd().zzb("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                }
                ++n4;
            }
            break;
        }
    }

    @WorkerThread
    protected final void zzE(zzab zzab2) {
        Preconditions.checkNotNull((Object)((Object)zzab2));
        ((zzhb)this).zzg();
        this.zza();
        this.zzs.zzax();
        zzhd zzhd2 = this.zzs;
        zzhd2 = ((zzgi)zzhd2).zzi();
        boolean bl = ((zzer)zzhd2).zzn(zzab2);
        zzab zzab3 = new zzab(zzab2);
        zzp zzp2 = this.zzO(true);
        zzjr zzjr2 = new zzjr(this, true, zzp2, bl, zzab3, zzab2);
        this.zzR(zzjr2);
    }

    @WorkerThread
    protected final void zzF(boolean bl) {
        ((zzhb)this).zzg();
        this.zza();
        if (bl) {
            this.zzS();
            this.zzs.zzi().zzj();
        }
        if (this.zzM()) {
            zzp zzp2 = this.zzO(false);
            zzjp zzjp2 = new zzjp(this, zzp2);
            this.zzR(zzjp2);
            return;
        }
    }

    @WorkerThread
    protected final void zzG(zziu zziu2) {
        ((zzhb)this).zzg();
        this.zza();
        zzjj zzjj2 = new zzjj(this, zziu2);
        this.zzR(zzjj2);
    }

    @WorkerThread
    public final void zzH(Bundle bundle) {
        ((zzhb)this).zzg();
        this.zza();
        zzp zzp2 = this.zzO(false);
        zzjk zzjk2 = new zzjk(this, zzp2, bundle);
        this.zzR(zzjk2);
    }

    @WorkerThread
    protected final void zzI() {
        ((zzhb)this).zzg();
        this.zza();
        zzp zzp2 = this.zzO(true);
        zzjo zzjo2 = new zzjo(this, zzp2);
        this.zzR(zzjo2);
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zzJ(zzeo zzeo2) {
        ((zzhb)this).zzg();
        Preconditions.checkNotNull((Object)zzeo2);
        this.zzb = zzeo2;
        this.zzQ();
        this.zzP();
    }

    @WorkerThread
    protected final void zzK(zzll zzll2) {
        ((zzhb)this).zzg();
        this.zza();
        this.zzS();
        zzhd zzhd2 = this.zzs;
        zzhd2 = ((zzgi)zzhd2).zzi();
        boolean bl = ((zzer)zzhd2).zzp(zzll2);
        zzp zzp2 = this.zzO(true);
        zzjd zzjd2 = new zzjd(this, zzp2, bl, zzll2);
        this.zzR(zzjd2);
    }

    @WorkerThread
    public final boolean zzL() {
        ((zzhb)this).zzg();
        this.zza();
        return this.zzb != null;
    }

    @Override
    protected final boolean zzf() {
        return false;
    }

    @WorkerThread
    final boolean zzM() {
        ((zzhb)this).zzg();
        this.zza();
        if (this.zzN()) {
            return this.zzs.zzv().zzm() >= (Integer)zzel.zzai.zza(null);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final boolean zzN() {
        ((zzhb)this).zzg();
        this.zza();
        if (this.zzc == null) {
            boolean bl;
            ((zzhb)this).zzg();
            this.zza();
            Object object = this.zzs.zzm();
            ((zzhb)object).zzg();
            object = !((zzfn)object).zza().contains("use_service") ? null : Boolean.valueOf(((zzfn)object).zza().getBoolean("use_service", false));
            if (object != null && ((Boolean)object).booleanValue()) {
                bl = true;
            } else {
                int n;
                this.zzs.zzax();
                if (this.zzs.zzh().zzh() == 1) {
                    bl = true;
                    n = 1;
                } else {
                    this.zzs.zzaz().zzj().zza("Checking service availability");
                    n = this.zzs.zzv().zzo(12451000);
                    switch (n) {
                        default: {
                            this.zzs.zzaz().zzk().zzb("Unexpected service status", n);
                            bl = false;
                            n = 0;
                            break;
                        }
                        case 0: {
                            this.zzs.zzaz().zzj().zza("Service available");
                            bl = true;
                            n = 1;
                            break;
                        }
                        case 1: {
                            this.zzs.zzaz().zzj().zza("Service missing");
                            bl = false;
                            n = 1;
                            break;
                        }
                        case 2: {
                            this.zzs.zzaz().zzc().zza("Service container out of date");
                            if (this.zzs.zzv().zzm() < 17443) {
                                bl = false;
                                n = 1;
                                break;
                            }
                            bl = object == null;
                            n = 0;
                            break;
                        }
                        case 3: {
                            this.zzs.zzaz().zzk().zza("Service disabled");
                            bl = false;
                            n = 0;
                            break;
                        }
                        case 9: {
                            this.zzs.zzaz().zzk().zza("Service invalid");
                            bl = false;
                            n = 0;
                            break;
                        }
                        case 18: {
                            this.zzs.zzaz().zzk().zza("Service updating");
                            bl = true;
                            n = 1;
                        }
                    }
                }
                if (!bl && this.zzs.zzf().zzx()) {
                    this.zzs.zzaz().zzd().zza("No way to upload. Consider using the full version of Analytics");
                } else if (n != 0) {
                    zzfn zzfn2 = this.zzs.zzm();
                    zzfn2.zzg();
                    zzfn2 = zzfn2.zza().edit();
                    zzfn2.putBoolean("use_service", bl);
                    zzfn2.apply();
                }
            }
            this.zzc = bl;
        }
        return this.zzc;
    }

    private final boolean zzS() {
        this.zzs.zzax();
        return true;
    }
}

