/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzjz;
import com.google.android.gms.measurement.internal.zzka;
import com.google.android.gms.measurement.internal.zzkb;
import com.google.android.gms.measurement.internal.zzkc;
import com.google.android.gms.measurement.internal.zzke;

@VisibleForTesting
public final class zzkd
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzew zzc;
    final /* synthetic */ zzke zza;

    static /* bridge */ /* synthetic */ void zza(zzkd zzkd2, boolean bl) {
        zzkd2.zzb = false;
    }

    protected zzkd(zzke zzke2) {
        this.zza = zzke2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzb(Intent object) {
        ((zzhd)this.zza).zzg();
        Context context = this.zza.zzs.zzau();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        synchronized (this) {
            boolean bl = this.zzb;
            if (bl) {
                object = this.zza;
                object = ((zzhd)object).zzs.zzay();
                ((zzfa)object).zzj().zza("Connection attempt already in progress");
                return;
            }
            zzhd zzhd2 = this.zza;
            zzhd2 = zzhd2.zzs.zzay();
            ((zzfa)zzhd2).zzj().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, (Intent)object, (ServiceConnection)zzke.zzi(this.zza), 129);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzc() {
        ((zzhd)this.zza).zzg();
        Object object = this.zza.zzs.zzau();
        synchronized (this) {
            zzew zzew2;
            boolean bl;
            boolean bl2 = this.zzb;
            if (bl2) {
                object = this.zza;
                object = ((zzhd)object).zzs.zzay();
                ((zzfa)object).zzj().zza("Connection attempt already in progress");
                return;
            }
            zzew zzew3 = this.zzc;
            if (zzew3 != null && ((bl = this.zzc.isConnecting()) || (bl = this.zzc.isConnected()))) {
                object = this.zza;
                object = ((zzhd)object).zzs.zzay();
                ((zzfa)object).zzj().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = zzew2 = new zzew((Context)object, Looper.getMainLooper(), this, this);
            object = this.zza;
            object = ((zzhd)object).zzs.zzay();
            ((zzfa)object).zzj().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final void zzd() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onConnected(Bundle object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        // MONITORENTER : this
        try {
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            object = (zzeq)this.zzc.getService();
            zzhd zzhd2 = this.zza;
            zzhd2 = zzhd2.zzs.zzaz();
            zzka zzka2 = new zzka(this, (zzeq)object);
            ((zzgh)zzhd2).zzp(zzka2);
            // MONITOREXIT : this
            return;
        }
        catch (DeadObjectException | IllegalStateException throwable) {
            this.zzc = null;
            this.zzb = false;
            return;
            {
                catch (Throwable throwable2) {}
                {
                    // MONITOREXIT : this
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        Object object2 = this.zza.zzs.zzl();
        if (object2 != null) {
            ((zzfa)object2).zzk().zzb("Service connection failed", object);
        }
        synchronized (this) {
            this.zzb = false;
            this.zzc = null;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : this
            object = this.zza;
            object = ((zzhd)object).zzs;
            object = ((zzgk)object).zzaz();
            object2 = new zzkc(this);
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        ((zzgh)object).zzp((Runnable)object2);
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        this.zza.zzs.zzay().zzc().zza("Service connection suspended");
        zzhf zzhf2 = this.zza;
        zzhf2 = ((zzhd)zzhf2).zzs;
        zzhf2 = ((zzgk)zzhf2).zzaz();
        zzkb zzkb2 = new zzkb(this);
        ((zzgh)zzhf2).zzp(zzkb2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onServiceConnected(ComponentName object, IBinder object2) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        // MONITORENTER : this
        if (object2 == null) {
            this.zzb = false;
            object = this.zza;
            object = ((zzhd)object).zzs.zzay();
            ((zzfa)object).zzd().zza("Service connected with null binder");
            // MONITOREXIT : this
            return;
        }
        try {
            object = object2.getInterfaceDescriptor();
            boolean bl = "com.google.android.gms.measurement.internal.IMeasurementService".equals(object);
            if (bl) {
                object = object2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService");
                bl = object instanceof zzeq;
                object = bl ? (zzeq)object : new zzeo((IBinder)object2);
                object2 = this.zza;
                object2 = ((zzhd)object2).zzs.zzay();
                ((zzfa)object2).zzj().zza("Bound to IMeasurementService interface");
                object2 = object;
            } else {
                object2 = this.zza;
                object2 = ((zzhd)object2).zzs.zzay();
                ((zzfa)object2).zzd().zzb("Got binder with a wrong descriptor", object);
                object2 = null;
            }
            object = object2;
        }
        catch (RemoteException remoteException) {
            block14: {
                object = null;
                break block14;
                catch (RemoteException remoteException2) {}
            }
            object2 = this.zza;
            object2 = ((zzhd)object2).zzs.zzay();
            ((zzfa)object2).zzd().zza("Service connect failed to get IMeasurementService");
        }
        if (object != null) {
            object2 = this.zza;
            object2 = ((zzhd)object2).zzs.zzaz();
            zzjy zzjy2 = new zzjy(this, (zzeq)object);
            ((zzgh)object2).zzp(zzjy2);
            return;
        }
        this.zzb = false;
        try {
            object = ConnectionTracker.getInstance();
            object2 = this.zza;
            object2 = ((zzhd)object2).zzs.zzau();
            object.unbindService((Context)object2, (ServiceConnection)zzke.zzi(this.zza));
            // MONITOREXIT : this
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        this.zza.zzs.zzay().zzc().zza("Service disconnected");
        zzhf zzhf2 = this.zza;
        zzhf2 = ((zzhd)zzhf2).zzs;
        zzhf2 = ((zzgk)zzhf2).zzaz();
        zzjz zzjz2 = new zzjz(this, componentName);
        ((zzgh)zzhf2).zzp(zzjz2);
    }
}

