/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzdu;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzgl;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzew
extends zzgl {
    @VisibleForTesting
    static final Pair zza;
    private SharedPreferences zzu;
    public zzeu zzb;
    public final zzes zzc;
    public final zzes zzd;
    public final zzev zze;
    private String zzv;
    private boolean zzw;
    private long zzx;
    public final zzes zzf;
    public final zzeq zzg;
    public final zzev zzh;
    public final zzeq zzi;
    public final zzes zzj;
    public final zzes zzk;
    public boolean zzl;
    public final zzeq zzm;
    public final zzeq zzn;
    public final zzes zzo;
    public final zzev zzp;
    public final zzev zzq;
    public final zzes zzr;
    public final zzer zzs;

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zza() {
        this.zzg();
        this.zzu();
        Preconditions.checkNotNull((Object)this.zzu);
        return this.zzu;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final Pair zzb(String string) {
        this.zzg();
        long l = this.zzt.zzav().elapsedRealtime();
        String string2 = this.zzv;
        if (string2 != null && l < this.zzx) {
            return new Pair((Object)string2, (Object)this.zzw);
        }
        this.zzx = l + this.zzt.zzf().zzi(string, zzdu.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            string = this.zzt.zzau();
            string = AdvertisingIdClient.getAdvertisingIdInfo((Context)string);
            this.zzv = "";
            string2 = string.getId();
            if (string2 != null) {
                this.zzv = string2;
            }
            this.zzw = string.isLimitAdTrackingEnabled();
        }
        catch (Exception exception) {
            this.zzt.zzay().zzc().zzb("Unable to get advertising id", exception);
            this.zzv = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzv, (Object)this.zzw);
    }

    @WorkerThread
    final zzai zzc() {
        this.zzg();
        return zzai.zzb(this.zza().getString("consent_settings", "G1"));
    }

    @WorkerThread
    final Boolean zzd() {
        this.zzg();
        if (this.zza().contains("measurement_enabled")) {
            return this.zza().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    static {
        Pair pair;
        zza = pair = new Pair((Object)"", (Object)0L);
    }

    zzew(zzfr object) {
        super((zzfr)object);
        this.zzf = object = new zzes(this, "session_timeout", 1800000L);
        this.zzg = object = new zzeq(this, "start_new_session", true);
        this.zzj = object = new zzes(this, "last_pause_time", 0L);
        this.zzk = object = new zzes(this, "session_id", 0L);
        this.zzh = object = new zzev(this, "non_personalized_ads", null);
        this.zzi = object = new zzeq(this, "allow_remote_dynamite", false);
        this.zzc = object = new zzes(this, "first_open_time", 0L);
        this.zzd = object = new zzes(this, "app_install_time", 0L);
        this.zze = object = new zzev(this, "app_instance_id", null);
        this.zzm = object = new zzeq(this, "app_backgrounded", false);
        this.zzn = object = new zzeq(this, "deep_link_retrieval_complete", false);
        this.zzo = object = new zzes(this, "deep_link_retrieval_attempts", 0L);
        this.zzp = object = new zzev(this, "firebase_feature_rollouts", null);
        this.zzq = object = new zzev(this, "deferred_attribution_cache", null);
        this.zzr = object = new zzes(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzs = object = new zzer(this, "default_event_parameters", null);
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    @WorkerThread
    protected final void zzaA() {
        zzeu zzeu2;
        boolean bl;
        this.zzu = this.zzt.zzau().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzl = bl = this.zzu.getBoolean("has_been_opened", false);
        if (!bl) {
            SharedPreferences.Editor editor = this.zzu.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzt.zzf();
        this.zzb = zzeu2 = new zzeu(this, "health_monitor", Math.max(0L, (Long)zzdu.zzb.zza(null)), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzh(Boolean bl) {
        zzew2.zzg();
        zzew zzew2 = zzew2.zza().edit();
        if (bl != null) {
            zzew2.putBoolean("measurement_enabled", bl);
        } else {
            zzew2.remove("measurement_enabled");
        }
        zzew2.apply();
    }

    @WorkerThread
    final void zzi(boolean bl) {
        zzew2.zzg();
        zzew2.zzt.zzay().zzj().zzb("App measurement setting deferred collection", bl);
        zzew zzew2 = zzew2.zza().edit();
        zzew2.putBoolean("deferred_analytics_collection", bl);
        zzew2.apply();
    }

    @WorkerThread
    final boolean zzj() {
        zzew zzew2 = zzew2.zzu;
        if (zzew2 == null) {
            return false;
        }
        return zzew2.contains("deferred_analytics_collection");
    }

    final boolean zzk(long l) {
        return l - this.zzf.zza() > this.zzj.zza();
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    @WorkerThread
    final boolean zzl(int n) {
        return zzai.zzj(n, this.zza().getInt("consent_source", 100));
    }
}

