/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzfc;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfe;
import com.google.android.gms.measurement.internal.zzfg;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgx;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzfi
extends zzgx {
    static final Pair zza = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzu;
    public zzfg zzb;
    public final zzfe zzc;
    public final zzfe zzd;
    public final zzfh zze;
    private String zzv;
    private boolean zzw;
    private long zzx;
    public final zzfe zzf;
    public final zzfc zzg;
    public final zzfh zzh;
    public final zzfc zzi;
    public final zzfe zzj;
    public final zzfe zzk;
    public boolean zzl;
    public final zzfc zzm;
    public final zzfc zzn;
    public final zzfe zzo;
    public final zzfh zzp;
    public final zzfh zzq;
    public final zzfe zzr;
    public final zzfd zzs;

    @WorkerThread
    protected final SharedPreferences zza() {
        this.zzg();
        this.zzv();
        Preconditions.checkNotNull((Object)this.zzu);
        return this.zzu;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final Pair zzb(String string) {
        this.zzg();
        long l = this.zzt.zzax().elapsedRealtime();
        String string2 = this.zzv;
        if (string2 != null && l < this.zzx) {
            return new Pair((Object)string2, (Object)this.zzw);
        }
        this.zzx = l + this.zzt.zzf().zzi(string, zzeg.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            string = this.zzt.zzaw();
            string = AdvertisingIdClient.getAdvertisingIdInfo((Context)string);
            this.zzv = "";
            string2 = string.getId();
            if (string2 != null) {
                this.zzv = string2;
            }
            this.zzw = string.isLimitAdTrackingEnabled();
        }
        catch (Exception exception) {
            this.zzt.zzaA().zzc().zzb("Unable to get advertising id", exception);
            this.zzv = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzv, (Object)this.zzw);
    }

    @WorkerThread
    final zzai zzc() {
        this.zzg();
        return zzai.zzb(this.zza().getString("consent_settings", "G1"));
    }

    @WorkerThread
    final Boolean zzd() {
        this.zzg();
        if (this.zza().contains("measurement_enabled")) {
            return this.zza().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    zzfi(zzgd object) {
        super((zzgd)object);
        object = "session_timeout";
        this.zzf = new zzfe(this, (String)object, 1800000L);
        object = "start_new_session";
        this.zzg = new zzfc(this, (String)object, true);
        object = "last_pause_time";
        this.zzj = new zzfe(this, (String)object, 0L);
        object = "session_id";
        this.zzk = new zzfe(this, (String)object, 0L);
        object = "non_personalized_ads";
        this.zzh = new zzfh(this, (String)object, null);
        object = "allow_remote_dynamite";
        this.zzi = new zzfc(this, (String)object, false);
        object = "first_open_time";
        this.zzc = new zzfe(this, (String)object, 0L);
        object = "app_install_time";
        this.zzd = new zzfe(this, (String)object, 0L);
        object = "app_instance_id";
        this.zze = new zzfh(this, (String)object, null);
        object = "app_backgrounded";
        this.zzm = new zzfc(this, (String)object, false);
        object = "deep_link_retrieval_complete";
        this.zzn = new zzfc(this, (String)object, false);
        object = "deep_link_retrieval_attempts";
        this.zzo = new zzfe(this, (String)object, 0L);
        object = "firebase_feature_rollouts";
        this.zzp = new zzfh(this, (String)object, null);
        object = "deferred_attribution_cache";
        this.zzq = new zzfh(this, (String)object, null);
        object = "deferred_attribution_cache_timestamp";
        this.zzr = new zzfe(this, (String)object, 0L);
        object = "default_event_parameters";
        this.zzs = new zzfd(this, (String)object, null);
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    @WorkerThread
    protected final void zzaC() {
        this.zzu = this.zzt.zzaw().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzl = this.zzu.getBoolean("has_been_opened", false);
        if (!this.zzl) {
            SharedPreferences.Editor editor = this.zzu.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzt.zzf();
        long l = Math.max(0L, (Long)zzeg.zzc.zza(null));
        this.zzb = new zzfg(this, "health_monitor", l, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzh(Boolean bl) {
        zzfi2.zzg();
        zzfi zzfi2 = zzfi2.zza().edit();
        if (bl != null) {
            zzfi2.putBoolean("measurement_enabled", bl);
        } else {
            zzfi2.remove("measurement_enabled");
        }
        zzfi2.apply();
    }

    @WorkerThread
    final void zzi(boolean bl) {
        this.zzg();
        this.zzt.zzaA().zzj().zzb("App measurement setting deferred collection", bl);
        SharedPreferences.Editor editor = this.zza().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzj() {
        zzfi zzfi2 = zzfi2.zzu;
        if (zzfi2 == null) {
            return false;
        }
        return zzfi2.contains("deferred_analytics_collection");
    }

    final boolean zzk(long l) {
        return l - this.zzf.zza() > this.zzj.zza();
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    @WorkerThread
    final boolean zzl(int n) {
        return zzai.zzj(n, this.zza().getInt("consent_source", 100));
    }
}

