/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzpb;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzes;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgy;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzeu
extends zzgy {
    private char zza = '\u0000';
    private long zzb = -1L;
    @GuardedBy(value="this")
    private String zzc;
    private final zzes zzd = new zzes(this, 6, false, false);
    private final zzes zze = new zzes(this, 6, true, false);
    private final zzes zzf = new zzes(this, 6, false, true);
    private final zzes zzg = new zzes(this, 5, false, false);
    private final zzes zzh = new zzes(this, 5, true, false);
    private final zzes zzi = new zzes(this, 5, false, true);
    private final zzes zzj = new zzes(this, 4, false, false);
    private final zzes zzk = new zzes(this, 3, false, false);
    private final zzes zzl = new zzes(this, 2, false, false);

    static /* bridge */ /* synthetic */ char zza(zzeu zzeu2) {
        return zzeu2.zza;
    }

    static /* bridge */ /* synthetic */ long zzb(zzeu zzeu2) {
        return zzeu2.zzb;
    }

    public final zzes zzc() {
        return this.zzk;
    }

    public final zzes zzd() {
        return this.zzd;
    }

    public final zzes zze() {
        return this.zzf;
    }

    public final zzes zzh() {
        return this.zze;
    }

    public final zzes zzi() {
        return this.zzj;
    }

    public final zzes zzj() {
        return this.zzl;
    }

    public final zzes zzk() {
        return this.zzg;
    }

    public final zzes zzl() {
        return this.zzi;
    }

    public final zzes zzm() {
        return this.zzh;
    }

    protected static Object zzn(String string) {
        if (string == null) {
            return null;
        }
        return new zzet(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    static String zzo(boolean bl, String string, Object object, Object object2, Object object3) {
        String string2;
        object = zzeu.zzp(bl, object);
        object2 = zzeu.zzp(bl, object2);
        object3 = zzeu.zzp(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null) {
            string = "";
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string2 = ": ";
        } else {
            string2 = "";
        }
        if (!TextUtils.isEmpty((CharSequence)object)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object);
            string2 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)object2)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object2);
            string2 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)object3)) {
            stringBuilder.append(string2);
            stringBuilder.append((String)object3);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static String zzp(boolean bl, Object object) {
        int n;
        String string;
        StringBuilder stringBuilder;
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return object.toString();
            }
            Object object2 = (Long)object;
            if (Math.abs((Long)object2) < 100L) {
                return object.toString();
            }
            char c = object.toString().charAt(0);
            object2 = String.valueOf(Math.abs((Long)object2));
            long l = Math.round(Math.pow(10.0, ((String)object2).length() + -1));
            long l2 = Math.round(Math.pow(10.0, ((String)object2).length()) + -1.0);
            object = new StringBuilder();
            object2 = c == '-' ? "-" : "";
            ((StringBuilder)object).append((String)object2);
            ((StringBuilder)object).append(l);
            ((StringBuilder)object).append("...");
            ((StringBuilder)object).append((String)object2);
            ((StringBuilder)object).append(l2);
            return ((StringBuilder)object).toString();
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Throwable) {
            object = (Throwable)object;
            String string2 = bl ? object.getClass().getName() : ((Throwable)object).toString();
            stringBuilder = new StringBuilder(string2);
            string = zzeu.zzq(zzge.class.getCanonicalName());
            object = ((Throwable)object).getStackTrace();
            n = ((Object)object).length;
        } else {
            if (object instanceof zzet) {
                return zzet.zza((zzet)object);
            }
            if (!bl) return object.toString();
            return "-";
        }
        for (int i = 0; i < n; ++i) {
            String string3;
            Object object3 = object[i];
            if (((StackTraceElement)object3).isNativeMethod() || (string3 = ((StackTraceElement)object3).getClassName()) == null || !zzeu.zzq(string3).equals(string)) continue;
            stringBuilder.append(": ");
            stringBuilder.append(object3);
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    static String zzq(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            zzpb.zzc();
            if (((Boolean)zzeh.zzay.zza(null)).booleanValue()) {
                return "";
            }
            return string;
        }
        return string.substring(0, n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EnsuresNonNull(value={"logTagDoNotUseDirectly"})
    @VisibleForTesting
    protected final String zzr() {
        synchronized (this) {
            Object object = this.zzc;
            if (object == null) {
                object = this.zzt.zzy();
                if (object != null) {
                    this.zzc = this.zzt.zzy();
                } else {
                    object = this.zzt.zzf();
                    this.zzc = ((zzag)object).zzn();
                }
            }
            Preconditions.checkNotNull((Object)this.zzc);
            return this.zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    static /* bridge */ /* synthetic */ void zzs(zzeu zzeu2, long l) {
        zzeu2.zzb = 77000L;
    }

    static /* bridge */ /* synthetic */ void zzt(zzeu zzeu2, char c) {
        zzeu2.zza = c;
    }

    zzeu(zzge zzge2) {
        super(zzge2);
    }

    protected final void zzu(int n, boolean bl, boolean bl2, String string, Object object, Object object2, Object object3) {
        if (!bl && Log.isLoggable((String)this.zzr(), (int)n)) {
            String string2 = zzeu.zzo(false, string, object, object2, object3);
            Log.println((int)n, (String)this.zzr(), (String)string2);
        }
        if (!bl2 && n >= 5) {
            Preconditions.checkNotNull((Object)string);
            zzgb zzgb2 = this.zzt.zzo();
            if (zzgb2 == null) {
                Log.println((int)6, (String)this.zzr(), (String)"Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzgb2.zzy()) {
                Log.println((int)6, (String)this.zzr(), (String)"Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n >= 9) {
                n = 8;
            }
            zzgb2.zzp(new zzer(this, n, string, object, object2, object3));
            return;
        }
    }

    @Override
    protected final boolean zzf() {
        return false;
    }
}

