/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzjt;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzjv;
import com.google.android.gms.measurement.internal.zzjw;
import com.google.android.gms.measurement.internal.zzjy;

@VisibleForTesting
public final class zzjx
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzeq zzc;
    final /* synthetic */ zzjy zza;

    static /* bridge */ /* synthetic */ void zza(zzjx zzjx2, boolean bl) {
        zzjx2.zzb = false;
    }

    protected zzjx(zzjy zzjy2) {
        this.zza = zzjy2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzb(Intent object) {
        ((zzgx)this.zza).zzg();
        Context context = this.zza.zzt.zzaw();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        synchronized (this) {
            boolean bl = this.zzb;
            if (bl) {
                object = this.zza;
                object = ((zzgx)object).zzt.zzaA();
                ((zzeu)object).zzj().zza("Connection attempt already in progress");
                return;
            }
            zzgx zzgx2 = this.zza;
            zzgx2 = zzgx2.zzt.zzaA();
            ((zzeu)zzgx2).zzj().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, (Intent)object, (ServiceConnection)zzjy.zzi(this.zza), 129);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzc() {
        ((zzgx)this.zza).zzg();
        Object object = this.zza.zzt.zzaw();
        synchronized (this) {
            boolean bl;
            boolean bl2 = this.zzb;
            if (bl2) {
                object = this.zza;
                object = ((zzgx)object).zzt.zzaA();
                ((zzeu)object).zzj().zza("Connection attempt already in progress");
                return;
            }
            zzeq zzeq2 = this.zzc;
            if (zzeq2 != null && ((bl = this.zzc.isConnecting()) || (bl = this.zzc.isConnected()))) {
                object = this.zza;
                object = ((zzgx)object).zzt.zzaA();
                ((zzeu)object).zzj().zza("Already awaiting connection attempt");
                return;
            }
            zzjx zzjx2 = this;
            this.zzc = new zzeq((Context)object, Looper.getMainLooper(), zzjx2, zzjx2);
            object = this.zza;
            object = ((zzgx)object).zzt.zzaA();
            ((zzeu)object).zzj().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final void zzd() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onConnected(Bundle object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        // MONITORENTER : this
        try {
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            object = (zzek)this.zzc.getService();
            zzgx zzgx2 = this.zza;
            zzgx2 = zzgx2.zzt.zzaB();
            ((zzgb)zzgx2).zzp(new zzju(this, (zzek)object));
            // MONITOREXIT : this
            return;
        }
        catch (DeadObjectException | IllegalStateException throwable) {
            this.zzc = null;
            this.zzb = false;
            return;
            {
                catch (Throwable throwable2) {}
                {
                    // MONITOREXIT : this
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzeu zzeu2 = this.zza.zzt.zzl();
        if (zzeu2 != null) {
            zzeu2.zzk().zzb("Service connection failed", connectionResult);
        }
        synchronized (this) {
            this.zzb = false;
            this.zzc = null;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        this.zza.zzt.zzaB().zzp(new zzjw(this));
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        this.zza.zzt.zzaA().zzc().zza("Service connection suspended");
        this.zza.zzt.zzaB().zzp(new zzjv(this));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onServiceConnected(ComponentName object, IBinder object2) {
        block13: {
            Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
            // MONITORENTER : this
            if (object2 == null) {
                this.zzb = false;
                object = this.zza;
                object = ((zzgx)object).zzt.zzaA();
                ((zzeu)object).zzd().zza("Service connected with null binder");
                // MONITOREXIT : this
                return;
            }
            try {
                object = object2.getInterfaceDescriptor();
                boolean bl = "com.google.android.gms.measurement.internal.IMeasurementService".equals(object);
                if (bl) {
                    object = object2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService");
                    bl = object instanceof zzek;
                    object = bl ? (zzek)object : new zzei((IBinder)object2);
                    object2 = this.zza;
                    object2 = ((zzgx)object2).zzt.zzaA();
                    ((zzeu)object2).zzj().zza("Bound to IMeasurementService interface");
                    break block13;
                }
                object2 = this.zza;
                object2 = ((zzgx)object2).zzt.zzaA();
                ((zzeu)object2).zzd().zzb("Got binder with a wrong descriptor", object);
                object = null;
            }
            catch (RemoteException remoteException) {
                block14: {
                    object = null;
                    break block14;
                    catch (RemoteException remoteException2) {}
                }
                object2 = this.zza;
                object2 = ((zzgx)object2).zzt.zzaA();
                ((zzeu)object2).zzd().zza("Service connect failed to get IMeasurementService");
            }
        }
        if (object != null) {
            object2 = this.zza;
            object2 = ((zzgx)object2).zzt.zzaB();
            ((zzgb)object2).zzp(new zzjs(this, (zzek)object));
            return;
        }
        this.zzb = false;
        try {
            object = ConnectionTracker.getInstance();
            object2 = this.zza;
            object2 = ((zzgx)object2).zzt.zzaw();
            object.unbindService((Context)object2, (ServiceConnection)zzjy.zzi(this.zza));
            // MONITOREXIT : this
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        this.zza.zzt.zzaA().zzc().zza("Service disconnected");
        this.zza.zzt.zzaB().zzp(new zzjt(this, componentName));
    }
}

