/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzlp;
import java.util.Map;

public final class zzd
extends zze {
    private final Map zza;
    private final Map zzb = new ArrayMap();
    private long zzc;

    static /* synthetic */ void zza(zzd zzd2, String string, long l) {
        Integer n;
        ((zzgw)zzd2).zzg();
        Preconditions.checkNotEmpty((String)string);
        if (zzd2.zzb.isEmpty()) {
            zzd2.zzc = l;
        }
        if ((n = (Integer)zzd2.zzb.get(string)) != null) {
            zzd2.zzb.put(string, n + 1);
            return;
        }
        if (zzd2.zzb.size() >= 100) {
            zzd2.zzt.zzaA().zzk().zza("Too many ads visible");
            return;
        }
        zzd2.zzb.put(string, 1);
        zzd2.zza.put(string, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* synthetic */ void zzb(zzd zzd2, String string, long l) {
        ((zzgw)zzd2).zzg();
        Preconditions.checkNotEmpty((String)string);
        Integer n = (Integer)zzd2.zzb.get(string);
        if (n == null) {
            zzd2.zzt.zzaA().zzd().zzb("Call to endAdUnitExposure for unknown ad unit id", string);
            return;
        }
        zzir zzir2 = zzd2.zzt.zzs().zzj(false);
        int n2 = n + -1;
        if (n2 != 0) {
            zzd2.zzb.put(string, n2);
            return;
        }
        zzd2.zzb.remove(string);
        Long l2 = (Long)zzd2.zza.get(string);
        if (l2 == null) {
            zzd2.zzt.zzaA().zzd().zza("First ad unit exposure time was never set");
        } else {
            long l3 = l - l2;
            zzd2.zza.remove(string);
            zzd2.zzi(string, l3, zzir2);
        }
        if (!zzd2.zzb.isEmpty()) {
            return;
        }
        long l4 = zzd2.zzc;
        if (l4 == 0L) {
            zzd2.zzt.zzaA().zzd().zza("First ad exposure time was never set");
            return;
        }
        zzd2.zzh(l - l4, zzir2);
        zzd2.zzc = 0L;
    }

    static /* bridge */ /* synthetic */ void zzc(zzd zzd2, long l) {
        zzd2.zzj(l);
    }

    public zzd(zzgd zzgd2) {
        super(zzgd2);
        this.zza = new ArrayMap();
    }

    public final void zzd(String string, long l) {
        if (string == null || string.length() == 0) {
            this.zzt.zzaA().zzd().zza("Ad unit id must be a non-empty string");
            return;
        }
        this.zzt.zzaB().zzp(new zza(this, string, l));
    }

    public final void zze(String string, long l) {
        if (string == null || string.length() == 0) {
            this.zzt.zzaA().zzd().zza("Ad unit id must be a non-empty string");
            return;
        }
        this.zzt.zzaB().zzp(new zzb(this, string, l));
    }

    @WorkerThread
    private final void zzh(long l, zzir zzir2) {
        if (zzir2 == null) {
            this.zzt.zzaA().zzj().zza("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzt.zzaA().zzj().zzb("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzlp.zzK(zzir2, bundle, true);
        this.zzt.zzq().zzG("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zzi(String string, long l, zzir zzir2) {
        if (zzir2 == null) {
            this.zzt.zzaA().zzj().zza("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzt.zzaA().zzj().zzb("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzlp.zzK(zzir2, bundle, true);
        this.zzt.zzq().zzG("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzf(long l) {
        zzir zzir2 = this.zzt.zzs().zzj(false);
        for (String string : this.zza.keySet()) {
            this.zzi(string, l - (Long)this.zza.get(string), zzir2);
        }
        if (!this.zza.isEmpty()) {
            this.zzh(l - this.zzc, zzir2);
        }
        this.zzj(l);
    }

    @WorkerThread
    private final void zzj(long l) {
        for (String string : this.zza.keySet()) {
            this.zza.put(string, l);
        }
        if (!this.zza.isEmpty()) {
            this.zzc = l;
            return;
        }
    }
}

