/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzpq;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzjz;
import com.google.android.gms.measurement.internal.zzln;
import com.google.android.gms.measurement.internal.zzlo;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzlp
extends zzgx {
    private static final String[] zza;
    private static final String[] zzb;
    private SecureRandom zzc;
    private final AtomicLong zzd = new AtomicLong(0L);
    private int zze;
    private Integer zzf = null;

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final int zza(String object, String string, String string2, Object object2, Bundle bundle, List list, boolean bl, boolean bl2) {
        Object object3;
        int n;
        int n2;
        block17: {
            block18: {
                block21: {
                    block22: {
                        Object object4;
                        block23: {
                            int n3;
                            boolean bl3;
                            block20: {
                                block19: {
                                    ((zzgw)object3).zzg();
                                    if (!((zzlp)object3).zzag(object2)) break block18;
                                    if (!bl2) return 21;
                                    if (!zzlp.zzau(string2, zzhd.zzc)) {
                                        return 20;
                                    }
                                    zzjz zzjz2 = ((zzlp)object3).zzt.zzt();
                                    ((zzgw)zzjz2).zzg();
                                    zzjz2.zza();
                                    if (zzjz2.zzN() && zzjz2.zzt.zzv().zzm() < 200900) {
                                        return 25;
                                    }
                                    ((zzgw)object3).zzt.zzf();
                                    bl3 = object2 instanceof Parcelable[];
                                    if (!bl3) break block19;
                                    n3 = ((Parcelable[])object2).length;
                                    break block20;
                                }
                                if (!(object2 instanceof ArrayList)) break block21;
                                n3 = ((ArrayList)object2).size();
                            }
                            if (n3 <= 200) break block22;
                            object4 = Integer.valueOf(n3);
                            ((zzgw)object3).zzt.zzaA().zzl().zzd("Parameter array is too long; discarded. Value kind, name, array length", "param", string2, object4);
                            ((zzgw)object3).zzt.zzf();
                            if (!bl3) break block23;
                            object4 = (Parcelable[])object2;
                            if (((Parcelable[])object4).length > 200) {
                                bundle.putParcelableArray(string2, (Parcelable[])Arrays.copyOf(object4, 200));
                                n2 = 17;
                                break block17;
                            } else {
                                n2 = 17;
                            }
                            break block17;
                        }
                        if (object2 instanceof ArrayList) {
                            object4 = (ArrayList)object2;
                            if (((ArrayList)object4).size() > 200) {
                                bundle.putParcelableArrayList(string2, new ArrayList(((ArrayList)object4).subList(0, 200)));
                                n2 = 17;
                                break block17;
                            } else {
                                n2 = 17;
                            }
                            break block17;
                        } else {
                            n2 = 17;
                        }
                        break block17;
                    }
                    n2 = 0;
                    break block17;
                }
                n2 = 0;
                break block17;
            }
            n2 = 0;
        }
        if (zzlp.zzaj(string) || zzlp.zzaj(string2)) {
            ((zzgw)object3).zzt.zzf();
            n = 256;
        } else {
            ((zzgw)object3).zzt.zzf();
            n = 100;
        }
        if (((zzlp)object3).zzab("param", string2, n, object2)) {
            return n2;
        }
        if (!bl2) return 4;
        if (object2 instanceof Bundle) {
            ((zzlp)object3).zzX((String)object, string, string2, (Bundle)object2, list, bl);
            return n2;
        }
        if (object2 instanceof Parcelable[]) {
            Parcelable[] parcelableArray = (Parcelable[])object2;
            n = parcelableArray.length;
            int n4 = 0;
            while (n4 < n) {
                Parcelable parcelable = parcelableArray[n4];
                if (!(parcelable instanceof Bundle)) {
                    object3 = parcelable.getClass();
                    ((zzgw)object3).zzt.zzaA().zzl().zzc("All Parcelable[] elements must be of type Bundle. Value type, name", object3, string2);
                    return 4;
                }
                ((zzlp)object3).zzX((String)object, string, string2, (Bundle)parcelable, list, bl);
                ++n4;
            }
            return n2;
        }
        if (!(object2 instanceof ArrayList)) return 4;
        ArrayList arrayList = (ArrayList)object2;
        n = arrayList.size();
        int n5 = 0;
        while (n5 < n) {
            Object e = arrayList.get(n5);
            if (!(e instanceof Bundle)) {
                object = ((zzgw)object3).zzt.zzaA().zzl();
                object3 = e != null ? e.getClass() : "null";
                ((zzer)object).zzc("All ArrayList elements must be of type Bundle. Value type, name", object3, string2);
                return 4;
            }
            ((zzlp)object3).zzX((String)object, string, string2, (Bundle)e, list, bl);
            ++n5;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    final int zzd(String string, Object object) {
        boolean bl;
        if ("_ldl".equals(string)) {
            int n = this.zzas(string);
            bl = this.zzab("user property referrer", string, n, object);
        } else {
            int n = this.zzas(string);
            bl = this.zzab("user property", string, n, object);
        }
        if (bl) {
            return 0;
        }
        return 7;
    }

    final int zzh(String string) {
        if (!this.zzac("event", string)) {
            return 2;
        }
        if (!this.zzaa("event", zzhc.zza, zzhc.zzb, string)) {
            return 13;
        }
        this.zzt.zzf();
        if (!this.zzZ("event", 40, string)) {
            return 2;
        }
        return 0;
    }

    final int zzi(String string) {
        if (!this.zzac("event param", string)) {
            return 3;
        }
        if (!this.zzaa("event param", null, null, string)) {
            return 14;
        }
        this.zzt.zzf();
        if (!this.zzZ("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final int zzj(String string) {
        if (!this.zzad("event param", string)) {
            return 3;
        }
        if (!this.zzaa("event param", null, null, string)) {
            return 14;
        }
        this.zzt.zzf();
        if (!this.zzZ("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final int zzl(String string) {
        if (!this.zzac("user property", string)) {
            return 6;
        }
        if (!this.zzaa("user property", zzhe.zza, null, string)) {
            return 15;
        }
        this.zzt.zzf();
        if (!this.zzZ("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    @EnsuresNonNull(value={"this.apkVersion"})
    public final int zzm() {
        if (this.zzf == null) {
            this.zzf = GoogleApiAvailabilityLight.getInstance().getApkVersion(this.zzt.zzaw()) / 1000;
        }
        return this.zzf;
    }

    private final int zzas(String string) {
        if ("_ldl".equals(string)) {
            this.zzt.zzf();
            return 2048;
        }
        if ("_id".equals(string)) {
            this.zzt.zzf();
            return 256;
        }
        if ("_lgclid".equals(string)) {
            this.zzt.zzf();
            return 100;
        }
        this.zzt.zzf();
        return 36;
    }

    public final int zzo(int n) {
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(this.zzt.zzaw(), 12451000);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static long zzp(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        int n = byArray.length;
        int n2 = n > 0 ? 1 : 0;
        Preconditions.checkState(n2 != 0);
        long l = 0L;
        n2 = 0;
        --n;
        while (n >= 0 && n >= byArray.length + -8) {
            l += ((long)byArray[n] & 0xFFL) << n2;
            n2 += 8;
            --n;
        }
        return l;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzq() {
        if (this.zzd.get() == 0L) {
            AtomicLong atomicLong = this.zzd;
            synchronized (atomicLong) {
                long l = System.nanoTime();
                Clock clock = this.zzt.zzax();
                Random random = new Random(l ^ clock.currentTimeMillis());
                long l2 = random.nextLong();
                int n = this.zze;
                this.zze = ++n;
                return l2 + (long)n;
            }
        }
        AtomicLong atomicLong = this.zzd;
        synchronized (atomicLong) {
            this.zzd.compareAndSet(-1L, 1L);
            return this.zzd.getAndIncrement();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final long zzr(long l, long l2) {
        return (l + l2 * 60000L) / 86400000L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Bundle zzs(Uri uri, boolean bl) {
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        block22: {
            Object object2;
            block20: {
                block21: {
                    Object object3;
                    if (uri == null) {
                        return null;
                    }
                    try {
                        boolean bl2 = uri.isHierarchical();
                        if (!bl2) break block20;
                        string6 = uri.getQueryParameter("utm_campaign");
                        string5 = uri.getQueryParameter("utm_source");
                        string4 = uri.getQueryParameter("utm_medium");
                        string3 = uri.getQueryParameter("gclid");
                        string2 = uri.getQueryParameter("utm_id");
                        string = uri.getQueryParameter("dclid");
                        object = uri.getQueryParameter("srsltid");
                        if (!bl) break block21;
                        object3 = object2 = uri.getQueryParameter("sfmc_id");
                        object2 = string6;
                        string6 = string5;
                        string5 = string4;
                        string4 = string3;
                        string3 = string2;
                        string2 = string;
                        string = object;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        ((zzgw)object2).zzt.zzaA().zzk().zzb("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
                        return null;
                    }
                    object = object3;
                    break block22;
                }
                object2 = string6;
                string6 = string5;
                string5 = string4;
                string4 = string3;
                string3 = string2;
                string2 = string;
                string = object;
                object = null;
                break block22;
            }
            object2 = null;
            string6 = null;
            string5 = null;
            string4 = null;
            string3 = null;
            string2 = null;
            string = null;
            object = null;
        }
        if (!(TextUtils.isEmpty((CharSequence)object2) && TextUtils.isEmpty((CharSequence)string6) && TextUtils.isEmpty((CharSequence)string5) && TextUtils.isEmpty((CharSequence)string4) && TextUtils.isEmpty((CharSequence)string3) && TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string) && (!bl || TextUtils.isEmpty((CharSequence)object)))) {
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)object2)) {
                bundle.putString("campaign", (String)object2);
            }
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                bundle.putString("source", string6);
            }
            if (!TextUtils.isEmpty((CharSequence)string5)) {
                bundle.putString("medium", string5);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                bundle.putString("gclid", string4);
            }
            if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("utm_term")))) {
                bundle.putString("term", (String)object2);
            }
            if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("utm_content")))) {
                bundle.putString("content", (String)object2);
            }
            if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("aclid")))) {
                bundle.putString("aclid", (String)object2);
            }
            if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("cp1")))) {
                bundle.putString("cp1", (String)object2);
            }
            if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("anid")))) {
                bundle.putString("anid", (String)object2);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                bundle.putString("campaign_id", string3);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                bundle.putString("dclid", string2);
            }
            if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("utm_source_platform")))) {
                bundle.putString("source_platform", (String)object2);
            }
            if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("utm_creative_format")))) {
                bundle.putString("creative_format", (String)object2);
            }
            if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("utm_marketing_tactic")))) {
                bundle.putString("marketing_tactic", (String)object2);
            }
            if (!TextUtils.isEmpty((CharSequence)string)) {
                bundle.putString("srsltid", string);
            }
            if (bl && !TextUtils.isEmpty((CharSequence)object)) {
                bundle.putString("sfmc_id", (String)object);
            }
            return bundle;
        }
        return null;
    }

    final Bundle zzt(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            Iterator iterator = bundle.keySet().iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = (String)iterator.next();
                Object object = this.zzA(string2, bundle.get(string2));
                if (object == null) {
                    string = this.zzt.zzj().zze(string);
                    this.zzt.zzaA().zzl().zzb("Param value can't be null", string);
                    continue;
                }
                this.zzP(bundle2, string, object);
            }
        }
        return bundle2;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Bundle zzu(String string, String string2, Bundle bundle, List list, boolean bl) {
        boolean bl2 = zzlp.zzau(string2, zzhc.zzd);
        if (bundle == null) {
            return null;
        }
        Bundle bundle2 = new Bundle(bundle);
        int n = this.zzt.zzf().zzc();
        Iterator iterator = new TreeSet(bundle.keySet()).iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string3;
            int n3;
            String string4 = (String)iterator.next();
            if (list == null || !list.contains(string4)) {
                n3 = !bl ? this.zzj(string4) : 0;
                if (n3 == 0) {
                    n3 = this.zzi(string4);
                }
            } else {
                n3 = 0;
            }
            if (n3 != 0) {
                String string5 = n3 == 3 ? string4 : null;
                String string6 = string4;
                this.zzJ(bundle2, n3, string6, string6, string5);
                bundle2.remove(string4);
                continue;
            }
            String string7 = string4;
            int n4 = this.zza(string, string2, string7, bundle.get(string7), bundle2, list, bl, bl2);
            if (n4 == 17) {
                String string8 = string4;
                this.zzJ(bundle2, 17, string8, string8, false);
            } else if (n4 != 0 && !"_ev".equals(string4)) {
                string3 = n4 == 21 ? string2 : string4;
            }
            if (!zzlp.zzak(string4) || ++n2 <= n) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Event can't contain more than ");
            stringBuilder.append(n);
            stringBuilder.append(" params");
            String string9 = stringBuilder.toString();
            this.zzt.zzaA().zze().zzc(string9, this.zzt.zzj().zzd(string2), this.zzt.zzj().zzb(bundle));
            zzlp.zzaq(bundle2, 5);
            bundle2.remove(string4);
            continue;
            String string10 = string4;
            this.zzJ(bundle2, n4, string3, string10, bundle.get(string10));
            bundle2.remove(string4);
        }
        return bundle2;
    }

    /*
     * Enabled aggressive block sorting
     */
    final zzau zzz(String string, String string2, Bundle bundle, String string3, long l, boolean bl, boolean bl2) {
        Object object;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        if (((zzlp)object).zzh(string2) != 0) {
            object = ((zzgw)object).zzt.zzj().zzf(string2);
            ((zzgw)object).zzt.zzaA().zzd().zzb("Invalid conditional property event name", object);
            throw new IllegalArgumentException();
        }
        bundle = bundle != null ? new Bundle(bundle) : new Bundle();
        bundle.putString("_o", string3);
        string = ((zzlp)object).zzu(string, string2, bundle, CollectionUtils.listOf((Object)"_o"), true);
        object = bl ? ((zzlp)object).zzt((Bundle)string) : string;
        Preconditions.checkNotNull((Object)object);
        return new zzau(string2, new zzas((Bundle)object), string3, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Object zzA(String string, Object object) {
        int n;
        if ("_ev".equals(string)) {
            this.zzt.zzf();
            return this.zzat(256, object, true, true);
        }
        if (zzlp.zzaj(string)) {
            this.zzt.zzf();
            n = 256;
            return this.zzat(n, object, false, true);
        }
        this.zzt.zzf();
        n = 100;
        return this.zzat(n, object, false, true);
    }

    final Object zzB(String string, Object object) {
        if ("_ldl".equals(string)) {
            zzlp zzlp2 = this;
            return zzlp2.zzat(zzlp2.zzas(string), object, true, false);
        }
        zzlp zzlp3 = this;
        return zzlp3.zzat(zzlp3.zzas(string), object, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object zzat(int n, Object parcelableArray, boolean bl, boolean n2) {
        if (parcelableArray == null) {
            return null;
        }
        if (parcelableArray instanceof Long || parcelableArray instanceof Double) {
            return parcelableArray;
        }
        if (parcelableArray instanceof Integer) {
            return (long)((Integer)parcelableArray).intValue();
        }
        if (parcelableArray instanceof Byte) {
            return (long)((Byte)parcelableArray).byteValue();
        }
        if (parcelableArray instanceof Short) {
            return (long)((Short)parcelableArray).shortValue();
        }
        if (parcelableArray instanceof Boolean) {
            long l;
            if (!((Boolean)parcelableArray).booleanValue()) {
                l = 0L;
                return l;
            }
            l = 1L;
            return l;
        }
        if (parcelableArray instanceof Float) {
            return ((Float)parcelableArray).doubleValue();
        }
        if (parcelableArray instanceof String || parcelableArray instanceof Character || parcelableArray instanceof CharSequence) {
            return this.zzD(parcelableArray.toString(), n, bl);
        }
        if (n2 == 0 || !(parcelableArray instanceof Bundle[]) && !(parcelableArray instanceof Parcelable[])) return null;
        ArrayList<Parcelable> arrayList = new ArrayList<Parcelable>();
        for (Parcelable parcelable : parcelableArray) {
            if (!(parcelable instanceof Bundle) || (parcelable = this.zzt((Bundle)parcelable)).isEmpty()) continue;
            arrayList.add(parcelable);
        }
        ArrayList<Parcelable> arrayList2 = arrayList;
        return arrayList2.toArray(new Bundle[arrayList2.size()]);
    }

    final String zzC() {
        byte[] byArray = new byte[16];
        objectArray.zzG().nextBytes(byArray);
        Object[] objectArray = new Object[]{new BigInteger(1, byArray)};
        return String.format(Locale.US, "%032x", objectArray);
    }

    public final String zzD(String string, int n, boolean bl) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string2.codePointCount(0, string2.length()) > n) {
            if (bl) {
                String string3 = string;
                return String.valueOf(string3.substring(0, string3.offsetByCodePoints(0, n))).concat("...");
            }
            return null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final URL zzE(long l, String string, String object, long l2) {
        Object object2;
        block4: {
            Preconditions.checkNotEmpty((String)object);
            Preconditions.checkNotEmpty((String)string);
            object = String.format("https://www.googleadservices.com/pagead/conversion/app/deeplink?id_type=adid&sdk_version=%s&rdid=%s&bundleid=%s&retry=%s", String.format("v%s.%s", 79000L, this.zzm()), object, string, l2);
            zzag zzag2 = this.zzt.zzf();
            boolean bl = string.equals(zzag2.zzm());
            if (!bl) break block4;
            try {
                object2 = ((String)object).concat("&ddl_test=1");
                return new URL((String)object2);
            }
            catch (IllegalArgumentException | MalformedURLException exception) {
                this.zzt.zzaA().zzd().zzb("Failed to create BOW URL for Deferred Deep Link. exception", exception.getMessage());
                return null;
            }
        }
        object2 = object;
        return new URL((String)object2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MessageDigest zzF() {
        int n = 0;
        while (n < 2) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (messageDigest != null) {
                    return messageDigest;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            ++n;
        }
        return null;
    }

    @EnsuresNonNull(value={"this.secureRandom"})
    @WorkerThread
    final SecureRandom zzG() {
        this.zzg();
        if (this.zzc == null) {
            this.zzc = new SecureRandom();
        }
        return this.zzc;
    }

    public static ArrayList zzH(List object) {
        if (object == null) {
            return new ArrayList(0);
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            AbstractSafeParcelable abstractSafeParcelable = (zzac)((Object)object.next());
            Bundle bundle = new Bundle();
            Object object2 = abstractSafeParcelable.zza;
            bundle.putString("app_id", (String)object2);
            object2 = abstractSafeParcelable.zzb;
            bundle.putString("origin", (String)object2);
            long l = abstractSafeParcelable.zzd;
            bundle.putLong("creation_timestamp", l);
            object2 = abstractSafeParcelable.zzc.zzb;
            bundle.putString("name", (String)object2);
            zzgz.zzb((Bundle)bundle, (Object)Preconditions.checkNotNull((Object)abstractSafeParcelable.zzc.zza()));
            boolean bl = abstractSafeParcelable.zze;
            bundle.putBoolean("active", bl);
            object2 = abstractSafeParcelable.zzf;
            if (object2 != null) {
                bundle.putString("trigger_event_name", (String)object2);
            }
            if ((object2 = abstractSafeParcelable.zzg) != null) {
                bundle.putString("timed_out_event_name", ((zzau)((Object)object2)).zza);
                object2 = ((zzau)((Object)object2)).zzb;
                if (object2 != null) {
                    bundle.putBundle("timed_out_event_params", ((zzas)object2).zzc());
                }
            }
            l = abstractSafeParcelable.zzh;
            bundle.putLong("trigger_timeout", l);
            object2 = abstractSafeParcelable.zzi;
            if (object2 != null) {
                bundle.putString("triggered_event_name", ((zzau)((Object)object2)).zza);
                object2 = ((zzau)((Object)object2)).zzb;
                if (object2 != null) {
                    bundle.putBundle("triggered_event_params", ((zzas)object2).zzc());
                }
            }
            l = abstractSafeParcelable.zzc.zzc;
            bundle.putLong("triggered_timestamp", l);
            l = abstractSafeParcelable.zzj;
            bundle.putLong("time_to_live", l);
            abstractSafeParcelable = abstractSafeParcelable.zzk;
            if (abstractSafeParcelable != null) {
                bundle.putString("expired_event_name", abstractSafeParcelable.zza);
                abstractSafeParcelable = abstractSafeParcelable.zzb;
                if (abstractSafeParcelable != null) {
                    bundle.putBundle("expired_event_params", abstractSafeParcelable.zzc());
                }
            }
            arrayList.add(bundle);
        }
        return arrayList;
    }

    static {
        String string = "firebase_";
        zza = new String[]{string, "google_", "ga_"};
        string = "_err";
        zzb = new String[]{string};
    }

    zzlp(zzgd zzgd2) {
        super(zzgd2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzI(Bundle bundle, long l) {
        long l2;
        long l3 = bundle.getLong("_et");
        if (l3 != 0L) {
            this.zzt.zzaA().zzk().zzb("Params already contained engagement", l3);
            l2 = l3;
        } else {
            l2 = 0L;
        }
        bundle.putLong("_et", l += l2);
    }

    final void zzJ(Bundle bundle, int n, String string, String string2, Object object) {
        if (zzlp.zzaq(bundle, n)) {
            ((zzgw)((Object)string3)).zzt.zzf();
            String string3 = ((zzlp)((Object)string3)).zzD(string, 40, true);
            bundle.putString("_ev", string3);
            if (object != null) {
                Preconditions.checkNotNull((Object)bundle);
                if (object instanceof String || object instanceof CharSequence) {
                    int n2 = object.toString().length();
                    bundle.putLong("_el", (long)n2);
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public static void zzK(zzir zzir2, Bundle bundle, boolean bl) {
        if (bundle != null && zzir2 != null) {
            if (!bundle.containsKey("_sc") || bl) {
                String string = zzir2.zza;
                if (string != null) {
                    bundle.putString("_sn", string);
                } else {
                    bundle.remove("_sn");
                }
                if ((string = zzir2.zzb) != null) {
                    bundle.putString("_sc", string);
                } else {
                    bundle.remove("_sc");
                }
                long l = zzir2.zzc;
                bundle.putLong("_si", l);
                return;
            }
            bl = false;
        }
        if (bundle != null && zzir2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
            return;
        }
    }

    final void zzL(Bundle bundle, Bundle bundle2) {
        if (bundle2 == null) {
            return;
        }
        for (String string : bundle2.keySet()) {
            if (bundle.containsKey(string)) continue;
            String string2 = string;
            this.zzt.zzv().zzP(bundle, string2, bundle2.get(string2));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzM(Parcelable[] parcelableArray, int n, boolean bl) {
        Preconditions.checkNotNull((Object)parcelableArray);
        int n2 = parcelableArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Bundle bundle = (Bundle)parcelableArray[n3];
            Iterator iterator = new TreeSet(bundle.keySet()).iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!zzlp.zzak(string) || zzlp.zzau(string, zzhd.zzd) || ++n4 <= n) continue;
                if (bl) {
                    zzer zzer2 = this.zzt.zzaA().zze();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Param can't contain more than ");
                    stringBuilder.append(n);
                    stringBuilder.append(" item-scoped custom parameters");
                    zzer2.zzc(stringBuilder.toString(), this.zzt.zzj().zze(string), this.zzt.zzj().zzb(bundle));
                    zzlp.zzaq(bundle, 28);
                } else {
                    String string2 = this.zzt.zzj().zze(string);
                    String string3 = this.zzt.zzj().zzb(bundle);
                    this.zzt.zzaA().zze().zzc("Param cannot contain item-scoped custom parameters", string2, string3);
                    zzlp.zzaq(bundle, 23);
                }
                bundle.remove(string);
            }
            ++n3;
        }
        return;
    }

    final void zzN(zzeu zzeu2, int n) {
        Iterator iterator = new TreeSet(zzeu2.zzd.keySet()).iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!zzlp.zzak(string) || ++n2 <= n) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Event can't contain more than ");
            stringBuilder.append(n);
            stringBuilder.append(" params");
            String string2 = stringBuilder.toString();
            this.zzt.zzaA().zze().zzc(string2, this.zzt.zzj().zzd(zzeu2.zza), this.zzt.zzj().zzb(zzeu2.zzd));
            zzlp.zzaq(zzeu2.zzd, 5);
            zzeu2.zzd.remove(string);
        }
    }

    final void zzO(zzlo zzlo2, String string, int n, String string2, String string3, int n2) {
        zzlp zzlp2 = new Bundle();
        zzlp.zzaq((Bundle)zzlp2, n);
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            zzlp2.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            long l = n2;
            zzlp2.putLong("_el", l);
        }
        zzlo2.zza(string, "_err", (Bundle)zzlp2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @WorkerThread
    protected final void zzaC() {
        long l;
        this.zzg();
        SecureRandom secureRandom = new SecureRandom();
        long l2 = secureRandom.nextLong();
        if (l2 == 0L) {
            long l3 = secureRandom.nextLong();
            if (l3 == 0L) {
                this.zzt.zzaA().zzk().zza("Utils falling back to Random for random id");
                l = l3;
            } else {
                l = l3;
            }
        } else {
            l = l2;
        }
        this.zzd.set(l);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final void zzP(Bundle object, String string, Object object2) {
        void var1_3;
        void var2_5;
        void var3_6;
        if (object == null) {
            return;
        }
        if (var3_6 instanceof Long) {
            object.putLong((String)var2_5, ((Long)var3_6).longValue());
            return;
        }
        if (var3_6 instanceof String) {
            object.putString((String)var2_5, String.valueOf(var3_6));
            return;
        }
        if (var3_6 instanceof Double) {
            object.putDouble((String)var2_5, ((Double)var3_6).doubleValue());
            return;
        }
        if (var3_6 instanceof Bundle[]) {
            object.putParcelableArray((String)var2_5, (Parcelable[])((Bundle[])var3_6));
            return;
        }
        if (var2_5 == null) {
            return;
        }
        if (var3_6 != null) {
            String string2 = var3_6.getClass().getSimpleName();
        } else {
            Object var1_4 = null;
        }
        String string3 = ((zzgw)((Object)string3)).zzt.zzj().zze((String)var2_5);
        ((zzgw)((Object)string3)).zzt.zzaA().zzl().zzc("Not putting event parameter. Invalid value type. name, type", string3, var1_3);
    }

    public final void zzQ(zzcf zzcf2, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("r", bl);
        try {
            zzcf2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzt.zzaA().zzk().zzb("Error returning boolean value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzR(zzcf zzcf2, ArrayList arrayList) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("r", arrayList);
        try {
            zzcf2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzt.zzaA().zzk().zzb("Error returning bundle list to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzS(zzcf zzcf2, Bundle bundle) {
        try {
            zzcf2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzt.zzaA().zzk().zzb("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzT(zzcf zzcf2, byte[] byArray) {
        Bundle bundle = new Bundle();
        bundle.putByteArray("r", byArray);
        try {
            zzcf2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzt.zzaA().zzk().zzb("Error returning byte array to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzU(zzcf zzcf2, int n) {
        Bundle bundle = new Bundle();
        bundle.putInt("r", n);
        try {
            zzcf2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzt.zzaA().zzk().zzb("Error returning int value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzV(zzcf zzcf2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("r", l);
        try {
            zzcf2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzt.zzaA().zzk().zzb("Error returning long value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzW(zzcf zzcf2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("r", string);
        try {
            zzcf2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzt.zzaA().zzk().zzb("Error returning string value to wrapper", (Object)remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzX(String string, String string2, String string3, Bundle bundle, List list, boolean bl) {
        if (bundle == null) {
            return;
        }
        zzag zzag2 = this.zzt.zzf();
        zzpq.zzc();
        int n = zzag2.zzt.zzf().zzs(null, zzeg.zzaz) ? (zzag2.zzt.zzv().zzai(231100000, true) ? 35 : 0) : 0;
        Iterator iterator = new TreeSet(bundle.keySet()).iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string4;
            int n3;
            String string5 = (String)iterator.next();
            if (list == null || !list.contains(string5)) {
                n3 = !bl ? this.zzj(string5) : 0;
                if (n3 == 0) {
                    n3 = this.zzi(string5);
                }
            } else {
                n3 = 0;
            }
            if (n3 != 0) {
                string4 = n3 == 3 ? string5 : null;
                String string6 = string5;
                this.zzJ(bundle, n3, string6, string6, string4);
                bundle.remove(string5);
                continue;
            }
            if (this.zzag(bundle.get(string5))) {
                this.zzt.zzaA().zzl().zzd("Nested Bundle parameters are not allowed; discarded. event name, param name, child param name", string2, string3, string5);
                n3 = 22;
            } else {
                String string7 = string5;
                n3 = this.zza(string, string2, string7, bundle.get(string7), bundle, list, bl, false);
            }
            if (n3 != 0 && !"_ev".equals(string5)) {
                Bundle bundle2 = bundle;
                String string8 = string5;
                this.zzJ(bundle2, n3, string8, string8, bundle2.get(string8));
                bundle.remove(string5);
                continue;
            }
            if (!zzlp.zzak(string5) || zzlp.zzau(string5, zzhd.zzd)) continue;
            ++n2;
            if (!this.zzai(231100000, true)) {
                String string9 = this.zzt.zzj().zzd(string2);
                string4 = this.zzt.zzj().zzb(bundle);
                this.zzt.zzaA().zze().zzc("Item array not supported on client's version of Google Play Services (Android Only)", string9, string4);
                zzlp.zzaq(bundle, 23);
                bundle.remove(string5);
                continue;
            }
            if (n2 <= n) continue;
            zzpq.zzc();
            if (this.zzt.zzf().zzs(null, zzeg.zzaz)) {
                zzer zzer2 = this.zzt.zzaA().zze();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Item can't contain more than ");
                stringBuilder.append(n);
                stringBuilder.append(" item-scoped custom params");
                zzer2.zzc(stringBuilder.toString(), this.zzt.zzj().zzd(string2), this.zzt.zzj().zzb(bundle));
                zzlp.zzaq(bundle, 28);
                bundle.remove(string5);
                continue;
            }
            String string10 = this.zzt.zzj().zzd(string2);
            string4 = this.zzt.zzj().zzb(bundle);
            this.zzt.zzaA().zze().zzc("Item cannot contain custom parameters", string10, string4);
            zzlp.zzaq(bundle, 23);
            bundle.remove(string5);
        }
        return;
    }

    private static boolean zzau(String string, String[] stringArray) {
        Preconditions.checkNotNull((Object)stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!zzln.zza(string, stringArray[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    final boolean zzY(String string, String string2) {
        Object object;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (zzlp.zzar(string)) return true;
            if (!((zzlp)object).zzt.zzL()) return false;
            object = zzet.zzn(string);
            ((zzgw)object).zzt.zzaA().zze().zzb("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", object);
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (zzlp.zzar(string2)) {
                return true;
            }
            object = zzet.zzn(string2);
            ((zzgw)object).zzt.zzaA().zze().zzb("Invalid admob_app_id. Analytics disabled.", object);
            return false;
        }
        if (!((zzlp)object).zzt.zzL()) return false;
        ((zzgw)object).zzt.zzaA().zze().zza("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
        return false;
    }

    final boolean zzZ(String string, int n, String string2) {
        if (string2 == null) {
            ((zzgw)((Object)n2)).zzt.zzaA().zze().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        String string3 = string2;
        if (string3.codePointCount(0, string3.length()) > n) {
            Integer n2 = n;
            ((zzgw)((Object)n2)).zzt.zzaA().zze().zzd("Name is too long. Type, maximum supported length, name", string, n2, string2);
            return false;
        }
        return true;
    }

    final boolean zzaa(String string, String[] stringArray, String[] stringArray2, String string2) {
        if (string2 == null) {
            this.zzt.zzaA().zze().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        Preconditions.checkNotNull((Object)string2);
        String[] stringArray3 = zza;
        for (int i = 0; i < 3; ++i) {
            if (!string2.startsWith(stringArray3[i])) continue;
            this.zzt.zzaA().zze().zzc("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null && zzlp.zzau(string2, stringArray) && (stringArray2 == null || !zzlp.zzau(string2, stringArray2))) {
            this.zzt.zzaA().zze().zzc("Name is reserved. Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zzab(String string, String string2, int n, Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            Object object2 = object = object.toString();
            if (((String)object2).codePointCount(0, ((String)object2).length()) > n) {
                Integer n2 = ((String)object).length();
                ((zzgw)((Object)n2)).zzt.zzaA().zzl().zzd("Value is too long; discarded. Value kind, name, value length", string, string2, n2);
                return false;
            }
            return true;
        }
        return false;
    }

    final boolean zzac(String string, String string2) {
        block8: {
            int n;
            int n2;
            block7: {
                if (string2 == null) {
                    this.zzt.zzaA().zze().zzb("Name is required and can't be null. Type", string);
                    return false;
                }
                if (string2.length() == 0) {
                    this.zzt.zzaA().zze().zzb("Name is required and can't be empty. Type", string);
                    return false;
                }
                n2 = string2.codePointAt(0);
                if (Character.isLetter(n2)) break block7;
                if (n2 != 95) break block8;
                n2 = 95;
            }
            int n3 = string2.length();
            for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
                n = string2.codePointAt(n2);
                if (n == 95 || Character.isLetterOrDigit(n)) {
                    continue;
                }
                this.zzt.zzaA().zze().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
                return false;
            }
            return true;
        }
        this.zzt.zzaA().zze().zzc("Name must start with a letter or _ (underscore). Type, name", string, string2);
        return false;
    }

    final boolean zzad(String string, String string2) {
        int n;
        if (string2 == null) {
            this.zzt.zzaA().zze().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            this.zzt.zzaA().zze().zzb("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            this.zzt.zzaA().zze().zzc("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
            n = string2.codePointAt(n2);
            if (n == 95 || Character.isLetterOrDigit(n)) {
                continue;
            }
            this.zzt.zzaA().zze().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    @WorkerThread
    final boolean zzae(String string) {
        this.zzg();
        if (Wrappers.packageManager((Context)this.zzt.zzaw()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        this.zzt.zzaA().zzc().zzb("Permission not granted", string);
        return false;
    }

    final boolean zzaf(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String string2 = this.zzt.zzf().zzl();
        this.zzt.zzay();
        return string2.equals(string);
    }

    final boolean zzag(Object object) {
        return object instanceof Parcelable[] || object instanceof ArrayList || object instanceof Bundle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final boolean zzah(Context context, String signatureArray) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        context = Wrappers.packageManager((Context)context).getPackageInfo((String)signatureArray, 64);
        if (context == null) return true;
        signatureArray = context.signatures;
        if (signatureArray == null) return true;
        int n = context.signatures.length;
        if (n <= 0) return true;
        try {
            context = context.signatures[0];
            return ((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(context.toByteArray()))).getSubjectX500Principal().equals(x500Principal);
        }
        catch (CertificateException certificateException) {
            this.zzt.zzaA().zzd().zzb("Error obtaining certificate", certificateException);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzt.zzaA().zzd().zzb("Package name not found", (Object)nameNotFoundException);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zzai(int n, boolean bl) {
        Boolean bl2 = this.zzt.zzt().zzj();
        if (this.zzm() >= n / 1000) return true;
        if (bl2 == null) return false;
        if (bl2 != false) return false;
        return true;
    }

    static boolean zzaj(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    static boolean zzak(String string) {
        Preconditions.checkNotEmpty((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean zzal(Context context) {
        block6: {
            PackageManager packageManager;
            block5: {
                Preconditions.checkNotNull((Object)context);
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            context = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzav(Context context, String string) {
        block6: {
            PackageManager packageManager;
            block5: {
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            context = packageManager.getServiceInfo(new ComponentName(context, string), 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    static boolean zzam(Context context, boolean bl) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzlp.zzav(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzlp.zzav(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    public static boolean zzan(String string) {
        return !zzb[0].equals(string);
    }

    final boolean zzao(String string, String string2, String string3, String string4) {
        boolean bl = TextUtils.isEmpty((CharSequence)string);
        boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
        if (!bl && !bl2) {
            Preconditions.checkNotNull((Object)string);
            return !string.equals(string2);
        }
        if (bl && bl2) {
            if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string4)) {
                return !string3.equals(string4);
            }
            return !TextUtils.isEmpty((CharSequence)string4);
        }
        if (!bl) {
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
        }
        return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
    }

    final byte[] zzap(Parcelable object) {
        if (object == null) {
            return null;
        }
        zzlp zzlp2 = Parcel.obtain();
        try {
            object.writeToParcel((Parcel)zzlp2, 0);
            object = zzlp2.marshall();
        }
        catch (Throwable throwable) {
            zzlp2.recycle();
            throw throwable;
        }
        zzlp2.recycle();
        return object;
    }

    static final boolean zzaq(Bundle bundle, int n) {
        if (bundle == null) {
            return false;
        }
        if (bundle.getLong("_err") == 0L) {
            long l = n;
            bundle.putLong("_err", l);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static final boolean zzar(String string) {
        Preconditions.checkNotNull((Object)string);
        return string.matches("^(1:\\d+:android:[a-f0-9]+|ca-app-pub-.*)$");
    }
}

