/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.internal.measurement.zzfy;
import com.google.android.gms.internal.measurement.zzfz;
import com.google.android.gms.internal.measurement.zzgb;
import com.google.android.gms.internal.measurement.zzgc;
import com.google.android.gms.internal.measurement.zzgd;
import com.google.android.gms.internal.measurement.zzhn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzfw
implements zzgd {
    @GuardedBy(value="ConfigurationContentLoader.class")
    private static final Map<Uri, zzfw> zza = new ArrayMap();
    private static final String[] zzb = new String[]{"key", "value"};
    private final ContentResolver zzc;
    private final Uri zzd;
    private final Runnable zze;
    private final ContentObserver zzf = new zzfy(this, null);
    private final Object zzg = new Object();
    private volatile Map<String, String> zzh;
    @GuardedBy(value="this")
    private final List<zzgb> zzi = new ArrayList<zzgb>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzfw zza(ContentResolver contentResolver, Uri uri, Runnable runnable) {
        Class<zzfw> clazz = zzfw.class;
        synchronized (zzfw.class) {
            zzfw zzfw2 = zza.get(uri);
            if (zzfw2 == null) {
                try {
                    zzfw2 = new zzfw(contentResolver, uri, runnable);
                    zza.put(uri, zzfw2);
                }
                catch (SecurityException securityException) {}
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zzfw2;
        }
    }

    @Override
    public final /* synthetic */ Object zza(String string) {
        String string2 = string;
        return this.zza().get(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> zza() {
        Map<String, String> map = this.zzh;
        if (map == null) {
            Object object = this.zzg;
            synchronized (object) {
                map = this.zzh;
                if (map == null) {
                    this.zzh = map = this.zze();
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    final /* synthetic */ Map zzb() {
        Cursor cursor = this.zzc.query(this.zzd, zzb, null, null, null);
        if (cursor == null) {
            return Collections.emptyMap();
        }
        try {
            Object object;
            int n = cursor.getCount();
            if (n == 0) {
                Map map = Collections.emptyMap();
                return map;
            }
            Object object2 = object = n <= 256 ? new ArrayMap(n) : new HashMap(n, 1.0f);
            while (cursor.moveToNext()) {
                object.put(cursor.getString(0), cursor.getString(1));
            }
            Object object3 = object;
            return object3;
        }
        finally {
            cursor.close();
        }
    }

    @Nullable
    private final Map<String, String> zze() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            zzfw zzfw2 = this;
            Map map = (Map)zzgc.zza(new zzfz(zzfw2));
            return map;
        }
        catch (SQLiteException | IllegalStateException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLdr", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    private zzfw(ContentResolver contentResolver, Uri uri, Runnable runnable) {
        zzhn.zza((Object)contentResolver);
        zzhn.zza((Object)uri);
        this.zzc = contentResolver;
        this.zzd = uri;
        this.zze = runnable;
        contentResolver.registerContentObserver(uri, false, this.zzf);
    }

    static synchronized void zzc() {
        for (zzfw zzfw2 : zza.values()) {
            zzfw2.zzc.unregisterContentObserver(zzfw2.zzf);
        }
        zza.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzd() {
        zzfw zzfw2;
        Object object = this.zzg;
        synchronized (object) {
            this.zzh = null;
            this.zze.run();
        }
        zzfw zzfw3 = zzfw2 = this;
        synchronized (zzfw2) {
            Iterator<zzgb> iterator = zzfw2.zzi.iterator();
            while (iterator.hasNext()) {
                iterator.next().zza();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }
}

