/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzdd;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzql;
import com.google.android.gms.internal.measurement.zzqr;
import com.google.android.gms.internal.measurement.zzri;
import com.google.android.gms.internal.measurement.zzsg;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzay;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfg;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzil;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzjz;
import com.google.android.gms.measurement.internal.zzkb;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zzkq;
import com.google.android.gms.measurement.internal.zzly;
import com.google.android.gms.measurement.internal.zzne;
import com.google.android.gms.measurement.internal.zzp;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.json.JSONException;
import org.json.JSONObject;

public class zzhc
implements zzic {
    private static volatile @Nullable zzhc zzb;
    private final Context zzc;
    private final @Nullable String zzd;
    private final @Nullable String zze;
    private final @Nullable String zzf;
    private final boolean zzg;
    private final zzae zzh;
    private final zzaf zzi;
    private final zzge zzj;
    private final zzfs zzk;
    private final zzgz zzl;
    private final zzly zzm;
    private final zzne zzn;
    private final zzfn zzo;
    private final Clock zzp;
    private final zzki zzq;
    private final zzin zzr;
    private final zzb zzs;
    private final zzjz zzt;
    private final @Nullable String zzu;
    private zzfl zzv;
    private zzkq zzw;
    private zzba zzx;
    private zzfm zzy;
    private boolean zzz = false;
    private Boolean zzaa;
    private long zzab;
    private volatile @Nullable Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    @VisibleForTesting
    private Boolean zzae;
    private volatile boolean zzaf;
    private int zzag;
    private int zzah;
    private AtomicInteger zzai = new AtomicInteger(0);
    @VisibleForTesting
    final long zza;

    @WorkerThread
    public final int zzc() {
        ((zzia)this.zzl()).zzt();
        if (this.zzi.zzv()) {
            return 1;
        }
        if (this.zzae != null && this.zzae.booleanValue()) {
            return 2;
        }
        if (!this.zzad()) {
            return 8;
        }
        Boolean bl = this.zzn().zzu();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        zzaf zzaf2 = this.zzi;
        Boolean bl2 = zzaf2.zzg("firebase_analytics_collection_enabled");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzad != null) {
            if (this.zzad.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    @Override
    @Pure
    public final Context zza() {
        return this.zzc;
    }

    @Override
    @Pure
    public final Clock zzb() {
        return this.zzp;
    }

    @Pure
    public final zzb zze() {
        if (this.zzs == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzs;
    }

    @Override
    @Pure
    public final zzae zzd() {
        return this.zzh;
    }

    @Pure
    public final zzaf zzf() {
        return this.zzi;
    }

    @Pure
    public final zzba zzg() {
        zzhc.zza(this.zzx);
        return this.zzx;
    }

    @Pure
    public final zzfm zzh() {
        zzhc.zza(this.zzy);
        return this.zzy;
    }

    @Pure
    public final zzfl zzi() {
        zzhc.zza(this.zzv);
        return this.zzv;
    }

    @Pure
    public final zzfn zzk() {
        return this.zzo;
    }

    @Override
    @Pure
    public final zzfs zzj() {
        zzhc.zza(this.zzk);
        return this.zzk;
    }

    public final @Nullable zzfs zzm() {
        if (this.zzk != null && this.zzk.zzae()) {
            return this.zzk;
        }
        return null;
    }

    @Pure
    public final zzge zzn() {
        zzhc.zza((zzia)this.zzj);
        return this.zzj;
    }

    @Override
    @Pure
    public final zzgz zzl() {
        zzhc.zza(this.zzl);
        return this.zzl;
    }

    @SideEffectFree
    final @Nullable zzgz zzo() {
        return this.zzl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzhc zza(Context context, @Nullable zzdd zzdd2, @Nullable Long l) {
        if (zzdd2 != null && (zzdd2.zze == null || zzdd2.zzf == null)) {
            zzdd2 = new zzdd(zzdd2.zza, zzdd2.zzb, zzdd2.zzc, zzdd2.zzd, null, null, zzdd2.zzg, null);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb == null) {
            Class<zzhc> clazz = zzhc.class;
            synchronized (zzhc.class) {
                if (zzb == null) {
                    zzil zzil2 = new zzil(context, zzdd2, l);
                    zzb = new zzhc(zzil2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (zzdd2 != null && zzdd2.zzg != null && zzdd2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            Preconditions.checkNotNull((Object)zzb);
            zzb.zza(zzdd2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        {
            Preconditions.checkNotNull((Object)zzb);
            return zzb;
        }
    }

    @Pure
    public final zzin zzp() {
        zzhc.zza(this.zzr);
        return this.zzr;
    }

    @Pure
    private final zzjz zzai() {
        zzhc.zza(this.zzt);
        return this.zzt;
    }

    @Pure
    public final zzki zzq() {
        zzhc.zza(this.zzq);
        return this.zzq;
    }

    @Pure
    public final zzkq zzr() {
        zzhc.zza(this.zzw);
        return this.zzw;
    }

    @Pure
    public final zzly zzs() {
        zzhc.zza(this.zzm);
        return this.zzm;
    }

    @Pure
    public final zzne zzt() {
        zzhc.zza((zzia)this.zzn);
        return this.zzn;
    }

    @Pure
    public final @Nullable String zzu() {
        return this.zzd;
    }

    @Pure
    public final @Nullable String zzv() {
        return this.zze;
    }

    @Pure
    public final @Nullable String zzw() {
        return this.zzf;
    }

    @Pure
    public final @Nullable String zzx() {
        return this.zzu;
    }

    static /* synthetic */ void zza(zzhc zzhc2, zzil zzil2) {
        zzil zzil3 = zzil2;
        zzhc zzhc3 = zzhc2;
        ((zzia)zzhc3.zzl()).zzt();
        Object object = zzhc3;
        zzba zzba2 = new zzba((zzhc)object);
        zzba2.zzac();
        zzhc3.zzx = zzba2;
        zzhc zzhc4 = zzhc3;
        object = zzil3;
        zzfm zzfm2 = new zzfm(zzhc4, ((zzil)object).zzf);
        zzfm2.zzv();
        zzhc3.zzy = zzfm2;
        object = zzhc3;
        zzfl zzfl2 = new zzfl((zzhc)object);
        zzfl2.zzv();
        zzhc3.zzv = zzfl2;
        object = zzhc3;
        zzkq zzkq2 = new zzkq((zzhc)object);
        zzkq2.zzv();
        zzhc3.zzw = zzkq2;
        zzhc3.zzn.zzad();
        zzhc3.zzj.zzad();
        zzhc3.zzy.zzw();
        zzhc3.zzj().zzn().zza("App measurement initialized, version", 81010L);
        zzhc3.zzj().zzn().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string = zzfm2.zzad();
        if (TextUtils.isEmpty((CharSequence)zzhc3.zzd)) {
            if (zzhc3.zzt().zzf(string)) {
                zzhc3.zzj().zzn().zza("Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.");
            } else {
                String string2 = string;
                zzhc3.zzj().zzn().zza("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app " + string2);
            }
        }
        zzhc3.zzj().zzc().zza("Debug-level message logging enabled");
        if (zzhc3.zzag != zzhc3.zzai.get()) {
            zzhc3.zzj().zzg().zza("Not all components initialized", zzhc3.zzag, zzhc3.zzai.get());
        }
        zzhc3.zzz = true;
    }

    private zzhc(zzil zzil2) {
        Object object;
        Preconditions.checkNotNull((Object)zzil2);
        Object object2 = zzil2.zza;
        zzfg.zza = this.zzh = new zzae((Context)object2);
        this.zzc = zzil2.zza;
        this.zzd = zzil2.zzb;
        this.zze = zzil2.zzc;
        this.zzf = zzil2.zzd;
        this.zzg = zzil2.zzh;
        this.zzac = zzil2.zze;
        this.zzu = zzil2.zzj;
        this.zzaf = true;
        zzdd zzdd2 = zzil2.zzg;
        if (zzdd2 != null && zzdd2.zzg != null) {
            object = zzdd2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
            if ((object = zzdd2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzae = (Boolean)object;
            }
        }
        zzgl.zzb(this.zzc);
        this.zzp = DefaultClock.getInstance();
        this.zza = zzil2.zzi != null ? zzil2.zzi.longValue() : this.zzp.currentTimeMillis();
        object2 = this;
        this.zzi = new zzaf((zzhc)object2);
        object2 = this;
        object = new zzge((zzhc)object2);
        ((zzid)object).zzac();
        this.zzj = object;
        object2 = this;
        zzfs zzfs2 = new zzfs((zzhc)object2);
        zzfs2.zzac();
        this.zzk = zzfs2;
        object2 = this;
        zzne zzne2 = new zzne((zzhc)object2);
        zzne2.zzac();
        this.zzn = zzne2;
        zzhc zzhc2 = this;
        object2 = zzil2;
        Object object3 = new zzio((zzil)object2, zzhc2);
        this.zzo = new zzfn((zzfq)object3);
        object2 = this;
        this.zzs = new zzb((zzhc)object2);
        object2 = this;
        zzki zzki2 = new zzki((zzhc)object2);
        zzki2.zzv();
        this.zzq = zzki2;
        object2 = this;
        zzin zzin2 = new zzin((zzhc)object2);
        zzin2.zzv();
        this.zzr = zzin2;
        object2 = this;
        zzly zzly2 = new zzly((zzhc)object2);
        zzly2.zzv();
        this.zzm = zzly2;
        object2 = this;
        zzjz zzjz2 = new zzjz((zzhc)object2);
        zzjz2.zzac();
        this.zzt = zzjz2;
        object2 = this;
        zzgz zzgz2 = new zzgz((zzhc)object2);
        zzgz2.zzac();
        this.zzl = zzgz2;
        boolean bl = zzil2.zzg != null && zzil2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        if (((zzhc)object2).zzc.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            object3 = ((zzhc)object2).zzp();
            if (((zzia)object3).zza().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzia)object3).zza().getApplicationContext();
                if (((zzin)object3).zza == null) {
                    ((zzin)object3).zza = new zzjy((zzin)object3);
                }
                if (bl3) {
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzin)object3).zza);
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzin)object3).zza);
                    ((zzia)object3).zzj().zzp().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzhc)object2).zzj().zzu().zza("Application context is not an Application");
        }
        this.zzl.zzb(new zzhh(this, zzil2));
    }

    private static void zza(zzia zzia2) {
        if (zzia2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    private static void zza(zze zze2) {
        if (zze2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zze2.zzy()) {
            String string = String.valueOf(zze2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    private static void zza(zzid zzid2) {
        if (zzid2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzid2.zzae()) {
            String string = String.valueOf(zzid2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    final void zzy() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzz() {
        this.zzai.incrementAndGet();
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzhc zzhc2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzhc2.zzj().zzu().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzhc2.zzn().zzo.zza(true);
        if (byArray2 == null || byArray2.length == 0) {
            zzhc2.zzj().zzc().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            String string5 = jSONObject.optString("gbraid", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzhc2.zzj().zzc().zza("Deferred Deep Link is empty.");
                return;
            }
            Bundle bundle = new Bundle();
            if (zzri.zzb() && zzhc2.zzi.zza(zzbi.zzcs)) {
                if (!zzhc2.zzt().zzi(string3)) {
                    zzhc2.zzj().zzu().zza("Deferred Deep Link validation failed. gclid, gbraid, deep link", string4, string5, string3);
                    return;
                }
                bundle.putString("gbraid", string5);
            } else if (!zzhc2.zzt().zzi(string3)) {
                zzhc2.zzj().zzu().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzhc2.zzr.zzc("auto", "_cmp", bundle);
            String string6 = string3;
            zzne zzne2 = zzhc2.zzt();
            if (!TextUtils.isEmpty((CharSequence)string6) && zzne2.zza(string6, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzia)zzne2).zza().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzhc2.zzj().zzg().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    final void zzaa() {
        ++this.zzag;
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzac = bl;
    }

    @WorkerThread
    public final void zzb(boolean bl) {
        ((zzia)this.zzl()).zzt();
        this.zzaf = bl;
    }

    @WorkerThread
    protected final void zza(@Nullable zzdd zzdd2) {
        zzie zzie2;
        IntentFilter intentFilter;
        zzic zzic2;
        ((zzia)this.zzl()).zzt();
        if (zzsg.zzb() && this.zzi.zza(zzbi.zzcg) && this.zzt().zzw()) {
            zzic2 = this.zzt();
            ((zzia)zzic2).zzt();
            intentFilter = new IntentFilter();
            intentFilter.addAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
            zzp zzp2 = new zzp(((zzne)zzic2).zzu);
            ContextCompat.registerReceiver((Context)((zzia)zzic2).zza(), (BroadcastReceiver)zzp2, (IntentFilter)intentFilter, (int)2);
            ((zzia)zzic2).zzj().zzc().zza("Registered app receiver");
        }
        zzie zzie3 = this.zzn().zzm();
        int n = zzie3.zza();
        zzie zzie4 = null;
        zzic2 = this.zzi;
        Boolean bl = ((zzaf)zzic2).zzg("google_analytics_default_allow_ad_storage");
        zzic2 = this.zzi;
        Boolean bl2 = ((zzaf)zzic2).zzg("google_analytics_default_allow_analytics_storage");
        if ((bl != null || bl2 != null) && this.zzn().zza(-10)) {
            zzie4 = new zzie(bl, bl2, -10);
        } else if (!(TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || n != 0 && n != 30 && n != 10 && n != 30 && n != 30 && n != 40)) {
            this.zzp().zza(new zzie(null, null, -10), this.zza);
        } else if (TextUtils.isEmpty((CharSequence)this.zzh().zzae()) && zzdd2 != null && zzdd2.zzg != null && this.zzn().zza(30) && (zzie2 = zzie.zza(zzdd2.zzg, 30)).zzi()) {
            zzie4 = zzie2;
        }
        if (zzie4 != null) {
            zzie3 = zzie4;
            this.zzp().zza(zzie3, this.zza);
        }
        this.zzp().zza(zzie3);
        if (zzql.zzb() && this.zzi.zza(zzbi.zzcl)) {
            intentFilter = zzdd2;
            zzic2 = this;
            int n2 = ((zzhc)zzic2).zzn().zzh().zza();
            zzaf zzaf2 = ((zzhc)zzic2).zzi;
            Boolean bl3 = zzaf2.zzg("google_analytics_default_allow_ad_user_data");
            if (bl3 != null && zzie.zza(-10, n2)) {
                ((zzhc)zzic2).zzp().zza(new zzay(bl3, -10));
            } else if (!(TextUtils.isEmpty((CharSequence)((zzhc)zzic2).zzh().zzae()) || n2 != 0 && n2 != 30)) {
                ((zzhc)zzic2).zzp().zza(new zzay(null, -10));
            } else {
                Boolean bl4;
                zzay zzay2;
                if (TextUtils.isEmpty((CharSequence)((zzhc)zzic2).zzh().zzae()) && intentFilter != null && intentFilter.zzg != null && zzie.zza(30, n2) && (zzay2 = zzay.zza(intentFilter.zzg, 30)).zzh()) {
                    ((zzhc)zzic2).zzp().zza(zzay2);
                }
                if (TextUtils.isEmpty((CharSequence)((zzhc)zzic2).zzh().zzae()) && intentFilter != null && intentFilter.zzg != null && ((zzhc)zzic2).zzn().zzh.zza() == null && (bl4 = zzay.zza(intentFilter.zzg)) != null) {
                    ((zzhc)zzic2).zzp().zza(intentFilter.zze, "allow_personalized_ads", (Object)bl4.toString(), false);
                }
            }
        }
        if (this.zzn().zzc.zza() == 0L) {
            this.zzj().zzp().zza("Persisting first open", this.zza);
            this.zzn().zzc.zza(this.zza);
        }
        this.zzp().zzb.zzb();
        if (!this.zzaf()) {
            if (this.zzac()) {
                if (!this.zzt().zze("android.permission.INTERNET")) {
                    this.zzj().zzg().zza("App is missing INTERNET permission");
                }
                if (!this.zzt().zze("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzj().zzg().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() && !this.zzi.zzw()) {
                    if (!zzne.zza(this.zzc)) {
                        this.zzj().zzg().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzne.zza(this.zzc, false)) {
                        this.zzj().zzg().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzj().zzg().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac())) {
                this.zzt();
                if (zzne.zza(this.zzh().zzae(), this.zzn().zzx(), this.zzh().zzac(), this.zzn().zzw())) {
                    this.zzj().zzn().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzn().zzy();
                    this.zzi().zzaa();
                    this.zzw.zzae();
                    this.zzw.zzad();
                    this.zzn().zzc.zza(this.zza);
                    this.zzn().zze.zza(null);
                }
                this.zzn().zzc(this.zzh().zzae());
                this.zzn().zzb(this.zzh().zzac());
            }
            if (!this.zzn().zzm().zza(zzie.zza.zzb)) {
                this.zzn().zze.zza(null);
            }
            this.zzp().zza(this.zzn().zze.zza());
            if (zzqr.zzb() && this.zzi.zza(zzbi.zzbm) && !this.zzt().zzx() && !TextUtils.isEmpty((CharSequence)this.zzn().zzq.zza())) {
                this.zzj().zzu().zza("Remote config removed with active feature rollouts");
                this.zzn().zzq.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac())) {
                boolean bl5 = this.zzac();
                if (!this.zzn().zzaa() && !this.zzi.zzv()) {
                    this.zzn().zzb(!bl5);
                }
                if (bl5) {
                    this.zzp().zzaj();
                }
                this.zzs().zza.zza();
                this.zzr().zza(new AtomicReference<String>());
                this.zzr().zza(this.zzn().zzt.zza());
            }
        }
        if (zzsg.zzb() && this.zzi.zza(zzbi.zzcg) && this.zzt().zzw()) {
            zzin zzin2 = this.zzp();
            zzin2.getClass();
            zzin zzin3 = zzin2;
            new Thread(new zzhf(zzin3)).start();
        }
        this.zzn().zzj.zza(true);
    }

    @WorkerThread
    public final boolean zzab() {
        return this.zzac != null && this.zzac != false;
    }

    @WorkerThread
    public final boolean zzac() {
        return this.zzc() == 0;
    }

    @WorkerThread
    public final boolean zzad() {
        ((zzia)this.zzl()).zzt();
        return this.zzaf;
    }

    @Pure
    public final boolean zzae() {
        return TextUtils.isEmpty((CharSequence)this.zzd);
    }

    @WorkerThread
    protected final boolean zzaf() {
        if (!this.zzz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
        ((zzia)this.zzl()).zzt();
        if (this.zzaa == null || this.zzab == 0L || this.zzaa != null && !this.zzaa.booleanValue() && Math.abs(this.zzp.elapsedRealtime() - this.zzab) > 1000L) {
            this.zzab = this.zzp.elapsedRealtime();
            this.zzaa = this.zzt().zze("android.permission.INTERNET") && this.zzt().zze("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() || this.zzi.zzw() || zzne.zza(this.zzc) && zzne.zza(this.zzc, false));
            if (this.zzaa.booleanValue()) {
                this.zzaa = this.zzt().zza(this.zzh().zzae(), this.zzh().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac());
            }
        }
        return this.zzaa;
    }

    @Pure
    public final boolean zzag() {
        return this.zzg;
    }

    @WorkerThread
    public final boolean zzah() {
        Object object;
        zzia zzia2;
        ((zzia)this.zzl()).zzt();
        zzhc.zza(this.zzai());
        String string = this.zzh().zzad();
        Pair<String, Boolean> pair = this.zzn().zza(string);
        if (!this.zzi.zzp() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzj().zzc().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return false;
        }
        if (!this.zzai().zzc()) {
            this.zzj().zzu().zza("Network is not available for Deferred Deep Link request. Skipping");
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (zzql.zzb() && this.zzi.zza(zzbi.zzcn)) {
            Boolean bl = this.zzn().zzh().zzc();
            if (bl != null && !bl.booleanValue()) {
                this.zzj().zzc().zza("DMA consent not granted on client. Skipping");
                return false;
            }
            Bundle bundle = null;
            zzia2 = this.zzp();
            zzia2.zzt();
            zzam zzam2 = ((zzf)zzia2).zzo().zzaa();
            if (zzam2 != null) {
                bundle = zzam2.zza;
            }
            if (bundle == null) {
                boolean bl2 = this.zzah++ < 10;
                String string2 = bl2 ? "Retrying." : "Skipping.";
                this.zzj().zzc().zza("Failed to retrieve DMA consent from the service, " + string2 + " retryCount", this.zzah);
                return bl2;
            }
            object = zzay.zza(bundle, 100);
            if (!((zzay)object).zzg()) {
                this.zzj().zzc().zza("DMA consent not granted on service. Skipping");
                return false;
            }
            zzie zzie2 = zzie.zza(bundle, 100);
            stringBuilder.append("&gcs=").append(zzie2.zzf());
            stringBuilder.append("&dma=").append(((zzay)object).zzd() == Boolean.FALSE ? 0 : 1);
            if (!TextUtils.isEmpty((CharSequence)((zzay)object).zze())) {
                stringBuilder.append("&dma_cps=").append(((zzay)object).zze());
            }
            int n = zzay.zza(bundle) == Boolean.TRUE ? 0 : 1;
            stringBuilder.append("&npa=").append(n);
            this.zzj().zzp().zza("Consent query parameters to Bow", stringBuilder);
        }
        zzne zzne2 = this.zzt();
        this.zzh();
        object = zzne2.zza(81010L, string, (String)pair.first, this.zzn().zzp.zza() - 1L, stringBuilder.toString());
        if (object != null) {
            zzhc zzhc2 = this;
            zzhe zzhe2 = new zzhe(zzhc2);
            URL uRL = object;
            String string3 = string;
            zzia2 = this.zzai();
            zzia2.zzt();
            ((zzid)zzia2).zzab();
            Preconditions.checkNotNull((Object)uRL);
            Preconditions.checkNotNull((Object)zzhe2);
            zzia2.zzl().zza(new zzkb((zzjz)zzia2, string3, uRL, null, null, zzhe2));
        }
        return false;
    }
}

