/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzkf;
import com.google.android.gms.measurement.internal.zzkh;
import com.google.android.gms.measurement.internal.zzkj;
import com.google.android.gms.measurement.internal.zzkk;
import com.google.android.gms.measurement.internal.zzkl;
import com.google.android.gms.measurement.internal.zzkm;
import com.google.android.gms.measurement.internal.zzkn;
import com.google.android.gms.measurement.internal.zzko;
import com.google.android.gms.measurement.internal.zzne;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzki
extends zze {
    private volatile @Nullable zzkf zzb;
    private volatile @Nullable zzkf zzc;
    @VisibleForTesting
    protected @Nullable zzkf zza;
    private final Map<Activity, zzkf> zzd;
    @GuardedBy(value="activityLock")
    private @Nullable Activity zze;
    @GuardedBy(value="activityLock")
    private volatile boolean zzf;
    private volatile @Nullable zzkf zzg;
    private @Nullable zzkf zzh;
    @GuardedBy(value="activityLock")
    private boolean zzi;
    private final Object zzj = new Object();

    static /* bridge */ /* synthetic */ zzkf zza(zzki zzki2) {
        return zzki2.zzh;
    }

    @MainThread
    private final zzkf zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzkf zzkf2 = this.zzd.get(activity);
        if (zzkf2 == null) {
            String string = this.zza(activity.getClass(), "Activity");
            zzkf2 = new zzkf(null, string, ((zzia)this).zzq().zzm());
            this.zzd.put(activity, zzkf2);
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return zzkf2;
    }

    public final @Nullable zzkf zzaa() {
        return this.zzb;
    }

    @WorkerThread
    public final @Nullable zzkf zza(boolean bl) {
        this.zzu();
        ((zzia)this).zzt();
        if (!bl) {
            return this.zza;
        }
        if (this.zza != null) {
            return this.zza;
        }
        return this.zzh;
    }

    @VisibleForTesting
    private final String zza(Class<?> clazz, String string) {
        String string2 = clazz.getCanonicalName();
        if (string2 == null) {
            return string;
        }
        String string3 = string2;
        zzki zzki2 = this;
        String[] stringArray = string3.split("\\.");
        String string4 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string4.length() > ((zzia)zzki2).zze().zzb(null)) {
            return string4.substring(0, ((zzia)zzki2).zze().zzb(null));
        }
        return string4;
    }

    static /* bridge */ /* synthetic */ void zza(zzki zzki2, zzkf zzkf2) {
        zzki2.zzh = null;
    }

    static /* bridge */ /* synthetic */ void zza(zzki zzki2, zzkf zzkf2, zzkf zzkf3, long l, boolean bl, Bundle bundle) {
        zzki2.zza(zzkf2, zzkf3, l, bl, null);
    }

    static /* synthetic */ void zza(zzki zzki2, Bundle bundle, zzkf zzkf2, zzkf zzkf3, long l) {
        long l2 = l;
        zzkf zzkf4 = zzkf3;
        zzkf zzkf5 = zzkf2;
        Bundle bundle2 = bundle;
        zzki zzki3 = zzki2;
        if (bundle2 != null) {
            bundle2.remove("screen_name");
            bundle2.remove("screen_class");
        }
        Bundle bundle3 = ((zzia)zzki3).zzq().zza(null, "screen_view", bundle2, null, false);
        zzki3.zza(zzkf5, zzkf4, l2, true, bundle3);
    }

    static /* bridge */ /* synthetic */ void zza(zzki zzki2, zzkf zzkf2, boolean bl, long l) {
        zzki2.zza(zzkf2, false, l);
    }

    public zzki(zzhc zzhc2) {
        super(zzhc2);
        this.zzd = new ConcurrentHashMap<Activity, zzkf>();
    }

    @MainThread
    private final void zza(Activity activity, zzkf zzkf2, boolean bl) {
        zzkf zzkf3;
        zzkf zzkf4;
        zzkf zzkf5 = zzkf4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzkf2.zzb == null) {
            zzkf3 = activity != null ? this.zza(activity.getClass(), "Activity") : null;
            zzkf2 = new zzkf(zzkf2.zza, (String)((Object)zzkf3), zzkf2.zzc, zzkf2.zze, zzkf2.zzf);
        }
        zzkf3 = zzkf2;
        this.zzc = this.zzb;
        this.zzb = zzkf3;
        long l = ((zzia)this).zzb().elapsedRealtime();
        ((zzia)this).zzl().zzb(new zzkj(this, zzkf3, zzkf4, l, bl));
    }

    @WorkerThread
    private final void zza(zzkf zzkf2, @Nullable zzkf zzkf3, long l, boolean bl, @Nullable Bundle bundle) {
        boolean bl2;
        ((zzia)this).zzt();
        boolean bl3 = zzkf3 == null || zzkf3.zzc != zzkf2.zzc || !zzkh.zza(zzkf3.zzb, zzkf2.zzb) || !zzkh.zza(zzkf3.zza, zzkf2.zza);
        boolean bl4 = bl2 = bl && this.zza != null;
        if (bl3) {
            long l2;
            long l3;
            Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            zzne.zza(zzkf2, bundle2, true);
            if (zzkf3 != null) {
                if (zzkf3.zza != null) {
                    bundle2.putString("_pn", zzkf3.zza);
                }
                if (zzkf3.zzb != null) {
                    bundle2.putString("_pc", zzkf3.zzb);
                }
                bundle2.putLong("_pi", zzkf3.zzc);
            }
            if (bl2 && (l3 = ((zzf)this).zzp().zzb.zza(l2 = l)) > 0L) {
                ((zzia)this).zzq().zza(bundle2, l3);
            }
            if (!((zzia)this).zze().zzu()) {
                bundle2.putLong("_mst", 1L);
            }
            String string = zzkf2.zze ? "app" : "auto";
            long l4 = ((zzia)this).zzb().currentTimeMillis();
            if (zzkf2.zze && zzkf2.zzf != 0L) {
                l4 = zzkf2.zzf;
            }
            ((zzf)this).zzm().zza(string, "_vs", l4, bundle2);
        }
        if (bl2) {
            this.zza(this.zza, true, l);
        }
        this.zza = zzkf2;
        if (zzkf2.zze) {
            this.zzh = zzkf2;
        }
        ((zzf)this).zzo().zza(zzkf2);
    }

    @MainThread
    public final void zza(Activity activity, @Nullable Bundle bundle) {
        if (!((zzia)this).zze().zzu()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzkf zzkf2 = new zzkf(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzkf2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            if (activity == this.zze) {
                this.zze = null;
            }
        }
        if (!((zzia)this).zze().zzu()) {
            return;
        }
        this.zzd.remove(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzb(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = false;
            this.zzf = true;
        }
        long l = ((zzia)this).zzb().elapsedRealtime();
        if (!((zzia)this).zze().zzu()) {
            this.zzb = null;
            ((zzia)this).zzl().zzb(new zzkl(this, l));
            return;
        }
        zzkf zzkf2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzia)this).zzl().zzb(new zzko(this, zzkf2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzc(Activity activity) {
        zzf zzf2;
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = true;
            if (activity != this.zze) {
                Activity activity2 = activity;
                zzf2 = this;
                Object object2 = ((zzki)zzf2).zzj;
                synchronized (object2) {
                    ((zzki)zzf2).zze = activity2;
                    ((zzki)zzf2).zzf = false;
                }
                if (zzf2.zze().zzu()) {
                    ((zzki)zzf2).zzg = null;
                    zzf2.zzl().zzb(new zzkn((zzki)zzf2));
                }
            }
        }
        if (!((zzia)this).zze().zzu()) {
            this.zzb = this.zzg;
            ((zzia)this).zzl().zzb(new zzkm(this));
            return;
        }
        object = this.zzd(activity);
        this.zza(activity, (zzkf)object, false);
        zzf2 = ((zzf)this).zzc();
        long l = zzf2.zzb().elapsedRealtime();
        zzf2.zzl().zzb(new zzc((zzb)zzf2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (!((zzia)this).zze().zzu()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzkf zzkf2 = this.zzd.get(activity);
        if (zzkf2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzkf2.zzc);
        bundle2.putString("name", zzkf2.zza);
        bundle2.putString("referrer_name", zzkf2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @WorkerThread
    private final void zza(@Nullable zzkf zzkf2, boolean bl, long l) {
        boolean bl2;
        ((zzf)this).zzc().zza(((zzia)this).zzb().elapsedRealtime());
        boolean bl3 = bl2 = zzkf2 != null && zzkf2.zzd;
        if (((zzf)this).zzp().zza(bl2, bl, l) && zzkf2 != null) {
            zzkf2.zzd = false;
        }
    }

    @Deprecated
    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zzia)this).zze().zzu()) {
            ((zzia)this).zzj().zzv().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        zzkf zzkf2 = this.zzb;
        if (zzkf2 == null) {
            ((zzia)this).zzj().zzv().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzia)this).zzj().zzv().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = this.zza(activity.getClass(), "Activity");
        }
        boolean bl = zzkh.zza(zzkf2.zzb, string2);
        boolean bl2 = zzkh.zza(zzkf2.zza, string);
        if (bl && bl2) {
            ((zzia)this).zzj().zzv().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > ((zzia)this).zze().zzb(null))) {
            ((zzia)this).zzj().zzv().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzia)this).zze().zzb(null))) {
            ((zzia)this).zzj().zzv().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzia)this).zzj().zzp().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzkf zzkf3 = new zzkf(string, string2, ((zzia)this).zzq().zzm());
        this.zzd.put(activity, zzkf3);
        this.zza(activity, zzkf3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Bundle bundle, long l) {
        zzkf zzkf2;
        String string = null;
        String string2 = null;
        Object object = this.zzj;
        synchronized (object) {
            if (!this.zzi) {
                ((zzia)this).zzj().zzv().zza("Cannot log screen view event when the app is in the background.");
                return;
            }
            if (bundle != null) {
                string = bundle.getString("screen_name");
                if (string != null && (string.length() <= 0 || string.length() > ((zzia)this).zze().zzb(null))) {
                    ((zzia)this).zzj().zzv().zza("Invalid screen name length for screen view. Length", string.length());
                    return;
                }
                string2 = bundle.getString("screen_class");
                if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzia)this).zze().zzb(null))) {
                    ((zzia)this).zzj().zzv().zza("Invalid screen class length for screen view. Length", string2.length());
                    return;
                }
            }
            if (string2 == null) {
                string2 = this.zze != null ? this.zza(this.zze.getClass(), "Activity") : "Activity";
            }
            zzkf2 = this.zzb;
            if (this.zzf && zzkf2 != null) {
                this.zzf = false;
                boolean bl = zzkh.zza(zzkf2.zzb, string2);
                boolean bl2 = zzkh.zza(zzkf2.zza, string);
                if (bl && bl2) {
                    ((zzia)this).zzj().zzv().zza("Ignoring call to log screen view event with duplicate parameters.");
                    return;
                }
            }
        }
        ((zzia)this).zzj().zzp().zza("Logging screen view with name, class", string == null ? "null" : string, string2 == null ? "null" : string2);
        object = this.zzb == null ? this.zzc : this.zzb;
        this.zzb = zzkf2 = new zzkf(string, string2, ((zzia)this).zzq().zzm(), true, l);
        this.zzc = object;
        this.zzg = zzkf2;
        long l2 = ((zzia)this).zzb().elapsedRealtime();
        ((zzia)this).zzl().zzb(new zzkk(this, bundle, zzkf2, (zzkf)object, l2));
    }

    @Override
    protected final boolean zzz() {
        return false;
    }
}

