/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.Context;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzid;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzba
extends zzic {
    private long zza;
    private String zzb;
    private AccountManager zzc;
    private @Nullable Boolean zzd;
    private long zze;

    @WorkerThread
    final long zzc() {
        ((zzid)this).zzt();
        return this.zze;
    }

    public final long zzg() {
        this.zzab();
        return this.zza;
    }

    public final String zzh() {
        this.zzab();
        return this.zzb;
    }

    zzba(zzhf zzhf2) {
        super(zzhf2);
    }

    @WorkerThread
    final void zzm() {
        ((zzid)this).zzt();
        this.zzd = null;
        this.zze = 0L;
    }

    @WorkerThread
    final boolean zzn() {
        ((zzid)this).zzt();
        long l = ((zzid)this).zzb().currentTimeMillis();
        if (l - this.zze > 86400000L) {
            this.zzd = null;
        }
        if (this.zzd != null) {
            return this.zzd;
        }
        if (ContextCompat.checkSelfPermission((Context)((zzid)this).zza(), (String)"android.permission.GET_ACCOUNTS") != 0) {
            ((zzid)this).zzj().zzw().zza("Permission error checking for dasher/unicorn accounts");
            this.zze = l;
            this.zzd = false;
            return false;
        }
        if (this.zzc == null) {
            this.zzc = AccountManager.get((Context)((zzid)this).zza());
        }
        try {
            Account[] accountArray = (Account[])this.zzc.getAccountsByTypeAndFeatures("com.google", new String[]{"service_HOSTED"}, null, null).getResult();
            if (accountArray != null && accountArray.length > 0) {
                this.zzd = true;
                this.zze = l;
                return true;
            }
            accountArray = (Account[])this.zzc.getAccountsByTypeAndFeatures("com.google", new String[]{"service_uca"}, null, null).getResult();
            if (accountArray != null && accountArray.length > 0) {
                this.zzd = true;
                this.zze = l;
                return true;
            }
        }
        catch (AuthenticatorException | OperationCanceledException | IOException throwable) {
            ((zzid)this).zzj().zzm().zza("Exception checking account types", throwable);
        }
        this.zze = l;
        this.zzd = false;
        return false;
    }

    @Override
    protected final boolean zzo() {
        Calendar calendar = Calendar.getInstance();
        this.zza = TimeUnit.MINUTES.convert(calendar.get(15) + calendar.get(16), TimeUnit.MILLISECONDS);
        Locale locale = Locale.getDefault();
        String string = locale.getCountry().toLowerCase(Locale.ENGLISH);
        String string2 = locale.getLanguage().toLowerCase(Locale.ENGLISH);
        this.zzb = string2 + "-" + string;
        return false;
    }
}

