/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zznc;
import com.google.android.gms.measurement.internal.zznd;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzfo
extends zze {
    private final zzfn zza = new zzfn(this, ((zzid)this).zza(), "google_app_measurement_local.db");
    private boolean zzb;

    private static long zza(SQLiteDatabase sQLiteDatabase) {
        Cursor cursor;
        block4: {
            long l;
            block5: {
                cursor = null;
                try {
                    cursor = sQLiteDatabase.query("messages", new String[]{"rowid"}, "type=?", new String[]{"3"}, null, null, "rowid desc", "1");
                    if (!cursor.moveToFirst()) break block4;
                    l = cursor.getLong(0);
                    if (cursor == null) break block5;
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        cursor.close();
                    }
                    throw throwable;
                }
                cursor.close();
            }
            return l;
        }
        if (cursor != null) {
            cursor.close();
        }
        return -1L;
    }

    @VisibleForTesting
    @WorkerThread
    private final @Nullable SQLiteDatabase zzad() throws SQLiteException {
        if (this.zzb) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.zza.getWritableDatabase();
        if (sQLiteDatabase == null) {
            this.zzb = true;
            return null;
        }
        return sQLiteDatabase;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final @Nullable List<AbstractSafeParcelable> zza(int n) {
        ((zzid)this).zzt();
        if (this.zzb) {
            return null;
        }
        ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
        if (!this.zzae()) {
            return arrayList;
        }
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block43: {
                if (n3 >= 5) {
                    ((zzid)this).zzj().zzu().zza("Failed to read events from database in reasonable time");
                    return null;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.zzad();
                    if (sQLiteDatabase != null) {
                        Object object;
                        sQLiteDatabase.beginTransaction();
                        long l = zzfo.zza(sQLiteDatabase);
                        String string = null;
                        String[] stringArray = null;
                        if (l != -1L) {
                            string = "rowid<?";
                            stringArray = new String[]{String.valueOf(l)};
                        }
                        cursor = sQLiteDatabase.query("messages", new String[]{"rowid", "type", "entry"}, string, stringArray, null, null, "rowid asc", Integer.toString(100));
                        long l2 = -1L;
                        while (cursor.moveToNext()) {
                            AbstractSafeParcelable abstractSafeParcelable;
                            Parcel parcel;
                            l2 = cursor.getLong(0);
                            int n4 = cursor.getInt(1);
                            object = cursor.getBlob(2);
                            if (n4 == 0) {
                                parcel = Parcel.obtain();
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    abstractSafeParcelable = (zzbg)((Object)zzbg.CREATOR.createFromParcel(parcel));
                                }
                                catch (SafeParcelReader.ParseException parseException) {
                                    ((zzid)this).zzj().zzg().zza("Failed to load event from local database");
                                    continue;
                                }
                                finally {
                                    parcel.recycle();
                                    continue;
                                }
                                if (abstractSafeParcelable == null) continue;
                                arrayList.add(abstractSafeParcelable);
                                continue;
                            }
                            if (n4 == 1) {
                                parcel = Parcel.obtain();
                                abstractSafeParcelable = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    abstractSafeParcelable = (zznc)((Object)zznc.CREATOR.createFromParcel(parcel));
                                }
                                catch (SafeParcelReader.ParseException parseException) {
                                    ((zzid)this).zzj().zzg().zza("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (abstractSafeParcelable == null) continue;
                                arrayList.add(abstractSafeParcelable);
                                continue;
                            }
                            if (n4 == 2) {
                                parcel = Parcel.obtain();
                                abstractSafeParcelable = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    abstractSafeParcelable = (zzad)((Object)zzad.CREATOR.createFromParcel(parcel));
                                }
                                catch (SafeParcelReader.ParseException parseException) {
                                    ((zzid)this).zzj().zzg().zza("Failed to load conditional user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (abstractSafeParcelable == null) continue;
                                arrayList.add(abstractSafeParcelable);
                                continue;
                            }
                            if (n4 == 3) {
                                ((zzid)this).zzj().zzu().zza("Skipping app launch break");
                                continue;
                            }
                            ((zzid)this).zzj().zzg().zza("Unknown record type in local database");
                        }
                        if (sQLiteDatabase.delete("messages", "rowid <= ?", new String[]{Long.toString(l2)}) < arrayList.size()) {
                            ((zzid)this).zzj().zzg().zza("Fewer entries removed from local database than expected");
                        }
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        object = arrayList;
                        return object;
                    }
                    this.zzb = true;
                    if (sQLiteDatabase == null) return null;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzid)this).zzj().zzg().zza("Error reading entries from local database", (Object)sQLiteFullException);
                    this.zzb = true;
                    break block43;
                }
                catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                    SystemClock.sleep((long)n2);
                    n2 += 20;
                    break block43;
                }
                catch (SQLiteException sQLiteException) {
                    if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                        sQLiteDatabase.endTransaction();
                    }
                    ((zzid)this).zzj().zzg().zza("Error reading entries from local database", (Object)sQLiteException);
                    this.zzb = true;
                    break block43;
                }
                sQLiteDatabase.close();
                return null;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    zzfo(zzhf zzhf2) {
        super(zzhf2);
    }

    @WorkerThread
    public final void zzaa() {
        ((zzid)this).zzt();
        try {
            SQLiteDatabase sQLiteDatabase = this.zzad();
            if (sQLiteDatabase != null) {
                int n = 0 + sQLiteDatabase.delete("messages", null, null);
                if (n > 0) {
                    ((zzid)this).zzj().zzp().zza("Reset local analytics data. records", n);
                }
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            ((zzid)this).zzj().zzg().zza("Error resetting local analytics data. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zzab() {
        return this.zza(3, new byte[0]);
    }

    @VisibleForTesting
    private final boolean zzae() {
        return ((zzid)this).zza().getDatabasePath("google_app_measurement_local.db").exists();
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final boolean zzac() {
        ((zzid)this).zzt();
        if (this.zzb) {
            return false;
        }
        if (!this.zzae()) {
            return false;
        }
        int n = 5;
        for (int i = 0; i < 5; ++i) {
            try (SQLiteDatabase sQLiteDatabase = null;){
                sQLiteDatabase = this.zzad();
                if (sQLiteDatabase == null) {
                    this.zzb = true;
                    return false;
                }
                sQLiteDatabase.beginTransaction();
                sQLiteDatabase.delete("messages", "type == ?", new String[]{Integer.toString(3)});
                sQLiteDatabase.setTransactionSuccessful();
                sQLiteDatabase.endTransaction();
                return true;
            }
        }
        ((zzid)this).zzj().zzu().zza("Error deleting app launch break from local database in reasonable time");
        return false;
    }

    public final boolean zza(zzad zzad2) {
        ((zzid)this).zzq();
        byte[] byArray = zznd.zza((Parcelable)zzad2);
        if (byArray.length > 131072) {
            ((zzid)this).zzj().zzm().zza("Conditional user property too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(2, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final boolean zza(int n, byte[] byArray) {
        ((zzid)this).zzt();
        if (this.zzb) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("type", Integer.valueOf(n));
        contentValues.put("entry", byArray);
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block20: {
                if (n3 >= 5) {
                    ((zzid)this).zzj().zzp().zza("Failed to write entry to local database");
                    return false;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.zzad();
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.beginTransaction();
                        long l = 0L;
                        cursor = sQLiteDatabase.rawQuery("select count(1) from messages", null);
                        if (cursor != null && cursor.moveToFirst()) {
                            l = cursor.getLong(0);
                        }
                        if (l >= 100000L) {
                            ((zzid)this).zzj().zzg().zza("Data loss, local db full");
                            long l2 = 100000L - l + 1L;
                            long l3 = sQLiteDatabase.delete("messages", "rowid in (select rowid from messages order by rowid asc limit ?)", new String[]{Long.toString(l2)});
                            if (l3 != l2) {
                                ((zzid)this).zzj().zzg().zza("Different delete count than expected in local db. expected, received, difference", l2, l3, l2 - l3);
                            }
                        }
                        sQLiteDatabase.insertOrThrow("messages", null, contentValues);
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        return true;
                    }
                    this.zzb = true;
                    if (sQLiteDatabase == null) return false;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzid)this).zzj().zzg().zza("Error writing entry; local database full", (Object)sQLiteFullException);
                    this.zzb = true;
                    break block20;
                }
                catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                    SystemClock.sleep((long)n2);
                    n2 += 20;
                    break block20;
                }
                catch (SQLiteException sQLiteException) {
                    if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                        sQLiteDatabase.endTransaction();
                    }
                    ((zzid)this).zzj().zzg().zza("Error writing entry to local database", (Object)sQLiteException);
                    this.zzb = true;
                    break block20;
                }
                sQLiteDatabase.close();
                return false;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    public final boolean zza(zzbg zzbg2) {
        Parcel parcel = Parcel.obtain();
        zzbg2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzid)this).zzj().zzm().zza("Event is too long for local database. Sending event directly to service");
            return false;
        }
        return this.zza(0, byArray);
    }

    public final boolean zza(zznc zznc2) {
        Parcel parcel = Parcel.obtain();
        zznc2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzid)this).zzj().zzm().zza("User property too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(1, byArray);
    }
}

