/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.internal.measurement.zzgh;
import com.google.android.gms.internal.measurement.zzgi;
import com.google.android.gms.internal.measurement.zzgj;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzgg
implements zzgj {
    @GuardedBy(value="ConfigurationContentLoader.class")
    private static final Map<Uri, zzgg> zza = new ArrayMap();
    private static final String[] zzb = new String[]{"key", "value"};
    private final ContentResolver zzc;
    private final Uri zzd;
    private final Runnable zze;
    private final ContentObserver zzf = new zzgi(this, null);
    private final Object zzg = new Object();
    private volatile Map<String, String> zzh;
    @GuardedBy(value="this")
    private final List<zzgh> zzi = new ArrayList<zzgh>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzgg zza(ContentResolver contentResolver, Uri uri, Runnable runnable) {
        Class<zzgg> clazz = zzgg.class;
        synchronized (zzgg.class) {
            zzgg zzgg2 = zza.get(uri);
            if (zzgg2 == null) {
                try {
                    zzgg2 = new zzgg(contentResolver, uri, runnable);
                    zza.put(uri, zzgg2);
                }
                catch (SecurityException securityException) {}
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zzgg2;
        }
    }

    @Override
    public final /* synthetic */ Object zza(String string) {
        String string2 = string;
        return this.zza().get(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> zza() {
        Map<String, String> map = this.zzh;
        if (map == null) {
            Object object = this.zzg;
            synchronized (object) {
                map = this.zzh;
                if (map == null) {
                    this.zzh = map = this.zze();
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    final /* synthetic */ Map zzb() {
        Cursor cursor = this.zzc.query(this.zzd, zzb, null, null, null);
        if (cursor == null) {
            return Collections.emptyMap();
        }
        try {
            Object object;
            int n = cursor.getCount();
            if (n == 0) {
                Map map = Collections.emptyMap();
                return map;
            }
            Object object2 = object = n <= 256 ? new ArrayMap(n) : new HashMap(n, 1.0f);
            while (cursor.moveToNext()) {
                object.put(cursor.getString(0), cursor.getString(1));
            }
            Object object3 = object;
            return object3;
        }
        finally {
            cursor.close();
        }
    }

    @Nullable
    private final Map<String, String> zze() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            zzgg zzgg2 = this;
            Map map = (Map)zzgm.zza(new zzgf(zzgg2));
            return map;
        }
        catch (SQLiteException | IllegalStateException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLdr", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    private zzgg(ContentResolver contentResolver, Uri uri, Runnable runnable) {
        Preconditions.checkNotNull((Object)contentResolver);
        Preconditions.checkNotNull((Object)uri);
        this.zzc = contentResolver;
        this.zzd = uri;
        this.zze = runnable;
        contentResolver.registerContentObserver(uri, false, this.zzf);
    }

    static synchronized void zzc() {
        for (zzgg zzgg2 : zza.values()) {
            zzgg2.zzc.unregisterContentObserver(zzgg2.zzf);
        }
        zza.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzd() {
        zzgg zzgg2;
        Object object = this.zzg;
        synchronized (object) {
            this.zzh = null;
            this.zze.run();
        }
        zzgg zzgg3 = zzgg2 = this;
        synchronized (zzgg2) {
            Iterator<zzgh> iterator = zzgg2.zzi.iterator();
            while (iterator.hasNext()) {
                iterator.next().zza();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }
}

