/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzkq;
import com.google.android.gms.measurement.internal.zzll;
import com.google.android.gms.measurement.internal.zzlm;
import com.google.android.gms.measurement.internal.zzln;
import com.google.android.gms.measurement.internal.zzlo;
import com.google.android.gms.measurement.internal.zzlq;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzlj
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile @Nullable zzfq zzc;
    final /* synthetic */ zzkq zza;

    static /* bridge */ /* synthetic */ void zza(zzlj zzlj2, boolean bl) {
        zzlj2.zzb = false;
    }

    protected zzlj(zzkq zzkq2) {
        this.zza = zzkq2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzib)this.zza).zzt();
        Context context = ((zzib)this.zza).zza();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzlj zzlj2 = this;
        synchronized (zzlj2) {
            if (this.zzb) {
                ((zzib)this.zza).zzj().zzp().zza("Connection attempt already in progress");
                return;
            }
            ((zzib)this.zza).zzj().zzp().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzkq.zzb(this.zza), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza() {
        ((zzib)this.zza).zzt();
        Context context = ((zzib)this.zza).zza();
        zzlj zzlj2 = this;
        synchronized (zzlj2) {
            if (this.zzb) {
                ((zzib)this.zza).zzj().zzp().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzib)this.zza).zzj().zzp().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzfq(context, Looper.getMainLooper(), this, this);
            ((zzib)this.zza).zzj().zzp().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    @WorkerThread
    public final void zzb() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzlj zzlj2 = this;
        synchronized (zzlj2) {
            try {
                Preconditions.checkNotNull((Object)((Object)this.zzc));
                zzfi zzfi2 = (zzfi)this.zzc.getService();
                ((zzib)this.zza).zzl().zzb(new zzlo(this, zzfi2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzfp zzfp2 = this.zza.zzu.zzm();
        if (zzfp2 != null) {
            zzfp2.zzu().zza("Service connection failed", connectionResult);
        }
        zzlj zzlj2 = this;
        synchronized (zzlj2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzib)this.zza).zzl().zzb(new zzlq(this));
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzib)this.zza).zzj().zzc().zza("Service connection suspended");
        ((zzib)this.zza).zzl().zzb(new zzln(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, @Nullable IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzlj zzlj2 = this;
        synchronized (zzlj2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzib)this.zza).zzj().zzg().zza("Service connected with null binder");
                return;
            }
            zzfi zzfi2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzfi2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzfi ? (zzfi)iInterface : new zzfk(iBinder2));
                    ((zzib)this.zza).zzj().zzp().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzib)this.zza).zzj().zzg().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzib)this.zza).zzj().zzg().zza("Service connect failed to get IMeasurementService");
            }
            if (zzfi2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzib)this.zza).zza(), (ServiceConnection)zzkq.zzb(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzfi2;
                ((zzib)this.zza).zzl().zzb(new zzlm(this, (zzfi)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzib)this.zza).zzj().zzc().zza("Service disconnected");
        ((zzib)this.zza).zzl().zzb(new zzll(this, componentName));
    }
}

