/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.collection.SimpleArrayMap;
import com.google.android.gms.internal.measurement.zzgp;
import com.google.android.gms.internal.measurement.zzgv;
import com.google.android.gms.internal.measurement.zzhe;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.common.base.Optional;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzhd {
    private static zzhe zza(Context context, File file) {
        Object object;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        try {
            String string;
            String string2;
            SimpleArrayMap simpleArrayMap = new SimpleArrayMap();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                object = string2.split(" ", 3);
                if (((String[])object).length != 3) {
                    string = string2;
                    Log.e((String)"HermeticFileOverrides", (String)("Invalid: " + string));
                    continue;
                }
                String string4 = zzhd.zza(object[0]);
                String string5 = Uri.decode((String)zzhd.zza(object[1]));
                String string6 = (String)hashMap.get(object[2]);
                if (string6 == null && ((string6 = Uri.decode((String)(string3 = zzhd.zza(object[2])))).length() < 1024 || string6 == string3)) {
                    hashMap.put(string3, string6);
                }
                if ((string3 = (SimpleArrayMap)simpleArrayMap.get((Object)string4)) == null) {
                    string3 = new SimpleArrayMap();
                    simpleArrayMap.put((Object)string4, (Object)string3);
                }
                string3.put((Object)string5, (Object)string6);
            }
            String string7 = context.getPackageName();
            string = String.valueOf(file);
            Log.w((String)"HermeticFileOverrides", (String)("Parsed " + string + " for Android package " + string7));
            object = new zzgv((SimpleArrayMap<String, SimpleArrayMap<String, String>>)simpleArrayMap);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        bufferedReader.close();
        return object;
    }

    private static Optional<File> zzb(Context context) {
        File file;
        try {
            file = new File(context.getDir("phenotype_hermetic", 0), "overrides.txt");
        }
        catch (RuntimeException runtimeException) {
            Log.e((String)"HermeticFileOverrides", (String)"no data dir", (Throwable)runtimeException);
            return Optional.absent();
        }
        if (file.exists()) {
            return Optional.of((Object)file);
        }
        return Optional.absent();
    }

    @VisibleForTesting
    static Optional<zzhe> zza(Context context) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            StrictMode.allowThreadDiskWrites();
            Optional<File> optional = zzhd.zzb(context);
            Optional optional2 = optional.isPresent() ? Optional.of((Object)zzhd.zza(context, (File)optional.get())) : Optional.absent();
            return optional2;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    private static final String zza(String string) {
        return new String(string);
    }

    public static class zza {
        private static volatile @Nullable Optional<zzhe> zza = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Optional<zzhe> zza(Context context) {
            Optional<zzhe> optional = zza;
            if (optional != null) return optional;
            Class<zza> clazz = zza.class;
            synchronized (zza.class) {
                Optional<zzhe> optional2;
                optional = zza;
                if (optional != null) return optional;
                new zzhd();
                Context context2 = context;
                if (!zzhh.zza(Build.TYPE, Build.TAGS)) {
                    optional2 = Optional.absent();
                } else {
                    Context context3;
                    Context context4 = context2;
                    optional2 = zzhd.zza(zzgp.zza() ? ((context3 = context4).isDeviceProtectedStorage() ? context3 : context3.createDeviceProtectedStorageContext()) : context4);
                }
                optional = optional2;
                zza = optional2;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return optional;
            }
        }

        private zza() {
        }
    }
}

