/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.google.android.gms.internal.measurement.zzci;
import com.google.android.gms.measurement.internal.zzgb;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzas {
    @WorkerThread
    private static Set<String> zza(SQLiteDatabase sQLiteDatabase, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = string;
        String string3 = "SELECT * FROM " + string2 + " LIMIT 0";
        try (Cursor cursor = sQLiteDatabase.rawQuery(string3, null);){
            Collections.addAll(hashSet, cursor.getColumnNames());
        }
        return hashSet;
    }

    @WorkerThread
    static void zza(zzgb zzgb2, SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, String @Nullable [] stringArray) throws SQLiteException {
        if (zzgb2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (!zzas.zza(zzgb2, sQLiteDatabase, string)) {
            sQLiteDatabase.execSQL(string2);
        }
        try {
            String[] stringArray2 = stringArray;
            String string4 = string3;
            String string5 = string;
            SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
            zzgb zzgb3 = zzgb2;
            if (zzgb3 == null) {
                throw new IllegalArgumentException("Monitor must not be null");
            }
            Set<String> set = zzas.zza(sQLiteDatabase2, string5);
            for (String string6 : string4.split(",")) {
                if (set.remove(string6)) continue;
                String string7 = string6;
                String string8 = string5;
                throw new SQLiteException("Table " + string8 + " is missing required column: " + string7);
            }
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; i += 2) {
                    if (set.remove(stringArray2[i])) continue;
                    sQLiteDatabase2.execSQL(stringArray2[i + 1]);
                }
            }
            if (!set.isEmpty()) {
                zzgb3.zzu().zza("Table has extra columns. table, columns", string5, TextUtils.join((CharSequence)", ", set));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            zzgb2.zzg().zza("Failed to verify columns on table that was just created", string);
            throw sQLiteException;
        }
    }

    static void zza(zzgb zzgb2, SQLiteDatabase sQLiteDatabase) {
        if (zzgb2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        File file = new File(zzci.zza().zza(sQLiteDatabase.getPath()));
        if (!file.setReadable(false, false)) {
            zzgb2.zzu().zza("Failed to turn off database read permission");
        }
        if (!file.setWritable(false, false)) {
            zzgb2.zzu().zza("Failed to turn off database write permission");
        }
        if (!file.setReadable(true, true)) {
            zzgb2.zzu().zza("Failed to turn on database read permission for owner");
        }
        if (!file.setWritable(true, true)) {
            zzgb2.zzu().zza("Failed to turn on database write permission for owner");
        }
    }

    @WorkerThread
    private static boolean zza(zzgb zzgb2, SQLiteDatabase sQLiteDatabase, String string) {
        if (zzgb2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
            boolean bl = cursor.moveToFirst();
            return bl;
        }
    }
}

