/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.measurement.zzdi;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzlc;
import com.google.android.gms.measurement.internal.zzld;
import com.google.android.gms.measurement.internal.zzle;
import com.google.android.gms.measurement.internal.zzlf;
import com.google.android.gms.measurement.internal.zzlg;
import com.google.android.gms.measurement.internal.zzlh;
import com.google.android.gms.measurement.internal.zzli;
import com.google.android.gms.measurement.internal.zzlj;
import com.google.android.gms.measurement.internal.zzlk;
import com.google.android.gms.measurement.internal.zzll;
import com.google.android.gms.measurement.internal.zzlm;
import com.google.android.gms.measurement.internal.zzln;
import com.google.android.gms.measurement.internal.zzlo;
import com.google.android.gms.measurement.internal.zzlp;
import com.google.android.gms.measurement.internal.zzlq;
import com.google.android.gms.measurement.internal.zzlr;
import com.google.android.gms.measurement.internal.zzls;
import com.google.android.gms.measurement.internal.zzlt;
import com.google.android.gms.measurement.internal.zzlu;
import com.google.android.gms.measurement.internal.zzlv;
import com.google.android.gms.measurement.internal.zzlx;
import com.google.android.gms.measurement.internal.zzms;
import com.google.android.gms.measurement.internal.zzmv;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzno;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzla
extends zzg {
    private final zzlx zza;
    private @Nullable zzfq zzb;
    private volatile Boolean zzc;
    private final zzav zzd;
    private final zzms zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzav zzg;

    @WorkerThread
    private final @Nullable zzn zzb(boolean bl) {
        return ((zzd)this).zzg().zza(bl ? ((zzim)this).zzj().zzx() : null);
    }

    @WorkerThread
    protected final @Nullable zzal zzaa() {
        ((zzim)this).zzt();
        this.zzu();
        zzfq zzfq2 = this.zzb;
        if (zzfq2 == null) {
            this.zzad();
            ((zzim)this).zzj().zzc().zza("Failed to get consents; not connected to service yet.");
            return null;
        }
        zzn zzn2 = this.zzb(false);
        Preconditions.checkNotNull((Object)((Object)zzn2));
        try {
            zzal zzal2 = zzfq2.zza(zzn2);
            this.zzam();
            return zzal2;
        }
        catch (RemoteException remoteException) {
            ((zzim)this).zzj().zzg().zza("Failed to get consents; remote exception", (Object)remoteException);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ zzfq zza(zzla zzla2) {
        return zzla2.zzb;
    }

    static /* bridge */ /* synthetic */ zzlx zzb(zzla zzla2) {
        return zzla2.zza;
    }

    final Boolean zzab() {
        return this.zzc;
    }

    static /* bridge */ /* synthetic */ void zza(zzla zzla2, zzfq zzfq2) {
        zzla2.zzb = null;
    }

    static /* synthetic */ void zzc(zzla zzla2) {
        zzla2.zzal();
    }

    static /* synthetic */ void zzd(zzla zzla2) {
        zzla zzla3 = zzla2;
        ((zzim)zzla3).zzt();
        if (zzla3.zzah()) {
            ((zzim)zzla3).zzj().zzp().zza("Inactivity, disconnecting from the service");
            zzla3.zzae();
        }
    }

    static /* synthetic */ void zza(zzla zzla2, ComponentName componentName) {
        ComponentName componentName2 = componentName;
        zzla zzla3 = zzla2;
        ((zzim)zzla3).zzt();
        if (zzla3.zzb != null) {
            zzla3.zzb = null;
            ((zzim)zzla3).zzj().zzp().zza("Disconnected from device MeasurementService", componentName2);
            zzla zzla4 = zzla3;
            ((zzim)zzla4).zzt();
            zzla4.zzad();
        }
    }

    static /* synthetic */ void zze(zzla zzla2) {
        zzla2.zzam();
    }

    protected zzla(zzho zzho2) {
        super(zzho2);
        this.zze = new zzms(zzho2.zzb());
        this.zza = new zzlx(this);
        this.zzd = new zzld(this, zzho2);
        this.zzg = new zzlm(this, zzho2);
    }

    @WorkerThread
    protected final void zzac() {
        ((zzim)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzb(true);
        ((zzd)this).zzh().zzab();
        this.zza(new zzll(this, zzn2));
    }

    @WorkerThread
    final void zzad() {
        ((zzim)this).zzt();
        this.zzu();
        if (this.zzah()) {
            return;
        }
        if (this.zzak()) {
            this.zza.zza();
            return;
        }
        if (!((zzim)this).zze().zzx()) {
            Intent intent;
            zzla zzla2 = this;
            PackageManager packageManager = ((zzim)zzla2).zza().getPackageManager();
            List list = packageManager.queryIntentServices(intent = new Intent().setClassName(((zzim)zzla2).zza(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && !list.isEmpty()) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                intent2.setComponent(new ComponentName(((zzim)this).zza(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzim)this).zzj().zzg().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    @WorkerThread
    public final void zzae() {
        ((zzim)this).zzt();
        this.zzu();
        this.zza.zzb();
        try {
            ConnectionTracker.getInstance().unbindService(((zzim)this).zza(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zzal() {
        ((zzim)this).zzt();
        ((zzim)this).zzj().zzp().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                ((zzim)this).zzj().zzg().zza("Task exception while flushing queue", runtimeException);
            }
        }
        this.zzf.clear();
        this.zzg.zza();
    }

    @WorkerThread
    public final void zza(zzdi zzdi2) {
        ((zzim)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzli(this, zzn2, zzdi2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzim)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzlj(this, atomicReference, zzn2));
    }

    @WorkerThread
    protected final void zza(zzdi zzdi2, @Nullable String string, @Nullable String string2) {
        ((zzim)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzlv(this, string, string2, zzn2, zzdi2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzac>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3) {
        ((zzim)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzls(this, atomicReference, string, string2, string3, zzn2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zzmv>> atomicReference, Bundle bundle) {
        ((zzim)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzle(this, atomicReference, zzn2, bundle));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zzno>> atomicReference, boolean bl) {
        ((zzim)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzlf(this, atomicReference, zzn2, bl));
    }

    @WorkerThread
    protected final void zza(zzdi zzdi2, @Nullable String string, @Nullable String string2, boolean bl) {
        ((zzim)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzlc(this, string, string2, zzn2, bl, zzdi2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzno>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        ((zzim)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzlu(this, atomicReference, string, string2, string3, zzn2, bl));
    }

    @WorkerThread
    protected final void zza(zzbf zzbf2, @Nullable String string) {
        Preconditions.checkNotNull((Object)((Object)zzbf2));
        ((zzim)this).zzt();
        this.zzu();
        boolean bl = ((zzd)this).zzh().zza(zzbf2);
        zzn zzn2 = this.zzb(true);
        this.zza(new zzlq(this, true, zzn2, bl, zzbf2, string));
    }

    @WorkerThread
    public final void zza(zzdi zzdi2, zzbf zzbf2, String string) {
        ((zzim)this).zzt();
        this.zzu();
        if (((zzim)this).zzq().zza(12451000) != 0) {
            ((zzim)this).zzj().zzu().zza("Not bundling data. Service unavailable or out of date");
            ((zzim)this).zzq().zza(zzdi2, new byte[0]);
            return;
        }
        this.zza(new zzlp(this, zzbf2, string, zzdi2));
    }

    @WorkerThread
    private final void zzam() {
        ((zzim)this).zzt();
        this.zze.zzb();
        this.zzd.zza((Long)zzbh.zzaj.zza(null));
    }

    @WorkerThread
    protected final void zzaf() {
        ((zzim)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzb(false);
        ((zzd)this).zzh().zzaa();
        this.zza(new zzlg(this, zzn2));
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzim)this).zzt();
        if (this.zzah()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzim)this).zzj().zzg().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzad();
    }

    @WorkerThread
    final void zza(zzfq zzfq2, @Nullable AbstractSafeParcelable abstractSafeParcelable, zzn zzn2) {
        ((zzim)this).zzt();
        this.zzu();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            List<AbstractSafeParcelable> list = ((zzd)this).zzh().zza(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzbf) {
                    try {
                        zzfq2.zza((zzbf)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzim)this).zzj().zzg().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzno) {
                    try {
                        zzfq2.zza((zzno)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzim)this).zzj().zzg().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzac) {
                    try {
                        zzfq2.zza((zzac)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzim)this).zzj().zzg().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzim)this).zzj().zzg().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzac zzac2) {
        Preconditions.checkNotNull((Object)((Object)zzac2));
        ((zzim)this).zzt();
        this.zzu();
        boolean bl = ((zzd)this).zzh().zza(zzac2);
        zzac zzac3 = new zzac(zzac2);
        zzn zzn2 = this.zzb(true);
        this.zza(new zzlt(this, true, zzn2, bl, zzac3, zzac2));
    }

    @WorkerThread
    protected final void zza(boolean bl) {
        ((zzim)this).zzt();
        this.zzu();
        if (bl) {
            ((zzd)this).zzh().zzaa();
        }
        if (this.zzaj()) {
            zzn zzn2 = this.zzb(false);
            this.zza(new zzlr(this, zzn2));
        }
    }

    @WorkerThread
    protected final void zza(@Nullable zzks zzks2) {
        ((zzim)this).zzt();
        this.zzu();
        this.zza(new zzlk(this, zzks2));
    }

    @WorkerThread
    public final void zza(Bundle bundle) {
        ((zzim)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzln(this, zzn2, bundle));
    }

    @WorkerThread
    protected final void zzag() {
        ((zzim)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzb(true);
        this.zza(new zzlo(this, zzn2));
    }

    @WorkerThread
    protected final void zza(zzfq zzfq2) {
        ((zzim)this).zzt();
        Preconditions.checkNotNull((Object)zzfq2);
        this.zzb = zzfq2;
        this.zzam();
        this.zzal();
    }

    @WorkerThread
    protected final void zza(zzno zzno2) {
        ((zzim)this).zzt();
        this.zzu();
        boolean bl = ((zzd)this).zzh().zza(zzno2);
        zzn zzn2 = this.zzb(true);
        this.zza(new zzlh(this, zzn2, bl, zzno2));
    }

    @WorkerThread
    public final boolean zzah() {
        ((zzim)this).zzt();
        this.zzu();
        return this.zzb != null;
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    final boolean zzai() {
        ((zzim)this).zzt();
        this.zzu();
        if (!this.zzak()) {
            return true;
        }
        return ((zzim)this).zzq().zzg() >= 200900;
    }

    @WorkerThread
    final boolean zzaj() {
        ((zzim)this).zzt();
        this.zzu();
        if (!this.zzak()) {
            return true;
        }
        return ((zzim)this).zzq().zzg() >= (Integer)zzbh.zzbn.zza(null);
    }

    @WorkerThread
    final boolean zzak() {
        ((zzim)this).zzt();
        this.zzu();
        if (this.zzc == null) {
            boolean bl;
            zzla zzla2 = this;
            ((zzim)zzla2).zzt();
            zzla2.zzu();
            Boolean bl2 = ((zzim)zzla2).zzk().zzp();
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else {
                boolean bl3;
                boolean bl4;
                if (((zzd)zzla2).zzg().zzaa() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzim)zzla2).zzj().zzp().zza("Checking service availability");
                    int n = ((zzim)zzla2).zzq().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzim)zzla2).zzj().zzp().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzim)zzla2).zzj().zzp().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzim)zzla2).zzj().zzu().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzim)zzla2).zzj().zzc().zza("Service container out of date");
                            if (((zzim)zzla2).zzq().zzg() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            bl4 = bl2 == null;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzim)zzla2).zzj().zzu().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzim)zzla2).zzj().zzu().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzim)zzla2).zzj().zzu().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzim)zzla2).zze().zzx()) {
                    ((zzim)zzla2).zzj().zzg().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzim)zzla2).zzk().zza(bl4);
                }
                bl = bl4;
            }
            this.zzc = bl;
        }
        return this.zzc;
    }
}

