/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzpa;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzio;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzgb
extends zzin {
    private char zza = '\u0000';
    private long zzb = -1L;
    @GuardedBy(value="this")
    private @MonotonicNonNull String zzc;
    private final zzgd zzd = new zzgd(this, 6, false, false);
    private final zzgd zze = new zzgd(this, 6, true, false);
    private final zzgd zzf = new zzgd(this, 6, false, true);
    private final zzgd zzg = new zzgd(this, 5, false, false);
    private final zzgd zzh = new zzgd(this, 5, true, false);
    private final zzgd zzi = new zzgd(this, 5, false, true);
    private final zzgd zzj = new zzgd(this, 4, false, false);
    private final zzgd zzk = new zzgd(this, 3, false, false);
    private final zzgd zzl = new zzgd(this, 2, false, false);

    static /* bridge */ /* synthetic */ char zza(zzgb zzgb2) {
        return zzgb2.zza;
    }

    static /* bridge */ /* synthetic */ long zzb(zzgb zzgb2) {
        return zzgb2.zzb;
    }

    public final zzgd zzc() {
        return this.zzk;
    }

    public final zzgd zzg() {
        return this.zzd;
    }

    public final zzgd zzh() {
        return this.zzf;
    }

    public final zzgd zzm() {
        return this.zze;
    }

    public final zzgd zzn() {
        return this.zzj;
    }

    public final zzgd zzp() {
        return this.zzl;
    }

    public final zzgd zzu() {
        return this.zzg;
    }

    public final zzgd zzv() {
        return this.zzi;
    }

    public final zzgd zzw() {
        return this.zzh;
    }

    protected static @Nullable Object zza(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return new zzgc(string);
    }

    static String zza(boolean bl, @Nullable String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (string == null) {
            string = "";
        }
        String string2 = zzgb.zza(bl, object);
        String string3 = zzgb.zza(bl, object2);
        String string4 = zzgb.zza(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string5 = ": ";
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(string5);
            stringBuilder.append(string2);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append(string5);
            stringBuilder.append(string3);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            stringBuilder.append(string5);
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    private static String zza(boolean bl, @Nullable Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return String.valueOf(object);
            }
            if (Math.abs((Long)object) < 100L) {
                return String.valueOf(object);
            }
            String string = String.valueOf(object).charAt(0) == '-' ? "-" : "";
            String string2 = String.valueOf(Math.abs((Long)object));
            long l = Math.round(Math.pow(10.0, string2.length()) - 1.0);
            String string3 = string;
            long l2 = Math.round(Math.pow(10.0, string2.length() - 1));
            String string4 = string;
            return string4 + l2 + "..." + string3 + l;
        }
        if (object instanceof Boolean) {
            return String.valueOf(object);
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            StringBuilder stringBuilder = new StringBuilder(bl ? throwable.getClass().getName() : throwable.toString());
            String string = zzgb.zzb(zzho.class.getCanonicalName());
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String string5;
                if (stackTraceElement.isNativeMethod() || (string5 = stackTraceElement.getClassName()) == null || !zzgb.zzb(string5).equals(string)) continue;
                stringBuilder.append(": ");
                stringBuilder.append(stackTraceElement);
                break;
            }
            return stringBuilder.toString();
        }
        if (object instanceof zzgc) {
            return zzgc.zza((zzgc)object);
        }
        if (bl) {
            return "-";
        }
        return String.valueOf(object);
    }

    @VisibleForTesting
    private static String zzb(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            if (zzpa.zza() && ((Boolean)zzbh.zzcc.zza(null)).booleanValue()) {
                return "";
            }
            return string;
        }
        return string.substring(0, n);
    }

    public final @Nullable String zzx() {
        if (((zzio)this).zzk().zzb == null) {
            return null;
        }
        Pair<String, Long> pair = ((zzio)this).zzk().zzb.zza();
        if (pair == null || pair == zzgm.zza) {
            return null;
        }
        String string = (String)pair.first;
        String string2 = String.valueOf(pair.second);
        return string2 + ":" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"logTagDoNotUseDirectly"})
    @VisibleForTesting
    private final String zzy() {
        zzgb zzgb2 = this;
        synchronized (zzgb2) {
            if (this.zzc == null) {
                String string;
                zzgb zzgb3;
                if (this.zzu.zzw() != null) {
                    zzgb3 = this;
                    string = this.zzu.zzw();
                } else {
                    zzgb3 = this;
                    string = "FA";
                }
                zzgb3.zzc = string;
            }
            Preconditions.checkNotNull((Object)this.zzc);
            return this.zzc;
        }
    }

    static /* bridge */ /* synthetic */ void zza(zzgb zzgb2, long l) {
        zzgb2.zzb = l;
    }

    static /* bridge */ /* synthetic */ void zza(zzgb zzgb2, char c) {
        zzgb2.zza = c;
    }

    zzgb(zzho zzho2) {
        super(zzho2);
    }

    protected final void zza(int n, boolean bl, boolean bl2, String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (!bl && this.zza(n)) {
            String string2 = zzgb.zza(false, string, object, object2, object3);
            this.zza(n, string2);
        }
        if (!bl2 && n >= 5) {
            Object object4 = object3;
            Object object5 = object2;
            Object object6 = object;
            String string3 = string;
            int n2 = n;
            zzgb zzgb2 = this;
            Preconditions.checkNotNull((Object)string3);
            zzhh zzhh2 = zzgb2.zzu.zzo();
            if (zzhh2 == null) {
                zzgb2.zza(6, "Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzhh2.zzaf()) {
                zzgb2.zza(6, "Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= 9) {
                n2 = 8;
            }
            int n3 = n2;
            zzhh2.zzb(new zzga(zzgb2, n3, string3, object6, object5, object4));
        }
    }

    @VisibleForTesting
    protected final void zza(int n, String string) {
        Log.println((int)n, (String)this.zzy(), (String)string);
    }

    @VisibleForTesting
    protected final boolean zza(int n) {
        return Log.isLoggable((String)this.zzy(), (int)n);
    }

    @Override
    protected final boolean zzo() {
        return false;
    }
}

