/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.measurement.zzdi;
import com.google.android.gms.internal.measurement.zzod;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzkx;
import com.google.android.gms.measurement.internal.zzle;
import com.google.android.gms.measurement.internal.zzlg;
import com.google.android.gms.measurement.internal.zzlh;
import com.google.android.gms.measurement.internal.zzli;
import com.google.android.gms.measurement.internal.zzlj;
import com.google.android.gms.measurement.internal.zzlk;
import com.google.android.gms.measurement.internal.zzll;
import com.google.android.gms.measurement.internal.zzlm;
import com.google.android.gms.measurement.internal.zzln;
import com.google.android.gms.measurement.internal.zzlo;
import com.google.android.gms.measurement.internal.zzlp;
import com.google.android.gms.measurement.internal.zzlq;
import com.google.android.gms.measurement.internal.zzlr;
import com.google.android.gms.measurement.internal.zzls;
import com.google.android.gms.measurement.internal.zzlt;
import com.google.android.gms.measurement.internal.zzlu;
import com.google.android.gms.measurement.internal.zzlv;
import com.google.android.gms.measurement.internal.zzlw;
import com.google.android.gms.measurement.internal.zzlx;
import com.google.android.gms.measurement.internal.zzly;
import com.google.android.gms.measurement.internal.zzlz;
import com.google.android.gms.measurement.internal.zzma;
import com.google.android.gms.measurement.internal.zzmb;
import com.google.android.gms.measurement.internal.zzmy;
import com.google.android.gms.measurement.internal.zzmz;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zznv;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzlf
extends zzg {
    private final zzma zza;
    private @Nullable zzfq zzb;
    private volatile Boolean zzc;
    private final zzav zzd;
    private final zzmz zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzav zzg;

    @WorkerThread
    private final @Nullable zzn zzc(boolean bl) {
        return ((zzd)this).zzg().zza(bl ? ((zzio)this).zzj().zzx() : null);
    }

    @WorkerThread
    protected final @Nullable zzal zzaa() {
        ((zzio)this).zzt();
        this.zzu();
        zzfq zzfq2 = this.zzb;
        if (zzfq2 == null) {
            this.zzad();
            ((zzio)this).zzj().zzc().zza("Failed to get consents; not connected to service yet.");
            return null;
        }
        zzn zzn2 = this.zzc(false);
        Preconditions.checkNotNull((Object)((Object)zzn2));
        try {
            zzal zzal2 = zzfq2.zza(zzn2);
            this.zzaq();
            return zzal2;
        }
        catch (RemoteException remoteException) {
            ((zzio)this).zzj().zzg().zza("Failed to get consents; remote exception", (Object)remoteException);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ zzfq zza(zzlf zzlf2) {
        return zzlf2.zzb;
    }

    static /* bridge */ /* synthetic */ zzma zzb(zzlf zzlf2) {
        return zzlf2.zza;
    }

    final Boolean zzab() {
        return this.zzc;
    }

    static /* bridge */ /* synthetic */ void zza(zzlf zzlf2, zzfq zzfq2) {
        zzlf2.zzb = null;
    }

    static /* synthetic */ void zzc(zzlf zzlf2) {
        zzlf2.zzap();
    }

    static /* synthetic */ void zzd(zzlf zzlf2) {
        zzlf zzlf3 = zzlf2;
        ((zzio)zzlf3).zzt();
        if (zzlf3.zzak()) {
            ((zzio)zzlf3).zzj().zzp().zza("Inactivity, disconnecting from the service");
            zzlf3.zzae();
        }
    }

    static /* synthetic */ void zza(zzlf zzlf2, ComponentName componentName) {
        ComponentName componentName2 = componentName;
        zzlf zzlf3 = zzlf2;
        ((zzio)zzlf3).zzt();
        if (zzlf3.zzb != null) {
            zzlf3.zzb = null;
            ((zzio)zzlf3).zzj().zzp().zza("Disconnected from device MeasurementService", componentName2);
            zzlf zzlf4 = zzlf3;
            ((zzio)zzlf4).zzt();
            zzlf4.zzad();
        }
    }

    static /* synthetic */ void zze(zzlf zzlf2) {
        zzlf2.zzaq();
    }

    protected zzlf(zzho zzho2) {
        super(zzho2);
        this.zze = new zzmz(zzho2.zzb());
        this.zza = new zzma(this);
        this.zzd = new zzlg(this, zzho2);
        this.zzg = new zzlt(this, zzho2);
    }

    @WorkerThread
    protected final void zzac() {
        ((zzio)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(true);
        ((zzd)this).zzh().zzab();
        this.zza(new zzlo(this, zzn2));
    }

    @WorkerThread
    final void zzad() {
        ((zzio)this).zzt();
        this.zzu();
        if (this.zzak()) {
            return;
        }
        if (this.zzao()) {
            this.zza.zza();
            return;
        }
        if (!((zzio)this).zze().zzx()) {
            Intent intent;
            zzlf zzlf2 = this;
            PackageManager packageManager = ((zzio)zzlf2).zza().getPackageManager();
            List list = packageManager.queryIntentServices(intent = new Intent().setClassName(((zzio)zzlf2).zza(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && !list.isEmpty()) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                intent2.setComponent(new ComponentName(((zzio)this).zza(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzio)this).zzj().zzg().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    @WorkerThread
    public final void zzae() {
        ((zzio)this).zzt();
        this.zzu();
        this.zza.zzb();
        try {
            ConnectionTracker.getInstance().unbindService(((zzio)this).zza(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zzap() {
        ((zzio)this).zzt();
        ((zzio)this).zzj().zzp().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                ((zzio)this).zzj().zzg().zza("Task exception while flushing queue", runtimeException);
            }
        }
        this.zzf.clear();
        this.zzg.zza();
    }

    @WorkerThread
    public final void zza(zzdi zzdi2) {
        ((zzio)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzlp(this, zzn2, zzdi2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzio)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzlm(this, atomicReference, zzn2));
    }

    @WorkerThread
    protected final void zza(zzdi zzdi2, @Nullable String string, @Nullable String string2) {
        ((zzio)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzly(this, string, string2, zzn2, zzdi2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzac>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3) {
        ((zzio)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzlz(this, atomicReference, string, string2, string3, zzn2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zzmy>> atomicReference, Bundle bundle) {
        ((zzio)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzll(this, atomicReference, zzn2, bundle));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zznv>> atomicReference, boolean bl) {
        ((zzio)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzli(this, atomicReference, zzn2, bl));
    }

    @WorkerThread
    protected final void zza(zzdi zzdi2, @Nullable String string, @Nullable String string2, boolean bl) {
        ((zzio)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzlj(this, string, string2, zzn2, bl, zzdi2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zznv>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        ((zzio)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzmb(this, atomicReference, string, string2, string3, zzn2, bl));
    }

    final /* synthetic */ void zzaf() {
        zzfq zzfq2 = this.zzb;
        if (zzfq2 == null) {
            ((zzio)this).zzj().zzg().zza("Failed to send Dma consent settings to service");
            return;
        }
        try {
            zzn zzn2 = this.zzc(false);
            Preconditions.checkNotNull((Object)((Object)zzn2));
            zzfq2.zzf(zzn2);
            this.zzaq();
            return;
        }
        catch (RemoteException remoteException) {
            ((zzio)this).zzj().zzg().zza("Failed to send Dma consent settings to the service", (Object)remoteException);
            return;
        }
    }

    final /* synthetic */ void zzag() {
        zzfq zzfq2 = this.zzb;
        if (zzfq2 == null) {
            ((zzio)this).zzj().zzg().zza("Failed to send storage consent settings to service");
            return;
        }
        try {
            zzn zzn2 = this.zzc(false);
            Preconditions.checkNotNull((Object)((Object)zzn2));
            zzfq2.zzh(zzn2);
            this.zzaq();
            return;
        }
        catch (RemoteException remoteException) {
            ((zzio)this).zzj().zzg().zza("Failed to send storage consent settings to the service", (Object)remoteException);
            return;
        }
    }

    @WorkerThread
    protected final void zza(zzbf zzbf2, @Nullable String string) {
        Preconditions.checkNotNull((Object)((Object)zzbf2));
        ((zzio)this).zzt();
        this.zzu();
        boolean bl = ((zzd)this).zzh().zza(zzbf2);
        zzn zzn2 = this.zzc(true);
        this.zza(new zzlx(this, true, zzn2, bl, zzbf2, string));
    }

    @WorkerThread
    public final void zza(zzdi zzdi2, zzbf zzbf2, String string) {
        ((zzio)this).zzt();
        this.zzu();
        if (((zzio)this).zzq().zza(12451000) != 0) {
            ((zzio)this).zzj().zzu().zza("Not bundling data. Service unavailable or out of date");
            ((zzio)this).zzq().zza(zzdi2, new byte[0]);
            return;
        }
        this.zza(new zzls(this, zzbf2, string, zzdi2));
    }

    @WorkerThread
    private final void zzaq() {
        ((zzio)this).zzt();
        this.zze.zzb();
        this.zzd.zza((Long)zzbh.zzaj.zza(null));
    }

    @WorkerThread
    protected final void zzah() {
        ((zzio)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        ((zzd)this).zzh().zzaa();
        this.zza(new zzln(this, zzn2));
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzio)this).zzt();
        if (this.zzak()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzio)this).zzj().zzg().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzad();
    }

    @WorkerThread
    final void zza(zzfq zzfq2, @Nullable AbstractSafeParcelable abstractSafeParcelable, zzn zzn2) {
        ((zzio)this).zzt();
        this.zzu();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            List<AbstractSafeParcelable> list = ((zzd)this).zzh().zza(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzbf) {
                    try {
                        zzfq2.zza((zzbf)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzio)this).zzj().zzg().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zznv) {
                    try {
                        zzfq2.zza((zznv)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzio)this).zzj().zzg().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzac) {
                    try {
                        zzfq2.zza((zzac)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzio)this).zzj().zzg().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzio)this).zzj().zzg().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzac zzac2) {
        Preconditions.checkNotNull((Object)((Object)zzac2));
        ((zzio)this).zzt();
        this.zzu();
        boolean bl = ((zzd)this).zzh().zza(zzac2);
        zzac zzac3 = new zzac(zzac2);
        zzn zzn2 = this.zzc(true);
        this.zza(new zzlw(this, true, zzn2, bl, zzac3, zzac2));
    }

    @WorkerThread
    protected final void zza(boolean bl) {
        ((zzio)this).zzt();
        this.zzu();
        if (!(zzod.zza() && ((zzio)this).zze().zza(zzbh.zzdf) || !bl)) {
            ((zzd)this).zzh().zzaa();
        }
        if (this.zzam()) {
            zzn zzn2 = this.zzc(false);
            this.zza(new zzlu(this, zzn2));
        }
    }

    @WorkerThread
    protected final void zza(@Nullable zzkx zzkx2) {
        ((zzio)this).zzt();
        this.zzu();
        this.zza(new zzlr(this, zzkx2));
    }

    @WorkerThread
    public final void zza(Bundle bundle) {
        ((zzio)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzlq(this, zzn2, bundle));
    }

    @WorkerThread
    protected final void zzai() {
        ((zzio)this).zzt();
        this.zzu();
        zzlf zzlf2 = this;
        this.zza(new zzlh(zzlf2));
    }

    @WorkerThread
    protected final void zzaj() {
        ((zzio)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(true);
        this.zza(new zzlv(this, zzn2));
    }

    @WorkerThread
    protected final void zza(zzfq zzfq2) {
        ((zzio)this).zzt();
        Preconditions.checkNotNull((Object)zzfq2);
        this.zzb = zzfq2;
        this.zzaq();
        this.zzap();
    }

    @WorkerThread
    protected final void zzb(boolean bl) {
        ((zzio)this).zzt();
        this.zzu();
        if (!(zzod.zza() && ((zzio)this).zze().zza(zzbh.zzdf) || !bl)) {
            ((zzd)this).zzh().zzaa();
        }
        zzlf zzlf2 = this;
        this.zza(new zzle(zzlf2));
    }

    @WorkerThread
    protected final void zza(zznv zznv2) {
        ((zzio)this).zzt();
        this.zzu();
        boolean bl = ((zzd)this).zzh().zza(zznv2);
        zzn zzn2 = this.zzc(true);
        this.zza(new zzlk(this, zzn2, bl, zznv2));
    }

    @WorkerThread
    public final boolean zzak() {
        ((zzio)this).zzt();
        this.zzu();
        return this.zzb != null;
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    final boolean zzal() {
        ((zzio)this).zzt();
        this.zzu();
        if (!this.zzao()) {
            return true;
        }
        return ((zzio)this).zzq().zzg() >= 200900;
    }

    @WorkerThread
    final boolean zzam() {
        ((zzio)this).zzt();
        this.zzu();
        if (!this.zzao()) {
            return true;
        }
        return ((zzio)this).zzq().zzg() >= (Integer)zzbh.zzbn.zza(null);
    }

    @WorkerThread
    final boolean zzan() {
        ((zzio)this).zzt();
        this.zzu();
        if (!this.zzao()) {
            return true;
        }
        return ((zzio)this).zzq().zzg() >= 241200;
    }

    @WorkerThread
    final boolean zzao() {
        ((zzio)this).zzt();
        this.zzu();
        if (this.zzc == null) {
            boolean bl;
            zzlf zzlf2 = this;
            ((zzio)zzlf2).zzt();
            zzlf2.zzu();
            Boolean bl2 = ((zzio)zzlf2).zzk().zzp();
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else {
                boolean bl3;
                boolean bl4;
                if (((zzd)zzlf2).zzg().zzaa() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzio)zzlf2).zzj().zzp().zza("Checking service availability");
                    int n = ((zzio)zzlf2).zzq().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzio)zzlf2).zzj().zzp().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzio)zzlf2).zzj().zzp().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzio)zzlf2).zzj().zzu().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzio)zzlf2).zzj().zzc().zza("Service container out of date");
                            if (((zzio)zzlf2).zzq().zzg() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            bl4 = bl2 == null;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzio)zzlf2).zzj().zzu().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzio)zzlf2).zzj().zzu().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzio)zzlf2).zzj().zzu().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzio)zzlf2).zze().zzx()) {
                    ((zzio)zzlf2).zzj().zzg().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzio)zzlf2).zzk().zza(bl4);
                }
                bl = bl4;
            }
            this.zzc = bl;
        }
        return this.zzc;
    }
}

