/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzpi;
import com.google.android.gms.internal.measurement.zzpn;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzit;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzag
extends zzim {
    private @Nullable Boolean zza;
    private @Nullable String zzb;
    private zzai zzc = new zzaf();
    private @MonotonicNonNull Boolean zzd;

    @WorkerThread
    public final double zza(@Nullable String string, zzfq<Double> zzfq2) {
        if (string == null) {
            return zzfq2.zza(null);
        }
        String string2 = this.zzc.zza(string, zzfq2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfq2.zza(null);
        }
        try {
            double d = Double.parseDouble(string2);
            return zzfq2.zza(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzfq2.zza(null);
        }
    }

    final int zzc() {
        if (zzpn.zza()) {
            zzfq<Boolean> zzfq2 = zzbf.zzcb;
            if (((zzim)this).zze().zzf(null, zzfq2)) {
                if (((zzim)this).zzq().zza(231100000, true)) {
                    return 35;
                }
                return 0;
            }
        }
        return 0;
    }

    final int zza(@Size(min=1L) String string) {
        return this.zza(string, zzbf.zzah, 500, 2000);
    }

    final int zza(@Nullable String string, boolean bl) {
        if (zzpi.zza()) {
            zzfq<Boolean> zzfq2 = zzbf.zzcu;
            if (((zzim)this).zze().zzf(null, zzfq2)) {
                if (bl) {
                    return this.zza(string, zzbf.zzar, 100, 500);
                }
                return 500;
            }
        }
        return 100;
    }

    final int zzb(@Nullable String string, boolean bl) {
        return Math.max(this.zza(string, bl), 256);
    }

    public final int zzg() {
        if (((zzim)this).zzq().zza(201500000, true)) {
            return 100;
        }
        return 25;
    }

    public final int zzb(@Size(min=1L) String string) {
        return this.zza(string, zzbf.zzai, 25, 100);
    }

    @WorkerThread
    public final int zzc(@Size(min=1L) String string) {
        return this.zzb(string, zzbf.zzo);
    }

    @WorkerThread
    public final int zzb(@Nullable String string, zzfq<Integer> zzfq2) {
        if (string == null) {
            return zzfq2.zza(null);
        }
        String string2 = this.zzc.zza(string, zzfq2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfq2.zza(null);
        }
        try {
            int n = Integer.parseInt(string2);
            return zzfq2.zza(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzfq2.zza(null);
        }
    }

    @WorkerThread
    public final int zza(@Nullable String string, zzfq<Integer> zzfq2, int n, int n2) {
        return Math.max(Math.min(this.zzb(string, zzfq2), n2), n);
    }

    @WorkerThread
    final long zzd(String string) {
        return this.zzc(string, zzbf.zza);
    }

    public static long zzh() {
        return zzbf.zzd.zza(null);
    }

    public static long zzm() {
        return zzbf.zzad.zza(null);
    }

    @WorkerThread
    public final long zzc(@Nullable String string, zzfq<Long> zzfq2) {
        if (string == null) {
            return zzfq2.zza(null);
        }
        String string2 = this.zzc.zza(string, zzfq2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfq2.zza(null);
        }
        try {
            long l = Long.parseLong(string2);
            return zzfq2.zza(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzfq2.zza(null);
        }
    }

    @VisibleForTesting
    private final @Nullable Bundle zzz() {
        try {
            if (((zzim)this).zza().getPackageManager() == null) {
                ((zzim)this).zzj().zzg().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzim)this).zza()).getApplicationInfo(((zzim)this).zza().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzim)this).zzj().zzg().zza("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            return applicationInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzim)this).zzj().zzg().zza("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public final zzit zze(String string) {
        Object object;
        Object object2;
        String string2 = string;
        zzag zzag2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzag2.zzz();
        if (bundle == null) {
            ((zzim)zzag2).zzj().zzg().zza("Failed to load metadata: Metadata bundle is null");
            object2 = null;
        } else {
            object2 = object = bundle.get(string2);
        }
        if (object2 == null) {
            return zzit.zza;
        }
        if (Boolean.TRUE.equals(object)) {
            return zzit.zzd;
        }
        if (Boolean.FALSE.equals(object)) {
            return zzit.zzc;
        }
        if ("default".equals(object)) {
            return zzit.zzb;
        }
        ((zzim)this).zzj().zzu().zza("Invalid manifest metadata for", string);
        return zzit.zza;
    }

    @VisibleForTesting
    final @Nullable Boolean zzf(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzz();
        if (bundle == null) {
            ((zzim)this).zzj().zzg().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    public final String zzn() {
        return this.zza("debug.firebase.analytics.app", "");
    }

    public final String zzo() {
        return this.zza("debug.deferred.deeplink", "");
    }

    @WorkerThread
    public final String zzd(@Nullable String string, zzfq<String> zzfq2) {
        if (string == null) {
            return zzfq2.zza(null);
        }
        return zzfq2.zza(this.zzc.zza(string, zzfq2.zza()));
    }

    public final @Nullable String zzp() {
        return this.zzb;
    }

    @WorkerThread
    final String zzg(String string) {
        return this.zzd(string, zzbf.zzal);
    }

    private final String zza(String string, String string2) {
        try {
            String string3 = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
            Preconditions.checkNotNull((Object)string3);
            return string3;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzim)this).zzj().zzg().zza("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzim)this).zzj().zzg().zza("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzim)this).zzj().zzg().zza("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzim)this).zzj().zzg().zza("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return string2;
    }

    @VisibleForTesting
    final @Nullable List<String> zzh(@Size(min=1L) String string) {
        Integer n;
        Integer n2;
        String string2 = string;
        zzag zzag2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzag2.zzz();
        if (bundle == null) {
            ((zzim)zzag2).zzj().zzg().zza("Failed to load metadata: Metadata bundle is null");
            n2 = null;
        } else {
            n2 = n = !bundle.containsKey(string2) ? null : Integer.valueOf(bundle.getInt(string2));
        }
        if (n2 == null) {
            return null;
        }
        try {
            String[] stringArray = ((zzim)this).zza().getResources().getStringArray(n.intValue());
            if (stringArray == null) {
                return null;
            }
            return Arrays.asList(stringArray);
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzim)this).zzj().zzg().zza("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    zzag(zzhm zzhm2) {
        super(zzhm2);
    }

    final void zza(zzai zzai2) {
        this.zzc = zzai2;
    }

    public final void zzi(@Nullable String string) {
        this.zzb = string;
    }

    public final boolean zzu() {
        Boolean bl = this.zzf("google_analytics_adid_collection_enabled");
        return bl == null || bl != false;
    }

    @WorkerThread
    final boolean zzj(String string) {
        return this.zzf(string, zzbf.zzak);
    }

    public final boolean zza(zzfq<Boolean> zzfq2) {
        zzfq<Boolean> zzfq3 = zzfq2;
        return this.zzf(null, zzfq3);
    }

    public final boolean zze(@Nullable String string, zzfq<Boolean> zzfq2) {
        return this.zzf(string, zzfq2);
    }

    @WorkerThread
    public final boolean zzf(@Nullable String string, zzfq<Boolean> zzfq2) {
        if (string == null) {
            return zzfq2.zza(null);
        }
        String string2 = this.zzc.zza(string, zzfq2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzfq2.zza(null);
        }
        return zzfq2.zza("1".equals(string2));
    }

    public final boolean zzk(String string) {
        return "1".equals(this.zzc.zza(string, "gaia_collection_enabled"));
    }

    public final boolean zzv() {
        Boolean bl = this.zzf("google_analytics_automatic_screen_reporting_enabled");
        return bl == null || bl != false;
    }

    public final boolean zzw() {
        Boolean bl = this.zzf("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final boolean zzl(String string) {
        return "1".equals(this.zzc.zza(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzx() {
        if (this.zza == null) {
            this.zza = this.zzf("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzu.zzag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"this.isMainProcess"})
    public final boolean zzy() {
        if (this.zzd == null) {
            zzag zzag2 = this;
            synchronized (zzag2) {
                if (this.zzd == null) {
                    ApplicationInfo applicationInfo = ((zzim)this).zza().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzd = string2 != null && string2.equals(string);
                    }
                    if (this.zzd == null) {
                        this.zzd = Boolean.TRUE;
                        ((zzim)this).zzj().zzg().zza("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzd;
    }
}

