/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzpb;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzip;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzfz
extends zzip {
    private char zza = '\u0000';
    private long zzb = -1L;
    @GuardedBy(value="this")
    private @MonotonicNonNull String zzc;
    private final zzgb zzd = new zzgb(this, 6, false, false);
    private final zzgb zze = new zzgb(this, 6, true, false);
    private final zzgb zzf = new zzgb(this, 6, false, true);
    private final zzgb zzg = new zzgb(this, 5, false, false);
    private final zzgb zzh = new zzgb(this, 5, true, false);
    private final zzgb zzi = new zzgb(this, 5, false, true);
    private final zzgb zzj = new zzgb(this, 4, false, false);
    private final zzgb zzk = new zzgb(this, 3, false, false);
    private final zzgb zzl = new zzgb(this, 2, false, false);

    static /* bridge */ /* synthetic */ char zza(zzfz zzfz2) {
        return zzfz2.zza;
    }

    static /* bridge */ /* synthetic */ long zzb(zzfz zzfz2) {
        return zzfz2.zzb;
    }

    public final zzgb zzc() {
        return this.zzk;
    }

    public final zzgb zzg() {
        return this.zzd;
    }

    public final zzgb zzh() {
        return this.zzf;
    }

    public final zzgb zzm() {
        return this.zze;
    }

    public final zzgb zzn() {
        return this.zzj;
    }

    public final zzgb zzp() {
        return this.zzl;
    }

    public final zzgb zzu() {
        return this.zzg;
    }

    public final zzgb zzv() {
        return this.zzi;
    }

    public final zzgb zzw() {
        return this.zzh;
    }

    protected static @Nullable Object zza(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return new zzge(string);
    }

    static String zza(boolean bl, @Nullable String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (string == null) {
            string = "";
        }
        String string2 = zzfz.zza(bl, object);
        String string3 = zzfz.zza(bl, object2);
        String string4 = zzfz.zza(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string5 = ": ";
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(string5);
            stringBuilder.append(string2);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append(string5);
            stringBuilder.append(string3);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            stringBuilder.append(string5);
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    private static String zza(boolean bl, @Nullable Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return String.valueOf(object);
            }
            if (Math.abs((Long)object) < 100L) {
                return String.valueOf(object);
            }
            String string = String.valueOf(object).charAt(0) == '-' ? "-" : "";
            String string2 = String.valueOf(Math.abs((Long)object));
            long l = Math.round(Math.pow(10.0, string2.length()) - 1.0);
            String string3 = string;
            long l2 = Math.round(Math.pow(10.0, string2.length() - 1));
            String string4 = string;
            return string4 + l2 + "..." + string3 + l;
        }
        if (object instanceof Boolean) {
            return String.valueOf(object);
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            StringBuilder stringBuilder = new StringBuilder(bl ? throwable.getClass().getName() : throwable.toString());
            String string = zzfz.zzb(zzhm.class.getCanonicalName());
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String string5;
                if (stackTraceElement.isNativeMethod() || (string5 = stackTraceElement.getClassName()) == null || !zzfz.zzb(string5).equals(string)) continue;
                stringBuilder.append(": ");
                stringBuilder.append(stackTraceElement);
                break;
            }
            return stringBuilder.toString();
        }
        if (object instanceof zzge) {
            return zzge.zza((zzge)object);
        }
        if (bl) {
            return "-";
        }
        return String.valueOf(object);
    }

    @VisibleForTesting
    private static String zzb(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            if (zzpb.zza() && ((Boolean)zzbf.zzca.zza(null)).booleanValue()) {
                return "";
            }
            return string;
        }
        return string.substring(0, n);
    }

    public final @Nullable String zzx() {
        if (((zzim)this).zzk().zzb == null) {
            return null;
        }
        Pair<String, Long> pair = ((zzim)this).zzk().zzb.zza();
        if (pair == null || pair == zzgo.zza) {
            return null;
        }
        String string = (String)pair.first;
        String string2 = String.valueOf(pair.second);
        return string2 + ":" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"logTagDoNotUseDirectly"})
    @VisibleForTesting
    private final String zzy() {
        zzfz zzfz2 = this;
        synchronized (zzfz2) {
            if (this.zzc == null) {
                String string;
                zzfz zzfz3;
                if (this.zzu.zzw() != null) {
                    zzfz3 = this;
                    string = this.zzu.zzw();
                } else {
                    zzfz3 = this;
                    string = "FA";
                }
                zzfz3.zzc = string;
            }
            Preconditions.checkNotNull((Object)this.zzc);
            return this.zzc;
        }
    }

    static /* bridge */ /* synthetic */ void zza(zzfz zzfz2, long l) {
        zzfz2.zzb = l;
    }

    static /* bridge */ /* synthetic */ void zza(zzfz zzfz2, char c) {
        zzfz2.zza = c;
    }

    zzfz(zzhm zzhm2) {
        super(zzhm2);
    }

    protected final void zza(int n, boolean bl, boolean bl2, String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (!bl && this.zza(n)) {
            String string2 = zzfz.zza(false, string, object, object2, object3);
            this.zza(n, string2);
        }
        if (!bl2 && n >= 5) {
            Object object4 = object3;
            Object object5 = object2;
            Object object6 = object;
            String string3 = string;
            int n2 = n;
            zzfz zzfz2 = this;
            Preconditions.checkNotNull((Object)string3);
            zzhj zzhj2 = zzfz2.zzu.zzo();
            if (zzhj2 == null) {
                zzfz2.zza(6, "Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzhj2.zzaf()) {
                zzfz2.zza(6, "Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= 9) {
                n2 = 8;
            }
            int n3 = n2;
            zzhj2.zzb(new zzgc(zzfz2, n3, string3, object6, object5, object4));
        }
    }

    @VisibleForTesting
    protected final void zza(int n, String string) {
        Log.println((int)n, (String)this.zzy(), (String)string);
    }

    @VisibleForTesting
    protected final boolean zza(int n) {
        return Log.isLoggable((String)this.zzy(), (int)n);
    }

    @Override
    protected final boolean zzo() {
        return false;
    }
}

