/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.SharedPreferences;
import android.os.Bundle;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzpz;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzgo;
import java.util.Arrays;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzgq {
    private final String zza;
    private final Bundle zzb;
    private @Nullable Bundle zzc;
    private final /* synthetic */ zzgo zzd;

    @WorkerThread
    public final Bundle zza() {
        zzgq zzgq2 = this;
        if (zzgq2.zzc == null) {
            String string = zzgq2.zzd.zzg().getString(zzgq2.zza, null);
            if (string != null) {
                try {
                    Bundle bundle = new Bundle();
                    JSONArray jSONArray = new JSONArray(string);
                    block18: for (int i = 0; i < jSONArray.length(); ++i) {
                        try {
                            String string2;
                            JSONObject jSONObject = jSONArray.getJSONObject(i);
                            String string3 = jSONObject.getString("n");
                            switch (string2 = jSONObject.getString("t")) {
                                case "s": {
                                    String string4 = jSONObject.getString("v");
                                    bundle.putString(string3, string4);
                                    break;
                                }
                                case "d": {
                                    double d = Double.parseDouble(jSONObject.getString("v"));
                                    bundle.putDouble(string3, d);
                                    break;
                                }
                                case "l": {
                                    long l = Long.parseLong(jSONObject.getString("v"));
                                    bundle.putLong(string3, l);
                                    break;
                                }
                                case "ia": {
                                    int n;
                                    if (!zzpz.zza() || !zzgq2.zzd.zze().zza(zzbf.zzcf)) continue block18;
                                    JSONArray jSONArray2 = new JSONArray(jSONObject.getString("v"));
                                    Object[] objectArray = new int[jSONArray2.length()];
                                    for (n = 0; n < objectArray.length; ++n) {
                                        objectArray[n] = jSONArray2.optInt(n);
                                    }
                                    bundle.putIntArray(string3, objectArray);
                                    break;
                                }
                                case "la": {
                                    int n;
                                    if (!zzpz.zza() || !zzgq2.zzd.zze().zza(zzbf.zzcf)) continue block18;
                                    JSONArray jSONArray2 = new JSONArray(jSONObject.getString("v"));
                                    Object[] objectArray = new long[jSONArray2.length()];
                                    for (n = 0; n < objectArray.length; ++n) {
                                        objectArray[n] = (int)jSONArray2.optLong(n);
                                    }
                                    bundle.putLongArray(string3, (long[])objectArray);
                                    break;
                                }
                                default: {
                                    zzgq2.zzd.zzj().zzg().zza("Unrecognized persisted bundle type. Type", string2);
                                    break;
                                }
                            }
                            continue;
                        }
                        catch (NumberFormatException | JSONException throwable) {
                            zzgq2.zzd.zzj().zzg().zza("Error reading value from SharedPreferences. Value dropped");
                        }
                    }
                    zzgq2.zzc = bundle;
                }
                catch (JSONException jSONException) {
                    zzgq2.zzd.zzj().zzg().zza("Error loading bundle from SharedPreferences. Values will be lost");
                }
            }
            if (zzgq2.zzc == null) {
                zzgq2.zzc = zzgq2.zzb;
            }
        }
        return this.zzc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String zzb(Bundle bundle) {
        JSONArray jSONArray = new JSONArray();
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = bundle.get(string);
            if (object == null) continue;
            try {
                JSONObject jSONObject;
                block14: {
                    block15: {
                        block18: {
                            block17: {
                                block16: {
                                    jSONObject = new JSONObject();
                                    jSONObject.put("n", (Object)string);
                                    if (!zzpz.zza() || !this.zzd.zze().zza(zzbf.zzcf)) break block15;
                                    if (!(object instanceof String)) break block16;
                                    jSONObject.put("v", (Object)String.valueOf(object));
                                    jSONObject.put("t", (Object)"s");
                                    break block14;
                                }
                                if (!(object instanceof Long)) break block17;
                                jSONObject.put("v", (Object)String.valueOf(object));
                                jSONObject.put("t", (Object)"l");
                                break block14;
                            }
                            if (!(object instanceof int[])) break block18;
                            jSONObject.put("v", (Object)Arrays.toString((int[])object));
                            jSONObject.put("t", (Object)"ia");
                            break block14;
                        }
                        if (object instanceof long[]) {
                            jSONObject.put("v", (Object)Arrays.toString((long[])object));
                            jSONObject.put("t", (Object)"la");
                            break block14;
                        } else if (object instanceof Double) {
                            jSONObject.put("v", (Object)String.valueOf(object));
                            jSONObject.put("t", (Object)"d");
                            break block14;
                        } else {
                            this.zzd.zzj().zzg().zza("Cannot serialize bundle value to SharedPreferences. Type", object.getClass());
                            continue;
                        }
                    }
                    jSONObject.put("v", (Object)String.valueOf(object));
                    if (object instanceof String) {
                        jSONObject.put("t", (Object)"s");
                    } else if (object instanceof Long) {
                        jSONObject.put("t", (Object)"l");
                    } else if (object instanceof Double) {
                        jSONObject.put("t", (Object)"d");
                    } else {
                        this.zzd.zzj().zzg().zza("Cannot serialize bundle value to SharedPreferences. Type", object.getClass());
                        continue;
                    }
                }
                jSONArray.put((Object)jSONObject);
            }
            catch (JSONException jSONException) {
                this.zzd.zzj().zzg().zza("Cannot serialize bundle value to SharedPreferences", (Object)jSONException);
                continue;
            }
            break;
        }
        return jSONArray.toString();
    }

    public zzgq(zzgo zzgo2, @Nullable String string, Bundle bundle) {
        this.zzd = zzgo2;
        Preconditions.checkNotEmpty((String)string);
        this.zza = string;
        this.zzb = new Bundle();
    }

    @WorkerThread
    public final void zza(@Nullable Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        SharedPreferences.Editor editor = this.zzd.zzg().edit();
        if (bundle.size() == 0) {
            editor.remove(this.zza);
        } else {
            editor.putString(this.zza, this.zzb(bundle));
        }
        editor.apply();
        this.zzc = bundle;
    }
}

