/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.measurement.zzdi;
import com.google.android.gms.internal.measurement.zzoe;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzlf;
import com.google.android.gms.measurement.internal.zzlg;
import com.google.android.gms.measurement.internal.zzlh;
import com.google.android.gms.measurement.internal.zzli;
import com.google.android.gms.measurement.internal.zzlj;
import com.google.android.gms.measurement.internal.zzlk;
import com.google.android.gms.measurement.internal.zzll;
import com.google.android.gms.measurement.internal.zzlm;
import com.google.android.gms.measurement.internal.zzln;
import com.google.android.gms.measurement.internal.zzlo;
import com.google.android.gms.measurement.internal.zzlp;
import com.google.android.gms.measurement.internal.zzlq;
import com.google.android.gms.measurement.internal.zzlr;
import com.google.android.gms.measurement.internal.zzls;
import com.google.android.gms.measurement.internal.zzlt;
import com.google.android.gms.measurement.internal.zzlu;
import com.google.android.gms.measurement.internal.zzlv;
import com.google.android.gms.measurement.internal.zzlw;
import com.google.android.gms.measurement.internal.zzlx;
import com.google.android.gms.measurement.internal.zzly;
import com.google.android.gms.measurement.internal.zzlz;
import com.google.android.gms.measurement.internal.zzma;
import com.google.android.gms.measurement.internal.zzmc;
import com.google.android.gms.measurement.internal.zzmx;
import com.google.android.gms.measurement.internal.zzna;
import com.google.android.gms.measurement.internal.zznt;
import com.google.android.gms.measurement.internal.zzo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzld
extends zze {
    private final zzmc zza;
    private @Nullable zzfs zzb;
    private volatile Boolean zzc;
    private final zzat zzd;
    private final zzmx zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzat zzg;

    @WorkerThread
    private final @Nullable zzo zzc(boolean bl) {
        return ((zzf)this).zzg().zza(bl ? ((zzim)this).zzj().zzx() : null);
    }

    @WorkerThread
    protected final @Nullable zzaj zzaa() {
        ((zzim)this).zzt();
        this.zzu();
        zzfs zzfs2 = this.zzb;
        if (zzfs2 == null) {
            this.zzad();
            ((zzim)this).zzj().zzc().zza("Failed to get consents; not connected to service yet.");
            return null;
        }
        zzo zzo2 = this.zzc(false);
        Preconditions.checkNotNull((Object)((Object)zzo2));
        try {
            zzaj zzaj2 = zzfs2.zza(zzo2);
            this.zzaq();
            return zzaj2;
        }
        catch (RemoteException remoteException) {
            ((zzim)this).zzj().zzg().zza("Failed to get consents; remote exception", (Object)remoteException);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ zzfs zza(zzld zzld2) {
        return zzld2.zzb;
    }

    static /* bridge */ /* synthetic */ zzmc zzb(zzld zzld2) {
        return zzld2.zza;
    }

    final Boolean zzab() {
        return this.zzc;
    }

    static /* bridge */ /* synthetic */ void zza(zzld zzld2, zzfs zzfs2) {
        zzld2.zzb = null;
    }

    static /* synthetic */ void zzc(zzld zzld2) {
        zzld2.zzap();
    }

    static /* synthetic */ void zzd(zzld zzld2) {
        zzld zzld3 = zzld2;
        ((zzim)zzld3).zzt();
        if (zzld3.zzak()) {
            ((zzim)zzld3).zzj().zzp().zza("Inactivity, disconnecting from the service");
            zzld3.zzae();
        }
    }

    static /* synthetic */ void zza(zzld zzld2, ComponentName componentName) {
        ComponentName componentName2 = componentName;
        zzld zzld3 = zzld2;
        ((zzim)zzld3).zzt();
        if (zzld3.zzb != null) {
            zzld3.zzb = null;
            ((zzim)zzld3).zzj().zzp().zza("Disconnected from device MeasurementService", componentName2);
            zzld zzld4 = zzld3;
            ((zzim)zzld4).zzt();
            zzld4.zzad();
        }
    }

    static /* synthetic */ void zze(zzld zzld2) {
        zzld2.zzaq();
    }

    protected zzld(zzhm zzhm2) {
        super(zzhm2);
        this.zze = new zzmx(zzhm2.zzb());
        this.zza = new zzmc(this);
        this.zzd = new zzli(this, zzhm2);
        this.zzg = new zzlr(this, zzhm2);
    }

    @WorkerThread
    protected final void zzac() {
        ((zzim)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(true);
        ((zzf)this).zzh().zzab();
        this.zza(new zzlq(this, zzo2));
    }

    @WorkerThread
    final void zzad() {
        ((zzim)this).zzt();
        this.zzu();
        if (this.zzak()) {
            return;
        }
        if (this.zzao()) {
            this.zza.zza();
            return;
        }
        if (!((zzim)this).zze().zzx()) {
            Intent intent;
            zzld zzld2 = this;
            PackageManager packageManager = ((zzim)zzld2).zza().getPackageManager();
            List list = packageManager.queryIntentServices(intent = new Intent().setClassName(((zzim)zzld2).zza(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && !list.isEmpty()) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                intent2.setComponent(new ComponentName(((zzim)this).zza(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzim)this).zzj().zzg().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    @WorkerThread
    public final void zzae() {
        ((zzim)this).zzt();
        this.zzu();
        this.zza.zzb();
        try {
            ConnectionTracker.getInstance().unbindService(((zzim)this).zza(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zzap() {
        ((zzim)this).zzt();
        ((zzim)this).zzj().zzp().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                ((zzim)this).zzj().zzg().zza("Task exception while flushing queue", runtimeException);
            }
        }
        this.zzf.clear();
        this.zzg.zza();
    }

    @WorkerThread
    public final void zza(zzdi zzdi2) {
        ((zzim)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzln(this, zzo2, zzdi2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzim)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzlo(this, atomicReference, zzo2));
    }

    @WorkerThread
    protected final void zza(zzdi zzdi2, @Nullable String string, @Nullable String string2) {
        ((zzim)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzma(this, string, string2, zzo2, zzdi2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzae>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3) {
        ((zzim)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzlx(this, atomicReference, string, string2, string3, zzo2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zzna>> atomicReference, Bundle bundle) {
        ((zzim)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzlj(this, atomicReference, zzo2, bundle));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zznt>> atomicReference, boolean bl) {
        ((zzim)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzlk(this, atomicReference, zzo2, bl));
    }

    @WorkerThread
    protected final void zza(zzdi zzdi2, @Nullable String string, @Nullable String string2, boolean bl) {
        ((zzim)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzlh(this, string, string2, zzo2, bl, zzdi2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zznt>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        ((zzim)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzlz(this, atomicReference, string, string2, string3, zzo2, bl));
    }

    final /* synthetic */ void zzaf() {
        zzfs zzfs2 = this.zzb;
        if (zzfs2 == null) {
            ((zzim)this).zzj().zzg().zza("Failed to send Dma consent settings to service");
            return;
        }
        try {
            zzo zzo2 = this.zzc(false);
            Preconditions.checkNotNull((Object)((Object)zzo2));
            zzfs2.zzf(zzo2);
            this.zzaq();
            return;
        }
        catch (RemoteException remoteException) {
            ((zzim)this).zzj().zzg().zza("Failed to send Dma consent settings to the service", (Object)remoteException);
            return;
        }
    }

    final /* synthetic */ void zzag() {
        zzfs zzfs2 = this.zzb;
        if (zzfs2 == null) {
            ((zzim)this).zzj().zzg().zza("Failed to send storage consent settings to service");
            return;
        }
        try {
            zzo zzo2 = this.zzc(false);
            Preconditions.checkNotNull((Object)((Object)zzo2));
            zzfs2.zzh(zzo2);
            this.zzaq();
            return;
        }
        catch (RemoteException remoteException) {
            ((zzim)this).zzj().zzg().zza("Failed to send storage consent settings to the service", (Object)remoteException);
            return;
        }
    }

    @WorkerThread
    protected final void zza(zzbd zzbd2, @Nullable String string) {
        Preconditions.checkNotNull((Object)((Object)zzbd2));
        ((zzim)this).zzt();
        this.zzu();
        boolean bl = ((zzf)this).zzh().zza(zzbd2);
        zzo zzo2 = this.zzc(true);
        this.zza(new zzlv(this, true, zzo2, bl, zzbd2, string));
    }

    @WorkerThread
    public final void zza(zzdi zzdi2, zzbd zzbd2, String string) {
        ((zzim)this).zzt();
        this.zzu();
        if (((zzim)this).zzq().zza(12451000) != 0) {
            ((zzim)this).zzj().zzu().zza("Not bundling data. Service unavailable or out of date");
            ((zzim)this).zzq().zza(zzdi2, new byte[0]);
            return;
        }
        this.zza(new zzlu(this, zzbd2, string, zzdi2));
    }

    @WorkerThread
    private final void zzaq() {
        ((zzim)this).zzt();
        this.zze.zzb();
        this.zzd.zza((Long)zzbf.zzaj.zza(null));
    }

    @WorkerThread
    protected final void zzah() {
        ((zzim)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        ((zzf)this).zzh().zzaa();
        this.zza(new zzll(this, zzo2));
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzim)this).zzt();
        if (this.zzak()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzim)this).zzj().zzg().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzad();
    }

    @WorkerThread
    final void zza(zzfs zzfs2, @Nullable AbstractSafeParcelable abstractSafeParcelable, zzo zzo2) {
        ((zzim)this).zzt();
        this.zzu();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            List<AbstractSafeParcelable> list = ((zzf)this).zzh().zza(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzbd) {
                    try {
                        zzfs2.zza((zzbd)abstractSafeParcelable2, zzo2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzim)this).zzj().zzg().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zznt) {
                    try {
                        zzfs2.zza((zznt)abstractSafeParcelable2, zzo2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzim)this).zzj().zzg().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzae) {
                    try {
                        zzfs2.zza((zzae)abstractSafeParcelable2, zzo2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzim)this).zzj().zzg().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzim)this).zzj().zzg().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzae zzae2) {
        Preconditions.checkNotNull((Object)((Object)zzae2));
        ((zzim)this).zzt();
        this.zzu();
        boolean bl = ((zzf)this).zzh().zza(zzae2);
        zzae zzae3 = new zzae(zzae2);
        zzo zzo2 = this.zzc(true);
        this.zza(new zzly(this, true, zzo2, bl, zzae3, zzae2));
    }

    @WorkerThread
    protected final void zza(boolean bl) {
        ((zzim)this).zzt();
        this.zzu();
        if (!(zzoe.zza() && ((zzim)this).zze().zza(zzbf.zzde) || !bl)) {
            ((zzf)this).zzh().zzaa();
        }
        if (this.zzam()) {
            zzo zzo2 = this.zzc(false);
            this.zza(new zzlw(this, zzo2));
        }
    }

    @WorkerThread
    protected final void zza(@Nullable zzkv zzkv2) {
        ((zzim)this).zzt();
        this.zzu();
        this.zza(new zzlp(this, zzkv2));
    }

    @WorkerThread
    public final void zza(Bundle bundle) {
        ((zzim)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzls(this, zzo2, bundle));
    }

    @WorkerThread
    protected final void zzai() {
        ((zzim)this).zzt();
        this.zzu();
        zzld zzld2 = this;
        this.zza(new zzlf(zzld2));
    }

    @WorkerThread
    protected final void zzaj() {
        ((zzim)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(true);
        this.zza(new zzlt(this, zzo2));
    }

    @WorkerThread
    protected final void zza(zzfs zzfs2) {
        ((zzim)this).zzt();
        Preconditions.checkNotNull((Object)zzfs2);
        this.zzb = zzfs2;
        this.zzaq();
        this.zzap();
    }

    @WorkerThread
    protected final void zzb(boolean bl) {
        ((zzim)this).zzt();
        this.zzu();
        if (!(zzoe.zza() && ((zzim)this).zze().zza(zzbf.zzde) || !bl)) {
            ((zzf)this).zzh().zzaa();
        }
        zzld zzld2 = this;
        this.zza(new zzlg(zzld2));
    }

    @WorkerThread
    protected final void zza(zznt zznt2) {
        ((zzim)this).zzt();
        this.zzu();
        boolean bl = ((zzf)this).zzh().zza(zznt2);
        zzo zzo2 = this.zzc(true);
        this.zza(new zzlm(this, zzo2, bl, zznt2));
    }

    @WorkerThread
    public final boolean zzak() {
        ((zzim)this).zzt();
        this.zzu();
        return this.zzb != null;
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    final boolean zzal() {
        ((zzim)this).zzt();
        this.zzu();
        if (!this.zzao()) {
            return true;
        }
        return ((zzim)this).zzq().zzg() >= 200900;
    }

    @WorkerThread
    final boolean zzam() {
        ((zzim)this).zzt();
        this.zzu();
        if (!this.zzao()) {
            return true;
        }
        return ((zzim)this).zzq().zzg() >= (Integer)zzbf.zzbn.zza(null);
    }

    @WorkerThread
    final boolean zzan() {
        ((zzim)this).zzt();
        this.zzu();
        if (!this.zzao()) {
            return true;
        }
        return ((zzim)this).zzq().zzg() >= 241200;
    }

    @WorkerThread
    final boolean zzao() {
        ((zzim)this).zzt();
        this.zzu();
        if (this.zzc == null) {
            boolean bl;
            zzld zzld2 = this;
            ((zzim)zzld2).zzt();
            zzld2.zzu();
            Boolean bl2 = ((zzim)zzld2).zzk().zzp();
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else {
                boolean bl3;
                boolean bl4;
                if (((zzf)zzld2).zzg().zzaa() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzim)zzld2).zzj().zzp().zza("Checking service availability");
                    int n = ((zzim)zzld2).zzq().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzim)zzld2).zzj().zzp().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzim)zzld2).zzj().zzp().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzim)zzld2).zzj().zzu().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzim)zzld2).zzj().zzc().zza("Service container out of date");
                            if (((zzim)zzld2).zzq().zzg() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            bl4 = bl2 == null;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzim)zzld2).zzj().zzu().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzim)zzld2).zzj().zzu().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzim)zzld2).zzj().zzu().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzim)zzld2).zze().zzx()) {
                    ((zzim)zzld2).zzj().zzg().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzim)zzld2).zzk().zza(bl4);
                }
                bl = bl4;
            }
            this.zzc = bl;
        }
        return this.zzc;
    }
}

