/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.internal.measurement.zzdl;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zzkk;
import com.google.android.gms.measurement.internal.zzkq;
import com.google.android.gms.measurement.zzb;
import com.google.android.gms.measurement.zzc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
@ShowFirstParty
@KeepForSdk
public class AppMeasurement {
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public static final String CRASH_ORIGIN = "crash";
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public static final String FCM_ORIGIN = "fcm";
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public static final String FIAM_ORIGIN = "fiam";
    private static volatile @Nullable AppMeasurement zza;
    private final zza zzb;

    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        return this.zzb.zza(string);
    }

    @Keep
    public long generateEventId() {
        return this.zzb.zza();
    }

    @Deprecated
    @ShowFirstParty
    @Keep
    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @NonNull
    public static AppMeasurement getInstance(@NonNull Context context) {
        return AppMeasurement.zza(context, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    private static AppMeasurement zza(Context context, @Nullable String string, @Nullable String string2) {
        if (zza != null) return zza;
        Class<AppMeasurement> clazz = AppMeasurement.class;
        synchronized (AppMeasurement.class) {
            if (zza != null) return zza;
            zzkk zzkk2 = AppMeasurement.zza(context, null);
            if (zzkk2 != null) {
                zza = new AppMeasurement(zzkk2);
            } else {
                zzhj zzhj2 = zzhj.zza(context, new zzdl(0L, 0L, true, null, null, null, null, null), null);
                zza = new AppMeasurement(zzhj2);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zza;
        }
    }

    private static @Nullable zzkk zza(Context context, @Nullable Bundle bundle) {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            return (zzkk)clazz.getDeclaredMethod("getScionFrontendApiImplementation", Context.class, Bundle.class).invoke(null, context, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @KeepForSdk
    @NonNull
    public @Nullable Boolean getBoolean() {
        return this.zzb.zzb();
    }

    @KeepForSdk
    @NonNull
    public @Nullable Double getDouble() {
        return this.zzb.zzc();
    }

    @KeepForSdk
    @NonNull
    public @Nullable Integer getInteger() {
        return this.zzb.zzd();
    }

    @KeepForSdk
    @NonNull
    public @Nullable Long getLong() {
        return this.zzb.zze();
    }

    @Keep
    @NonNull
    public @Nullable String getAppInstanceId() {
        return this.zzb.zzf();
    }

    @Keep
    @NonNull
    public @Nullable String getCurrentScreenClass() {
        return this.zzb.zzg();
    }

    @Keep
    @NonNull
    public @Nullable String getCurrentScreenName() {
        return this.zzb.zzh();
    }

    @Keep
    @NonNull
    public @Nullable String getGmpAppId() {
        return this.zzb.zzi();
    }

    @KeepForSdk
    @NonNull
    public @Nullable String getString() {
        return this.zzb.zzj();
    }

    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public List<ConditionalUserProperty> getConditionalUserProperties(@NonNull @Nullable String string, @Size(min=1L, max=23L) @NonNull @Nullable String string2) {
        List list = this.zzb.zza(string, string2);
        ArrayList<ConditionalUserProperty> arrayList = new ArrayList<ConditionalUserProperty>(list == null ? 0 : list.size());
        for (Bundle bundle : list) {
            arrayList.add(new ConditionalUserProperty(bundle));
        }
        return arrayList;
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public Map<String, Object> getUserProperties(boolean bl) {
        return this.zzb.zza(bl);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    @NonNull
    protected Map<String, Object> getUserProperties(@NonNull @Nullable String string, @Size(min=1L, max=24L) @NonNull @Nullable String string2, boolean bl) {
        return this.zzb.zza(string, string2, bl);
    }

    private AppMeasurement(zzhj zzhj2) {
        zzhj zzhj3 = zzhj2;
        this.zzb = new com.google.android.gms.measurement.zza(zzhj3);
    }

    private AppMeasurement(zzkk zzkk2) {
        zzkk zzkk3 = zzkk2;
        this.zzb = new zzc(zzkk3);
    }

    @Keep
    public void beginAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zzb.zzb(string);
    }

    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @NonNull @Nullable String string2, @NonNull @Nullable Bundle bundle) {
        this.zzb.zza(string, string2, bundle);
    }

    @Keep
    public void endAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zzb.zzc(string);
    }

    @ShowFirstParty
    @Keep
    public void logEventInternal(@NonNull String string, @NonNull String string2, @NonNull Bundle bundle) {
        this.zzb.zzb(string, string2, bundle);
    }

    @ShowFirstParty
    @KeepForSdk
    public void logEventInternalNoInterceptor(@NonNull String string, @NonNull String string2, @NonNull Bundle bundle, long l) {
        this.zzb.zza(string, string2, bundle, l);
    }

    @ShowFirstParty
    @KeepForSdk
    public void registerOnMeasurementEventListener(@NonNull OnEventListener onEventListener) {
        this.zzb.zza(onEventListener);
    }

    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void setConditionalUserProperty(@NonNull ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        ConditionalUserProperty conditionalUserProperty2 = conditionalUserProperty;
        Bundle bundle = new Bundle();
        if (conditionalUserProperty2.mAppId != null) {
            bundle.putString("app_id", conditionalUserProperty2.mAppId);
        }
        if (conditionalUserProperty2.mOrigin != null) {
            bundle.putString("origin", conditionalUserProperty2.mOrigin);
        }
        if (conditionalUserProperty2.mName != null) {
            bundle.putString("name", conditionalUserProperty2.mName);
        }
        if (conditionalUserProperty2.mValue != null) {
            zzio.zza((Bundle)bundle, (Object)conditionalUserProperty2.mValue);
        }
        if (conditionalUserProperty2.mTriggerEventName != null) {
            bundle.putString("trigger_event_name", conditionalUserProperty2.mTriggerEventName);
        }
        bundle.putLong("trigger_timeout", conditionalUserProperty2.mTriggerTimeout);
        if (conditionalUserProperty2.mTimedOutEventName != null) {
            bundle.putString("timed_out_event_name", conditionalUserProperty2.mTimedOutEventName);
        }
        if (conditionalUserProperty2.mTimedOutEventParams != null) {
            bundle.putBundle("timed_out_event_params", conditionalUserProperty2.mTimedOutEventParams);
        }
        if (conditionalUserProperty2.mTriggeredEventName != null) {
            bundle.putString("triggered_event_name", conditionalUserProperty2.mTriggeredEventName);
        }
        if (conditionalUserProperty2.mTriggeredEventParams != null) {
            bundle.putBundle("triggered_event_params", conditionalUserProperty2.mTriggeredEventParams);
        }
        bundle.putLong("time_to_live", conditionalUserProperty2.mTimeToLive);
        if (conditionalUserProperty2.mExpiredEventName != null) {
            bundle.putString("expired_event_name", conditionalUserProperty2.mExpiredEventName);
        }
        if (conditionalUserProperty2.mExpiredEventParams != null) {
            bundle.putBundle("expired_event_params", conditionalUserProperty2.mExpiredEventParams);
        }
        bundle.putLong("creation_timestamp", conditionalUserProperty2.mCreationTimestamp);
        bundle.putBoolean("active", conditionalUserProperty2.mActive);
        bundle.putLong("triggered_timestamp", conditionalUserProperty2.mTriggeredTimestamp);
        this.zzb.zza(bundle);
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public void setEventInterceptor(@NonNull EventInterceptor eventInterceptor) {
        this.zzb.zza(eventInterceptor);
    }

    @ShowFirstParty
    @KeepForSdk
    public void unregisterOnMeasurementEventListener(@NonNull OnEventListener onEventListener) {
        this.zzb.zzb(onEventListener);
    }

    private static abstract class zza
    implements zzkk {
        abstract @Nullable Boolean zzb();

        abstract @Nullable Double zzc();

        abstract @Nullable Integer zzd();

        abstract @Nullable Long zze();

        abstract @Nullable String zzj();

        abstract Map<String, Object> zza(boolean var1);

        private zza() {
        }

        /* synthetic */ zza(zzb zzb2) {
            this();
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static class ConditionalUserProperty {
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @NonNull
        public @Nullable String mAppId;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @NonNull
        public @Nullable String mOrigin;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @NonNull
        public @Nullable String mName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @NonNull
        public @Nullable Object mValue;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        @NonNull
        public @Nullable String mTriggerEventName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggerTimeout;
        @Keep
        @NonNull
        public @Nullable String mTimedOutEventName;
        @Keep
        @NonNull
        public @Nullable Bundle mTimedOutEventParams;
        @Keep
        @NonNull
        public @Nullable String mTriggeredEventName;
        @Keep
        @NonNull
        public @Nullable Bundle mTriggeredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTimeToLive;
        @Keep
        @NonNull
        public @Nullable String mExpiredEventName;
        @Keep
        @NonNull
        public @Nullable Bundle mExpiredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mCreationTimestamp;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public boolean mActive;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggeredTimestamp;

        @KeepForSdk
        public ConditionalUserProperty() {
        }

        @VisibleForTesting
        ConditionalUserProperty(@NonNull Bundle bundle) {
            Preconditions.checkNotNull((Object)bundle);
            this.mAppId = (String)zzio.zza((Bundle)bundle, (String)"app_id", String.class, null);
            this.mOrigin = (String)zzio.zza((Bundle)bundle, (String)"origin", String.class, null);
            this.mName = (String)zzio.zza((Bundle)bundle, (String)"name", String.class, null);
            this.mValue = zzio.zza((Bundle)bundle, (String)"value", Object.class, null);
            this.mTriggerEventName = (String)zzio.zza((Bundle)bundle, (String)"trigger_event_name", String.class, null);
            this.mTriggerTimeout = (Long)zzio.zza((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)0L);
            this.mTimedOutEventName = (String)zzio.zza((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
            this.mTimedOutEventParams = (Bundle)zzio.zza((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
            this.mTriggeredEventName = (String)zzio.zza((Bundle)bundle, (String)"triggered_event_name", String.class, null);
            this.mTriggeredEventParams = (Bundle)zzio.zza((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
            this.mTimeToLive = (Long)zzio.zza((Bundle)bundle, (String)"time_to_live", Long.class, (Object)0L);
            this.mExpiredEventName = (String)zzio.zza((Bundle)bundle, (String)"expired_event_name", String.class, null);
            this.mExpiredEventParams = (Bundle)zzio.zza((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
            this.mActive = (Boolean)zzio.zza((Bundle)bundle, (String)"active", Boolean.class, (Object)false);
            this.mCreationTimestamp = (Long)zzio.zza((Bundle)bundle, (String)"creation_timestamp", Long.class, (Object)0L);
            this.mTriggeredTimestamp = (Long)zzio.zza((Bundle)bundle, (String)"triggered_timestamp", Long.class, (Object)0L);
        }

        @KeepForSdk
        public ConditionalUserProperty(@NonNull ConditionalUserProperty conditionalUserProperty) {
            Preconditions.checkNotNull((Object)conditionalUserProperty);
            this.mAppId = conditionalUserProperty.mAppId;
            this.mOrigin = conditionalUserProperty.mOrigin;
            this.mCreationTimestamp = conditionalUserProperty.mCreationTimestamp;
            this.mName = conditionalUserProperty.mName;
            if (conditionalUserProperty.mValue != null) {
                this.mValue = zzkq.zza((Object)conditionalUserProperty.mValue);
                if (this.mValue == null) {
                    this.mValue = conditionalUserProperty.mValue;
                }
            }
            this.mActive = conditionalUserProperty.mActive;
            this.mTriggerEventName = conditionalUserProperty.mTriggerEventName;
            this.mTriggerTimeout = conditionalUserProperty.mTriggerTimeout;
            this.mTimedOutEventName = conditionalUserProperty.mTimedOutEventName;
            if (conditionalUserProperty.mTimedOutEventParams != null) {
                this.mTimedOutEventParams = new Bundle(conditionalUserProperty.mTimedOutEventParams);
            }
            this.mTriggeredEventName = conditionalUserProperty.mTriggeredEventName;
            if (conditionalUserProperty.mTriggeredEventParams != null) {
                this.mTriggeredEventParams = new Bundle(conditionalUserProperty.mTriggeredEventParams);
            }
            this.mTriggeredTimestamp = conditionalUserProperty.mTriggeredTimestamp;
            this.mTimeToLive = conditionalUserProperty.mTimeToLive;
            this.mExpiredEventName = conditionalUserProperty.mExpiredEventName;
            if (conditionalUserProperty.mExpiredEventParams != null) {
                this.mExpiredEventParams = new Bundle(conditionalUserProperty.mExpiredEventParams);
            }
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface OnEventListener
    extends zziu {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void onEvent(@NonNull String var1, @NonNull String var2, @NonNull Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface EventInterceptor
    extends zziv {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void interceptEvent(@NonNull String var1, @NonNull String var2, @NonNull Bundle var3, long var4);
    }
}

