/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzdl;
import com.google.android.gms.internal.measurement.zzgw;
import com.google.android.gms.internal.measurement.zznb;
import com.google.android.gms.internal.measurement.zzok;
import com.google.android.gms.internal.measurement.zzpd;
import com.google.android.gms.internal.measurement.zzpp;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzax;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzil;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzkn;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzlb;
import com.google.android.gms.measurement.internal.zzml;
import com.google.android.gms.measurement.internal.zznt;
import com.google.android.gms.measurement.internal.zzo;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.json.JSONException;
import org.json.JSONObject;

public class zzhj
implements zzil {
    private static volatile @Nullable zzhj zzb;
    private final Context zzc;
    private final @Nullable String zzd;
    private final @Nullable String zze;
    private final @Nullable String zzf;
    private final boolean zzg;
    private final zzad zzh;
    private final zzae zzi;
    private final zzgl zzj;
    private final zzfw zzk;
    private final zzhg zzl;
    private final zzml zzm;
    private final zznt zzn;
    private final zzfv zzo;
    private final Clock zzp;
    private final zzks zzq;
    private final zziz zzr;
    private final zza zzs;
    private final zzkn zzt;
    private final @Nullable String zzu;
    private zzft zzv;
    private zzlb zzw;
    private zzaz zzx;
    private zzfq zzy;
    private boolean zzz = false;
    private Boolean zzaa;
    private long zzab;
    private volatile @Nullable Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    @VisibleForTesting
    private Boolean zzae;
    private volatile boolean zzaf;
    private int zzag;
    private int zzah;
    private AtomicInteger zzai = new AtomicInteger(0);
    @VisibleForTesting
    final long zza;

    @WorkerThread
    public final int zzc() {
        ((zzij)this.zzl()).zzt();
        if (this.zzi.zzw()) {
            return 1;
        }
        if (this.zzae != null && this.zzae.booleanValue()) {
            return 2;
        }
        if (!this.zzad()) {
            return 8;
        }
        Boolean bl = this.zzn().zzv();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        zzae zzae2 = this.zzi;
        Boolean bl2 = zzae2.zzf("firebase_analytics_collection_enabled");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzad != null) {
            if (this.zzad.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    @Override
    @Pure
    public final Context zza() {
        return this.zzc;
    }

    @Override
    @Pure
    public final Clock zzb() {
        return this.zzp;
    }

    @Pure
    public final zza zze() {
        if (this.zzs == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzs;
    }

    @Override
    @Pure
    public final zzad zzd() {
        return this.zzh;
    }

    @Pure
    public final zzae zzf() {
        return this.zzi;
    }

    @Pure
    public final zzaz zzg() {
        zzhj.zza(this.zzx);
        return this.zzx;
    }

    @Pure
    public final zzfq zzh() {
        zzhj.zza(this.zzy);
        return this.zzy;
    }

    @Pure
    public final zzft zzi() {
        zzhj.zza(this.zzv);
        return this.zzv;
    }

    @Pure
    public final zzfv zzk() {
        return this.zzo;
    }

    @Override
    @Pure
    public final zzfw zzj() {
        zzhj.zza(this.zzk);
        return this.zzk;
    }

    public final @Nullable zzfw zzm() {
        if (this.zzk != null && this.zzk.zzaf()) {
            return this.zzk;
        }
        return null;
    }

    @Pure
    public final zzgl zzn() {
        zzhj.zza((zzij)this.zzj);
        return this.zzj;
    }

    @Override
    @Pure
    public final zzhg zzl() {
        zzhj.zza(this.zzl);
        return this.zzl;
    }

    @SideEffectFree
    final @Nullable zzhg zzo() {
        return this.zzl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzhj zza(Context context, @Nullable zzdl zzdl2, @Nullable Long l) {
        if (zzdl2 != null && (zzdl2.zze == null || zzdl2.zzf == null)) {
            zzdl2 = new zzdl(zzdl2.zza, zzdl2.zzb, zzdl2.zzc, zzdl2.zzd, null, null, zzdl2.zzg, null);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb == null) {
            Class<zzhj> clazz = zzhj.class;
            synchronized (zzhj.class) {
                if (zzb == null) {
                    zzix zzix2 = new zzix(context, zzdl2, l);
                    zzb = new zzhj(zzix2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (zzdl2 != null && zzdl2.zzg != null && zzdl2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            Preconditions.checkNotNull((Object)zzb);
            zzb.zza(zzdl2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        {
            Preconditions.checkNotNull((Object)zzb);
            return zzb;
        }
    }

    @Pure
    public final zziz zzp() {
        zzhj.zza(this.zzr);
        return this.zzr;
    }

    @Pure
    private final zzkn zzai() {
        zzhj.zza(this.zzt);
        return this.zzt;
    }

    @Pure
    public final zzks zzq() {
        zzhj.zza(this.zzq);
        return this.zzq;
    }

    @Pure
    public final zzlb zzr() {
        zzhj.zza(this.zzw);
        return this.zzw;
    }

    @Pure
    public final zzml zzs() {
        zzhj.zza(this.zzm);
        return this.zzm;
    }

    @Pure
    public final zznt zzt() {
        zzhj.zza((zzij)this.zzn);
        return this.zzn;
    }

    @Pure
    public final @Nullable String zzu() {
        return this.zzd;
    }

    @Pure
    public final @Nullable String zzv() {
        return this.zze;
    }

    @Pure
    public final @Nullable String zzw() {
        return this.zzf;
    }

    @Pure
    public final @Nullable String zzx() {
        return this.zzu;
    }

    static /* synthetic */ void zza(zzhj zzhj2, zzix zzix2) {
        zzix zzix3 = zzix2;
        zzhj zzhj3 = zzhj2;
        ((zzij)zzhj3.zzl()).zzt();
        Object object = zzhj3;
        zzaz zzaz2 = new zzaz((zzhj)object);
        zzaz2.zzad();
        zzhj3.zzx = zzaz2;
        zzhj zzhj4 = zzhj3;
        object = zzix3;
        zzfq zzfq2 = new zzfq(zzhj4, ((zzix)object).zzf);
        zzfq2.zzv();
        zzhj3.zzy = zzfq2;
        object = zzhj3;
        zzft zzft2 = new zzft((zzhj)object);
        zzft2.zzv();
        zzhj3.zzv = zzft2;
        object = zzhj3;
        zzlb zzlb2 = new zzlb((zzhj)object);
        zzlb2.zzv();
        zzhj3.zzw = zzlb2;
        zzhj3.zzn.zzae();
        zzhj3.zzj.zzae();
        zzhj3.zzy.zzw();
        zzhj3.zzj().zzn().zza("App measurement initialized, version", 95001L);
        zzhj3.zzj().zzn().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string = zzfq2.zzad();
        if (TextUtils.isEmpty((CharSequence)zzhj3.zzd)) {
            if (zzhj3.zzt().zzd(string, zzhj3.zzi.zzp())) {
                zzhj3.zzj().zzn().zza("Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.");
            } else {
                String string2 = string;
                zzhj3.zzj().zzn().zza("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app " + string2);
            }
        }
        zzhj3.zzj().zzc().zza("Debug-level message logging enabled");
        if (zzhj3.zzag != zzhj3.zzai.get()) {
            zzhj3.zzj().zzg().zza("Not all components initialized", zzhj3.zzag, zzhj3.zzai.get());
        }
        zzhj3.zzz = true;
    }

    private zzhj(zzix zzix2) {
        Object object;
        Preconditions.checkNotNull((Object)zzix2);
        Object object2 = zzix2.zza;
        zzfk.zza = this.zzh = new zzad((Context)object2);
        this.zzc = zzix2.zza;
        this.zzd = zzix2.zzb;
        this.zze = zzix2.zzc;
        this.zzf = zzix2.zzd;
        this.zzg = zzix2.zzh;
        this.zzac = zzix2.zze;
        this.zzu = zzix2.zzj;
        this.zzaf = true;
        zzdl zzdl2 = zzix2.zzg;
        if (zzdl2 != null && zzdl2.zzg != null) {
            object = zzdl2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
            if ((object = zzdl2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzae = (Boolean)object;
            }
        }
        zzgw.zzb(this.zzc);
        this.zzp = DefaultClock.getInstance();
        this.zza = zzix2.zzi != null ? zzix2.zzi.longValue() : this.zzp.currentTimeMillis();
        object2 = this;
        this.zzi = new zzae((zzhj)object2);
        object2 = this;
        object = new zzgl((zzhj)object2);
        ((zzim)object).zzad();
        this.zzj = object;
        object2 = this;
        zzfw zzfw2 = new zzfw((zzhj)object2);
        zzfw2.zzad();
        this.zzk = zzfw2;
        object2 = this;
        zznt zznt2 = new zznt((zzhj)object2);
        zznt2.zzad();
        this.zzn = zznt2;
        zzhj zzhj2 = this;
        object2 = zzix2;
        zziw zziw2 = new zziw((zzix)object2, zzhj2);
        this.zzo = new zzfv(zziw2);
        object2 = this;
        this.zzs = new zza((zzhj)object2);
        object2 = this;
        zzks zzks2 = new zzks((zzhj)object2);
        zzks2.zzv();
        this.zzq = zzks2;
        object2 = this;
        zziz zziz2 = new zziz((zzhj)object2);
        zziz2.zzv();
        this.zzr = zziz2;
        object2 = this;
        zzml zzml2 = new zzml((zzhj)object2);
        zzml2.zzv();
        this.zzm = zzml2;
        object2 = this;
        zzkn zzkn2 = new zzkn((zzhj)object2);
        zzkn2.zzad();
        this.zzt = zzkn2;
        object2 = this;
        zzhg zzhg2 = new zzhg((zzhj)object2);
        zzhg2.zzad();
        this.zzl = zzhg2;
        boolean bl = zzix2.zzg != null && zzix2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        if (((zzhj)object2).zzc.getApplicationContext() instanceof Application) {
            ((zzhj)object2).zzp().zzb(bl2);
        } else {
            ((zzhj)object2).zzj().zzu().zza("Application context is not an Application");
        }
        this.zzl.zzb(new zzho(this, zzix2));
    }

    private static void zza(zzij zzij2) {
        if (zzij2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    private static void zza(zzg zzg2) {
        if (zzg2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzg2.zzy()) {
            String string = String.valueOf(zzg2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    private static void zza(zzim zzim2) {
        if (zzim2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzim2.zzaf()) {
            String string = String.valueOf(zzim2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    final void zzy() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzz() {
        this.zzai.incrementAndGet();
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzhj zzhj2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzhj2.zzj().zzu().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzhj2.zzn().zzo.zza(true);
        if (byArray2 == null || byArray2.length == 0) {
            zzhj2.zzj().zzc().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzhj2.zzj().zzc().zza("Deferred Deep Link is empty.");
                return;
            }
            String string4 = jSONObject.optString("gclid", "");
            String string5 = jSONObject.optString("gbraid", "");
            String string6 = jSONObject.optString("gad_source", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            Bundle bundle = new Bundle();
            if (zzok.zza() && zzhj2.zzi.zza(zzbh.zzco)) {
                long l;
                if (!zzhj2.zzt().zzi(string3)) {
                    zzhj2.zzj().zzu().zza("Deferred Deep Link validation failed. gclid, gbraid, deep link", string4, string5, string3);
                    return;
                }
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    bundle.putString("gbraid", string5);
                }
                if (!TextUtils.isEmpty((CharSequence)string6)) {
                    bundle.putString("gad_source", string6);
                }
                if ((l = Double.valueOf(d).longValue()) > 0L) {
                    bundle.putLong("click_timestamp", l);
                }
            } else if (!zzhj2.zzt().zzi(string3)) {
                zzhj2.zzj().zzu().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            if (zzok.zza()) {
                zzhj2.zzi.zza(zzbh.zzco);
            }
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzhj2.zzr.zzc("auto", "_cmp", bundle);
            String string7 = string3;
            zznt zznt2 = zzhj2.zzt();
            if (!TextUtils.isEmpty((CharSequence)string7) && zznt2.zza(string7, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzij)zznt2).zza().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzhj2.zzj().zzg().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    final void zzaa() {
        ++this.zzag;
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzac = bl;
    }

    @WorkerThread
    public final void zzb(boolean bl) {
        ((zzij)this.zzl()).zzt();
        this.zzaf = bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    protected final void zza(@Nullable zzdl var1_1) {
        block39: {
            block38: {
                this.zzl().zzt();
                if (zzpd.zza() && this.zzi.zza(zzbh.zzcc) && this.zzt().zzw()) {
                    var9_2 = this.zzt();
                    var9_2.zzt();
                    var10_3 = new IntentFilter();
                    var10_3.addAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
                    var11_4 = new zzo(var9_2.zzu);
                    ContextCompat.registerReceiver((Context)var9_2.zza(), (BroadcastReceiver)var11_4, (IntentFilter)var10_3, (int)2);
                    var9_2.zzj().zzc().zza("Registered app receiver");
                }
                var2_5 = this.zzn().zzn();
                var3_6 = var2_5.zza();
                var4_7 = null;
                if (zznb.zza() && this.zzi.zza(zzbh.zzcx)) {
                    var5_9 = this.zzi.zze("google_analytics_default_allow_ad_storage");
                    var6_11 = this.zzi.zze("google_analytics_default_allow_analytics_storage");
                    if ((var5_9 != zziq.zza || var6_11 != zziq.zza) && this.zzn().zza(-10)) {
                        var4_7 = zzin.zza(var5_9, var6_11, -10);
                    } else if (!(TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || var3_6 != 0 && var3_6 != 30 && var3_6 != 10 && var3_6 != 30 && var3_6 != 30 && var3_6 != 40)) {
                        this.zzp().zza(new zzin(null, null, -10), this.zza, false);
                    } else if (TextUtils.isEmpty((CharSequence)this.zzh().zzae()) && var1_1 != null && var1_1.zzg != null && this.zzn().zza(30) && (var7_13 = zzin.zza(var1_1.zzg, 30)).zzk()) {
                        var4_7 = var7_13;
                    }
                } else {
                    var9_2 = this.zzi;
                    var5_10 = var9_2.zzf("google_analytics_default_allow_ad_storage");
                    var9_2 = this.zzi;
                    var6_12 = var9_2.zzf("google_analytics_default_allow_analytics_storage");
                    if ((var5_10 != null || var6_12 != null) && this.zzn().zza(-10)) {
                        var4_7 = new zzin(var5_10, var6_12, -10);
                    } else if (!(TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || var3_6 != 0 && var3_6 != 30 && var3_6 != 10 && var3_6 != 30 && var3_6 != 30 && var3_6 != 40)) {
                        this.zzp().zza(new zzin(null, null, -10), this.zza, false);
                    } else if (TextUtils.isEmpty((CharSequence)this.zzh().zzae()) && var1_1 != null && var1_1.zzg != null && this.zzn().zza(30) && (var7_14 = zzin.zza(var1_1.zzg, 30)).zzk()) {
                        var4_7 = var7_14;
                    }
                }
                if (var4_7 != null) {
                    var2_5 = var4_7;
                    this.zzp().zza(var2_5, this.zza, this.zzi.zza(zzbh.zzda));
                }
                this.zzp().zza(var2_5);
                var10_3 = var1_1;
                var9_2 = this;
                var12_15 = var9_2.zzn().zzm().zza();
                if (!zznb.zza() || !var9_2.zzi.zza(zzbh.zzcx)) break block38;
                var13_16 /* !! */  = var9_2.zzi.zze("google_analytics_default_allow_ad_user_data");
                if (var13_16 /* !! */  == zziq.zza || !zzin.zza(-10, var12_15)) ** GOTO lbl-1000
                var9_2.zzp().zza(zzax.zza((zziq)var13_16 /* !! */ , -10), var9_2.zzi.zza(zzbh.zzda));
                break block39;
            }
            var15_17 = var9_2.zzi;
            var13_16 /* !! */  = var15_17.zzf("google_analytics_default_allow_ad_user_data");
            if (var13_16 /* !! */  != null && zzin.zza(-10, var12_15)) {
                var9_2.zzp().zza(new zzax(var13_16 /* !! */ , -10), var9_2.zzi.zza(zzbh.zzda));
            } else if (!(TextUtils.isEmpty((CharSequence)var9_2.zzh().zzae()) || var12_15 != 0 && var12_15 != 30)) {
                var9_2.zzp().zza(new zzax(null, -10), var9_2.zzi.zza(zzbh.zzda));
            } else {
                if (TextUtils.isEmpty((CharSequence)var9_2.zzh().zzae()) && var10_3 != null && var10_3.zzg != null && zzin.zza(30, var12_15) && (var13_16 /* !! */  = zzax.zza(var10_3.zzg, 30)).zzg()) {
                    var9_2.zzp().zza((zzax)var13_16 /* !! */ , var9_2.zzi.zza(zzbh.zzda));
                }
                if (TextUtils.isEmpty((CharSequence)var9_2.zzh().zzae()) && var10_3 != null && var10_3.zzg != null && var9_2.zzn().zzh.zza() == null && (var14_18 = zzax.zza(var10_3.zzg)) != null) {
                    var9_2.zzp().zza(var10_3.zze, "allow_personalized_ads", (Object)var14_18.toString(), false);
                }
            }
        }
        if (zzpp.zza() && this.zzi.zza(zzbh.zzcu) && ((var10_3 = (var9_2 = this.zzi).zzf("google_analytics_tcf_data_enabled")) == null ? true : var10_3.booleanValue())) {
            this.zzj().zzc().zza("TCF client enabled.");
            this.zzp().zzas();
            this.zzp().zzaq();
        }
        if (this.zzn().zzc.zza() == 0L) {
            this.zzj().zzp().zza("Persisting first open", this.zza);
            this.zzn().zzc.zza(this.zza);
        }
        this.zzp().zza.zzb();
        if (!this.zzaf()) {
            if (this.zzac()) {
                if (!this.zzt().zze("android.permission.INTERNET")) {
                    this.zzj().zzg().zza("App is missing INTERNET permission");
                }
                if (!this.zzt().zze("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzj().zzg().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() && !this.zzi.zzx()) {
                    if (!zznt.zza(this.zzc)) {
                        this.zzj().zzg().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zznt.zza(this.zzc, false)) {
                        this.zzj().zzg().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzj().zzg().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac())) {
                this.zzt();
                if (zznt.zza(this.zzh().zzae(), this.zzn().zzy(), this.zzh().zzac(), this.zzn().zzx())) {
                    this.zzj().zzn().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzn().zzz();
                    this.zzi().zzaa();
                    this.zzw.zzae();
                    this.zzw.zzad();
                    this.zzn().zzc.zza(this.zza);
                    this.zzn().zze.zza(null);
                }
                this.zzn().zzc(this.zzh().zzae());
                this.zzn().zzb(this.zzh().zzac());
            }
            if (!this.zzn().zzn().zza(zzin.zza.zzb)) {
                this.zzn().zze.zza(null);
            }
            this.zzp().zzc(this.zzn().zze.zza());
            if (!this.zzt().zzx() && !TextUtils.isEmpty((CharSequence)this.zzn().zzq.zza())) {
                this.zzj().zzu().zza("Remote config removed with active feature rollouts");
                this.zzn().zzq.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac())) {
                var4_8 = this.zzac();
                if (!this.zzn().zzab() && !this.zzi.zzw()) {
                    this.zzn().zzb(var4_8 == false);
                }
                if (var4_8) {
                    this.zzp().zzam();
                }
                this.zzs().zza.zza();
                this.zzr().zza(new AtomicReference<String>());
                this.zzr().zza(this.zzn().zzt.zza());
            }
        }
        if (zzpd.zza() && this.zzi.zza(zzbh.zzcc) && this.zzt().zzw()) {
            v0 = this.zzp();
            Objects.requireNonNull(v0);
            var8_19 = v0;
            new Thread(new zzhm(var8_19)).start();
        }
        this.zzn().zzj.zza(true);
    }

    @WorkerThread
    public final boolean zzab() {
        return this.zzac != null && this.zzac != false;
    }

    @WorkerThread
    public final boolean zzac() {
        return this.zzc() == 0;
    }

    @WorkerThread
    public final boolean zzad() {
        ((zzij)this.zzl()).zzt();
        return this.zzaf;
    }

    @Pure
    public final boolean zzae() {
        return TextUtils.isEmpty((CharSequence)this.zzd);
    }

    @WorkerThread
    protected final boolean zzaf() {
        if (!this.zzz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
        ((zzij)this.zzl()).zzt();
        if (this.zzaa == null || this.zzab == 0L || this.zzaa != null && !this.zzaa.booleanValue() && Math.abs(this.zzp.elapsedRealtime() - this.zzab) > 1000L) {
            this.zzab = this.zzp.elapsedRealtime();
            this.zzaa = this.zzt().zze("android.permission.INTERNET") && this.zzt().zze("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() || this.zzi.zzx() || zznt.zza(this.zzc) && zznt.zza(this.zzc, false));
            if (this.zzaa.booleanValue()) {
                this.zzaa = this.zzt().zza(this.zzh().zzae(), this.zzh().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac());
            }
        }
        return this.zzaa;
    }

    @Pure
    public final boolean zzag() {
        return this.zzg;
    }

    @WorkerThread
    public final boolean zzah() {
        Object object;
        ((zzij)this.zzl()).zzt();
        zzhj.zza(this.zzai());
        String string = this.zzh().zzad();
        Pair<String, Boolean> pair = this.zzn().zza(string);
        if (!this.zzi.zzu() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzj().zzc().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return false;
        }
        if (!this.zzai().zzc()) {
            this.zzj().zzu().zza("Network is not available for Deferred Deep Link request. Skipping");
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        zzij zzij2 = this.zzr();
        zzij2.zzt();
        ((zzg)zzij2).zzu();
        if (!((zzlb)zzij2).zzao() ? true : zzij2.zzq().zzg() >= 234200) {
            object = null;
            zzal zzal2 = this.zzp().zzab();
            if (zzal2 != null) {
                object = zzal2.zza;
            }
            if (object == null) {
                boolean bl = this.zzah++ < 10;
                String string2 = bl ? "Retrying." : "Skipping.";
                this.zzj().zzc().zza("Failed to retrieve DMA consent from the service, " + string2 + " retryCount", this.zzah);
                return bl;
            }
            zzin zzin2 = zzin.zza(object, 100);
            stringBuilder.append("&gcs=").append(zzin2.zzg());
            zzax zzax2 = zzax.zza(object, 100);
            stringBuilder.append("&dma=").append(zzax2.zzd() == Boolean.FALSE ? 0 : 1);
            if (!TextUtils.isEmpty((CharSequence)zzax2.zze())) {
                stringBuilder.append("&dma_cps=").append(zzax2.zze());
            }
            int n = zzax.zza(object) == Boolean.TRUE ? 0 : 1;
            stringBuilder.append("&npa=").append(n);
            this.zzj().zzp().zza("Consent query parameters to Bow", stringBuilder);
        }
        zznt zznt2 = this.zzt();
        this.zzh();
        object = zznt2.zza(95001L, string, (String)pair.first, this.zzn().zzp.zza() - 1L, stringBuilder.toString());
        if (object != null) {
            zzhj zzhj2 = this;
            zzhl zzhl2 = new zzhl(zzhj2);
            Object object2 = object;
            String string3 = string;
            zzij2 = this.zzai();
            zzij2.zzt();
            ((zzim)zzij2).zzac();
            Preconditions.checkNotNull((Object)object2);
            Preconditions.checkNotNull((Object)zzhl2);
            zzij2.zzl().zza(new zzkp((zzkn)zzij2, string3, (URL)object2, null, null, zzhl2));
        }
        return false;
    }
}

