/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.measurement.zzdg;
import com.google.android.gms.internal.measurement.zznk;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzla;
import com.google.android.gms.measurement.internal.zzlb;
import com.google.android.gms.measurement.internal.zzlc;
import com.google.android.gms.measurement.internal.zzld;
import com.google.android.gms.measurement.internal.zzle;
import com.google.android.gms.measurement.internal.zzlf;
import com.google.android.gms.measurement.internal.zzlg;
import com.google.android.gms.measurement.internal.zzlh;
import com.google.android.gms.measurement.internal.zzli;
import com.google.android.gms.measurement.internal.zzlj;
import com.google.android.gms.measurement.internal.zzlk;
import com.google.android.gms.measurement.internal.zzll;
import com.google.android.gms.measurement.internal.zzlm;
import com.google.android.gms.measurement.internal.zzln;
import com.google.android.gms.measurement.internal.zzlo;
import com.google.android.gms.measurement.internal.zzlp;
import com.google.android.gms.measurement.internal.zzlq;
import com.google.android.gms.measurement.internal.zzlr;
import com.google.android.gms.measurement.internal.zzls;
import com.google.android.gms.measurement.internal.zzlt;
import com.google.android.gms.measurement.internal.zzlu;
import com.google.android.gms.measurement.internal.zzlw;
import com.google.android.gms.measurement.internal.zzmr;
import com.google.android.gms.measurement.internal.zzmu;
import com.google.android.gms.measurement.internal.zzno;
import com.google.android.gms.measurement.internal.zzo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzkx
extends zze {
    private final zzlw zza;
    private @Nullable zzfl zzb;
    private volatile Boolean zzc;
    private final zzat zzd;
    private final zzmr zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzat zzg;

    @WorkerThread
    private final @Nullable zzo zzc(boolean bl) {
        return ((zzf)this).zzg().zza(bl ? ((zzij)this).zzj().zzx() : null);
    }

    @WorkerThread
    protected final @Nullable zzaj zzaa() {
        ((zzij)this).zzt();
        this.zzu();
        zzfl zzfl2 = this.zzb;
        if (zzfl2 == null) {
            this.zzad();
            ((zzij)this).zzj().zzc().zza("Failed to get consents; not connected to service yet.");
            return null;
        }
        zzo zzo2 = this.zzc(false);
        Preconditions.checkNotNull((Object)((Object)zzo2));
        try {
            zzaj zzaj2 = zzfl2.zza(zzo2);
            this.zzaq();
            return zzaj2;
        }
        catch (RemoteException remoteException) {
            ((zzij)this).zzj().zzg().zza("Failed to get consents; remote exception", (Object)remoteException);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ zzfl zza(zzkx zzkx2) {
        return zzkx2.zzb;
    }

    static /* bridge */ /* synthetic */ zzlw zzb(zzkx zzkx2) {
        return zzkx2.zza;
    }

    final Boolean zzab() {
        return this.zzc;
    }

    static /* bridge */ /* synthetic */ void zza(zzkx zzkx2, zzfl zzfl2) {
        zzkx2.zzb = null;
    }

    static /* synthetic */ void zzc(zzkx zzkx2) {
        zzkx2.zzap();
    }

    static /* synthetic */ void zzd(zzkx zzkx2) {
        zzkx zzkx3 = zzkx2;
        ((zzij)zzkx3).zzt();
        if (zzkx3.zzak()) {
            ((zzij)zzkx3).zzj().zzp().zza("Inactivity, disconnecting from the service");
            zzkx3.zzae();
        }
    }

    static /* synthetic */ void zza(zzkx zzkx2, ComponentName componentName) {
        ComponentName componentName2 = componentName;
        zzkx zzkx3 = zzkx2;
        ((zzij)zzkx3).zzt();
        if (zzkx3.zzb != null) {
            zzkx3.zzb = null;
            ((zzij)zzkx3).zzj().zzp().zza("Disconnected from device MeasurementService", componentName2);
            zzkx zzkx4 = zzkx3;
            ((zzij)zzkx4).zzt();
            zzkx4.zzad();
        }
    }

    static /* synthetic */ void zze(zzkx zzkx2) {
        zzkx2.zzaq();
    }

    protected zzkx(zzhj zzhj2) {
        super(zzhj2);
        this.zze = new zzmr(zzhj2.zzb());
        this.zza = new zzlw(this);
        this.zzd = new zzlc(this, zzhj2);
        this.zzg = new zzll(this, zzhj2);
    }

    @WorkerThread
    protected final void zzac() {
        ((zzij)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(true);
        ((zzf)this).zzh().zzab();
        this.zza(new zzlk(this, zzo2));
    }

    @WorkerThread
    final void zzad() {
        ((zzij)this).zzt();
        this.zzu();
        if (this.zzak()) {
            return;
        }
        if (this.zzao()) {
            this.zza.zza();
            return;
        }
        if (!((zzij)this).zze().zzx()) {
            Intent intent;
            zzkx zzkx2 = this;
            PackageManager packageManager = ((zzij)zzkx2).zza().getPackageManager();
            List list = packageManager.queryIntentServices(intent = new Intent().setClassName(((zzij)zzkx2).zza(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && !list.isEmpty()) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                intent2.setComponent(new ComponentName(((zzij)this).zza(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzij)this).zzj().zzg().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    @WorkerThread
    public final void zzae() {
        ((zzij)this).zzt();
        this.zzu();
        this.zza.zzb();
        try {
            ConnectionTracker.getInstance().unbindService(((zzij)this).zza(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zzap() {
        ((zzij)this).zzt();
        ((zzij)this).zzj().zzp().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                ((zzij)this).zzj().zzg().zza("Task exception while flushing queue", runtimeException);
            }
        }
        this.zzf.clear();
        this.zzg.zza();
    }

    @WorkerThread
    public final void zza(zzdg zzdg2) {
        ((zzij)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzlh(this, zzo2, zzdg2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzij)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzli(this, atomicReference, zzo2));
    }

    @WorkerThread
    protected final void zza(zzdg zzdg2, @Nullable String string, @Nullable String string2) {
        ((zzij)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzlu(this, string, string2, zzo2, zzdg2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzae>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3) {
        ((zzij)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzlr(this, atomicReference, string, string2, string3, zzo2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zzmu>> atomicReference, Bundle bundle) {
        ((zzij)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzld(this, atomicReference, zzo2, bundle));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zzno>> atomicReference, boolean bl) {
        ((zzij)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzle(this, atomicReference, zzo2, bl));
    }

    @WorkerThread
    protected final void zza(zzdg zzdg2, @Nullable String string, @Nullable String string2, boolean bl) {
        ((zzij)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzlb(this, string, string2, zzo2, bl, zzdg2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzno>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        ((zzij)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzlt(this, atomicReference, string, string2, string3, zzo2, bl));
    }

    final /* synthetic */ void zzaf() {
        zzfl zzfl2 = this.zzb;
        if (zzfl2 == null) {
            ((zzij)this).zzj().zzg().zza("Failed to send Dma consent settings to service");
            return;
        }
        try {
            zzo zzo2 = this.zzc(false);
            Preconditions.checkNotNull((Object)((Object)zzo2));
            zzfl2.zzf(zzo2);
            this.zzaq();
            return;
        }
        catch (RemoteException remoteException) {
            ((zzij)this).zzj().zzg().zza("Failed to send Dma consent settings to the service", (Object)remoteException);
            return;
        }
    }

    final /* synthetic */ void zzag() {
        zzfl zzfl2 = this.zzb;
        if (zzfl2 == null) {
            ((zzij)this).zzj().zzg().zza("Failed to send storage consent settings to service");
            return;
        }
        try {
            zzo zzo2 = this.zzc(false);
            Preconditions.checkNotNull((Object)((Object)zzo2));
            zzfl2.zzh(zzo2);
            this.zzaq();
            return;
        }
        catch (RemoteException remoteException) {
            ((zzij)this).zzj().zzg().zza("Failed to send storage consent settings to the service", (Object)remoteException);
            return;
        }
    }

    @WorkerThread
    protected final void zza(zzbd zzbd2, @Nullable String string) {
        Preconditions.checkNotNull((Object)((Object)zzbd2));
        ((zzij)this).zzt();
        this.zzu();
        boolean bl = ((zzf)this).zzh().zza(zzbd2);
        zzo zzo2 = this.zzc(true);
        this.zza(new zzlp(this, true, zzo2, bl, zzbd2, string));
    }

    @WorkerThread
    public final void zza(zzdg zzdg2, zzbd zzbd2, String string) {
        ((zzij)this).zzt();
        this.zzu();
        if (((zzij)this).zzq().zza(12451000) != 0) {
            ((zzij)this).zzj().zzu().zza("Not bundling data. Service unavailable or out of date");
            ((zzij)this).zzq().zza(zzdg2, new byte[0]);
            return;
        }
        this.zza(new zzlo(this, zzbd2, string, zzdg2));
    }

    @WorkerThread
    private final void zzaq() {
        ((zzij)this).zzt();
        this.zze.zzb();
        this.zzd.zza((Long)zzbf.zzaj.zza(null));
    }

    @WorkerThread
    protected final void zzah() {
        ((zzij)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        ((zzf)this).zzh().zzaa();
        this.zza(new zzlf(this, zzo2));
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzij)this).zzt();
        if (this.zzak()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzij)this).zzj().zzg().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzad();
    }

    @WorkerThread
    final void zza(zzfl zzfl2, @Nullable AbstractSafeParcelable abstractSafeParcelable, zzo zzo2) {
        ((zzij)this).zzt();
        this.zzu();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            List<AbstractSafeParcelable> list = ((zzf)this).zzh().zza(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzbd) {
                    try {
                        zzfl2.zza((zzbd)abstractSafeParcelable2, zzo2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzij)this).zzj().zzg().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzno) {
                    try {
                        zzfl2.zza((zzno)abstractSafeParcelable2, zzo2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzij)this).zzj().zzg().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzae) {
                    try {
                        zzfl2.zza((zzae)abstractSafeParcelable2, zzo2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzij)this).zzj().zzg().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzij)this).zzj().zzg().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzae zzae2) {
        Preconditions.checkNotNull((Object)((Object)zzae2));
        ((zzij)this).zzt();
        this.zzu();
        boolean bl = ((zzf)this).zzh().zza(zzae2);
        zzae zzae3 = new zzae(zzae2);
        zzo zzo2 = this.zzc(true);
        this.zza(new zzls(this, true, zzo2, bl, zzae3, zzae2));
    }

    @WorkerThread
    protected final void zza(boolean bl) {
        ((zzij)this).zzt();
        this.zzu();
        if (!(zznk.zza() && ((zzij)this).zze().zza(zzbf.zzcu) || !bl)) {
            ((zzf)this).zzh().zzaa();
        }
        if (this.zzam()) {
            zzo zzo2 = this.zzc(false);
            this.zza(new zzlq(this, zzo2));
        }
    }

    @WorkerThread
    protected final void zza(@Nullable zzkp zzkp2) {
        ((zzij)this).zzt();
        this.zzu();
        this.zza(new zzlj(this, zzkp2));
    }

    @WorkerThread
    public final void zza(Bundle bundle) {
        ((zzij)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(false);
        this.zza(new zzlm(this, zzo2, bundle));
    }

    @WorkerThread
    protected final void zzai() {
        ((zzij)this).zzt();
        this.zzu();
        zzkx zzkx2 = this;
        this.zza(new zzkz(zzkx2));
    }

    @WorkerThread
    protected final void zzaj() {
        ((zzij)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzc(true);
        this.zza(new zzln(this, zzo2));
    }

    @WorkerThread
    protected final void zza(zzfl zzfl2) {
        ((zzij)this).zzt();
        Preconditions.checkNotNull((Object)zzfl2);
        this.zzb = zzfl2;
        this.zzaq();
        this.zzap();
    }

    @WorkerThread
    protected final void zzb(boolean bl) {
        ((zzij)this).zzt();
        this.zzu();
        if (!(zznk.zza() && ((zzij)this).zze().zza(zzbf.zzcu) || !bl)) {
            ((zzf)this).zzh().zzaa();
        }
        zzkx zzkx2 = this;
        this.zza(new zzla(zzkx2));
    }

    @WorkerThread
    protected final void zza(zzno zzno2) {
        ((zzij)this).zzt();
        this.zzu();
        boolean bl = ((zzf)this).zzh().zza(zzno2);
        zzo zzo2 = this.zzc(true);
        this.zza(new zzlg(this, zzo2, bl, zzno2));
    }

    @WorkerThread
    public final boolean zzak() {
        ((zzij)this).zzt();
        this.zzu();
        return this.zzb != null;
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    final boolean zzal() {
        ((zzij)this).zzt();
        this.zzu();
        if (!this.zzao()) {
            return true;
        }
        return ((zzij)this).zzq().zzg() >= 200900;
    }

    @WorkerThread
    final boolean zzam() {
        ((zzij)this).zzt();
        this.zzu();
        if (!this.zzao()) {
            return true;
        }
        return ((zzij)this).zzq().zzg() >= (Integer)zzbf.zzbo.zza(null);
    }

    @WorkerThread
    final boolean zzan() {
        ((zzij)this).zzt();
        this.zzu();
        if (!this.zzao()) {
            return true;
        }
        return ((zzij)this).zzq().zzg() >= 241200;
    }

    @WorkerThread
    final boolean zzao() {
        ((zzij)this).zzt();
        this.zzu();
        if (this.zzc == null) {
            boolean bl;
            zzkx zzkx2 = this;
            ((zzij)zzkx2).zzt();
            zzkx2.zzu();
            Boolean bl2 = ((zzij)zzkx2).zzk().zzp();
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else {
                boolean bl3;
                boolean bl4;
                if (((zzf)zzkx2).zzg().zzaa() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzij)zzkx2).zzj().zzp().zza("Checking service availability");
                    int n = ((zzij)zzkx2).zzq().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzij)zzkx2).zzj().zzp().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzij)zzkx2).zzj().zzp().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzij)zzkx2).zzj().zzu().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzij)zzkx2).zzj().zzc().zza("Service container out of date");
                            if (((zzij)zzkx2).zzq().zzg() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            bl4 = bl2 == null;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzij)zzkx2).zzj().zzu().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzij)zzkx2).zzj().zzu().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzij)zzkx2).zzj().zzu().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzij)zzkx2).zze().zzx()) {
                    ((zzij)zzkx2).zzj().zzg().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzij)zzkx2).zzk().zza(bl4);
                }
                bl = bl4;
            }
            this.zzc = bl;
        }
        return this.zzc;
    }
}

