/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzdt;
import com.google.android.gms.internal.measurement.zzir;
import com.google.android.gms.internal.measurement.zzox;
import com.google.android.gms.internal.measurement.zzqn;
import com.google.android.gms.internal.measurement.zzrl;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzbb;
import com.google.android.gms.measurement.internal.zzbj;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzlb;
import com.google.android.gms.measurement.internal.zzld;
import com.google.android.gms.measurement.internal.zzlg;
import com.google.android.gms.measurement.internal.zzlp;
import com.google.android.gms.measurement.internal.zznb;
import com.google.android.gms.measurement.internal.zzop;
import com.google.android.gms.measurement.internal.zzr;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.json.JSONException;
import org.json.JSONObject;

public class zzhw
implements zzja {
    private static volatile @Nullable zzhw zzb;
    private final Context zzc;
    private final @Nullable String zzd;
    private final @Nullable String zze;
    private final @Nullable String zzf;
    private final boolean zzg;
    private final zzac zzh;
    private final zzah zzi;
    private final zzgu zzj;
    private final zzgi zzk;
    private final zzhp zzl;
    private final zznb zzm;
    private final zzop zzn;
    private final zzgh zzo;
    private final Clock zzp;
    private final zzlg zzq;
    private final zzjk zzr;
    private final zza zzs;
    private final zzlb zzt;
    private final @Nullable String zzu;
    private zzgf zzv;
    private zzlp zzw;
    private zzbb zzx;
    private zzgc zzy;
    private boolean zzz = false;
    private Boolean zzaa;
    private long zzab;
    private volatile @Nullable Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    @VisibleForTesting
    private Boolean zzae;
    private volatile boolean zzaf;
    private int zzag;
    private int zzah;
    private AtomicInteger zzai = new AtomicInteger(0);
    @VisibleForTesting
    final long zza;

    @WorkerThread
    public final int zzc() {
        ((zziy)this.zzl()).zzt();
        if (this.zzi.zzz()) {
            return 1;
        }
        if (this.zzae != null && this.zzae.booleanValue()) {
            return 2;
        }
        if (!this.zzad()) {
            return 8;
        }
        Boolean bl = this.zzn().zzv();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        zzah zzah2 = this.zzi;
        Boolean bl2 = zzah2.zze("firebase_analytics_collection_enabled");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzad != null) {
            if (this.zzad.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    @Override
    @Pure
    public final Context zza() {
        return this.zzc;
    }

    @Override
    @Pure
    public final Clock zzb() {
        return this.zzp;
    }

    @Pure
    public final zza zze() {
        if (this.zzs == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzs;
    }

    @Override
    @Pure
    public final zzac zzd() {
        return this.zzh;
    }

    @Pure
    public final zzah zzf() {
        return this.zzi;
    }

    @Pure
    public final zzbb zzg() {
        zzhw.zza(this.zzx);
        return this.zzx;
    }

    @Pure
    public final zzgc zzh() {
        zzhw.zza(this.zzy);
        return this.zzy;
    }

    @Pure
    public final zzgf zzi() {
        zzhw.zza(this.zzv);
        return this.zzv;
    }

    @Pure
    public final zzgh zzk() {
        return this.zzo;
    }

    @Override
    @Pure
    public final zzgi zzj() {
        zzhw.zza(this.zzk);
        return this.zzk;
    }

    public final @Nullable zzgi zzm() {
        if (this.zzk != null && this.zzk.zzaf()) {
            return this.zzk;
        }
        return null;
    }

    @Pure
    public final zzgu zzn() {
        zzhw.zza((zziy)this.zzj);
        return this.zzj;
    }

    @Override
    @Pure
    public final zzhp zzl() {
        zzhw.zza(this.zzl);
        return this.zzl;
    }

    @SideEffectFree
    final @Nullable zzhp zzo() {
        return this.zzl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzhw zza(Context context, @Nullable zzdt zzdt2, @Nullable Long l) {
        if (zzdt2 != null && (zzdt2.zze == null || zzdt2.zzf == null)) {
            zzdt2 = new zzdt(zzdt2.zza, zzdt2.zzb, zzdt2.zzc, zzdt2.zzd, null, null, zzdt2.zzg, null);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb == null) {
            Class<zzhw> clazz = zzhw.class;
            synchronized (zzhw.class) {
                if (zzb == null) {
                    zzji zzji2 = new zzji(context, zzdt2, l);
                    zzb = new zzhw(zzji2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (zzdt2 != null && zzdt2.zzg != null && zzdt2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            Preconditions.checkNotNull((Object)zzb);
            zzb.zza(zzdt2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        {
            Preconditions.checkNotNull((Object)zzb);
            return zzb;
        }
    }

    @Pure
    public final zzjk zzp() {
        zzhw.zza(this.zzr);
        return this.zzr;
    }

    @Pure
    private final zzlb zzai() {
        zzhw.zza(this.zzt);
        return this.zzt;
    }

    @Pure
    public final zzlg zzq() {
        zzhw.zza(this.zzq);
        return this.zzq;
    }

    @Pure
    public final zzlp zzr() {
        zzhw.zza(this.zzw);
        return this.zzw;
    }

    @Pure
    public final zznb zzs() {
        zzhw.zza(this.zzm);
        return this.zzm;
    }

    @Pure
    public final zzop zzt() {
        zzhw.zza((zziy)this.zzn);
        return this.zzn;
    }

    @Pure
    public final @Nullable String zzu() {
        return this.zzd;
    }

    @Pure
    public final @Nullable String zzv() {
        return this.zze;
    }

    @Pure
    public final @Nullable String zzw() {
        return this.zzf;
    }

    @Pure
    public final @Nullable String zzx() {
        return this.zzu;
    }

    static /* synthetic */ void zza(zzhw zzhw2, zzji zzji2) {
        zzji zzji3 = zzji2;
        zzhw zzhw3 = zzhw2;
        ((zziy)zzhw3.zzl()).zzt();
        Object object = zzhw3;
        zzbb zzbb2 = new zzbb((zzhw)object);
        zzbb2.zzad();
        zzhw3.zzx = zzbb2;
        zzhw zzhw4 = zzhw3;
        object = zzji3;
        zzgc zzgc2 = new zzgc(zzhw4, ((zzji)object).zzf);
        zzgc2.zzv();
        zzhw3.zzy = zzgc2;
        object = zzhw3;
        zzgf zzgf2 = new zzgf((zzhw)object);
        zzgf2.zzv();
        zzhw3.zzv = zzgf2;
        object = zzhw3;
        zzlp zzlp2 = new zzlp((zzhw)object);
        zzlp2.zzv();
        zzhw3.zzw = zzlp2;
        zzhw3.zzn.zzae();
        zzhw3.zzj.zzae();
        zzhw3.zzy.zzw();
        zzhw3.zzj().zzn().zza("App measurement initialized, version", 102001L);
        zzhw3.zzj().zzn().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string = zzgc2.zzad();
        if (TextUtils.isEmpty((CharSequence)zzhw3.zzd)) {
            if (zzhw3.zzt().zzd(string, zzhw3.zzi.zzw())) {
                zzhw3.zzj().zzn().zza("Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.");
            } else {
                String string2 = string;
                zzhw3.zzj().zzn().zza("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app " + string2);
            }
        }
        zzhw3.zzj().zzc().zza("Debug-level message logging enabled");
        if (zzhw3.zzag != zzhw3.zzai.get()) {
            zzhw3.zzj().zzg().zza("Not all components initialized", zzhw3.zzag, zzhw3.zzai.get());
        }
        zzhw3.zzz = true;
    }

    private zzhw(zzji zzji2) {
        Object object;
        Preconditions.checkNotNull((Object)zzji2);
        Object object2 = zzji2.zza;
        zzfw.zza = this.zzh = new zzac((Context)object2);
        this.zzc = zzji2.zza;
        this.zzd = zzji2.zzb;
        this.zze = zzji2.zzc;
        this.zzf = zzji2.zzd;
        this.zzg = zzji2.zzh;
        this.zzac = zzji2.zze;
        this.zzu = zzji2.zzj;
        this.zzaf = true;
        zzdt zzdt2 = zzji2.zzg;
        if (zzdt2 != null && zzdt2.zzg != null) {
            object = zzdt2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
            if ((object = zzdt2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzae = (Boolean)object;
            }
        }
        zzir.zzb(this.zzc);
        this.zzp = DefaultClock.getInstance();
        this.zza = zzji2.zzi != null ? zzji2.zzi.longValue() : this.zzp.currentTimeMillis();
        object2 = this;
        this.zzi = new zzah((zzhw)object2);
        object2 = this;
        object = new zzgu((zzhw)object2);
        ((zzix)object).zzad();
        this.zzj = object;
        object2 = this;
        zzgi zzgi2 = new zzgi((zzhw)object2);
        zzgi2.zzad();
        this.zzk = zzgi2;
        object2 = this;
        zzop zzop2 = new zzop((zzhw)object2);
        zzop2.zzad();
        this.zzn = zzop2;
        zzhw zzhw2 = this;
        object2 = zzji2;
        zzjl zzjl2 = new zzjl((zzji)object2, zzhw2);
        this.zzo = new zzgh(zzjl2);
        object2 = this;
        this.zzs = new zza((zzhw)object2);
        object2 = this;
        zzlg zzlg2 = new zzlg((zzhw)object2);
        zzlg2.zzv();
        this.zzq = zzlg2;
        object2 = this;
        zzjk zzjk2 = new zzjk((zzhw)object2);
        zzjk2.zzv();
        this.zzr = zzjk2;
        object2 = this;
        zznb zznb2 = new zznb((zzhw)object2);
        zznb2.zzv();
        this.zzm = zznb2;
        object2 = this;
        zzlb zzlb2 = new zzlb((zzhw)object2);
        zzlb2.zzad();
        this.zzt = zzlb2;
        object2 = this;
        zzhp zzhp2 = new zzhp((zzhw)object2);
        zzhp2.zzad();
        this.zzl = zzhp2;
        boolean bl = zzji2.zzg != null && zzji2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        if (((zzhw)object2).zzc.getApplicationContext() instanceof Application) {
            ((zzhw)object2).zzp().zzb(bl2);
        } else {
            ((zzhw)object2).zzj().zzu().zza("Application context is not an Application");
        }
        this.zzl.zzb(new zzhx(this, zzji2));
    }

    private static void zza(zziy zziy2) {
        if (zziy2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    private static void zza(zzf zzf2) {
        if (zzf2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzf2.zzy()) {
            String string = String.valueOf(zzf2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    private static void zza(zzix zzix2) {
        if (zzix2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzix2.zzaf()) {
            String string = String.valueOf(zzix2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    final void zzy() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzz() {
        this.zzai.incrementAndGet();
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzhw zzhw2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzhw2.zzj().zzu().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzhw2.zzn().zzo.zza(true);
        if (byArray2 == null || byArray2.length == 0) {
            zzhw2.zzj().zzc().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzhw2.zzj().zzc().zza("Deferred Deep Link is empty.");
                return;
            }
            String string4 = jSONObject.optString("gclid", "");
            String string5 = jSONObject.optString("gbraid", "");
            String string6 = jSONObject.optString("gad_source", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            Bundle bundle = new Bundle();
            if (zzqn.zza() && zzhw2.zzi.zza(zzbj.zzcs)) {
                if (!zzhw2.zzt().zzi(string3)) {
                    zzhw2.zzj().zzu().zza("Deferred Deep Link validation failed. gclid, gbraid, deep link", string4, string5, string3);
                    return;
                }
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    bundle.putString("gbraid", string5);
                }
                if (!TextUtils.isEmpty((CharSequence)string6)) {
                    bundle.putString("gad_source", string6);
                }
            } else if (!zzhw2.zzt().zzi(string3)) {
                zzhw2.zzj().zzu().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            if (zzqn.zza()) {
                zzhw2.zzi.zza(zzbj.zzcs);
            }
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzhw2.zzr.zzc("auto", "_cmp", bundle);
            String string7 = string3;
            zzop zzop2 = zzhw2.zzt();
            if (!TextUtils.isEmpty((CharSequence)string7) && zzop2.zza(string7, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zziy)zzop2).zza().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzhw2.zzj().zzg().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    final void zzaa() {
        ++this.zzag;
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzac = bl;
    }

    @WorkerThread
    public final void zzb(boolean bl) {
        ((zziy)this.zzl()).zzt();
        this.zzaf = bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    protected final void zza(@Nullable zzdt var1_1) {
        block40: {
            block39: {
                this.zzl().zzt();
                if (zzrl.zza() && this.zzi.zza(zzbj.zzch) && this.zzt().zzw()) {
                    var9_2 = this.zzt();
                    var9_2.zzt();
                    var10_3 = new IntentFilter();
                    var10_3.addAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
                    var11_4 = new zzr(var9_2.zzu);
                    ContextCompat.registerReceiver((Context)var9_2.zza(), (BroadcastReceiver)var11_4, (IntentFilter)var10_3, (int)2);
                    var9_2.zzj().zzc().zza("Registered app receiver");
                }
                var2_5 = this.zzn().zzn();
                var3_6 = var2_5.zza();
                var4_7 = null;
                if (zzox.zza() && this.zzi.zza(zzbj.zzcx)) {
                    var5_9 = this.zzi.zzc("google_analytics_default_allow_ad_storage", false);
                    var6_11 = this.zzi.zzc("google_analytics_default_allow_analytics_storage", false);
                    if ((var5_9 != zzjb.zza || var6_11 != zzjb.zza) && this.zzn().zza(-10)) {
                        var4_7 = zzjc.zza(var5_9, var6_11, -10);
                    } else if (!(TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || var3_6 != 0 && var3_6 != 30 && var3_6 != 10 && var3_6 != 30 && var3_6 != 30 && var3_6 != 40)) {
                        this.zzp().zza(new zzjc(null, null, -10), this.zza, false);
                    } else if (TextUtils.isEmpty((CharSequence)this.zzh().zzae()) && var1_1 != null && var1_1.zzg != null && this.zzn().zza(30) && (var7_13 = zzjc.zza(var1_1.zzg, 30)).zzk()) {
                        var4_7 = var7_13;
                    }
                } else {
                    var9_2 = this.zzi;
                    var5_10 = var9_2.zze("google_analytics_default_allow_ad_storage");
                    var9_2 = this.zzi;
                    var6_12 = var9_2.zze("google_analytics_default_allow_analytics_storage");
                    if ((var5_10 != null || var6_12 != null) && this.zzn().zza(-10)) {
                        var4_7 = new zzjc(var5_10, var6_12, -10);
                    } else if (!(TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || var3_6 != 0 && var3_6 != 30 && var3_6 != 10 && var3_6 != 30 && var3_6 != 30 && var3_6 != 40)) {
                        this.zzp().zza(new zzjc(null, null, -10), this.zza, false);
                    } else if (TextUtils.isEmpty((CharSequence)this.zzh().zzae()) && var1_1 != null && var1_1.zzg != null && this.zzn().zza(30) && (var7_14 = zzjc.zza(var1_1.zzg, 30)).zzk()) {
                        var4_7 = var7_14;
                    }
                }
                if (var4_7 != null) {
                    var2_5 = var4_7;
                    this.zzp().zza(var2_5, this.zza, this.zzi.zza(zzbj.zzda));
                }
                this.zzp().zza(var2_5);
                var10_3 = var1_1;
                var9_2 = this;
                var12_15 = var9_2.zzn().zzm().zza();
                if (!zzox.zza() || !var9_2.zzi.zza(zzbj.zzcx)) break block39;
                var13_16 /* !! */  = var9_2.zzi.zzc("google_analytics_default_allow_ad_personalization_signals", true);
                if (var13_16 /* !! */  != zzjb.zza) {
                    var9_2.zzj().zzp().zza("Default ad personalization consent from Manifest", var13_16 /* !! */ );
                }
                if ((var14_17 = var9_2.zzi.zzc("google_analytics_default_allow_ad_user_data", true)) == zzjb.zza || !zzjc.zza(-10, var12_15)) ** GOTO lbl-1000
                var9_2.zzp().zza(zzaz.zza((zzjb)var14_17, -10), var9_2.zzi.zza(zzbj.zzda));
                break block40;
            }
            var15_18 = var9_2.zzi;
            var13_16 /* !! */  = var15_18.zze("google_analytics_default_allow_ad_user_data");
            if (var13_16 /* !! */  != null && zzjc.zza(-10, var12_15)) {
                var9_2.zzp().zza(new zzaz(var13_16 /* !! */ , -10), var9_2.zzi.zza(zzbj.zzda));
            } else if (!(TextUtils.isEmpty((CharSequence)var9_2.zzh().zzae()) || var12_15 != 0 && var12_15 != 30)) {
                var9_2.zzp().zza(new zzaz(null, -10), var9_2.zzi.zza(zzbj.zzda));
            } else {
                if (TextUtils.isEmpty((CharSequence)var9_2.zzh().zzae()) && var10_3 != null && var10_3.zzg != null && zzjc.zza(30, var12_15) && (var13_16 /* !! */  = zzaz.zza(var10_3.zzg, 30)).zzg()) {
                    var9_2.zzp().zza((zzaz)var13_16 /* !! */ , var9_2.zzi.zza(zzbj.zzda));
                }
                if (TextUtils.isEmpty((CharSequence)var9_2.zzh().zzae()) && var10_3 != null && var10_3.zzg != null && var9_2.zzn().zzh.zza() == null && (var14_17 = zzaz.zza(var10_3.zzg)) != null) {
                    var9_2.zzp().zza(var10_3.zze, "allow_personalized_ads", (Object)var14_17.toString(), false);
                }
            }
        }
        var9_2 = this.zzi;
        var10_3 = var9_2.zze("google_analytics_tcf_data_enabled");
        if (var10_3 == null ? true : var10_3.booleanValue()) {
            this.zzj().zzc().zza("TCF client enabled.");
            this.zzp().zzat();
            this.zzp().zzar();
        }
        if (this.zzn().zzc.zza() == 0L) {
            this.zzj().zzp().zza("Persisting first open", this.zza);
            this.zzn().zzc.zza(this.zza);
        }
        this.zzp().zza.zzb();
        if (!this.zzaf()) {
            if (this.zzac()) {
                if (!this.zzt().zze("android.permission.INTERNET")) {
                    this.zzj().zzg().zza("App is missing INTERNET permission");
                }
                if (!this.zzt().zze("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzj().zzg().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() && !this.zzi.zzaa()) {
                    if (!zzop.zza(this.zzc)) {
                        this.zzj().zzg().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzop.zza(this.zzc, false)) {
                        this.zzj().zzg().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzj().zzg().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac())) {
                this.zzt();
                if (zzop.zza(this.zzh().zzae(), this.zzn().zzy(), this.zzh().zzac(), this.zzn().zzx())) {
                    this.zzj().zzn().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzn().zzz();
                    this.zzi().zzaa();
                    this.zzw.zzaf();
                    this.zzw.zzae();
                    this.zzn().zzc.zza(this.zza);
                    this.zzn().zze.zza(null);
                }
                this.zzn().zzc(this.zzh().zzae());
                this.zzn().zzb(this.zzh().zzac());
            }
            if (!this.zzn().zzn().zza(zzjc.zza.zzb)) {
                this.zzn().zze.zza(null);
            }
            this.zzp().zzc(this.zzn().zze.zza());
            if (!this.zzt().zzx() && !TextUtils.isEmpty((CharSequence)this.zzn().zzq.zza())) {
                this.zzj().zzu().zza("Remote config removed with active feature rollouts");
                this.zzn().zzq.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac())) {
                var4_8 = this.zzac();
                if (!this.zzn().zzab() && !this.zzi.zzz()) {
                    this.zzn().zzb(var4_8 == false);
                }
                if (var4_8) {
                    this.zzp().zzan();
                }
                this.zzs().zza.zza();
                this.zzr().zza(new AtomicReference<String>());
                this.zzr().zza(this.zzn().zzt.zza());
            }
        }
        if (zzrl.zza() && this.zzi.zza(zzbj.zzch) && this.zzt().zzw()) {
            v0 = this.zzp();
            Objects.requireNonNull(v0);
            var8_19 = v0;
            new Thread(new zzhv(var8_19)).start();
        }
        this.zzn().zzj.zza(true);
    }

    @WorkerThread
    public final boolean zzab() {
        return this.zzac != null && this.zzac != false;
    }

    @WorkerThread
    public final boolean zzac() {
        return this.zzc() == 0;
    }

    @WorkerThread
    public final boolean zzad() {
        ((zziy)this.zzl()).zzt();
        return this.zzaf;
    }

    @Pure
    public final boolean zzae() {
        return TextUtils.isEmpty((CharSequence)this.zzd);
    }

    @WorkerThread
    protected final boolean zzaf() {
        if (!this.zzz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
        ((zziy)this.zzl()).zzt();
        if (this.zzaa == null || this.zzab == 0L || this.zzaa != null && !this.zzaa.booleanValue() && Math.abs(this.zzp.elapsedRealtime() - this.zzab) > 1000L) {
            this.zzab = this.zzp.elapsedRealtime();
            this.zzaa = this.zzt().zze("android.permission.INTERNET") && this.zzt().zze("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() || this.zzi.zzaa() || zzop.zza(this.zzc) && zzop.zza(this.zzc, false));
            if (this.zzaa.booleanValue()) {
                this.zzaa = this.zzt().zza(this.zzh().zzae(), this.zzh().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac());
            }
        }
        return this.zzaa;
    }

    @Pure
    public final boolean zzag() {
        return this.zzg;
    }

    @WorkerThread
    public final boolean zzah() {
        Object object;
        ((zziy)this.zzl()).zzt();
        zzhw.zza(this.zzai());
        String string = this.zzh().zzad();
        Pair<String, Boolean> pair = this.zzn().zza(string);
        if (!this.zzi.zzx() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzj().zzc().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return false;
        }
        if (!this.zzai().zzc()) {
            this.zzj().zzu().zza("Network is not available for Deferred Deep Link request. Skipping");
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        zziy zziy2 = this.zzr();
        zziy2.zzt();
        ((zzf)zziy2).zzu();
        if (!((zzlp)zziy2).zzap() ? true : zziy2.zzq().zzg() >= 234200) {
            object = null;
            zzak zzak2 = this.zzp().zzab();
            if (zzak2 != null) {
                object = zzak2.zza;
            }
            if (object == null) {
                boolean bl = this.zzah++ < 10;
                String string2 = bl ? "Retrying." : "Skipping.";
                this.zzj().zzc().zza("Failed to retrieve DMA consent from the service, " + string2 + " retryCount", this.zzah);
                return bl;
            }
            zzjc zzjc2 = zzjc.zza(object, 100);
            stringBuilder.append("&gcs=").append(zzjc2.zzg());
            zzaz zzaz2 = zzaz.zza(object, 100);
            stringBuilder.append("&dma=").append(zzaz2.zzd() == Boolean.FALSE ? 0 : 1);
            if (!TextUtils.isEmpty((CharSequence)zzaz2.zze())) {
                stringBuilder.append("&dma_cps=").append(zzaz2.zze());
            }
            int n = zzaz.zza(object) == Boolean.TRUE ? 0 : 1;
            stringBuilder.append("&npa=").append(n);
            this.zzj().zzp().zza("Consent query parameters to Bow", stringBuilder);
        }
        zzop zzop2 = this.zzt();
        this.zzh();
        object = zzop2.zza(102001L, string, (String)pair.first, this.zzn().zzp.zza() - 1L, stringBuilder.toString());
        if (object != null) {
            zzhw zzhw2 = this;
            zzhy zzhy2 = new zzhy(zzhw2);
            Object object2 = object;
            String string3 = string;
            zziy2 = this.zzai();
            zziy2.zzt();
            ((zzix)zziy2).zzac();
            Preconditions.checkNotNull((Object)object2);
            Preconditions.checkNotNull((Object)zzhy2);
            zziy2.zzl().zza(new zzld((zzlb)zziy2, string3, (URL)object2, null, null, zzhy2));
        }
        return false;
    }
}

