/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zzlh;
import com.google.android.gms.measurement.internal.zzli;
import com.google.android.gms.measurement.internal.zzlj;
import com.google.android.gms.measurement.internal.zzlk;
import com.google.android.gms.measurement.internal.zzll;
import com.google.android.gms.measurement.internal.zzlm;
import com.google.android.gms.measurement.internal.zzln;
import com.google.android.gms.measurement.internal.zzop;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzlg
extends zzf {
    private volatile @Nullable zzlh zzb;
    private volatile @Nullable zzlh zzc;
    @VisibleForTesting
    protected @Nullable zzlh zza;
    private final Map<Activity, zzlh> zzd;
    @GuardedBy(value="activityLock")
    private @Nullable Activity zze;
    @GuardedBy(value="activityLock")
    private volatile boolean zzf;
    private volatile @Nullable zzlh zzg;
    private @Nullable zzlh zzh;
    @GuardedBy(value="activityLock")
    private boolean zzi;
    private final Object zzj = new Object();

    static /* bridge */ /* synthetic */ zzlh zza(zzlg zzlg2) {
        return zzlg2.zzh;
    }

    @MainThread
    private final zzlh zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzlh zzlh2 = this.zzd.get(activity);
        if (zzlh2 == null) {
            String string = this.zza(activity.getClass(), "Activity");
            zzlh2 = new zzlh(null, string, ((zziy)this).zzq().zzm());
            this.zzd.put(activity, zzlh2);
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return zzlh2;
    }

    public final @Nullable zzlh zzaa() {
        return this.zzb;
    }

    @WorkerThread
    public final @Nullable zzlh zza(boolean bl) {
        this.zzu();
        ((zziy)this).zzt();
        if (!bl) {
            return this.zza;
        }
        if (this.zza != null) {
            return this.zza;
        }
        return this.zzh;
    }

    @VisibleForTesting
    private final String zza(Class<?> clazz, String string) {
        String string2 = clazz.getCanonicalName();
        if (string2 == null) {
            return string;
        }
        String string3 = string2;
        zzlg zzlg2 = this;
        String[] stringArray = string3.split("\\.");
        String string4 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string4.length() > ((zziy)zzlg2).zze().zza(null, false)) {
            return string4.substring(0, ((zziy)zzlg2).zze().zza(null, false));
        }
        return string4;
    }

    static /* bridge */ /* synthetic */ void zza(zzlg zzlg2, zzlh zzlh2) {
        zzlg2.zzh = null;
    }

    static /* bridge */ /* synthetic */ void zza(zzlg zzlg2, zzlh zzlh2, zzlh zzlh3, long l, boolean bl, Bundle bundle) {
        zzlg2.zza(zzlh2, zzlh3, l, bl, null);
    }

    static /* synthetic */ void zza(zzlg zzlg2, Bundle bundle, zzlh zzlh2, zzlh zzlh3, long l) {
        long l2 = l;
        zzlh zzlh4 = zzlh3;
        zzlh zzlh5 = zzlh2;
        Bundle bundle2 = bundle;
        zzlg zzlg3 = zzlg2;
        if (bundle2 != null) {
            bundle2.remove("screen_name");
            bundle2.remove("screen_class");
        }
        Bundle bundle3 = ((zziy)zzlg3).zzq().zza(null, "screen_view", bundle2, null, false);
        zzlg3.zza(zzlh5, zzlh4, l2, true, bundle3);
    }

    static /* bridge */ /* synthetic */ void zza(zzlg zzlg2, zzlh zzlh2, boolean bl, long l) {
        zzlg2.zza(zzlh2, false, l);
    }

    public zzlg(zzhw zzhw2) {
        super(zzhw2);
        this.zzd = new ConcurrentHashMap<Activity, zzlh>();
    }

    @MainThread
    private final void zza(Activity activity, zzlh zzlh2, boolean bl) {
        zzlh zzlh3;
        zzlh zzlh4;
        zzlh zzlh5 = zzlh4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzlh2.zzb == null) {
            zzlh3 = activity != null ? this.zza(activity.getClass(), "Activity") : null;
            zzlh2 = new zzlh(zzlh2.zza, (String)((Object)zzlh3), zzlh2.zzc, zzlh2.zze, zzlh2.zzf);
        }
        zzlh3 = zzlh2;
        this.zzc = this.zzb;
        this.zzb = zzlh3;
        long l = ((zziy)this).zzb().elapsedRealtime();
        ((zziy)this).zzl().zzb(new zzli(this, zzlh3, zzlh4, l, bl));
    }

    @WorkerThread
    private final void zza(zzlh zzlh2, @Nullable zzlh zzlh3, long l, boolean bl, @Nullable Bundle bundle) {
        boolean bl2;
        ((zziy)this).zzt();
        boolean bl3 = zzlh3 == null || zzlh3.zzc != zzlh2.zzc || !Objects.equals(zzlh3.zzb, zzlh2.zzb) || !Objects.equals(zzlh3.zza, zzlh2.zza);
        boolean bl4 = bl2 = bl && this.zza != null;
        if (bl3) {
            long l2;
            long l3;
            Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            zzop.zza(zzlh2, bundle2, true);
            if (zzlh3 != null) {
                if (zzlh3.zza != null) {
                    bundle2.putString("_pn", zzlh3.zza);
                }
                if (zzlh3.zzb != null) {
                    bundle2.putString("_pc", zzlh3.zzb);
                }
                bundle2.putLong("_pi", zzlh3.zzc);
            }
            if (bl2 && (l3 = ((zzg)this).zzp().zzb.zza(l2 = l)) > 0L) {
                ((zziy)this).zzq().zza(bundle2, l3);
            }
            if (!((zziy)this).zze().zzy()) {
                bundle2.putLong("_mst", 1L);
            }
            String string = zzlh2.zze ? "app" : "auto";
            long l4 = ((zziy)this).zzb().currentTimeMillis();
            if (zzlh2.zze && zzlh2.zzf != 0L) {
                l4 = zzlh2.zzf;
            }
            ((zzg)this).zzm().zza(string, "_vs", l4, bundle2);
        }
        if (bl2) {
            this.zza(this.zza, true, l);
        }
        this.zza = zzlh2;
        if (zzlh2.zze) {
            this.zzh = zzlh2;
        }
        ((zzg)this).zzo().zza(zzlh2);
    }

    @MainThread
    public final void zza(Activity activity, @Nullable Bundle bundle) {
        if (!((zziy)this).zze().zzy()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzlh zzlh2 = new zzlh(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzlh2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            if (activity == this.zze) {
                this.zze = null;
            }
        }
        if (!((zziy)this).zze().zzy()) {
            return;
        }
        this.zzd.remove(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzb(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = false;
            this.zzf = true;
        }
        long l = ((zziy)this).zzb().elapsedRealtime();
        if (!((zziy)this).zze().zzy()) {
            this.zzb = null;
            ((zziy)this).zzl().zzb(new zzlk(this, l));
            return;
        }
        zzlh zzlh2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zziy)this).zzl().zzb(new zzln(this, zzlh2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzc(Activity activity) {
        zzg zzg2;
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = true;
            if (activity != this.zze) {
                Activity activity2 = activity;
                zzg2 = this;
                Object object2 = ((zzlg)zzg2).zzj;
                synchronized (object2) {
                    ((zzlg)zzg2).zze = activity2;
                    ((zzlg)zzg2).zzf = false;
                }
                if (zzg2.zze().zzy()) {
                    ((zzlg)zzg2).zzg = null;
                    zzg2.zzl().zzb(new zzlm((zzlg)zzg2));
                }
            }
        }
        if (!((zziy)this).zze().zzy()) {
            this.zzb = this.zzg;
            ((zziy)this).zzl().zzb(new zzll(this));
            return;
        }
        object = this.zzd(activity);
        this.zza(activity, (zzlh)object, false);
        zzg2 = ((zzg)this).zzc();
        long l = zzg2.zzb().elapsedRealtime();
        zzg2.zzl().zzb(new zze((zza)zzg2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (!((zziy)this).zze().zzy()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzlh zzlh2 = this.zzd.get(activity);
        if (zzlh2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzlh2.zzc);
        bundle2.putString("name", zzlh2.zza);
        bundle2.putString("referrer_name", zzlh2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @WorkerThread
    private final void zza(@Nullable zzlh zzlh2, boolean bl, long l) {
        boolean bl2;
        ((zzg)this).zzc().zza(((zziy)this).zzb().elapsedRealtime());
        boolean bl3 = bl2 = zzlh2 != null && zzlh2.zzd;
        if (((zzg)this).zzp().zza(bl2, bl, l) && zzlh2 != null) {
            zzlh2.zzd = false;
        }
    }

    @Deprecated
    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zziy)this).zze().zzy()) {
            ((zziy)this).zzj().zzv().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        zzlh zzlh2 = this.zzb;
        if (zzlh2 == null) {
            ((zziy)this).zzj().zzv().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zziy)this).zzj().zzv().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = this.zza(activity.getClass(), "Activity");
        }
        boolean bl = Objects.equals(zzlh2.zzb, string2);
        boolean bl2 = Objects.equals(zzlh2.zza, string);
        if (bl && bl2) {
            ((zziy)this).zzj().zzv().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > ((zziy)this).zze().zza(null, false))) {
            ((zziy)this).zzj().zzv().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > ((zziy)this).zze().zza(null, false))) {
            ((zziy)this).zzj().zzv().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zziy)this).zzj().zzp().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzlh zzlh3 = new zzlh(string, string2, ((zziy)this).zzq().zzm());
        this.zzd.put(activity, zzlh3);
        this.zza(activity, zzlh3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Bundle bundle, long l) {
        zzlh zzlh2;
        String string = null;
        String string2 = null;
        Object object = this.zzj;
        synchronized (object) {
            if (!this.zzi) {
                ((zziy)this).zzj().zzv().zza("Cannot log screen view event when the app is in the background.");
                return;
            }
            if (bundle != null) {
                string = bundle.getString("screen_name");
                if (string != null && (string.length() <= 0 || string.length() > ((zziy)this).zze().zza(null, false))) {
                    ((zziy)this).zzj().zzv().zza("Invalid screen name length for screen view. Length", string.length());
                    return;
                }
                string2 = bundle.getString("screen_class");
                if (string2 != null && (string2.length() <= 0 || string2.length() > ((zziy)this).zze().zza(null, false))) {
                    ((zziy)this).zzj().zzv().zza("Invalid screen class length for screen view. Length", string2.length());
                    return;
                }
            }
            if (string2 == null) {
                string2 = this.zze != null ? this.zza(this.zze.getClass(), "Activity") : "Activity";
            }
            zzlh2 = this.zzb;
            if (this.zzf && zzlh2 != null) {
                this.zzf = false;
                boolean bl = Objects.equals(zzlh2.zzb, string2);
                boolean bl2 = Objects.equals(zzlh2.zza, string);
                if (bl && bl2) {
                    ((zziy)this).zzj().zzv().zza("Ignoring call to log screen view event with duplicate parameters.");
                    return;
                }
            }
        }
        ((zziy)this).zzj().zzp().zza("Logging screen view with name, class", string == null ? "null" : string, string2 == null ? "null" : string2);
        object = this.zzb == null ? this.zzc : this.zzb;
        this.zzb = zzlh2 = new zzlh(string, string2, ((zziy)this).zzq().zzm(), true, l);
        this.zzc = object;
        this.zzg = zzlh2;
        long l2 = ((zziy)this).zzb().elapsedRealtime();
        ((zziy)this).zzl().zzb(new zzlj(this, bundle, zzlh2, (zzlh)object, l2));
    }

    @Override
    protected final boolean zzz() {
        return false;
    }
}

